/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services;

import io.github.thebusybiscuit.slimefun4.core.services.Language;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.UnaryOperator;
import java.util.logging.Level;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.ChatColors;
import me.mrCookieSlime.Slimefun.cscorelib2.config.Localization;
import me.mrCookieSlime.Slimefun.cscorelib2.data.PersistentDataAPI;
import org.bukkit.ChatColor;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.plugin.Plugin;

public class LocalizationService
extends Localization
implements Keyed {
    private static final String LANGUAGE_PATH = "language";
    private final Map<String, Language> languages = new LinkedHashMap<String, Language>();
    private final SlimefunPlugin plugin;
    private final NamespacedKey languageKey;
    private final Language defaultLanguage;

    public LocalizationService(SlimefunPlugin plugin) {
        super((Plugin)plugin);
        this.plugin = plugin;
        this.languageKey = new NamespacedKey((Plugin)plugin, LANGUAGE_PATH);
        this.defaultLanguage = new Language("default", this.getConfig().getConfiguration(), "11b3188fd44902f72602bd7c2141f5a70673a411adb3d81862c69e536166b");
        this.loadLanguages();
        String selectedLanguage = SlimefunPlugin.getSelectedLanguage();
        String language = this.getLanguage();
        if (this.hasLanguage(selectedLanguage)) {
            this.setLanguage(selectedLanguage, !selectedLanguage.equals(language));
        } else {
            plugin.getLogger().log(Level.WARNING, "Could not recognize the given language: \"{0}\"", selectedLanguage);
        }
        this.setPrefix("&aSlimefun 4 &7> ");
        this.save();
    }

    public String getPrefix() {
        return this.getMessage("prefix");
    }

    public String getMessage(Player p, String key) {
        Optional<String> language = PersistentDataAPI.getOptionalString((PersistentDataHolder)p, this.languageKey);
        if (language.isPresent()) {
            FileConfiguration cfg = this.languages.get(language.get()).getConfig();
            return cfg.getString(key);
        }
        return this.getMessage(key);
    }

    public List<String> getMessages(Player p, String key) {
        Optional<String> language = PersistentDataAPI.getOptionalString((PersistentDataHolder)p, this.languageKey);
        if (language.isPresent()) {
            FileConfiguration cfg = this.languages.get(language.get()).getConfig();
            return cfg.getStringList(key);
        }
        return this.getMessages(key);
    }

    @Override
    public void sendMessage(CommandSender sender, String key) {
        String prefix = this.getPrefix();
        if (sender instanceof Player) {
            sender.sendMessage(ChatColors.color(prefix + this.getMessage((Player)sender, key)));
        } else {
            sender.sendMessage(ChatColor.stripColor((String)ChatColors.color(prefix + this.getMessage(key))));
        }
    }

    @Override
    public void sendMessage(CommandSender sender, String key, boolean addPrefix) {
        this.sendMessage(sender, key);
    }

    public void sendMessage(CommandSender sender, String key, UnaryOperator<String> function) {
        String prefix = this.getPrefix();
        if (sender instanceof Player) {
            sender.sendMessage(ChatColors.color(prefix + (String)function.apply(this.getMessage((Player)sender, key))));
        } else {
            sender.sendMessage(ChatColor.stripColor((String)ChatColors.color(prefix + (String)function.apply(this.getMessage(key)))));
        }
    }

    @Override
    public void sendMessage(CommandSender sender, String key, boolean addPrefix, UnaryOperator<String> function) {
        this.sendMessage(sender, key, function);
    }

    @Override
    public void sendMessages(CommandSender sender, String key) {
        String prefix = this.getPrefix();
        if (sender instanceof Player) {
            for (String translation : this.getMessages((Player)sender, key)) {
                String message = ChatColors.color(prefix + translation);
                sender.sendMessage(message);
            }
        } else {
            for (String translation : this.getMessages(key)) {
                String message = ChatColors.color(prefix + translation);
                sender.sendMessage(ChatColor.stripColor((String)message));
            }
        }
    }

    @Override
    public void sendMessages(CommandSender sender, String key, boolean addPrefix, UnaryOperator<String> function) {
        this.sendMessages(sender, key, function);
    }

    public void sendMessages(CommandSender sender, String key, UnaryOperator<String> function) {
        String prefix = this.getPrefix();
        if (sender instanceof Player) {
            for (String translation : this.getMessages((Player)sender, key)) {
                String message = ChatColors.color(prefix + (String)function.apply(translation));
                sender.sendMessage(message);
            }
        } else {
            for (String translation : this.getMessages(key)) {
                String message = ChatColors.color(prefix + (String)function.apply(translation));
                sender.sendMessage(ChatColor.stripColor((String)message));
            }
        }
    }

    public Collection<Language> getLanguages() {
        return this.languages.values();
    }

    private String getLanguage() {
        String language = this.getConfig().getString(LANGUAGE_PATH);
        return language == null ? "en" : language;
    }

    private void setLanguage(String language, boolean reset) {
        if (reset) {
            for (String key : this.getConfig().getKeys()) {
                this.getConfig().setValue(key, null);
            }
        }
        Slimefun.getLogger().log(Level.INFO, "Loading language \"{0}\"", language);
        this.getConfig().setValue(LANGUAGE_PATH, language);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(((Object)((Object)this.plugin)).getClass().getResourceAsStream("/languages/messages_" + language + ".yml")));){
            YamlConfiguration config = YamlConfiguration.loadConfiguration((Reader)reader);
            this.getConfig().getConfiguration().setDefaults((Configuration)config);
        }
        catch (IOException e) {
            Slimefun.getLogger().log(Level.SEVERE, "Failed to load language file: \"messages_" + language + ".yml\"", e);
        }
        this.save();
    }

    private void loadLanguages() {
        this.addLanguage("en", "a1701f21835a898b20759fb30a583a38b994abf60d3912ab4ce9f2311e74f72");
    }

    private void addLanguage(String id, String hash) {
        this.languages.put(id, new Language(id, this.loadLanguage(id), hash));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private FileConfiguration loadLanguage(String id) {
        if (!this.hasLanguage(id)) {
            return this.getConfig().getConfiguration();
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(((Object)((Object)this.plugin)).getClass().getResourceAsStream("/languages/messages_" + id + ".yml")));){
            YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((Reader)reader);
            return yamlConfiguration;
        }
        catch (IOException e) {
            Slimefun.getLogger().log(Level.SEVERE, "Failed to load language file into memory: \"messages_" + id + ".yml\"", e);
            return this.getConfig().getConfiguration();
        }
    }

    public boolean hasLanguage(String language) {
        return ((Object)((Object)this.plugin)).getClass().getResource("/languages/messages_" + language + ".yml") != null;
    }

    public Language getLanguage(Player p) {
        Optional<String> language = PersistentDataAPI.getOptionalString((PersistentDataHolder)p, this.languageKey);
        if (language.isPresent()) {
            return this.languages.get(language.get());
        }
        return this.getDefaultLanguage();
    }

    public Language getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public NamespacedKey getKey() {
        return this.languageKey;
    }
}

