/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.api.item_transport;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ClickAction;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.Item.CustomItem;
import me.mrCookieSlime.CSCoreLibPlugin.general.Math.DoubleHandler;
import me.mrCookieSlime.CSCoreLibPlugin.general.Particles.MC_1_8.ParticleEffect;
import me.mrCookieSlime.Slimefun.Setup.SlimefunManager;
import me.mrCookieSlime.Slimefun.SlimefunStartup;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.UniversalBlockMenu;
import me.mrCookieSlime.Slimefun.api.item_transport.CargoManager;
import me.mrCookieSlime.Slimefun.api.item_transport.ChestTerminalSorter;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemRequest;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemSlot;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import me.mrCookieSlime.Slimefun.api.item_transport.StoredItem;
import me.mrCookieSlime.Slimefun.holograms.CargoHologram;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.material.MaterialData;
import org.bukkit.plugin.Plugin;

public class CargoNet {
    public static boolean EXTRA_CHANNELS = false;
    private static final int RANGE = 5;
    public static List<BlockFace> faces = Arrays.asList(BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST);
    public static Map<Location, Integer> round_robin = new HashMap<Location, Integer>();
    public static Set<ItemRequest> requests = new HashSet<ItemRequest>();
    private static int[] slots = new int[]{19, 20, 21, 28, 29, 30, 37, 38, 39};
    private static final ChestTerminalSorter sorter = new ChestTerminalSorter();
    public static final int[] terminal_slots = new int[]{0, 1, 2, 3, 4, 5, 6, 9, 10, 11, 12, 13, 14, 15, 18, 19, 20, 21, 22, 23, 24, 27, 28, 29, 30, 31, 32, 33, 36, 37, 38, 39, 40, 41, 42};
    private static final ItemStack terminal_noitem_item = new CustomItem(new MaterialData(Material.BARRIER), "&4No Item cached", new String[0]);
    private static final ChestMenu.MenuClickHandler terminal_noitem_handler = new ChestMenu.MenuClickHandler(){

        public boolean onClick(Player p, int slot, ItemStack stack, ClickAction action) {
            return false;
        }
    };

    public static void tick(final Block b) {
        final HashMap<Location, Integer> input = new HashMap<Location, Integer>();
        final HashMap<Integer, List<Location>> output = new HashMap<Integer, List<Location>>();
        final HashSet<Location> providers = new HashSet<Location>();
        final HashSet<Location> terminals = new HashSet<Location>();
        final HashSet<Location> imports = new HashSet<Location>();
        final HashSet<Location> exports = new HashSet<Location>();
        final HashSet<Location> destinations = new HashSet<Location>();
        HashSet<Location> blocks = new HashSet<Location>();
        blocks.add(b.getLocation());
        final ArrayList<Location> visualizer1 = new ArrayList<Location>();
        final ArrayList<Location> visualizer2 = new ArrayList<Location>();
        if (CargoNet.scan(b.getLocation(), blocks, visualizer1, visualizer2, Axis.UNKNOWN, input, output, terminals, providers, destinations, imports, exports).isEmpty()) {
            CargoHologram.update(b, "&7Status: &4&lOFFLINE");
        } else {
            final BlockStorage storage = BlockStorage.getStorage(b.getWorld());
            SlimefunStartup.instance.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)SlimefunStartup.instance, new Runnable(){

                @Override
                public void run() {
                    Block target;
                    if (BlockStorage.getBlockInfo(b, "visualizer") == null) {
                        for (int i = 0; i < visualizer1.size(); ++i) {
                            Location l1 = (Location)visualizer1.get(i);
                            Location l2 = (Location)visualizer2.get(i);
                            try {
                                ParticleEffect.REDSTONE.drawLine(new Location(l1.getWorld(), (double)l1.getBlockX() + 0.5, (double)l1.getBlockY() + 0.5, (double)l1.getBlockZ() + 0.5), new Location(l2.getWorld(), (double)l2.getBlockX() + 0.5, (double)l2.getBlockY() + 0.5, (double)l2.getBlockZ() + 0.5));
                                continue;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    if (EXTRA_CHANNELS) {
                        BlockMenu menu;
                        for (Location bus : imports) {
                            menu = BlockStorage.getInventory(bus);
                            if (menu.getItemInSlot(17) == null) {
                                Block target2 = CargoNet.getAttachedBlock(bus.getBlock());
                                ItemSlot stack = CargoManager.withdraw(bus.getBlock(), storage, target2, -1);
                                if (stack != null) {
                                    menu.replaceExistingItem(17, stack.getItem());
                                }
                            }
                            if (menu.getItemInSlot(17) == null) continue;
                            requests.add(new ItemRequest(bus, 17, menu.getItemInSlot(17), ItemTransportFlow.INSERT));
                        }
                        for (Location bus : exports) {
                            menu = BlockStorage.getInventory(bus);
                            if (menu.getItemInSlot(17) != null) {
                                Block target2 = CargoNet.getAttachedBlock(bus.getBlock());
                                menu.replaceExistingItem(17, CargoManager.insert(bus.getBlock(), storage, target2, menu.getItemInSlot(17), -1));
                            }
                            if (menu.getItemInSlot(17) != null) continue;
                            ArrayList<CustomItem> items = new ArrayList<CustomItem>();
                            for (int slot : slots) {
                                ItemStack template = menu.getItemInSlot(slot);
                                if (template == null) continue;
                                items.add(new CustomItem(template, 1));
                            }
                            if (items.isEmpty()) continue;
                            int index = Integer.parseInt(BlockStorage.getBlockInfo(bus, "index"));
                            if (++index > items.size() - 1) {
                                index = 0;
                            }
                            BlockStorage.addBlockInfo(bus, "index", String.valueOf(index));
                            requests.add(new ItemRequest(bus, 17, (ItemStack)items.get(index), ItemTransportFlow.WITHDRAW));
                        }
                        Iterator<ItemRequest> iterator = requests.iterator();
                        while (iterator.hasNext()) {
                            ItemRequest request = iterator.next();
                            if (!terminals.contains(request.getTerminal()) && !imports.contains(request.getTerminal()) && !exports.contains(request.getTerminal())) continue;
                            menu = BlockStorage.getInventory(request.getTerminal());
                            switch (request.getDirection()) {
                                case INSERT: {
                                    ItemStack stack = request.getItem();
                                    for (Location l : destinations) {
                                        Block target3 = CargoNet.getAttachedBlock(l.getBlock());
                                        stack = CargoManager.insert(l.getBlock(), storage, target3, stack, -1);
                                        if (stack != null) continue;
                                        menu.replaceExistingItem(request.getSlot(), null);
                                        break;
                                    }
                                    if (stack != null) {
                                        menu.replaceExistingItem(request.getSlot(), stack);
                                    }
                                    iterator.remove();
                                    break;
                                }
                                case WITHDRAW: {
                                    int slot = request.getSlot();
                                    ItemStack prevStack = menu.getItemInSlot(slot);
                                    if (!(prevStack == null || prevStack.getAmount() + request.getItem().getAmount() <= prevStack.getMaxStackSize() && SlimefunManager.isItemSimiliar(prevStack, (ItemStack)new CustomItem(request.getItem(), 1), true, SlimefunManager.DataType.ALWAYS))) {
                                        iterator.remove();
                                        break;
                                    }
                                    Object stack = null;
                                    ItemStack requested = request.getItem();
                                    for (Location l : providers) {
                                        target = CargoNet.getAttachedBlock(l.getBlock());
                                        ItemStack is = CargoManager.withdraw(l.getBlock(), storage, target, requested);
                                        if (is == null) continue;
                                        stack = stack == null ? is : new CustomItem(stack, stack.getAmount() + is.getAmount());
                                        if (is.getAmount() == requested.getAmount()) break;
                                        requested = new CustomItem(requested, requested.getAmount() - is.getAmount());
                                    }
                                    if (stack != null) {
                                        ItemStack prev = menu.getItemInSlot(slot);
                                        if (prev == null) {
                                            menu.replaceExistingItem(slot, (ItemStack)stack);
                                        } else {
                                            menu.replaceExistingItem(slot, (ItemStack)new CustomItem(stack, stack.getAmount() + prev.getAmount()));
                                        }
                                    }
                                    iterator.remove();
                                    break;
                                }
                            }
                        }
                    }
                    for (Map.Entry entry : input.entrySet()) {
                        ChestMenu menu;
                        ItemSlot slot;
                        Block inputTarget = CargoNet.getAttachedBlock(((Location)entry.getKey()).getBlock());
                        ItemStack stack = null;
                        int previousSlot = -1;
                        boolean roundrobin = BlockStorage.getBlockInfo((Location)entry.getKey(), "round-robin").equals("true");
                        if (inputTarget != null && (slot = CargoManager.withdraw(((Location)entry.getKey()).getBlock(), storage, inputTarget, Integer.parseInt(BlockStorage.getBlockInfo((Location)entry.getKey(), "index")))) != null) {
                            stack = slot.getItem();
                            previousSlot = slot.getSlot();
                        }
                        if (stack != null && output.containsKey(entry.getValue())) {
                            Location out;
                            ArrayList<Location> outputlist = new ArrayList<Location>((Collection)output.get(entry.getValue()));
                            if (roundrobin) {
                                int c_index;
                                if (!round_robin.containsKey(entry.getKey())) {
                                    round_robin.put((Location)entry.getKey(), 0);
                                }
                                if ((c_index = round_robin.get(entry.getKey()).intValue()) < outputlist.size()) {
                                    for (int i = 0; i < c_index; ++i) {
                                        Location temp = (Location)outputlist.get(0);
                                        outputlist.remove(temp);
                                        outputlist.add(temp);
                                    }
                                    ++c_index;
                                } else {
                                    c_index = 1;
                                }
                                round_robin.put((Location)entry.getKey(), c_index);
                            }
                            Iterator c_index = outputlist.iterator();
                            while (c_index.hasNext() && ((target = CargoNet.getAttachedBlock((out = (Location)c_index.next()).getBlock())) == null || (stack = CargoManager.insert(out.getBlock(), storage, target, stack, -1)) != null)) {
                            }
                        }
                        if (stack == null || previousSlot <= -1) continue;
                        if (storage.hasUniversalInventory(inputTarget)) {
                            menu = storage.getUniversalInventory(inputTarget);
                            menu.replaceExistingItem(previousSlot, stack);
                            continue;
                        }
                        if (storage.hasInventory(inputTarget.getLocation())) {
                            menu = BlockStorage.getInventory(inputTarget.getLocation());
                            menu.replaceExistingItem(previousSlot, stack);
                            continue;
                        }
                        if (!(inputTarget.getState() instanceof InventoryHolder)) continue;
                        Inventory inv2 = ((InventoryHolder)inputTarget.getState()).getInventory();
                        inv2.setItem(previousSlot, stack);
                    }
                    if (EXTRA_CHANNELS) {
                        ArrayList<StoredItem> items = new ArrayList<StoredItem>();
                        for (final Location l : providers) {
                            int c_index;
                            ChestMenu menu;
                            Block target4 = CargoNet.getAttachedBlock(l.getBlock());
                            if (storage.hasUniversalInventory(target4)) {
                                menu = storage.getUniversalInventory(target4);
                                int[] roundrobin = menu.getPreset().getSlotsAccessedByItemTransport((UniversalBlockMenu)menu, ItemTransportFlow.WITHDRAW, null);
                                int inv2 = roundrobin.length;
                                for (c_index = 0; c_index < inv2; ++c_index) {
                                    int slot = roundrobin[c_index];
                                    ItemStack is = menu.getItemInSlot(slot);
                                    if (is == null || !CargoManager.matchesFilter(l.getBlock(), is, -1)) continue;
                                    boolean add = true;
                                    for (StoredItem storedItem : items) {
                                        if (!SlimefunManager.isItemSimiliar(is, storedItem.getItem(), true, SlimefunManager.DataType.ALWAYS)) continue;
                                        add = false;
                                        storedItem.add(is.getAmount());
                                    }
                                    if (!add) continue;
                                    items.add(new StoredItem((ItemStack)new CustomItem(is, 1), is.getAmount()));
                                }
                                continue;
                            }
                            if (storage.hasInventory(target4.getLocation())) {
                                menu = BlockStorage.getInventory(target4.getLocation());
                                if (BlockStorage.checkID(target4.getLocation()).startsWith("BARREL_") && BlockStorage.getBlockInfo(target4.getLocation(), "storedItems") != null) {
                                    int stored = Integer.valueOf(BlockStorage.getBlockInfo(target4.getLocation(), "storedItems"));
                                    int[] inv2 = menu.getPreset().getSlotsAccessedByItemTransport((BlockMenu)menu, ItemTransportFlow.WITHDRAW, null);
                                    c_index = inv2.length;
                                    for (int slot = 0; slot < c_index; ++slot) {
                                        int slot2 = inv2[slot];
                                        ItemStack is = menu.getItemInSlot(slot2);
                                        if (is == null || !CargoManager.matchesFilter(l.getBlock(), is, -1)) continue;
                                        boolean add = true;
                                        for (StoredItem item2 : items) {
                                            if (!SlimefunManager.isItemSimiliar(is, item2.getItem(), true, SlimefunManager.DataType.ALWAYS)) continue;
                                            add = false;
                                            item2.add(is.getAmount() + stored);
                                        }
                                        if (!add) continue;
                                        items.add(new StoredItem((ItemStack)new CustomItem(is, 1), is.getAmount() + stored));
                                    }
                                    continue;
                                }
                                int[] stored = menu.getPreset().getSlotsAccessedByItemTransport((BlockMenu)menu, ItemTransportFlow.WITHDRAW, null);
                                int inv2 = stored.length;
                                for (c_index = 0; c_index < inv2; ++c_index) {
                                    int slot = stored[c_index];
                                    ItemStack is = menu.getItemInSlot(slot);
                                    if (is == null || !CargoManager.matchesFilter(l.getBlock(), is, -1)) continue;
                                    boolean add = true;
                                    for (StoredItem storedItem : items) {
                                        if (!SlimefunManager.isItemSimiliar(is, storedItem.getItem(), true, SlimefunManager.DataType.ALWAYS)) continue;
                                        add = false;
                                        storedItem.add(is.getAmount());
                                    }
                                    if (!add) continue;
                                    items.add(new StoredItem((ItemStack)new CustomItem(is, 1), is.getAmount()));
                                }
                                continue;
                            }
                            if (!(target4.getState() instanceof InventoryHolder)) continue;
                            Inventory inv = ((InventoryHolder)target4.getState()).getInventory();
                            ItemStack[] stored = inv.getContents();
                            int inv2 = stored.length;
                            for (c_index = 0; c_index < inv2; ++c_index) {
                                ItemStack is = stored[c_index];
                                if (is == null || !CargoManager.matchesFilter(l.getBlock(), is, -1)) continue;
                                boolean add = true;
                                for (StoredItem item : items) {
                                    if (!SlimefunManager.isItemSimiliar(is, item.getItem(), true, SlimefunManager.DataType.ALWAYS)) continue;
                                    add = false;
                                    item.add(is.getAmount());
                                }
                                if (!add) continue;
                                items.add(new StoredItem((ItemStack)new CustomItem(is, 1), is.getAmount()));
                            }
                        }
                        Collections.sort(items, sorter);
                        for (final Location l : terminals) {
                            BlockMenu menu = BlockStorage.getInventory(l);
                            int page = Integer.parseInt(BlockStorage.getBlockInfo(l, "page"));
                            if (!items.isEmpty() && items.size() < (page - 1) * terminal_slots.length + 1) {
                                page = 1;
                                BlockStorage.addBlockInfo(l, "page", String.valueOf(1));
                            }
                            for (int i = 0; i < terminal_slots.length; ++i) {
                                int slot = terminal_slots[i];
                                if (items.size() > i + terminal_slots.length * (page - 1)) {
                                    final StoredItem item = (StoredItem)items.get(i + terminal_slots.length * (page - 1));
                                    ItemStack stack = item.getItem().clone();
                                    ItemMeta im = stack.getItemMeta();
                                    ArrayList<String> lore = new ArrayList<String>();
                                    lore.add("");
                                    lore.add("&7Stored Items: &r" + DoubleHandler.getFancyDouble((double)item.getAmount()));
                                    if (stack.getMaxStackSize() > 1) {
                                        lore.add("&7<Left Click: Request 1 | Right Click: Request " + (item.getAmount() > stack.getMaxStackSize() ? stack.getMaxStackSize() : item.getAmount()) + ">");
                                    } else {
                                        lore.add("&7<Left Click: Request 1>");
                                    }
                                    lore.add("");
                                    if (im.hasLore()) {
                                        for (String string : im.getLore()) {
                                            lore.add(string);
                                        }
                                    }
                                    im.setLore(lore);
                                    stack.setItemMeta(im);
                                    menu.replaceExistingItem(slot, stack);
                                    menu.addMenuClickHandler(slot, new ChestMenu.MenuClickHandler(){

                                        public boolean onClick(Player p, int slot, ItemStack is, ClickAction action) {
                                            requests.add(new ItemRequest(l, 44, (ItemStack)new CustomItem(item.getItem(), action.isRightClicked() ? (item.getAmount() > item.getItem().getMaxStackSize() ? item.getItem().getMaxStackSize() : item.getAmount()) : 1), ItemTransportFlow.WITHDRAW));
                                            return false;
                                        }
                                    });
                                    continue;
                                }
                                menu.replaceExistingItem(slot, terminal_noitem_item);
                                menu.addMenuClickHandler(slot, terminal_noitem_handler);
                            }
                            ItemStack sent_item = menu.getItemInSlot(17);
                            if (sent_item == null) continue;
                            requests.add(new ItemRequest(l, 17, sent_item, ItemTransportFlow.INSERT));
                        }
                    }
                    CargoHologram.update(b, "&7Status: &a&lONLINE");
                }
            });
        }
    }

    private static Block getAttachedBlock(Block block) {
        if (block.getData() == 2) {
            return block.getRelative(BlockFace.SOUTH);
        }
        if (block.getData() == 3) {
            return block.getRelative(BlockFace.NORTH);
        }
        if (block.getData() == 4) {
            return block.getRelative(BlockFace.EAST);
        }
        if (block.getData() == 5) {
            return block.getRelative(BlockFace.WEST);
        }
        return null;
    }

    private static int getFrequency(Location l) {
        int freq = 0;
        try {
            freq = Integer.parseInt(BlockStorage.getBlockInfo(l).getString("frequency"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return freq;
    }

    public static Set<Location> scan(Location source, Set<Location> blocks, List<Location> l1, List<Location> l2, Axis exclude, Map<Location, Integer> input, Map<Integer, List<Location>> output, Set<Location> terminals, Set<Location> providers, Set<Location> destinations, Set<Location> imports, Set<Location> exports) {
        Location l;
        int i;
        if (!exclude.equals((Object)Axis.X_POSITIVE)) {
            for (i = 0; i <= 5; ++i) {
                l = new Location(source.getWorld(), source.getX() + (double)i + 1.0, source.getY(), source.getZ());
                if (CargoNet.continueScan(source, l, l1, l2, Axis.X_NEGATIVE, blocks, input, output, terminals, providers, destinations, imports, exports)) continue;
                return new HashSet<Location>();
            }
        }
        if (!exclude.equals((Object)Axis.X_NEGATIVE)) {
            for (i = 0; i <= 5; ++i) {
                l = new Location(source.getWorld(), source.getX() - (double)i - 1.0, source.getY(), source.getZ());
                if (CargoNet.continueScan(source, l, l1, l2, Axis.X_POSITIVE, blocks, input, output, terminals, providers, destinations, imports, exports)) continue;
                return new HashSet<Location>();
            }
        }
        if (!exclude.equals((Object)Axis.Y_POSITIVE)) {
            for (i = 0; i <= 5; ++i) {
                l = new Location(source.getWorld(), source.getX(), source.getY() + (double)i + 1.0, source.getZ());
                if (CargoNet.continueScan(source, l, l1, l2, Axis.Y_NEGATIVE, blocks, input, output, terminals, providers, destinations, imports, exports)) continue;
                return new HashSet<Location>();
            }
        }
        if (!exclude.equals((Object)Axis.Y_NEGATIVE)) {
            for (i = 0; i <= 5; ++i) {
                l = new Location(source.getWorld(), source.getX(), source.getY() - (double)i - 1.0, source.getZ());
                if (CargoNet.continueScan(source, l, l1, l2, Axis.Y_POSITIVE, blocks, input, output, terminals, providers, destinations, imports, exports)) continue;
                return new HashSet<Location>();
            }
        }
        if (!exclude.equals((Object)Axis.Z_POSITIVE)) {
            for (i = 0; i <= 5; ++i) {
                l = new Location(source.getWorld(), source.getX(), source.getY(), source.getZ() + (double)i + 1.0);
                if (CargoNet.continueScan(source, l, l1, l2, Axis.Z_NEGATIVE, blocks, input, output, terminals, providers, destinations, imports, exports)) continue;
                return new HashSet<Location>();
            }
        }
        if (!exclude.equals((Object)Axis.Z_NEGATIVE)) {
            for (i = 0; i <= 5; ++i) {
                l = new Location(source.getWorld(), source.getX(), source.getY(), source.getZ() - (double)i - 1.0);
                if (CargoNet.continueScan(source, l, l1, l2, Axis.Z_POSITIVE, blocks, input, output, terminals, providers, destinations, imports, exports)) continue;
                return new HashSet<Location>();
            }
        }
        return blocks;
    }

    private static boolean continueScan(Location source, Location l, List<Location> l1, List<Location> l2, Axis axis, Set<Location> blocks, Map<Location, Integer> input, Map<Integer, List<Location>> output, Set<Location> terminals, Set<Location> providers, Set<Location> destinations, Set<Location> imports, Set<Location> exports) {
        if (!blocks.contains(l)) {
            String id = BlockStorage.checkID(l);
            if (id == null) {
                return true;
            }
            if (id.equals("CARGO_MANAGER")) {
                return false;
            }
            if (id.equals("CARGO_NODE")) {
                blocks.add(l);
                l1.add(source);
                l2.add(l);
                CargoNet.scan(l, blocks, l1, l2, axis, input, output, terminals, providers, destinations, imports, exports);
                if (blocks.isEmpty()) {
                    return false;
                }
            } else if (id.equals("CARGO_NODE_INPUT")) {
                blocks.add(l);
                l1.add(source);
                l2.add(l);
                int freq = CargoNet.getFrequency(l);
                if (freq == 16) {
                    providers.add(l);
                } else {
                    input.put(l, freq);
                }
            } else if (id.equals("CHEST_TERMINAL")) {
                blocks.add(l);
                l1.add(source);
                l2.add(l);
                terminals.add(l);
            } else if (id.equals("CT_IMPORT_BUS")) {
                blocks.add(l);
                l1.add(source);
                l2.add(l);
                imports.add(l);
            } else if (id.equals("CT_EXPORT_BUS")) {
                blocks.add(l);
                l1.add(source);
                l2.add(l);
                exports.add(l);
            } else if (id.equals("CARGO_NODE_OUTPUT")) {
                blocks.add(l);
                l1.add(source);
                l2.add(l);
                int freq = CargoNet.getFrequency(l);
                if (freq == 16) {
                    destinations.add(l);
                } else {
                    ArrayList<Location> list = output.containsKey(freq) ? output.get(freq) : new ArrayList<Location>();
                    list.add(l);
                    output.put(freq, list);
                }
            } else if (id.equals("CARGO_NODE_OUTPUT_ADVANCED")) {
                blocks.add(l);
                l1.add(source);
                l2.add(l);
                int freq = CargoNet.getFrequency(l);
                if (freq == 16) {
                    destinations.add(l);
                } else {
                    ArrayList<Location> list = output.containsKey(freq) ? output.get(freq) : new ArrayList<Location>();
                    list.add(l);
                    output.put(freq, list);
                }
            }
        }
        return true;
    }

    public static boolean isConnected(Block b) {
        return CargoNet.passiveScan(b.getLocation(), Axis.UNKNOWN, new HashSet<Location>());
    }

    private static boolean passiveScan(Location source, Axis exclude, Set<Location> sources) {
        Location l;
        int i;
        sources.add(source);
        HashSet<Location> blocks = new HashSet<Location>();
        blocks.add(source);
        if (!exclude.equals((Object)Axis.X_POSITIVE)) {
            for (i = 0; i <= 5; ++i) {
                l = new Location(source.getWorld(), source.getX() + (double)i + 1.0, source.getY(), source.getZ());
                if (!CargoNet.continuePassiveScan(l, Axis.X_NEGATIVE, sources)) continue;
                return true;
            }
        }
        if (!exclude.equals((Object)Axis.X_NEGATIVE)) {
            for (i = 0; i <= 5; ++i) {
                l = new Location(source.getWorld(), source.getX() - (double)i - 1.0, source.getY(), source.getZ());
                if (!CargoNet.continuePassiveScan(l, Axis.X_POSITIVE, sources)) continue;
                return true;
            }
        }
        if (!exclude.equals((Object)Axis.Y_POSITIVE)) {
            for (i = 0; i <= 5; ++i) {
                l = new Location(source.getWorld(), source.getX(), source.getY() + (double)i + 1.0, source.getZ());
                if (!CargoNet.continuePassiveScan(l, Axis.Y_NEGATIVE, sources)) continue;
                return true;
            }
        }
        if (!exclude.equals((Object)Axis.Y_NEGATIVE)) {
            for (i = 0; i <= 5; ++i) {
                l = new Location(source.getWorld(), source.getX(), source.getY() - (double)i - 1.0, source.getZ());
                if (!CargoNet.continuePassiveScan(l, Axis.Y_POSITIVE, sources)) continue;
                return true;
            }
        }
        if (!exclude.equals((Object)Axis.Z_POSITIVE)) {
            for (i = 0; i <= 5; ++i) {
                l = new Location(source.getWorld(), source.getX(), source.getY(), source.getZ() + (double)i + 1.0);
                if (!CargoNet.continuePassiveScan(l, Axis.Z_NEGATIVE, sources)) continue;
                return true;
            }
        }
        if (!exclude.equals((Object)Axis.Z_NEGATIVE)) {
            for (i = 0; i <= 5; ++i) {
                l = new Location(source.getWorld(), source.getX(), source.getY(), source.getZ() - (double)i - 1.0);
                if (!CargoNet.continuePassiveScan(l, Axis.Z_POSITIVE, sources)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean continuePassiveScan(Location l, Axis axis, Set<Location> sources) {
        if (!sources.contains(l)) {
            String id = BlockStorage.checkID(l);
            if (id == null) {
                return false;
            }
            if (id.equals("CARGO_MANAGER")) {
                return true;
            }
            if (id.equals("CARGO_NODE")) {
                return CargoNet.passiveScan(l, axis, sources);
            }
        }
        return false;
    }

    public static enum Axis {
        X_POSITIVE,
        X_NEGATIVE,
        Y_POSITIVE,
        Y_NEGATIVE,
        Z_POSITIVE,
        Z_NEGATIVE,
        UNKNOWN;

    }
}

