/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.logging.Level;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.cscorelib2.config.Localization;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class LocalizationService
extends Localization {
    private static final String LANGUAGE_PATH = "language";
    private final SlimefunPlugin plugin;

    public LocalizationService(SlimefunPlugin plugin) {
        super((Plugin)plugin);
        this.plugin = plugin;
        String selectedLanguage = SlimefunPlugin.getSelectedLanguage();
        String language = this.getLanguage();
        if (this.hasLanguage(selectedLanguage)) {
            this.setLanguage(selectedLanguage, !selectedLanguage.equals(language));
        } else {
            plugin.getLogger().log(Level.WARNING, "Could not recognize the given language: \"{0}\"", selectedLanguage);
        }
        this.setPrefix("&aSlimefun 4 &7> ");
        this.save();
    }

    private String getLanguage() {
        String language = this.getConfig().getString(LANGUAGE_PATH);
        return language == null ? "en" : language;
    }

    private void setLanguage(String language, boolean reset) {
        if (reset) {
            for (String key : this.getConfig().getKeys()) {
                this.getConfig().setValue(key, null);
            }
        }
        Slimefun.getLogger().log(Level.INFO, "Loading language \"{0}\"", language);
        this.getConfig().setValue(LANGUAGE_PATH, language);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(((Object)((Object)this.plugin)).getClass().getResourceAsStream("/languages/messages_" + language + ".yml")));){
            YamlConfiguration config = YamlConfiguration.loadConfiguration((Reader)reader);
            this.getConfig().getConfiguration().setDefaults((Configuration)config);
        }
        catch (IOException e) {
            Slimefun.getLogger().log(Level.SEVERE, "Failed to load language file: \"messages_" + language + ".yml\"", e);
        }
        this.save();
    }

    public boolean hasLanguage(String language) {
        return ((Object)((Object)this.plugin)).getClass().getResource("/languages/messages_" + language + ".yml") != null;
    }
}

