/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.AncientAltar;

import java.util.ArrayList;
import java.util.List;
import me.mrCookieSlime.CSCoreLibPlugin.general.Particles.MC_1_8.ParticleEffect;
import me.mrCookieSlime.Slimefun.SlimefunStartup;
import me.mrCookieSlime.Slimefun.listeners.AncientAltarListener;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class RitualAnimation
implements Runnable {
    List<Block> altars;
    Block altar;
    Location l;
    ItemStack output;
    List<Block> pedestals;
    List<ItemStack> items;
    List<Location> particles;
    boolean running;
    int stage;

    public RitualAnimation(List<Block> altars, Block altar, Location drop, ItemStack output, List<Block> pedestals, List<ItemStack> items) {
        this.l = drop;
        this.altar = altar;
        this.altars = altars;
        this.output = output;
        this.pedestals = pedestals;
        this.items = items;
        this.particles = new ArrayList<Location>();
        this.running = true;
        this.stage = 0;
    }

    @Override
    public void run() {
        this.idle();
        if (this.stage == 36) {
            this.finish();
            return;
        }
        if (this.stage > 0 && this.stage % 4 == 0) {
            this.checkPedestal(this.pedestals.get(this.stage / 4 - 1));
        }
        ++this.stage;
        SlimefunStartup.instance.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)SlimefunStartup.instance, (Runnable)this, 8L);
    }

    private void idle() {
        try {
            ParticleEffect.SPELL_WITCH.display(this.l, 1.2f, 0.0f, 1.2f, 0.0f, 16);
            ParticleEffect.FIREWORKS_SPARK.display(this.l, 0.2f, 0.0f, 0.2f, 0.0f, 8);
            for (Location l2 : this.particles) {
                ParticleEffect.ENCHANTMENT_TABLE.display(l2, 0.3f, 0.2f, 0.3f, 0.0f, 16);
                ParticleEffect.CRIT_MAGIC.display(l2, 0.3f, 0.2f, 0.3f, 0.0f, 8);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void checkPedestal(Block pedestal) {
        Item item = AncientAltarListener.findItem(pedestal);
        if (item == null) {
            this.abort();
        } else {
            this.particles.add(pedestal.getLocation().add(0.5, 1.5, 0.5));
            this.items.add(AncientAltarListener.fixItemStack(item.getItemStack(), item.getCustomName()));
            pedestal.getWorld().playSound(pedestal.getLocation(), Sound.ENTITY_ENDERMEN_TELEPORT, 5.0f, 2.0f);
            try {
                ParticleEffect.ENCHANTMENT_TABLE.display(pedestal.getLocation().add(0.5, 1.5, 0.5), 0.3f, 0.2f, 0.3f, 0.0f, 16);
                ParticleEffect.CRIT_MAGIC.display(pedestal.getLocation().add(0.5, 1.5, 0.5), 0.3f, 0.2f, 0.3f, 0.0f, 8);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            item.remove();
            pedestal.removeMetadata("item_placed", (Plugin)SlimefunStartup.instance);
        }
    }

    private void abort() {
        this.running = false;
        for (ItemStack stack : this.items) {
            this.l.getWorld().dropItemNaturally(this.l, stack);
        }
        this.l.getWorld().playSound(this.l, Sound.BLOCK_NOTE_SNARE, 5.0f, 1.0f);
        this.altars.remove(this.altar);
    }

    private void finish() {
        this.l.getWorld().playSound(this.l, Sound.ENTITY_ZOMBIE_VILLAGER_CURE, 1.0f, 1.0f);
        this.l.getWorld().playEffect(this.l, Effect.STEP_SOUND, (Object)Material.EMERALD_BLOCK);
        this.l.getWorld().dropItemNaturally(this.l.add(0.0, 1.0, 0.0), this.output);
        this.altars.remove(this.altar);
    }
}

