/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.api.network;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import me.mrCookieSlime.CSCoreLibPlugin.general.Particles.MC_1_8.ParticleEffect;
import me.mrCookieSlime.Slimefun.SlimefunStartup;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;

public abstract class Network {
    private static List<Network> NETWORK_LIST = new ArrayList<Network>();
    protected Location regulator;
    private Queue<Location> nodeQueue = new ArrayDeque<Location>();
    protected Set<Location> connectedLocations = new HashSet<Location>();
    protected Set<Location> regulatorNodes = new HashSet<Location>();
    protected Set<Location> connectorNodes = new HashSet<Location>();
    protected Set<Location> terminusNodes = new HashSet<Location>();

    public static <T extends Network> T getNetworkFromLocation(Location l, Class<T> type) {
        for (Network n : NETWORK_LIST) {
            if (!type.isInstance(n) || !n.connectsTo(l)) continue;
            return (T)((Network)type.cast(n));
        }
        return null;
    }

    public static <T extends Network> List<T> getNetworksFromLocation(Location l, Class<T> type) {
        ArrayList<T> ret = new ArrayList<T>();
        for (Network n : NETWORK_LIST) {
            if (!type.isInstance(n) || !n.connectsTo(l)) continue;
            ret.add(type.cast(n));
        }
        return ret;
    }

    public static void registerNetwork(Network n) {
        NETWORK_LIST.add(n);
    }

    public static void unregisterNetwork(Network n) {
        NETWORK_LIST.remove(n);
    }

    public static void handleAllNetworkLocationUpdate(Location l) {
        for (Network n : Network.getNetworksFromLocation(l, Network.class)) {
            n.handleLocationUpdate(l);
        }
    }

    public abstract int getRange();

    public abstract Component classifyLocation(Location var1);

    public abstract void locationClassificationChange(Location var1, Component var2, Component var3);

    protected Network(Location regulator) {
        this.regulator = regulator;
        this.connectedLocations.add(regulator);
        this.nodeQueue.add(regulator.clone());
    }

    protected void addLocationToNetwork(Location l) {
        if (this.connectedLocations.contains(l)) {
            return;
        }
        this.connectedLocations.add(l.clone());
        this.handleLocationUpdate(l);
    }

    public void handleLocationUpdate(Location l) {
        if (this.regulator.equals((Object)l)) {
            Network.unregisterNetwork(this);
            return;
        }
        this.nodeQueue.add(l.clone());
    }

    public boolean connectsTo(Location l) {
        return this.connectedLocations.contains(l);
    }

    private Component getCurrentClassification(Location l) {
        if (this.regulatorNodes.contains(l)) {
            return Component.REGULATOR;
        }
        if (this.connectorNodes.contains(l)) {
            return Component.CONNECTOR;
        }
        if (this.terminusNodes.contains(l)) {
            return Component.TERMINUS;
        }
        return null;
    }

    private void discoverStep() {
        int steps = 0;
        while (this.nodeQueue.peek() != null) {
            Location l = this.nodeQueue.poll();
            Component currentAssignment = this.getCurrentClassification(l);
            Component classification = this.classifyLocation(l);
            if (classification != currentAssignment) {
                if (currentAssignment == Component.REGULATOR || currentAssignment == Component.CONNECTOR) {
                    Network.unregisterNetwork(this);
                    return;
                }
                if (currentAssignment == Component.TERMINUS) {
                    this.terminusNodes.remove(l);
                }
                if (classification == Component.REGULATOR) {
                    this.regulatorNodes.add(l);
                    this.discoverNeighbors(l);
                } else if (classification == Component.CONNECTOR) {
                    this.connectorNodes.add(l);
                    this.discoverNeighbors(l);
                } else if (classification == Component.TERMINUS) {
                    this.terminusNodes.add(l);
                }
                this.locationClassificationChange(l, currentAssignment, classification);
            }
            if (++steps != 500) continue;
            break;
        }
    }

    private void discoverNeighbors(Location l, int xDiff, int yDiff, int zDiff) {
        for (int i = this.getRange() + 1; i > 0; --i) {
            Location new_location = l.clone().add((double)(i * xDiff), (double)(i * yDiff), (double)(i * zDiff));
            this.addLocationToNetwork(new_location);
        }
    }

    private void discoverNeighbors(Location l) {
        this.discoverNeighbors(l, 1, 0, 0);
        this.discoverNeighbors(l, -1, 0, 0);
        this.discoverNeighbors(l, 0, 1, 0);
        this.discoverNeighbors(l, 0, -1, 0);
        this.discoverNeighbors(l, 0, 0, 1);
        this.discoverNeighbors(l, 0, 0, -1);
    }

    public void display() {
        SlimefunStartup.instance.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)SlimefunStartup.instance, new Runnable(){

            @Override
            public void run() {
                for (Location l : Network.this.connectedLocations) {
                    try {
                        ParticleEffect.REDSTONE.display(l.clone().add(0.5, 0.5, 0.5), 0.0f, 0.0f, 0.0f, 0.0f, 1);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    public void tick() {
        this.discoverStep();
    }

    public static enum Component {
        CONNECTOR,
        REGULATOR,
        TERMINUS;

    }
}

