/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.androids;

import io.github.thebusybiscuit.slimefun4.api.events.AndroidMineEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;
import java.util.logging.Level;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ClickAction;
import me.mrCookieSlime.ExoticGarden.ExoticGarden;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Lists.SlimefunItems;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunBlockHandler;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.UnregisterReason;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineFuel;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.interfaces.InventoryBlock;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.Setup.SlimefunManager;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.androids.AndroidEntity;
import me.mrCookieSlime.Slimefun.androids.AndroidType;
import me.mrCookieSlime.Slimefun.androids.ScriptPart;
import me.mrCookieSlime.Slimefun.androids.comparators.ScriptReputationSorter;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import me.mrCookieSlime.Slimefun.cscorelib2.blocks.Vein;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.ChatInput;
import me.mrCookieSlime.Slimefun.cscorelib2.collections.RandomizedSet;
import me.mrCookieSlime.Slimefun.cscorelib2.config.Config;
import me.mrCookieSlime.Slimefun.cscorelib2.inventory.ItemUtils;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import me.mrCookieSlime.Slimefun.cscorelib2.materials.MaterialCollections;
import me.mrCookieSlime.Slimefun.cscorelib2.materials.MaterialConverter;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.ProtectableAction;
import me.mrCookieSlime.Slimefun.cscorelib2.skull.SkullBlock;
import me.mrCookieSlime.Slimefun.cscorelib2.skull.SkullItem;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Dispenser;
import org.bukkit.block.Skull;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Rotatable;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Animals;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public abstract class ProgrammableAndroid
extends SlimefunItem
implements InventoryBlock {
    private static final ItemStack EFFECTIVE_PICKAXE = new ItemStack(Material.DIAMOND_PICKAXE);
    private static final int[] border = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 18, 24, 25, 26, 27, 33, 35, 36, 42, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53};
    private static final int[] border_out = new int[]{10, 11, 12, 13, 14, 19, 23, 28, 32, 37, 38, 39, 40, 41};
    private static final RandomizedSet<ItemStack> fishingLoot = new RandomizedSet();
    private static final List<BlockFace> directions;
    private final Set<MachineFuel> recipes = new HashSet<MachineFuel>();
    private final String texture;

    @Override
    public int[] getInputSlots() {
        return new int[0];
    }

    @Override
    public int[] getOutputSlots() {
        return new int[]{20, 21, 22, 29, 30, 31};
    }

    public abstract AndroidType getAndroidType();

    public abstract float getFuelEfficiency();

    public abstract int getTier();

    public ProgrammableAndroid(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
        this.texture = item.getBase64Texture().orElse(null);
        if (this.getTier() == 1) {
            this.registerFuel(new MachineFuel(800, new ItemStack(Material.COAL_BLOCK)));
            this.registerFuel(new MachineFuel(45, new ItemStack(Material.BLAZE_ROD)));
            for (Material mat : Tag.ITEMS_COALS.getValues()) {
                this.registerFuel(new MachineFuel(8, new ItemStack(mat)));
            }
            for (Material mat : Tag.LOGS.getValues()) {
                this.registerFuel(new MachineFuel(2, new ItemStack(mat)));
            }
            for (Material mat : Tag.PLANKS.getValues()) {
                this.registerFuel(new MachineFuel(1, new ItemStack(mat)));
            }
        } else if (this.getTier() == 2) {
            this.registerFuel(new MachineFuel(100, new ItemStack(Material.LAVA_BUCKET)));
            this.registerFuel(new MachineFuel(200, SlimefunItems.BUCKET_OF_OIL));
            this.registerFuel(new MachineFuel(500, SlimefunItems.BUCKET_OF_FUEL));
        } else {
            this.registerFuel(new MachineFuel(2500, SlimefunItems.URANIUM));
            this.registerFuel(new MachineFuel(1200, SlimefunItems.NEPTUNIUM));
            this.registerFuel(new MachineFuel(3000, SlimefunItems.BOOSTED_URANIUM));
        }
        new BlockMenuPreset(this.getID(), "Programmable Android"){

            @Override
            public void init() {
                ProgrammableAndroid.this.constructMenu(this);
            }

            @Override
            public boolean canOpen(Block b, Player p) {
                boolean open;
                boolean bl = open = BlockStorage.getLocationInfo(b.getLocation(), "owner").equals(p.getUniqueId().toString()) || p.hasPermission("slimefun.android.bypass");
                if (!open) {
                    SlimefunPlugin.getLocal().sendMessage((CommandSender)p, "inventory.no-access", true);
                }
                return open;
            }

            @Override
            public void newInstance(BlockMenu menu, Block b) {
                menu.replaceExistingItem(15, new CustomItem(SkullItem.fromBase64("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZTAxYzdiNTcyNjE3ODk3NGIzYjNhMDFiNDJhNTkwZTU0MzY2MDI2ZmQ0MzgwOGYyYTc4NzY0ODg0M2E3ZjVhIn19fQ=="), "&aStart/Continue", new String[0]));
                menu.addMenuClickHandler(15, (p, slot, item, action) -> {
                    SlimefunPlugin.getLocal().sendMessage((CommandSender)p, "robot.started", true);
                    BlockStorage.addBlockInfo(b, "paused", "false");
                    p.closeInventory();
                    return false;
                });
                menu.replaceExistingItem(17, new CustomItem(SkullItem.fromBase64("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMTYxMzlmZDFjNTY1NGU1NmU5ZTRlMmM4YmU3ZWIyYmQ1YjQ5OWQ2MzM2MTY2NjNmZWVlOTliNzQzNTJhZDY0In19fQ=="), "&4Pause", new String[0]));
                menu.addMenuClickHandler(17, (p, slot, item, action) -> {
                    BlockStorage.addBlockInfo(b, "paused", "true");
                    SlimefunPlugin.getLocal().sendMessage((CommandSender)p, "robot.stopped", true);
                    return false;
                });
                menu.replaceExistingItem(16, new CustomItem(SkullItem.fromBase64("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZDc4ZjJiN2U1ZTc1NjM5ZWE3ZmI3OTZjMzVkMzY0YzRkZjI4YjQyNDNlNjZiNzYyNzdhYWRjZDYyNjEzMzcifX19"), "&bMemory Core", "", "&8\u21e8 &7Click to open the Script Editor"));
                menu.addMenuClickHandler(16, (p, slot, item, action) -> {
                    BlockStorage.addBlockInfo(b, "paused", "true");
                    SlimefunPlugin.getLocal().sendMessage((CommandSender)p, "robot.stopped", true);
                    ProgrammableAndroid.this.openScriptEditor(p, b);
                    return false;
                });
            }

            @Override
            public int[] getSlotsAccessedByItemTransport(ItemTransportFlow flow) {
                return new int[0];
            }
        };
        ProgrammableAndroid.registerBlockHandler(this.getID(), new SlimefunBlockHandler(){

            @Override
            public void onPlace(Player p, Block b, SlimefunItem item) {
                BlockStorage.addBlockInfo(b, "owner", p.getUniqueId().toString());
                BlockStorage.addBlockInfo(b, "script", "START-TURN_LEFT-REPEAT");
                BlockStorage.addBlockInfo(b, "index", "0");
                BlockStorage.addBlockInfo(b, "fuel", "0");
                BlockStorage.addBlockInfo(b, "rotation", p.getFacing().getOppositeFace().toString());
                BlockStorage.addBlockInfo(b, "paused", "true");
                b.setType(Material.PLAYER_HEAD);
                Rotatable blockData = (Rotatable)b.getBlockData();
                blockData.setRotation(p.getFacing());
                b.setBlockData((BlockData)blockData);
            }

            @Override
            public boolean onBreak(Player p, Block b, SlimefunItem item, UnregisterReason reason) {
                BlockMenu inv;
                boolean allow;
                boolean bl = allow = reason == UnregisterReason.PLAYER_BREAK && (BlockStorage.getLocationInfo(b.getLocation(), "owner").equals(p.getUniqueId().toString()) || p.hasPermission("slimefun.android.bypass"));
                if (allow && (inv = BlockStorage.getInventory(b)) != null) {
                    if (inv.getItemInSlot(43) != null) {
                        b.getWorld().dropItemNaturally(b.getLocation(), inv.getItemInSlot(43));
                        inv.replaceExistingItem(43, null);
                    }
                    for (int slot : ProgrammableAndroid.this.getOutputSlots()) {
                        if (inv.getItemInSlot(slot) == null) continue;
                        b.getWorld().dropItemNaturally(b.getLocation(), inv.getItemInSlot(slot));
                        inv.replaceExistingItem(slot, null);
                    }
                }
                return allow;
            }
        });
    }

    protected void tick(Block b) {
        if (!(b.getState() instanceof Skull)) {
            return;
        }
        if (BlockStorage.getLocationInfo(b.getLocation(), "paused").equals("false")) {
            BlockMenu menu = BlockStorage.getInventory(b);
            float fuel = Float.parseFloat(BlockStorage.getLocationInfo(b.getLocation(), "fuel"));
            if ((double)fuel < 0.001) {
                ItemStack item = menu.getItemInSlot(43);
                if (item != null) {
                    for (MachineFuel recipe : this.recipes) {
                        if (!SlimefunManager.isItemSimilar(item, recipe.getInput(), true)) continue;
                        menu.consumeItem(43);
                        if (this.getTier() == 2) {
                            menu.pushItem(new ItemStack(Material.BUCKET), this.getOutputSlots());
                        }
                        BlockStorage.addBlockInfo(b, "fuel", String.valueOf((int)((float)recipe.getTicks() * this.getFuelEfficiency())));
                        break;
                    }
                }
            } else {
                String[] script = BlockStorage.getLocationInfo(b.getLocation(), "script").split("-");
                int index = Integer.parseInt(BlockStorage.getLocationInfo(b.getLocation(), "index")) + 1;
                if (index >= script.length) {
                    index = 0;
                }
                boolean refresh = true;
                BlockStorage.addBlockInfo(b, "fuel", String.valueOf(fuel - 1.0f));
                ScriptPart part = ScriptPart.valueOf(script[index]);
                if (this.getAndroidType().isType(part.getRequiredType())) {
                    BlockFace face = BlockFace.valueOf((String)BlockStorage.getLocationInfo(b.getLocation(), "rotation"));
                    double damage = this.getTier() < 2 ? 20.0 : 4.0 * (double)this.getTier();
                    block0 : switch (part) {
                        case GO_DOWN: {
                            this.move(b, face, b.getRelative(BlockFace.DOWN));
                            break;
                        }
                        case GO_FORWARD: {
                            this.move(b, face, b.getRelative(face));
                            break;
                        }
                        case GO_UP: {
                            this.move(b, face, b.getRelative(BlockFace.UP));
                            break;
                        }
                        case REPEAT: {
                            BlockStorage.addBlockInfo(b, "index", String.valueOf(0));
                            break;
                        }
                        case TURN_LEFT: {
                            int indexLeft = directions.indexOf(BlockFace.valueOf((String)BlockStorage.getLocationInfo(b.getLocation(), "rotation"))) - 1;
                            if (indexLeft < 0) {
                                indexLeft = directions.size() - 1;
                            }
                            Rotatable rotatableLeft = (Rotatable)b.getBlockData();
                            rotatableLeft.setRotation(directions.get(indexLeft));
                            b.setBlockData((BlockData)rotatableLeft);
                            BlockStorage.addBlockInfo(b, "rotation", directions.get(indexLeft).toString());
                            break;
                        }
                        case TURN_RIGHT: {
                            int indexRight = directions.indexOf(BlockFace.valueOf((String)BlockStorage.getLocationInfo(b.getLocation(), "rotation"))) + 1;
                            if (indexRight == directions.size()) {
                                indexRight = 0;
                            }
                            Rotatable rotatableRight = (Rotatable)b.getBlockData();
                            rotatableRight.setRotation(directions.get(indexRight));
                            b.setBlockData((BlockData)rotatableRight);
                            BlockStorage.addBlockInfo(b, "rotation", directions.get(indexRight).toString());
                            break;
                        }
                        case DIG_FORWARD: {
                            this.mine(b, menu, b.getRelative(face));
                            break;
                        }
                        case DIG_UP: {
                            this.mine(b, menu, b.getRelative(BlockFace.UP));
                            break;
                        }
                        case DIG_DOWN: {
                            this.mine(b, menu, b.getRelative(BlockFace.DOWN));
                            break;
                        }
                        case CATCH_FISH: {
                            ItemStack drop;
                            Block water = b.getRelative(BlockFace.DOWN);
                            if (water.getType() != Material.WATER) break;
                            water.getWorld().playSound(water.getLocation(), Sound.ENTITY_PLAYER_SPLASH, 1.0f, 1.0f);
                            if (ThreadLocalRandom.current().nextInt(100) >= 10 * this.getTier() || !menu.fits(drop = fishingLoot.getRandom(), this.getOutputSlots())) break;
                            menu.pushItem(drop, this.getOutputSlots());
                            break;
                        }
                        case MOVE_AND_DIG_FORWARD: {
                            this.movedig(b, menu, face, b.getRelative(face));
                            break;
                        }
                        case MOVE_AND_DIG_UP: {
                            this.movedig(b, menu, face, b.getRelative(BlockFace.UP));
                            break;
                        }
                        case MOVE_AND_DIG_DOWN: {
                            this.movedig(b, menu, face, b.getRelative(BlockFace.DOWN));
                            break;
                        }
                        case INTERFACE_ITEMS: {
                            if (!BlockStorage.check(b.getRelative(face), "ANDROID_INTERFACE_ITEMS") || !(b.getRelative(face).getState() instanceof Dispenser)) break;
                            Dispenser d = (Dispenser)b.getRelative(face).getState();
                            for (int slot : this.getOutputSlots()) {
                                ItemStack stack = menu.getItemInSlot(slot);
                                if (stack == null) continue;
                                Optional optional = d.getInventory().addItem(new ItemStack[]{stack}).values().stream().findFirst();
                                if (optional.isPresent()) {
                                    menu.replaceExistingItem(slot, (ItemStack)optional.get());
                                    continue;
                                }
                                menu.replaceExistingItem(slot, null);
                            }
                            break;
                        }
                        case INTERFACE_FUEL: {
                            if (!BlockStorage.check(b.getRelative(face), "ANDROID_INTERFACE_FUEL") || !(b.getRelative(face).getState() instanceof Dispenser)) break;
                            Dispenser d = (Dispenser)b.getRelative(face).getState();
                            for (int slot = 0; slot < 9; ++slot) {
                                ItemStack item = d.getInventory().getItem(slot);
                                if (item == null) continue;
                                if (menu.getItemInSlot(43) == null) {
                                    menu.replaceExistingItem(43, item);
                                    d.getInventory().setItem(slot, null);
                                    break block0;
                                }
                                if (!SlimefunManager.isItemSimilar(item, menu.getItemInSlot(43), true)) continue;
                                int rest = item.getType().getMaxStackSize() - menu.getItemInSlot(43).getAmount();
                                if (rest <= 0) break block0;
                                int amt = item.getAmount() > rest ? rest : item.getAmount();
                                menu.replaceExistingItem(43, new CustomItem(item, menu.getItemInSlot(43).getAmount() + amt));
                                ItemUtils.consumeItem(item, amt, false);
                                break block0;
                            }
                            break;
                        }
                        case FARM_FORWARD: {
                            this.farm(menu, b.getRelative(face));
                            break;
                        }
                        case FARM_DOWN: {
                            this.farm(menu, b.getRelative(BlockFace.DOWN));
                            break;
                        }
                        case FARM_EXOTIC_FORWARD: {
                            this.exoticFarm(menu, b.getRelative(face));
                            break;
                        }
                        case FARM_EXOTIC_DOWN: {
                            this.exoticFarm(menu, b.getRelative(BlockFace.DOWN));
                            break;
                        }
                        case CHOP_TREE: {
                            ItemStack drop;
                            List<Block> list;
                            if (!MaterialCollections.getAllLogs().contains(b.getRelative(face).getType()) || (list = Vein.find(b.getRelative(face), 180, block -> MaterialCollections.getAllLogs().contains(block.getType()))).isEmpty()) break;
                            refresh = false;
                            Block log = list.get(list.size() - 1);
                            log.getWorld().playEffect(log.getLocation(), Effect.STEP_SOUND, (Object)log.getType());
                            if (!SlimefunPlugin.getProtectionManager().hasPermission(Bukkit.getOfflinePlayer((UUID)UUID.fromString(BlockStorage.getLocationInfo(b.getLocation(), "owner"))), log.getLocation(), ProtectableAction.BREAK_BLOCK) || !menu.fits(drop = new ItemStack(log.getType()), this.getOutputSlots())) break;
                            menu.pushItem(drop, this.getOutputSlots());
                            log.getWorld().playEffect(log.getLocation(), Effect.STEP_SOUND, (Object)log.getType());
                            if (log.getY() == b.getRelative(face).getY()) {
                                Optional<Material> sapling = MaterialConverter.getSaplingFromLog(log.getType());
                                if (!sapling.isPresent()) break;
                                log.setType(sapling.get());
                                break;
                            }
                            log.setType(Material.AIR);
                            break;
                        }
                        case ATTACK_MOBS_ANIMALS: {
                            this.killEntities(b, damage, e -> true);
                            break;
                        }
                        case ATTACK_MOBS: {
                            this.killEntities(b, damage, e -> e instanceof Monster);
                            break;
                        }
                        case ATTACK_ANIMALS: {
                            this.killEntities(b, damage, e -> e instanceof Animals);
                            break;
                        }
                        case ATTACK_ANIMALS_ADULT: {
                            this.killEntities(b, damage, e -> e instanceof Animals && e instanceof org.bukkit.entity.Ageable && ((org.bukkit.entity.Ageable)e).isAdult());
                            break;
                        }
                    }
                }
                if (refresh) {
                    BlockStorage.addBlockInfo(b, "index", String.valueOf(index));
                }
            }
        }
    }

    private void killEntities(Block b, double damage, Predicate<Entity> predicate) {
        double radius = 4.0 + (double)this.getTier();
        for (Entity n2 : b.getWorld().getNearbyEntities(b.getLocation(), radius, radius, radius, n -> n instanceof LivingEntity && !(n instanceof ArmorStand) && !(n instanceof Player) && n.isValid() && predicate.test((Entity)n))) {
            boolean attack = false;
            switch (BlockFace.valueOf((String)BlockStorage.getLocationInfo(b.getLocation(), "rotation"))) {
                case NORTH: {
                    attack = n2.getLocation().getZ() < (double)b.getZ();
                    break;
                }
                case EAST: {
                    attack = n2.getLocation().getX() > (double)b.getX();
                    break;
                }
                case SOUTH: {
                    attack = n2.getLocation().getZ() > (double)b.getZ();
                    break;
                }
                case WEST: {
                    attack = n2.getLocation().getX() < (double)b.getX();
                    break;
                }
            }
            if (!attack) continue;
            if (n2.hasMetadata("android_killer")) {
                n2.removeMetadata("android_killer", (Plugin)SlimefunPlugin.instance);
            }
            n2.setMetadata("android_killer", (MetadataValue)new FixedMetadataValue((Plugin)SlimefunPlugin.instance, (Object)new AndroidEntity(this, b)));
            ((LivingEntity)n2).damage(damage);
            break;
        }
    }

    private void move(Block b, BlockFace face, Block block) {
        if (block.getY() > 0 && block.getY() < block.getWorld().getMaxHeight() && (block.getType() == Material.AIR || block.getType() == Material.CAVE_AIR)) {
            block.setType(Material.PLAYER_HEAD);
            Rotatable blockData = (Rotatable)block.getBlockData();
            blockData.setRotation(face.getOppositeFace());
            block.setBlockData((BlockData)blockData);
            SkullBlock.setFromBase64(block, this.texture);
            b.setType(Material.AIR);
            BlockStorage.moveBlockInfo(b.getLocation(), block.getLocation());
        }
    }

    private void mine(Block b, BlockMenu menu, Block block) {
        Collection drops = block.getDrops(EFFECTIVE_PICKAXE);
        if (!MaterialCollections.getAllUnbreakableBlocks().contains(block.getType()) && !drops.isEmpty() && SlimefunPlugin.getProtectionManager().hasPermission(Bukkit.getOfflinePlayer((UUID)UUID.fromString(BlockStorage.getLocationInfo(b.getLocation(), "owner"))), block.getLocation(), ProtectableAction.BREAK_BLOCK)) {
            String item = BlockStorage.checkID(block);
            AndroidMineEvent event = new AndroidMineEvent(block, new AndroidEntity(this, b));
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            if (item == null) {
                for (ItemStack drop : drops) {
                    if (!menu.fits(drop, this.getOutputSlots())) continue;
                    menu.pushItem(drop, this.getOutputSlots());
                    block.getWorld().playEffect(block.getLocation(), Effect.STEP_SOUND, (Object)block.getType());
                    block.setType(Material.AIR);
                }
            }
        }
    }

    private void movedig(Block b, BlockMenu menu, BlockFace face, Block block) {
        Collection drops = block.getDrops(EFFECTIVE_PICKAXE);
        if (!MaterialCollections.getAllUnbreakableBlocks().contains(block.getType()) && !drops.isEmpty() && SlimefunPlugin.getProtectionManager().hasPermission(Bukkit.getOfflinePlayer((UUID)UUID.fromString(BlockStorage.getLocationInfo(b.getLocation(), "owner"))), block.getLocation(), ProtectableAction.BREAK_BLOCK)) {
            SlimefunItem item = BlockStorage.check(block);
            AndroidMineEvent event = new AndroidMineEvent(block, new AndroidEntity(this, b));
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            if (item == null) {
                for (ItemStack drop : drops) {
                    if (!menu.fits(drop, this.getOutputSlots())) continue;
                    menu.pushItem(drop, this.getOutputSlots());
                    block.getWorld().playEffect(block.getLocation(), Effect.STEP_SOUND, (Object)block.getType());
                    block.setType(Material.AIR);
                    this.move(b, face, block);
                    b.setType(Material.AIR);
                    BlockStorage.moveBlockInfo(b.getLocation(), block.getLocation());
                }
            }
        } else {
            this.move(b, face, block);
        }
    }

    private boolean isFullGrown(Block block) {
        if (!(block.getBlockData() instanceof Ageable)) {
            return false;
        }
        Ageable ageable = (Ageable)block.getBlockData();
        return ageable.getAge() >= ageable.getMaximumAge();
    }

    private void farm(BlockMenu menu, Block block) {
        ItemStack drop;
        if (this.isFullGrown(block) && (drop = this.getDropFromCrop(block.getType())) != null && menu.fits(drop, this.getOutputSlots())) {
            menu.pushItem(drop, this.getOutputSlots());
            Ageable ageable = (Ageable)block.getBlockData();
            ageable.setAge(0);
            block.setBlockData((BlockData)ageable);
            block.getWorld().playEffect(block.getLocation(), Effect.STEP_SOUND, (Object)block.getType());
        }
    }

    private ItemStack getDropFromCrop(Material crop) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        switch (crop) {
            case WHEAT: {
                return new ItemStack(Material.WHEAT, ((Random)random).nextInt(2) + 1);
            }
            case POTATOES: {
                return new ItemStack(Material.POTATO, ((Random)random).nextInt(3) + 1);
            }
            case CARROTS: {
                return new ItemStack(Material.CARROT, ((Random)random).nextInt(3) + 1);
            }
            case BEETROOTS: {
                return new ItemStack(Material.BEETROOT, ((Random)random).nextInt(3) + 1);
            }
            case COCOA: {
                return new ItemStack(Material.COCOA_BEANS, ((Random)random).nextInt(3) + 1);
            }
            case NETHER_WART: {
                return new ItemStack(Material.NETHER_WART, ((Random)random).nextInt(3) + 1);
            }
            case SWEET_BERRY_BUSH: {
                return new ItemStack(Material.SWEET_BERRIES, ((Random)random).nextInt(3) + 1);
            }
        }
        return null;
    }

    private void exoticFarm(BlockMenu menu, Block block) {
        ItemStack drop;
        this.farm(menu, block);
        if (SlimefunPlugin.getHooks().isExoticGardenInstalled() && (drop = ExoticGarden.harvestPlant((Block)block)) != null && menu.fits(drop, this.getOutputSlots())) {
            menu.pushItem(drop, this.getOutputSlots());
            block.getWorld().playEffect(block.getLocation(), Effect.STEP_SOUND, (Object)block.getType());
        }
    }

    private void constructMenu(BlockMenuPreset preset) {
        for (int i : border) {
            preset.addItem(i, new CustomItem(new ItemStack(Material.GRAY_STAINED_GLASS_PANE), " ", new String[0]), (p, slot, item, action) -> false);
        }
        for (int i : border_out) {
            preset.addItem(i, new CustomItem(new ItemStack(Material.ORANGE_STAINED_GLASS_PANE), " ", new String[0]), (p, slot, item, action) -> false);
        }
        for (int i : this.getOutputSlots()) {
            preset.addMenuClickHandler(i, (ChestMenu.MenuClickHandler)new ChestMenu.AdvancedMenuClickHandler(){

                public boolean onClick(Player p, int slot, ItemStack cursor, ClickAction action) {
                    return false;
                }

                public boolean onClick(InventoryClickEvent e, Player p, int slot, ItemStack cursor, ClickAction action) {
                    return cursor == null || cursor.getType() == null || cursor.getType() == Material.AIR;
                }
            });
        }
        if (this.getTier() == 1) {
            preset.addItem(34, new CustomItem(SkullItem.fromBase64("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvOTM0M2NlNThkYTU0Yzc5OTI0YTJjOTMzMWNmYzQxN2ZlOGNjYmJlYTliZTQ1YTdhYzg1ODYwYTZjNzMwIn19fQ=="), "&8\u21e9 &cFuel Input &8\u21e9", "", "&rThis Android runs on solid Fuel", "&re.g. Coal, Wood, etc..."), (p, slot, item, action) -> false);
        } else if (this.getTier() == 2) {
            preset.addItem(34, new CustomItem(SkullItem.fromBase64("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvOTM0M2NlNThkYTU0Yzc5OTI0YTJjOTMzMWNmYzQxN2ZlOGNjYmJlYTliZTQ1YTdhYzg1ODYwYTZjNzMwIn19fQ=="), "&8\u21e9 &cFuel Input &8\u21e9", "", "&rThis Android runs on liquid Fuel", "&re.g. Lava, Oil, Fuel, etc..."), (p, slot, item, action) -> false);
        } else {
            preset.addItem(34, new CustomItem(SkullItem.fromBase64("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvOTM0M2NlNThkYTU0Yzc5OTI0YTJjOTMzMWNmYzQxN2ZlOGNjYmJlYTliZTQ1YTdhYzg1ODYwYTZjNzMwIn19fQ=="), "&8\u21e9 &cFuel Input &8\u21e9", "", "&rThis Android runs on radioactive Fuel", "&re.g. Uranium, Neptunium or Boosted Uranium"), (p, slot, item, action) -> false);
        }
    }

    public void openScriptEditor(Player p, Block b) {
        ChestMenu menu = new ChestMenu("&eScript Editor");
        try {
            menu.addItem(1, (ItemStack)new CustomItem(SkullItem.fromBase64("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZDliZjZkYjRhZWRhOWQ4ODIyYjlmNzM2NTM4ZThjMThiOWE0ODQ0Zjg0ZWI0NTUwNGFkZmJmZWU4N2ViIn19fQ=="), "&2> Edit Script", "", "&aEdits your current Script"));
            menu.addMenuClickHandler(1, (pl, slot, item, action) -> {
                this.openScript(pl, b, BlockStorage.getLocationInfo(b.getLocation(), "script"));
                return false;
            });
            menu.addItem(3, (ItemStack)new CustomItem(SkullItem.fromBase64("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMTcxZDg5NzljMTg3OGEwNTk4N2E3ZmFmMjFiNTZkMWI3NDRmOWQwNjhjNzRjZmZjZGUxZWExZWRhZDU4NTIifX19"), "&4> Create new Script", "", "&cDeletes your current Script", "&cand creates a blank one"));
            menu.addMenuClickHandler(3, (pl, slot, item, action) -> {
                this.openScript(pl, b, "START-TURN_LEFT-REPEAT");
                return false;
            });
            menu.addItem(5, (ItemStack)new CustomItem(SkullItem.fromBase64("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYzAxNTg2ZTM5ZjZmZmE2M2I0ZmIzMDFiNjVjYTdkYThhOTJmNzM1M2FhYWI4OWQzODg2NTc5MTI1ZGZiYWY5In19fQ=="), "&6> Download a Script", "", "&eDownload a Script from the Server", "&eYou can edit or simply use it"));
            menu.addMenuClickHandler(5, (pl, slot, item, action) -> {
                this.openScriptDownloader(pl, b, 1);
                return false;
            });
            menu.addItem(8, (ItemStack)new CustomItem(SkullItem.fromBase64("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYTE4NWM5N2RiYjgzNTNkZTY1MjY5OGQyNGI2NDMyN2I3OTNhM2YzMmE5OGJlNjdiNzE5ZmJlZGFiMzVlIn19fQ=="), "&6> Back", "", "&7Return to the Android's interface"));
            menu.addMenuClickHandler(8, (pl, slot, item, action) -> {
                BlockStorage.getInventory(b).open(new Player[]{p});
                return false;
            });
        }
        catch (Exception x) {
            Slimefun.getLogger().log(Level.SEVERE, "An Error occured while creating the Script Editor for Slimefun " + Slimefun.getVersion(), x);
        }
        menu.open(new Player[]{p});
    }

    public void openScript(Player p, Block b, String script) {
        ChestMenu menu = new ChestMenu("&eScript Editor");
        String[] commands = script.split("-");
        menu.addItem(0, (ItemStack)new CustomItem(ScriptPart.START.toItemStack(), ScriptPart.START.toItemStack().getItemMeta().getDisplayName(), "", "&7\u21e8 &eLeft Click &7to return to the Android's interface"));
        menu.addMenuClickHandler(0, (pl, slot, item, action) -> {
            BlockStorage.getInventory(b).open(new Player[]{pl});
            return false;
        });
        for (int i = 1; i < commands.length; ++i) {
            int index = i;
            if (i == commands.length - 1) {
                int additional;
                int n = additional = commands.length == 54 ? 0 : 1;
                if (additional == 1) {
                    try {
                        menu.addItem(i, (ItemStack)new CustomItem(SkullItem.fromBase64("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMTcxZDg5NzljMTg3OGEwNTk4N2E3ZmFmMjFiNTZkMWI3NDRmOWQwNjhjNzRjZmZjZGUxZWExZWRhZDU4NTIifX19"), "&7> Add new Command", new String[0]));
                        menu.addMenuClickHandler(i, (pl, slot, item, action) -> {
                            this.openScriptComponentEditor(pl, b, script, index);
                            return false;
                        });
                    }
                    catch (Exception x) {
                        Slimefun.getLogger().log(Level.SEVERE, "An Error occured while creating the Script Editor for Slimefun " + Slimefun.getVersion(), x);
                    }
                }
                menu.addItem(i + additional, (ItemStack)new CustomItem(ScriptPart.REPEAT.toItemStack(), ScriptPart.REPEAT.toItemStack().getItemMeta().getDisplayName(), "", "&7\u21e8 &eLeft Click &7to return to the Android's interface"));
                menu.addMenuClickHandler(i + additional, (pl, slot, item, action) -> {
                    BlockStorage.getInventory(b).open(new Player[]{pl});
                    return false;
                });
                continue;
            }
            ItemStack stack = ScriptPart.valueOf(commands[i]).toItemStack();
            menu.addItem(i, (ItemStack)new CustomItem(stack, stack.getItemMeta().getDisplayName(), "", "&7\u21e8 &eLeft Click &7to edit", "&7\u21e8 &eRight Click &7to delete", "&7\u21e8 &eShift + Right Click &7to duplicate"));
            menu.addMenuClickHandler(i, (pl, slot, item, action) -> {
                if (action.isRightClicked() && action.isShiftClicked()) {
                    if (commands.length == 54) {
                        return false;
                    }
                    int j = 0;
                    StringBuilder builder = new StringBuilder("START-");
                    for (String command : commands) {
                        if (j > 0) {
                            if (j == index) {
                                builder.append(commands[j] + "-");
                                builder.append(commands[j] + "-");
                            } else if (j < commands.length - 1) {
                                builder.append(command + "-");
                            }
                        }
                        ++j;
                    }
                    builder.append("REPEAT");
                    BlockStorage.addBlockInfo(b, "script", builder.toString());
                    this.openScript(pl, b, builder.toString());
                } else if (action.isRightClicked()) {
                    int j = 0;
                    StringBuilder builder = new StringBuilder("START-");
                    for (String command : commands) {
                        if (j != index && j > 0 && j < commands.length - 1) {
                            builder.append(command + "-");
                        }
                        ++j;
                    }
                    builder.append("REPEAT");
                    BlockStorage.addBlockInfo(b, "script", builder.toString());
                    this.openScript(pl, b, builder.toString());
                } else {
                    this.openScriptComponentEditor(pl, b, script, index);
                }
                return false;
            });
        }
        menu.open(new Player[]{p});
    }

    private void openScriptDownloader(Player p, Block b, int page) {
        int target;
        ChestMenu menu = new ChestMenu("Android Scripts");
        menu.addMenuOpeningHandler(pl -> pl.playSound(pl.getLocation(), Sound.BLOCK_NOTE_BLOCK_HAT, 0.7f, 0.7f));
        List<Config> scripts = this.getUploadedScripts();
        int index = 0;
        int pages = scripts.size() / 45 + 1;
        for (int i = 45; i < 54; ++i) {
            menu.addItem(i, (ItemStack)new CustomItem(new ItemStack(Material.GRAY_STAINED_GLASS_PANE), " ", new String[0]));
            menu.addMenuClickHandler(i, (pl, slot, item, action) -> false);
        }
        menu.addItem(46, (ItemStack)new CustomItem(new ItemStack(Material.LIME_STAINED_GLASS_PANE), "&r\u21e6 Previous Page", "", "&7(" + page + " / " + pages + ")"));
        menu.addMenuClickHandler(46, (pl, slot, item, action) -> {
            int next = page - 1;
            if (next < 1) {
                next = pages;
            }
            if (next != page) {
                this.openScriptDownloader(pl, b, next);
            }
            return false;
        });
        try {
            menu.addItem(48, (ItemStack)new CustomItem(SkullItem.fromBase64("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMTA1YTJjYWI4YjY4ZWE1N2UzYWY5OTJhMzZlNDdjOGZmOWFhODdjYzg3NzYyODE5NjZmOGMzY2YzMWEzOCJ9fX0="), "&eUpload a Script", "", "&6Click &7to upload your Android's Script", "&7to the Database"));
            menu.addMenuClickHandler(48, (pl, slot, item, action) -> {
                String code = BlockStorage.getLocationInfo(b.getLocation(), "script");
                int num = 1;
                for (Config script : this.getUploadedScripts()) {
                    if (script.getString("author").equals(pl.getUniqueId().toString())) {
                        ++num;
                    }
                    if (!script.getString("code").equals(code)) continue;
                    SlimefunPlugin.getLocal().sendMessage((CommandSender)pl, "android.scripts.already-uploaded", true);
                    return false;
                }
                int id = num;
                pl.closeInventory();
                SlimefunPlugin.getLocal().sendMessages((CommandSender)pl, "android.scripts.enter-name");
                ChatInput.waitForPlayer((Plugin)SlimefunPlugin.instance, pl, message -> {
                    Config script = new Config("plugins/Slimefun/scripts/" + this.getAndroidType().toString() + '/' + p.getName() + ' ' + id + ".sfs");
                    script.setValue("author", pl.getUniqueId().toString());
                    script.setValue("author_name", pl.getName());
                    script.setValue("name", ChatColor.stripColor((String)ChatColor.translateAlternateColorCodes((char)'&', (String)message)));
                    script.setValue("code", code);
                    script.setValue("downloads", 0);
                    script.setValue("android", this.getAndroidType().toString());
                    script.setValue("rating.positive", new ArrayList());
                    script.setValue("rating.negative", new ArrayList());
                    script.save();
                    SlimefunPlugin.getLocal().sendMessages((CommandSender)pl, "android.scripts.uploaded");
                    this.openScriptDownloader(pl, b, page);
                });
                return false;
            });
            menu.addItem(50, (ItemStack)new CustomItem(new ItemStack(Material.LIME_STAINED_GLASS_PANE), "&rNext Page \u21e8", "", "&7(" + page + " / " + pages + ")"));
            menu.addMenuClickHandler(50, (pl, slot, item, action) -> {
                int next = page + 1;
                if (next > pages) {
                    next = 1;
                }
                if (next != page) {
                    this.openScriptDownloader(pl, b, next);
                }
                return false;
            });
            menu.addItem(53, (ItemStack)new CustomItem(SkullItem.fromBase64("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYTE4NWM5N2RiYjgzNTNkZTY1MjY5OGQyNGI2NDMyN2I3OTNhM2YzMmE5OGJlNjdiNzE5ZmJlZGFiMzVlIn19fQ=="), "&6> Back", "", "&7Return to the Android's interface"));
            menu.addMenuClickHandler(53, (pl, slot, item, action) -> {
                this.openScriptEditor(pl, b);
                return false;
            });
        }
        catch (Exception x) {
            Slimefun.getLogger().log(Level.SEVERE, "An Error occured while creating the Script Download Menu for Slimefun " + Slimefun.getVersion(), x);
        }
        int categoryIndex = 45 * (page - 1);
        for (int i = 0; i < 45 && (target = categoryIndex + i) < scripts.size(); ++i) {
            String author;
            Config script = scripts.get(target);
            OfflinePlayer op = Bukkit.getOfflinePlayer((UUID)script.getUUID("author"));
            String string = author = op != null && op.getName() != null ? op.getName() : script.getString("author_name");
            if (script.getString("author").equals(p.getUniqueId().toString())) {
                menu.addItem(index, (ItemStack)new CustomItem(this.getItem(), "&b" + script.getString("name"), "&7by &r" + author, "", "&7Downloads: &r" + script.getInt("downloads"), "&7Rating: " + this.getScriptRatingPercentage(script), "&a" + this.getScriptRating(script, true) + " \u263a &7- &4\u2639 " + this.getScriptRating(script, false), "", "&eLeft Click &rto download this Script", "&4(This will override your current Script)"));
            } else {
                menu.addItem(index, (ItemStack)new CustomItem(this.getItem(), "&b" + script.getString("name"), "&7by &r" + author, "", "&7Downloads: &r" + script.getInt("downloads"), "&7Rating: " + this.getScriptRatingPercentage(script), "&a" + this.getScriptRating(script, true) + " \u263a &7- &4\u2639 " + this.getScriptRating(script, false), "", "&eLeft Click &rto download this Script", "&4(This will override your current Script)", "&eShift + Left Click &rto leave a positive Rating", "&eShift + Right Click &rto leave a negative Rating"));
            }
            menu.addMenuClickHandler(index, (pl, slot, item, action) -> {
                Config script2 = new Config(script.getFile());
                if (action.isShiftClicked()) {
                    if (script2.getString("author").equals(pl.getUniqueId().toString())) {
                        SlimefunPlugin.getLocal().sendMessage((CommandSender)pl, "android.scripts.rating.own", true);
                    } else if (action.isRightClicked()) {
                        if (!script2.getStringList("rating.negative").contains(pl.getUniqueId().toString()) && !script2.getStringList("rating.positive").contains(pl.getUniqueId().toString())) {
                            List<String> list = script2.getStringList("rating.negative");
                            list.add(p.getUniqueId().toString());
                            script2.setValue("rating.negative", list);
                            script2.save();
                            this.openScriptDownloader(pl, b, page);
                        } else {
                            SlimefunPlugin.getLocal().sendMessage((CommandSender)pl, "android.scripts.rating.already", true);
                        }
                    } else if (!script2.getStringList("rating.negative").contains(pl.getUniqueId().toString()) && !script2.getStringList("rating.positive").contains(pl.getUniqueId().toString())) {
                        List<String> list = script2.getStringList("rating.positive");
                        list.add(pl.getUniqueId().toString());
                        script2.setValue("rating.positive", list);
                        script2.save();
                        this.openScriptDownloader(pl, b, page);
                    } else {
                        SlimefunPlugin.getLocal().sendMessage((CommandSender)pl, "android.scripts.rating.already", true);
                    }
                } else if (!action.isRightClicked()) {
                    script2.setValue("downloads", script2.getInt("downloads") + 1);
                    script2.save();
                    BlockStorage.addBlockInfo(b, "script", script2.getString("code"));
                    this.openScriptEditor(pl, b);
                }
                return false;
            });
            ++index;
        }
        menu.open(new Player[]{p});
    }

    public float getScriptRating(Config script) {
        int positive = this.getScriptRating(script, true) + 1;
        int negative = this.getScriptRating(script, false);
        return (float)Math.round((double)positive / (double)(positive + negative) * 100.0) / 100.0f;
    }

    private int getScriptRating(Config script, boolean positive) {
        if (positive) {
            return script.getStringList("rating.positive").size();
        }
        return script.getStringList("rating.negative").size();
    }

    private String getScriptRatingPercentage(Config script) {
        String progress = String.valueOf(this.getScriptRating(script));
        progress = Float.parseFloat(progress) < 16.0f ? "&4" + progress + "&r% " : (Float.parseFloat(progress) < 32.0f ? "&c" + progress + "&r% " : (Float.parseFloat(progress) < 48.0f ? "&6" + progress + "&r% " : (Float.parseFloat(progress) < 64.0f ? "&e" + progress + "&r% " : (Float.parseFloat(progress) < 80.0f ? "&2" + progress + "&r% " : "&a" + progress + "&r% "))));
        return progress;
    }

    protected void openScriptComponentEditor(Player p, Block b, String script, int index) {
        ChestMenu menu = new ChestMenu("&eScript Editor");
        String[] commands = script.split("-");
        for (int i = 0; i < 9; ++i) {
            menu.addItem(i, (ItemStack)new CustomItem(new ItemStack(Material.GRAY_STAINED_GLASS_PANE), " ", new String[0]), (pl, slot, item, action) -> false);
        }
        try {
            menu.addItem(9, (ItemStack)new CustomItem(SkullItem.fromBase64("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMTYxMzlmZDFjNTY1NGU1NmU5ZTRlMmM4YmU3ZWIyYmQ1YjQ5OWQ2MzM2MTY2NjNmZWVlOTliNzQzNTJhZDY0In19fQ=="), "&rDo nothing", new String[0]), (pl, slot, item, action) -> {
                int i = 0;
                StringBuilder builder = new StringBuilder("START-");
                for (String command : commands) {
                    if (i != index && i > 0 && i < commands.length - 1) {
                        builder.append(command + "-");
                    }
                    ++i;
                }
                builder.append("REPEAT");
                BlockStorage.addBlockInfo(b, "script", builder.toString());
                this.openScript(p, b, builder.toString());
                return false;
            });
        }
        catch (Exception x) {
            Slimefun.getLogger().log(Level.SEVERE, "An Error occured while creating the Script Editor for Slimefun " + Slimefun.getVersion(), x);
        }
        int i = 10;
        for (ScriptPart part : this.getAccessibleScriptParts()) {
            menu.addItem(i, part.toItemStack());
            menu.addMenuClickHandler(i, (pl, slot, item, action) -> {
                int j = 0;
                StringBuilder builder = new StringBuilder("START-");
                for (String command : commands) {
                    if (j > 0) {
                        if (j == index) {
                            builder.append(part.toString() + "-");
                        } else if (j < commands.length - 1) {
                            builder.append(command + "-");
                        }
                    }
                    ++j;
                }
                builder.append("REPEAT");
                BlockStorage.addBlockInfo(b, "script", builder.toString());
                this.openScript(pl, b, builder.toString());
                return false;
            });
            ++i;
        }
        menu.open(new Player[]{p});
    }

    public void addItems(Block b, ItemStack ... items) {
        for (ItemStack item : items) {
            BlockStorage.getInventory(b).pushItem(item, this.getOutputSlots());
        }
    }

    @Override
    public void register(boolean slimefun) {
        this.addItemHandler(new BlockTicker(){

            @Override
            public void tick(Block b, SlimefunItem sf, me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config data) {
                if (b != null) {
                    ProgrammableAndroid.this.tick(b);
                }
            }

            @Override
            public boolean isSynchronized() {
                return true;
            }
        });
        super.register(slimefun);
    }

    public void registerFuel(MachineFuel fuel) {
        this.recipes.add(fuel);
    }

    public List<Config> getUploadedScripts() {
        ArrayList<Config> scripts = new ArrayList<Config>();
        File directory = new File("plugins/Slimefun/scripts/" + this.getAndroidType().toString());
        if (!directory.exists()) {
            directory.mkdirs();
        }
        for (File script : directory.listFiles()) {
            if (!script.getName().endsWith("sfs")) continue;
            scripts.add(new Config(script));
        }
        if (this.getAndroidType() != AndroidType.NONE) {
            File directory2 = new File("plugins/Slimefun/scripts/NONE");
            if (!directory2.exists()) {
                directory2.mkdirs();
            }
            for (File script : directory2.listFiles()) {
                if (!script.getName().endsWith("sfs")) continue;
                scripts.add(new Config(script));
            }
        }
        Collections.sort(scripts, new ScriptReputationSorter(this));
        return scripts;
    }

    public List<ScriptPart> getAccessibleScriptParts() {
        ArrayList<ScriptPart> list = new ArrayList<ScriptPart>();
        for (ScriptPart part : ScriptPart.values()) {
            if (part == ScriptPart.START || part == ScriptPart.REPEAT || !this.getAndroidType().isType(part.getRequiredType())) continue;
            list.add(part);
        }
        return list;
    }

    static {
        for (Material fish : MaterialCollections.getAllFishItems()) {
            fishingLoot.add(new ItemStack(fish), 20.0f);
        }
        fishingLoot.add(new ItemStack(Material.BONE), 10.0f);
        fishingLoot.add(new ItemStack(Material.STRING), 10.0f);
        fishingLoot.add(new ItemStack(Material.STICK), 5.0f);
        fishingLoot.add(new ItemStack(Material.INK_SAC), 4.0f);
        fishingLoot.add(new ItemStack(Material.ROTTEN_FLESH), 3.0f);
        fishingLoot.add(new ItemStack(Material.LEATHER), 2.0f);
        directions = Arrays.asList(BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST);
    }
}

