/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.cscorelib2.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import me.mrCookieSlime.Slimefun.cscorelib2.collections.Streamable;

public class LoopIterator<T>
implements Iterator<T>,
Streamable<T> {
    private List<T> list;
    private int size;
    private int index = 0;

    public LoopIterator(@NonNull Collection<T> collection) {
        if (collection == null) {
            throw new NullPointerException("collection is marked non-null but is null");
        }
        this.init(collection);
    }

    public LoopIterator(@NonNull Streamable<T> streamable) {
        if (streamable == null) {
            throw new NullPointerException("streamable is marked non-null but is null");
        }
        if (streamable instanceof LoopIterator) {
            throw new IllegalArgumentException("Cannot loop-iterate over a LoopIterator");
        }
        this.init(streamable.stream().collect(Collectors.toList()));
    }

    private void init(Collection<T> collection) {
        this.size = collection.size();
        this.list = this.size > 0 ? new ArrayList<T>(collection) : null;
    }

    @Override
    public boolean hasNext() {
        return this.size > 0;
    }

    @Override
    public T next() {
        if (this.list == null) {
            throw new NoSuchElementException("The given collection was empty.");
        }
        if (this.index >= this.size) {
            this.index = 0;
        }
        return this.list.get(this.index++);
    }

    @Override
    public Stream<T> stream() {
        return Stream.generate(this::next);
    }

    public int getIndex() {
        return this.index;
    }
}

