/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.api;

import java.util.Optional;
import java.util.function.Consumer;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import me.mrCookieSlime.Slimefun.cscorelib2.item.ImmutableItemMeta;
import me.mrCookieSlime.Slimefun.cscorelib2.skull.SkullItem;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class SlimefunItemStack
extends CustomItem {
    private String id;
    private ImmutableItemMeta immutableMeta;
    private final String texture;

    public SlimefunItemStack(String id, Material type, String name, String ... lore) {
        super(type, name, lore);
        this.texture = null;
        this.setID(id);
    }

    public SlimefunItemStack(String id, Material type, Color color, String name, String ... lore) {
        super(new ItemStack(type), color, name, lore);
        this.texture = null;
        this.setID(id);
    }

    public SlimefunItemStack(String id, ItemStack item, String name, String ... lore) {
        super(item, name, lore);
        this.texture = null;
        this.setID(id);
    }

    public SlimefunItemStack(String id, ItemStack item) {
        super(item);
        this.texture = null;
        this.setID(id);
    }

    public SlimefunItemStack(String id, ItemStack item, Consumer<ItemMeta> consumer) {
        super(item, consumer);
        this.texture = null;
        this.setID(id);
    }

    public SlimefunItemStack(String id, Material type, String name, Consumer<ItemMeta> consumer) {
        super(type, (ItemMeta meta) -> {
            if (name != null) {
                meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)name));
            }
            consumer.accept((ItemMeta)meta);
        });
        this.texture = null;
        this.setID(id);
    }

    public SlimefunItemStack(String id, String texture, String name, String ... lore) {
        super(SkullItem.fromBase64(texture), name, lore);
        this.texture = texture;
        this.setID(id);
    }

    public SlimefunItemStack(String id, String texture, String name, Consumer<ItemMeta> consumer) {
        super(SkullItem.fromBase64(texture), (ItemMeta meta) -> {
            if (name != null) {
                meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)name));
            }
            consumer.accept((ItemMeta)meta);
        });
        this.texture = texture;
        this.setID(id);
    }

    public SlimefunItemStack(String id, String texture, Consumer<ItemMeta> consumer) {
        super(SkullItem.fromBase64(texture), consumer);
        this.texture = texture;
        this.setID(id);
    }

    private void setID(String id) {
        this.id = id;
        ItemMeta meta = this.getItemMeta();
        SlimefunPlugin.getItemDataService().setItemData(meta, id);
        SlimefunPlugin.getItemTextureService().setTexture(meta, id);
        this.setItemMeta(meta);
    }

    public String getItemID() {
        return this.id;
    }

    public ImmutableItemMeta getImmutableMeta() {
        return this.immutableMeta;
    }

    public boolean setItemMeta(ItemMeta meta) {
        this.immutableMeta = new ImmutableItemMeta(meta);
        return super.setItemMeta(meta);
    }

    public ItemStack clone() {
        SlimefunItemStack item = (SlimefunItemStack)super.clone();
        item.id = this.getItemID();
        return item;
    }

    public Optional<String> getBase64Texture() {
        return Optional.ofNullable(this.texture);
    }
}

