/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.api;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import me.mrCookieSlime.Slimefun.Objects.Research;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.HashedArmorpiece;
import me.mrCookieSlime.Slimefun.api.inventory.BackpackInventory;
import me.mrCookieSlime.Slimefun.cscorelib2.config.Config;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public final class PlayerProfile {
    private final UUID uuid;
    private final String name;
    private final Config cfg;
    private boolean dirty = false;
    private boolean markedForDeletion = false;
    private final Set<Research> researches = new HashSet<Research>();
    private final Map<Integer, BackpackInventory> backpacks = new HashMap<Integer, BackpackInventory>();
    private final LinkedList<Object> guideHistory = new LinkedList();
    private final HashedArmorpiece[] armor = new HashedArmorpiece[]{new HashedArmorpiece(), new HashedArmorpiece(), new HashedArmorpiece(), new HashedArmorpiece()};

    private PlayerProfile(OfflinePlayer p) {
        this.uuid = p.getUniqueId();
        this.name = p.getName();
        this.cfg = new Config(new File("data-storage/Slimefun/Players/" + this.uuid.toString() + ".yml"));
        for (Research research : Research.list()) {
            if (!this.cfg.contains("researches." + research.getID())) continue;
            this.researches.add(research);
        }
    }

    private PlayerProfile(UUID uuid) {
        this(Bukkit.getOfflinePlayer((UUID)uuid));
    }

    public HashedArmorpiece[] getArmor() {
        return this.armor;
    }

    public Config getConfig() {
        return this.cfg;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public boolean isMarkedForDeletion() {
        return this.markedForDeletion;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void save() {
        for (BackpackInventory backpack : this.backpacks.values()) {
            backpack.save();
        }
        this.cfg.save();
        this.dirty = false;
    }

    public void setResearched(Research research, boolean unlock) {
        this.dirty = true;
        if (unlock) {
            this.cfg.setValue("researches." + research.getID(), true);
            this.researches.add(research);
        } else {
            this.cfg.setValue("researches." + research.getID(), null);
            this.researches.remove(research);
        }
    }

    public boolean hasUnlocked(Research research) {
        return !research.isEnabled() || this.researches.contains(research);
    }

    public Set<Research> getResearches() {
        return this.researches;
    }

    public void markForDeletion() {
        this.markedForDeletion = true;
    }

    public void markDirty() {
        this.dirty = true;
    }

    public BackpackInventory createBackpack(int size) {
        IntStream stream = IntStream.iterate(0, i -> i + 1).filter(i -> !this.cfg.contains("backpacks." + i + ".size"));
        int id = stream.findFirst().getAsInt();
        BackpackInventory backpack = new BackpackInventory(this, id, size);
        this.backpacks.put(id, backpack);
        return backpack;
    }

    public BackpackInventory getBackpack(int id) {
        BackpackInventory backpack = this.backpacks.get(id);
        if (backpack != null) {
            return backpack;
        }
        backpack = new BackpackInventory(this, id);
        this.backpacks.put(id, backpack);
        return backpack;
    }

    public String getTitle() {
        List<String> titles = SlimefunPlugin.getSettings().researchesTitles;
        float fraction = (float)this.researches.size() / (float)Research.list().size();
        int index = (int)(fraction * (float)(titles.size() - 1));
        return titles.get(index);
    }

    public void sendStats(CommandSender sender) {
        Set<Research> researched = this.getResearches();
        int levels = researched.stream().mapToInt(Research::getCost).sum();
        String progress = String.valueOf((float)Math.round((float)researched.size() * 100.0f / (float)Research.list().size() * 100.0f) / 100.0f);
        progress = Float.parseFloat(progress) < 16.0f ? "&4" + progress + " &r% " : (Float.parseFloat(progress) < 32.0f ? "&c" + progress + " &r% " : (Float.parseFloat(progress) < 48.0f ? "&6" + progress + " &r% " : (Float.parseFloat(progress) < 64.0f ? "&e" + progress + " &r% " : (Float.parseFloat(progress) < 80.0f ? "&2" + progress + " &r% " : "&a" + progress + " &r% "))));
        sender.sendMessage("");
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&7Statistics for Player: &b" + this.name)));
        sender.sendMessage("");
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&7Title: &b" + this.getTitle())));
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&7Research Progress: " + progress + "&e(" + researched.size() + " / " + Research.list().size() + ")")));
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&7Total XP Levels spent: &b" + levels)));
    }

    public Player getPlayer() {
        return Bukkit.getPlayer((UUID)this.getUUID());
    }

    public LinkedList<Object> getGuideHistory() {
        return this.guideHistory;
    }

    public static PlayerProfile fromUUID(UUID uuid) {
        PlayerProfile profile = SlimefunPlugin.getUtilities().profiles.get(uuid);
        if (profile == null) {
            profile = new PlayerProfile(uuid);
            SlimefunPlugin.getUtilities().profiles.put(uuid, profile);
        } else {
            profile.markedForDeletion = false;
        }
        return profile;
    }

    public static boolean fromUUID(UUID uuid, Consumer<PlayerProfile> callback) {
        PlayerProfile profile = SlimefunPlugin.getUtilities().profiles.get(uuid);
        if (profile != null) {
            callback.accept(profile);
            return true;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)SlimefunPlugin.instance, () -> {
            PlayerProfile pp = new PlayerProfile(uuid);
            SlimefunPlugin.getUtilities().profiles.put(uuid, pp);
            callback.accept(pp);
        });
        return false;
    }

    public static PlayerProfile get(OfflinePlayer p) {
        PlayerProfile profile = SlimefunPlugin.getUtilities().profiles.get(p.getUniqueId());
        if (profile == null) {
            profile = new PlayerProfile(p);
            SlimefunPlugin.getUtilities().profiles.put(p.getUniqueId(), profile);
        } else {
            profile.markedForDeletion = false;
        }
        return profile;
    }

    public static boolean get(OfflinePlayer p, Consumer<PlayerProfile> callback) {
        PlayerProfile profile = SlimefunPlugin.getUtilities().profiles.get(p.getUniqueId());
        if (profile != null) {
            callback.accept(profile);
            return true;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)SlimefunPlugin.instance, () -> {
            PlayerProfile pp = new PlayerProfile(p);
            SlimefunPlugin.getUtilities().profiles.put(p.getUniqueId(), pp);
            callback.accept(pp);
        });
        return false;
    }

    public static boolean isLoaded(UUID uuid) {
        return SlimefunPlugin.getUtilities().profiles.containsKey(uuid);
    }

    public static Optional<PlayerProfile> find(OfflinePlayer p) {
        return Optional.ofNullable(SlimefunPlugin.getUtilities().profiles.get(p.getUniqueId()));
    }

    public static Iterator<PlayerProfile> iterator() {
        return SlimefunPlugin.getUtilities().profiles.values().iterator();
    }

    public static BackpackInventory getBackpack(ItemStack item) {
        if (item == null || !item.hasItemMeta() || !item.getItemMeta().hasLore()) {
            return null;
        }
        Optional<Object> id = Optional.empty();
        String uuid = "";
        for (String line : item.getItemMeta().getLore()) {
            if (!line.startsWith(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7ID: ")) || !line.contains("#")) continue;
            try {
                id = Optional.of(Integer.parseInt(line.split("#")[1]));
                uuid = line.split("#")[0].replace(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7ID: "), "");
            }
            catch (NumberFormatException x) {
                return null;
            }
        }
        if (id.isPresent()) {
            return PlayerProfile.fromUUID(UUID.fromString(uuid)).getBackpack((Integer)id.get());
        }
        return null;
    }

    public String toString() {
        return "PlayerProfile {" + this.uuid + "}";
    }
}

