/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.api.inventory;

import java.util.ArrayList;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.Item.CustomItem;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.inventory.ItemManipulationEvent;
import me.mrCookieSlime.Slimefun.cscorelib2.inventory.InvUtils;
import me.mrCookieSlime.Slimefun.cscorelib2.inventory.ItemUtils;
import org.bukkit.block.Block;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class DirtyChestMenu
extends ChestMenu {
    protected final BlockMenuPreset preset;
    protected ItemManipulationEvent event;
    protected int changes = 1;

    public DirtyChestMenu(BlockMenuPreset preset) {
        super(preset.getTitle());
        this.preset = preset;
    }

    public void markDirty() {
        ++this.changes;
    }

    public boolean isDirty() {
        return this.changes > 0;
    }

    public int getUnsavedChanges() {
        return this.changes;
    }

    public BlockMenuPreset getPreset() {
        return this.preset;
    }

    public boolean canOpen(Block b, Player p) {
        return this.preset.canOpen(b, p);
    }

    public void close() {
        for (HumanEntity human : new ArrayList(this.toInventory().getViewers())) {
            human.closeInventory();
        }
    }

    public void registerEvent(ItemManipulationEvent event) {
        this.event = event;
    }

    public ChestMenu addMenuOpeningHandler(ChestMenu.MenuOpeningHandler handler) {
        if (handler instanceof SaveHandler) {
            return super.addMenuOpeningHandler((ChestMenu.MenuOpeningHandler)new SaveHandler(this, ((SaveHandler)handler).getOpeningHandler()));
        }
        return super.addMenuOpeningHandler((ChestMenu.MenuOpeningHandler)new SaveHandler(this, handler));
    }

    public boolean fits(ItemStack item, int ... slots) {
        return InvUtils.fits(this.toInventory(), item, slots);
    }

    public ItemStack pushItem(ItemStack item, int ... slots) {
        int amount = item.getAmount();
        for (int slot : slots) {
            if (amount <= 0) break;
            ItemStack stack = this.getItemInSlot(slot);
            if (stack == null) {
                this.replaceExistingItem(slot, item);
                return null;
            }
            if (stack.getAmount() >= stack.getMaxStackSize() || !ItemUtils.canStack(item, stack)) continue;
            amount -= stack.getMaxStackSize() - stack.getAmount();
            stack.setAmount(Math.min(stack.getAmount() + item.getAmount(), stack.getMaxStackSize()));
        }
        if (amount > 0) {
            return new CustomItem(item, amount);
        }
        return null;
    }

    public void replaceExistingItem(int slot, ItemStack item) {
        this.replaceExistingItem(slot, item, true);
    }

    public void replaceExistingItem(int slot, ItemStack item, boolean event) {
        ItemStack previous = this.getItemInSlot(slot);
        if (event && this.event != null) {
            item = this.event.onEvent(slot, previous, item);
        }
        super.replaceExistingItem(slot, item);
        this.markDirty();
    }

    public static class SaveHandler
    implements ChestMenu.MenuOpeningHandler {
        private DirtyChestMenu menu;
        private ChestMenu.MenuOpeningHandler handler;

        public SaveHandler(DirtyChestMenu menu, ChestMenu.MenuOpeningHandler handler) {
            this.menu = menu;
            this.handler = handler;
        }

        public void onOpen(Player p) {
            this.handler.onOpen(p);
            this.menu.markDirty();
        }

        public ChestMenu.MenuOpeningHandler getOpeningHandler() {
            return this.handler;
        }
    }
}

