/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.Objects;

import java.util.Arrays;
import java.util.List;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunMachine;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.BlockFace;

public class MultiBlock {
    public static final List<Tag<Material>> SUPPORTED_TAGS = Arrays.asList(Tag.LOGS, Tag.WOODEN_FENCES, Tag.WOODEN_TRAPDOORS, Tag.WOODEN_SLABS);
    private final Material[] blocks;
    private final BlockFace trigger;
    private final boolean isSymmetric;

    public MultiBlock(Material[] build, BlockFace trigger) {
        this.blocks = build;
        this.trigger = trigger;
        this.isSymmetric = MultiBlock.isSymmetric(build);
    }

    private static boolean isSymmetric(Material[] blocks) {
        return blocks[0] == blocks[2] && blocks[3] == blocks[5] && blocks[6] == blocks[8];
    }

    public Material[] getBuild() {
        return this.blocks;
    }

    public BlockFace getTriggerBlock() {
        return this.trigger;
    }

    public void register() {
        SlimefunPlugin.getUtilities().allMultiblocks.add(this);
    }

    public static List<MultiBlock> list() {
        return SlimefunPlugin.getUtilities().allMultiblocks;
    }

    public boolean isMultiBlock(SlimefunItem machine) {
        if (machine instanceof SlimefunMachine) {
            return this.isMultiBlock(((SlimefunMachine)machine).toMultiBlock());
        }
        return false;
    }

    public boolean isMultiBlock(MultiBlock mb) {
        if (mb == null) {
            return false;
        }
        if (this.trigger == mb.getTriggerBlock()) {
            for (int i = 0; i < mb.getBuild().length; ++i) {
                if (this.compareBlocks(this.blocks[i], mb.getBuild()[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean compareBlocks(Material a, Material b) {
        if (b != null) {
            for (Tag<Material> tag : SUPPORTED_TAGS) {
                if (!tag.isTagged((Keyed)b)) continue;
                return tag.isTagged((Keyed)a);
            }
            if (b != a) {
                return false;
            }
        }
        return true;
    }

    public boolean isSymmetric() {
        return this.isSymmetric;
    }
}

