/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.GPS;

import io.github.thebusybiscuit.slimefun4.core.utils.ChestMenuUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.Item.CustomItem;
import me.mrCookieSlime.Slimefun.GPS.NetworkStatus;
import me.mrCookieSlime.Slimefun.GPS.TeleportationSequence;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.machines.electric.gps.GPSTransmitter;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.ChatInput;
import me.mrCookieSlime.Slimefun.cscorelib2.config.Config;
import me.mrCookieSlime.Slimefun.cscorelib2.math.DoubleHandler;
import me.mrCookieSlime.Slimefun.cscorelib2.skull.SkullItem;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class GPSNetwork {
    private static final String DIRECTORY = "data-storage/Slimefun/waypoints/";
    private final Map<UUID, Set<Location>> transmitters = new HashMap<UUID, Set<Location>>();
    private final int[] border = new int[]{0, 1, 3, 5, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 26, 27, 35, 36, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53};
    private final int[] inventory = new int[]{19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34, 37, 38, 39, 40, 41, 42, 43};
    private final int[] teleporterBorder = new int[]{0, 1, 2, 3, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 26, 27, 35, 36, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53};
    private final int[] teleporterInventory = new int[]{19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34, 37, 38, 39, 40, 41, 42, 43};

    public void updateTransmitter(Location l, UUID uuid, NetworkStatus status) {
        Set set = this.transmitters.getOrDefault(uuid, new HashSet());
        if (status == NetworkStatus.ONLINE) {
            if (set.add(l)) {
                this.transmitters.put(uuid, set);
            }
        } else {
            set.remove(l);
            this.transmitters.put(uuid, set);
        }
    }

    public int getNetworkComplexity(UUID uuid) {
        if (!this.transmitters.containsKey(uuid)) {
            return 0;
        }
        int level = 0;
        for (Location l : this.transmitters.get(uuid)) {
            SlimefunItem item = BlockStorage.check(l);
            if (!(item instanceof GPSTransmitter)) continue;
            level += ((GPSTransmitter)item).getMultiplier(l.getBlockY());
        }
        return level;
    }

    public int countTransmitters(UUID uuid) {
        if (!this.transmitters.containsKey(uuid)) {
            return 0;
        }
        return this.transmitters.get(uuid).size();
    }

    public void openTransmitterControlPanel(Player p) {
        ChestMenu menu = new ChestMenu("&9Control Panel");
        for (int slot2 : this.border) {
            menu.addItem(slot2, (ItemStack)new CustomItem(new ItemStack(Material.GRAY_STAINED_GLASS_PANE), " "), (pl, slotn, item, action) -> false);
        }
        menu.addItem(2, (ItemStack)new CustomItem(SkullItem.fromBase64("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYjBjOWMxYTAyMmY0MGI3M2YxNGI0Y2JhMzdjNzE4YzZhNTMzZjNhMjg2NGI2NTM2ZDVmNDU2OTM0Y2MxZiJ9fX0="), "&7Transmitter Overview &e(Selected)"));
        menu.addMenuClickHandler(2, ChestMenuUtils.getEmptyClickHandler());
        int complexity = this.getNetworkComplexity(p.getUniqueId());
        menu.addItem(4, (ItemStack)new CustomItem(SkullItem.fromBase64("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZGRjZmJhNThmYWYxZjY0ODQ3ODg0MTExODIyYjY0YWZhMjFkN2ZjNjJkNDQ4MWYxNGYzZjNiY2I2MzMwIn19fQ=="), "&7Network Info", new String[]{"", "&8\u21e8 &7Status: " + (complexity > 0 ? "&2&lONLINE" : "&4&lOFFLINE"), "&8\u21e8 &7Complexity: &r" + complexity}));
        menu.addMenuClickHandler(4, ChestMenuUtils.getEmptyClickHandler());
        menu.addItem(6, (ItemStack)new CustomItem(SkullItem.fromBase64("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYzljODg4MWU0MjkxNWE5ZDI5YmI2MWExNmZiMjZkMDU5OTEzMjA0ZDI2NWRmNWI0MzliM2Q3OTJhY2Q1NiJ9fX0="), "&7Waypoint Overview &r(Select)"));
        menu.addMenuClickHandler(6, (pl, slot, item, action) -> {
            this.openWaypointControlPanel(pl);
            return false;
        });
        int index = 0;
        for (Location l : this.getTransmitters(p.getUniqueId())) {
            if (index >= this.inventory.length) break;
            SlimefunItem sfi = BlockStorage.check(l);
            if (!(sfi instanceof GPSTransmitter)) continue;
            int slot3 = this.inventory[index];
            menu.addItem(slot3, (ItemStack)new CustomItem(SkullItem.fromBase64("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYjBjOWMxYTAyMmY0MGI3M2YxNGI0Y2JhMzdjNzE4YzZhNTMzZjNhMjg2NGI2NTM2ZDVmNDU2OTM0Y2MxZiJ9fX0="), "&bGPS Transmitter", new String[]{"&8\u21e8 &7World: &r" + l.getWorld().getName(), "&8\u21e8 &7X: &r" + l.getX(), "&8\u21e8 &7Y: &r" + l.getY(), "&8\u21e8 &7Z: &r" + l.getZ(), "", "&8\u21e8 &7Signal Strength: &r" + ((GPSTransmitter)sfi).getMultiplier(l.getBlockY()), "&8\u21e8 &7Ping: &r" + DoubleHandler.fixDouble(1000.0 / l.getY()) + "ms"}));
            menu.addMenuClickHandler(slot3, ChestMenuUtils.getEmptyClickHandler());
            ++index;
        }
        menu.open(new Player[]{p});
    }

    public static ItemStack getPlanet(Map.Entry<String, Location> entry) {
        Location l = entry.getValue();
        if (entry.getKey().startsWith("&4Deathpoint")) {
            return SkullItem.fromBase64("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMWFlMzg1NWY5NTJjZDRhMDNjMTQ4YTk0NmUzZjgxMmE1OTU1YWQzNWNiY2I1MjYyN2VhNGFjZDQ3ZDMwODEifX19");
        }
        if (l.getWorld().getEnvironment() == World.Environment.NETHER) {
            return SkullItem.fromBase64("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZDgzNTcxZmY1ODlmMWE1OWJiMDJiODA4MDBmYzczNjExNmUyN2MzZGNmOWVmZWJlZGU4Y2YxZmRkZSJ9fX0=");
        }
        if (l.getWorld().getEnvironment() == World.Environment.THE_END) {
            return SkullItem.fromBase64("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYzZjYWM1OWIyYWFlNDg5YWEwNjg3YjVkODAyYjI1NTVlYjE0YTQwYmQ2MmIyMWViMTE2ZmE1NjljZGI3NTYifX19");
        }
        return SkullItem.fromBase64("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYzljODg4MWU0MjkxNWE5ZDI5YmI2MWExNmZiMjZkMDU5OTEzMjA0ZDI2NWRmNWI0MzliM2Q3OTJhY2Q1NiJ9fX0=");
    }

    public void openWaypointControlPanel(Player p) {
        ChestMenu menu = new ChestMenu("&9Control Panel");
        for (int slot2 : this.border) {
            menu.addItem(slot2, (ItemStack)new CustomItem(new ItemStack(Material.GRAY_STAINED_GLASS_PANE), " "), (pl, slotn, item, action) -> false);
        }
        menu.addItem(2, (ItemStack)new CustomItem(SkullItem.fromBase64("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYjBjOWMxYTAyMmY0MGI3M2YxNGI0Y2JhMzdjNzE4YzZhNTMzZjNhMjg2NGI2NTM2ZDVmNDU2OTM0Y2MxZiJ9fX0="), "&7Transmitter Overview &r(Select)"));
        menu.addMenuClickHandler(2, (pl, slot, item, action) -> {
            this.openTransmitterControlPanel(pl);
            return false;
        });
        int complexity = this.getNetworkComplexity(p.getUniqueId());
        menu.addItem(4, (ItemStack)new CustomItem(SkullItem.fromBase64("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZGRjZmJhNThmYWYxZjY0ODQ3ODg0MTExODIyYjY0YWZhMjFkN2ZjNjJkNDQ4MWYxNGYzZjNiY2I2MzMwIn19fQ=="), "&7Network Info", new String[]{"", "&8\u21e8 &7Status: " + (complexity > 0 ? "&2&lONLINE" : "&4&lOFFLINE"), "&8\u21e8 &7Complexity: &r" + complexity}));
        menu.addMenuClickHandler(4, ChestMenuUtils.getEmptyClickHandler());
        menu.addItem(6, (ItemStack)new CustomItem(SkullItem.fromBase64("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYzljODg4MWU0MjkxNWE5ZDI5YmI2MWExNmZiMjZkMDU5OTEzMjA0ZDI2NWRmNWI0MzliM2Q3OTJhY2Q1NiJ9fX0="), "&7Waypoint Overview &e(Selected)"));
        menu.addMenuClickHandler(6, ChestMenuUtils.getEmptyClickHandler());
        int index = 0;
        for (Map.Entry<String, Location> entry : this.getWaypoints(p.getUniqueId()).entrySet()) {
            if (index >= this.inventory.length) break;
            int slot3 = this.inventory[index];
            Location l = entry.getValue();
            ItemStack globe = GPSNetwork.getPlanet(entry);
            menu.addItem(slot3, (ItemStack)new CustomItem(globe, entry.getKey(), new String[]{"&8\u21e8 &7World: &r" + l.getWorld().getName(), "&8\u21e8 &7X: &r" + l.getX(), "&8\u21e8 &7Y: &r" + l.getY(), "&8\u21e8 &7Z: &r" + l.getZ(), "", "&8\u21e8 &cClick to delete"}));
            menu.addMenuClickHandler(slot3, (pl, slotn, item, action) -> {
                String id = ChatColor.stripColor((String)ChatColor.translateAlternateColorCodes((char)'&', (String)((String)entry.getKey()))).toUpperCase().replace(' ', '_');
                Config cfg = new Config(DIRECTORY + pl.getUniqueId().toString() + ".yml");
                cfg.setValue(id, null);
                cfg.save();
                pl.playSound(pl.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                this.openWaypointControlPanel(pl);
                return false;
            });
            ++index;
        }
        menu.open(new Player[]{p});
    }

    public Map<String, Location> getWaypoints(UUID uuid) {
        HashMap<String, Location> map = new HashMap<String, Location>();
        Config cfg = new Config(DIRECTORY + uuid.toString() + ".yml");
        for (String key : cfg.getKeys()) {
            if (!cfg.contains(key + ".world") || Bukkit.getWorld((String)cfg.getString(key + ".world")) == null) continue;
            map.put(cfg.getString(key + ".name"), cfg.getLocation(key));
        }
        return map;
    }

    public void addWaypoint(Player p, Location l) {
        if (this.getWaypoints(p.getUniqueId()).size() + 2 > this.inventory.length) {
            SlimefunPlugin.getLocal().sendMessage((CommandSender)p, "gps.waypoint.max", true);
            return;
        }
        SlimefunPlugin.getLocal().sendMessage((CommandSender)p, "gps.waypoint.new", true);
        p.playSound(p.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 0.5f, 1.0f);
        ChatInput.waitForPlayer((Plugin)SlimefunPlugin.instance, p, message -> this.addWaypoint(p, (String)message, l));
    }

    public void addWaypoint(Player p, String name, Location l) {
        if (this.getWaypoints(p.getUniqueId()).size() + 2 > this.inventory.length) {
            SlimefunPlugin.getLocal().sendMessage((CommandSender)p, "gps.waypoint.max", true);
            return;
        }
        Config cfg = new Config(DIRECTORY + p.getUniqueId().toString() + ".yml");
        String id = ChatColor.stripColor((String)ChatColor.translateAlternateColorCodes((char)'&', (String)name)).toUpperCase().replace(' ', '_');
        cfg.setValue(id, l);
        cfg.setValue(id + ".name", name);
        cfg.save();
        p.playSound(p.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 1.0f, 1.0f);
        SlimefunPlugin.getLocal().sendMessage((CommandSender)p, "gps.waypoint.added", true);
    }

    public Set<Location> getTransmitters(UUID uuid) {
        return this.transmitters.getOrDefault(uuid, new HashSet());
    }

    public void openTeleporterGUI(Player p, UUID uuid, Block b, int complexity) {
        if (SlimefunPlugin.getUtilities().teleporterUsers.contains(p.getUniqueId())) {
            return;
        }
        p.playSound(p.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
        SlimefunPlugin.getUtilities().teleporterUsers.add(p.getUniqueId());
        ChestMenu menu = new ChestMenu("&3Teleporter");
        menu.addMenuCloseHandler(pl -> SlimefunPlugin.getUtilities().teleporterUsers.remove(pl.getUniqueId()));
        for (int slot : this.teleporterBorder) {
            menu.addItem(slot, (ItemStack)new CustomItem(new ItemStack(Material.GRAY_STAINED_GLASS_PANE), " "), (pl, slotn, item, action) -> false);
        }
        menu.addItem(4, (ItemStack)new CustomItem(SkullItem.fromBase64("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYzljODg4MWU0MjkxNWE5ZDI5YmI2MWExNmZiMjZkMDU5OTEzMjA0ZDI2NWRmNWI0MzliM2Q3OTJhY2Q1NiJ9fX0="), "&7Waypoint Overview &e(Select a Destination)"));
        menu.addMenuClickHandler(4, ChestMenuUtils.getEmptyClickHandler());
        Location source = new Location(b.getWorld(), (double)b.getX() + 0.5, (double)b.getY() + 2.0, (double)b.getZ() + 0.5);
        int index = 0;
        for (Map.Entry<String, Location> entry : Slimefun.getGPSNetwork().getWaypoints(uuid).entrySet()) {
            if (index >= this.teleporterInventory.length) break;
            int slot = this.teleporterInventory[index];
            Location l = entry.getValue();
            ItemStack globe = GPSNetwork.getPlanet(entry);
            menu.addItem(slot, (ItemStack)new CustomItem(globe, entry.getKey(), new String[]{"&8\u21e8 &7World: &r" + l.getWorld().getName(), "&8\u21e8 &7X: &r" + l.getX(), "&8\u21e8 &7Y: &r" + l.getY(), "&8\u21e8 &7Z: &r" + l.getZ(), "&8\u21e8 &7Estimated Teleportation Time: &r" + 50 / TeleportationSequence.getSpeed(Slimefun.getGPSNetwork().getNetworkComplexity(uuid), source, l) + "s", "", "&8\u21e8 &cClick to select"}));
            menu.addMenuClickHandler(slot, (pl, slotn, item, action) -> {
                pl.closeInventory();
                TeleportationSequence.start(pl.getUniqueId(), complexity, source, l, false);
                return false;
            });
            ++index;
        }
        menu.open(new Player[]{p});
    }
}

