/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.cscorelib2.updater;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import me.mrCookieSlime.Slimefun.cscorelib2.updater.UpdateCheck;
import me.mrCookieSlime.Slimefun.cscorelib2.updater.Updater;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class BukkitUpdater
implements Updater {
    private static final String API_URL = "https://api.curseforge.com/servermods/files?projectIds=";
    private static final char[] BLACKLIST = "abcdefghijklmnopqrstuvwxyz-+_ ()[]{}".toCharArray();
    private static final String[] DEV_KEYWORDS = new String[]{"DEV", "EXPERIMENTAL", "BETA", "ALPHA", "UNFINISHED"};
    private Plugin plugin;
    private int id;
    private URL url;
    private Thread thread;
    private URL download;
    private File file;
    private String localVersion;
    private String remoteVersion;
    protected int timeout = 5000;
    protected UpdateCheck predicate;

    public BukkitUpdater(Plugin plugin, File file, int id) {
        this.plugin = plugin;
        this.id = id;
        this.file = file;
        this.localVersion = plugin.getDescription().getVersion();
        this.predicate = (local, remote) -> {
            if (local.equals(remote)) {
                return false;
            }
            String[] localSplit = local.split("\\.");
            String[] remoteSplit = remote.split("\\.");
            for (int i = 0; i < remoteSplit.length; ++i) {
                if (localSplit.length - 1 < i) {
                    return true;
                }
                if (Integer.parseInt(localSplit[i]) > Integer.parseInt(remoteSplit[i])) {
                    return false;
                }
                if (Integer.parseInt(remoteSplit[i]) <= Integer.parseInt(localSplit[i])) continue;
                return true;
            }
            return false;
        };
    }

    @Override
    public void start() {
        for (String dev : DEV_KEYWORDS) {
            if (!this.localVersion.contains(dev)) continue;
            this.plugin.getLogger().log(Level.WARNING, " ");
            this.plugin.getLogger().log(Level.WARNING, "################## - DEVELOPMENT BUILD - ##################");
            this.plugin.getLogger().log(Level.WARNING, "You appear to be using an experimental build of " + this.plugin.getName());
            this.plugin.getLogger().log(Level.WARNING, "Version {0}", this.localVersion);
            this.plugin.getLogger().log(Level.WARNING, " ");
            this.plugin.getLogger().log(Level.WARNING, "Auto-Updates have been disabled. Use at your own risk!");
            this.plugin.getLogger().log(Level.WARNING, " ");
            return;
        }
        this.localVersion = this.localVersion.toLowerCase();
        for (char blocked : BLACKLIST) {
            this.localVersion = this.localVersion.replace(String.valueOf(blocked), "");
        }
        this.prepareUpdateFolder();
        try {
            this.url = new URL(API_URL + this.id);
            this.plugin.getServer().getScheduler().runTask(this.plugin, () -> {
                this.thread = new Thread(new UpdaterTask());
                this.thread.start();
            });
        }
        catch (MalformedURLException malformedURLException) {
            this.plugin.getLogger().log(Level.SEVERE, "Auto-Updater URL is malformed", malformedURLException);
        }
    }

    @Override
    public String getLocalVersion() {
        return this.localVersion;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setPredicate(UpdateCheck predicate) {
        this.predicate = predicate;
    }

    public class UpdaterTask
    implements Runnable {
        @Override
        public void run() {
            if (this.connect()) {
                try {
                    this.check();
                }
                catch (NumberFormatException x) {
                    BukkitUpdater.this.plugin.getLogger().log(Level.SEVERE, "Could not auto-update " + BukkitUpdater.this.plugin.getName());
                    BukkitUpdater.this.plugin.getLogger().log(Level.SEVERE, "Unrecognized Version: \"" + BukkitUpdater.this.localVersion + "\"");
                }
            }
        }

        private boolean connect() {
            try {
                URLConnection connection = BukkitUpdater.this.url.openConnection();
                connection.setConnectTimeout(BukkitUpdater.this.timeout);
                connection.addRequestProperty("User-Agent", "Auto Updater (by TheBusyBiscuit)");
                connection.setDoOutput(true);
                BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                JsonArray array = (JsonArray)new JsonParser().parse(reader.readLine());
                if (array.size() == 0) {
                    BukkitUpdater.this.plugin.getLogger().log(Level.WARNING, "The Auto-Updater could not connect to dev.bukkit.org, is it down?");
                    try {
                        BukkitUpdater.this.thread.join();
                    }
                    catch (InterruptedException x) {
                        BukkitUpdater.this.plugin.getLogger().log(Level.SEVERE, "The Auto-Updater Thread was interrupted", x);
                        Thread.currentThread().interrupt();
                    }
                    return false;
                }
                JsonObject latest = array.get(array.size() - 1).getAsJsonObject();
                BukkitUpdater.this.download = this.traceURL(latest.get("downloadUrl").getAsString().replace("https:", "http:"));
                BukkitUpdater.this.remoteVersion = latest.getAsJsonObject().get("name").getAsString();
                BukkitUpdater.this.remoteVersion = BukkitUpdater.this.remoteVersion.toLowerCase();
                for (char blocked : BLACKLIST) {
                    BukkitUpdater.this.remoteVersion = BukkitUpdater.this.remoteVersion.replace(String.valueOf(blocked), "");
                }
                return true;
            }
            catch (IOException e) {
                BukkitUpdater.this.plugin.getLogger().log(Level.WARNING, "Could not connect to github.io, is it down?", e);
                try {
                    BukkitUpdater.this.thread.join();
                }
                catch (InterruptedException x) {
                    BukkitUpdater.this.plugin.getLogger().log(Level.SEVERE, "The Auto-Updater Thread was interrupted", x);
                    Thread.currentThread().interrupt();
                }
                return false;
            }
        }

        private void check() {
            if (BukkitUpdater.this.predicate.hasUpdate(BukkitUpdater.this.localVersion, BukkitUpdater.this.remoteVersion)) {
                this.install();
            } else {
                BukkitUpdater.this.plugin.getLogger().log(Level.INFO, BukkitUpdater.this.plugin.getName() + " is up to date!");
                try {
                    BukkitUpdater.this.thread.join();
                }
                catch (InterruptedException x) {
                    BukkitUpdater.this.plugin.getLogger().log(Level.SEVERE, "The Auto-Updater Thread was interrupted", x);
                    Thread.currentThread().interrupt();
                }
            }
        }

        private URL traceURL(String location) throws IOException {
            HttpURLConnection connection = null;
            while (true) {
                connection = (HttpURLConnection)new URL(location).openConnection();
                connection.setInstanceFollowRedirects(false);
                connection.setConnectTimeout(5000);
                connection.addRequestProperty("User-Agent", "Auto Updater (by mrCookieSlime)");
                int code = connection.getResponseCode();
                if (code != 301 && code != 302) break;
                String loc = connection.getHeaderField("Location");
                location = new URL(new URL(location), loc).toExternalForm();
            }
            return new URL(connection.getURL().toString().replace(" ", "%20"));
        }

        private void install() {
            BukkitUpdater.this.plugin.getLogger().log(Level.INFO, BukkitUpdater.this.plugin.getName() + " is outdated!");
            BukkitUpdater.this.plugin.getLogger().log(Level.INFO, "Downloading " + BukkitUpdater.this.plugin.getName() + " v" + BukkitUpdater.this.remoteVersion);
            BukkitUpdater.this.plugin.getServer().getScheduler().runTask(BukkitUpdater.this.plugin, () -> {
                BufferedInputStream input = null;
                FileOutputStream output = null;
                try {
                    int read;
                    input = new BufferedInputStream(BukkitUpdater.this.download.openStream());
                    output = new FileOutputStream(new File("plugins/" + Bukkit.getUpdateFolder(), BukkitUpdater.this.file.getName()));
                    byte[] data = new byte[1024];
                    while ((read = input.read(data, 0, 1024)) != -1) {
                        output.write(data, 0, read);
                    }
                }
                catch (Exception x) {
                    BukkitUpdater.this.plugin.getLogger().log(Level.SEVERE, "Could not auto-update " + BukkitUpdater.this.plugin.getName(), x);
                }
                finally {
                    try {
                        if (input != null) {
                            input.close();
                        }
                        if (output != null) {
                            output.close();
                        }
                        BukkitUpdater.this.plugin.getLogger().log(Level.INFO, " ");
                        BukkitUpdater.this.plugin.getLogger().log(Level.INFO, "#################### - UPDATE - ####################");
                        BukkitUpdater.this.plugin.getLogger().log(Level.INFO, BukkitUpdater.this.plugin.getName() + " was successfully updated (" + BukkitUpdater.this.localVersion + " -> " + BukkitUpdater.this.remoteVersion + ")");
                        BukkitUpdater.this.plugin.getLogger().log(Level.INFO, "Please restart your Server in order to use the new Version");
                        BukkitUpdater.this.plugin.getLogger().log(Level.INFO, " ");
                    }
                    catch (IOException e) {
                        BukkitUpdater.this.plugin.getLogger().log(Level.SEVERE, "An Error occured while auto-updating \"" + BukkitUpdater.this.plugin.getName() + "\"", e);
                    }
                    try {
                        BukkitUpdater.this.thread.join();
                    }
                    catch (InterruptedException x) {
                        BukkitUpdater.this.plugin.getLogger().log(Level.SEVERE, "The Auto-Updater Thread was interrupted", x);
                        Thread.currentThread().interrupt();
                    }
                }
            });
        }
    }
}

