/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.cscorelib2.database;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.logging.Level;
import me.mrCookieSlime.Slimefun.cscorelib2.database.Database;
import me.mrCookieSlime.Slimefun.cscorelib2.database.SQLDatabase;
import org.bukkit.plugin.Plugin;

public abstract class LocalSQLDatabase<T extends LocalSQLDatabase<T>>
extends SQLDatabase<T> {
    protected String name;

    public LocalSQLDatabase(Plugin plugin, String name, Database.DatabaseLoader<T> callback) {
        super(plugin);
        this.name = name;
        this.callback = callback;
        this.queries = new HashSet();
        this.getConnection();
    }

    public abstract String getDriver();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Connection getConnection() {
        try {
            if (this.connection != null && this.connection.isValid(1)) {
                return this.connection;
            }
        }
        catch (SQLException e) {
            this.getLogger().log(Level.SEVERE, "An Exeption occured while connecting to a Database", e);
        }
        try {
            this.getLogger().log(Level.INFO, "Loading SQL Driver...");
            Class.forName(this.getDriver());
        }
        catch (Exception x) {
            this.getLogger().log(Level.SEVERE, "An Exception occured while loading the Database Driver: " + this.getDriver(), x);
            this.callback.onLoad(this, null);
            return null;
        }
        this.getLogger().log(Level.INFO, "Attempting to connect to local Database \"{0}\"", this.name);
        try (Connection connection2 = DriverManager.getConnection(this.getIP());){
            this.getLogger().log(Level.INFO, "> Connection Result: SUCCESSFUL");
            this.callback.onLoad(this, connection2);
            this.connection = connection2;
            Connection connection = connection2;
            return connection;
        }
        catch (Exception x) {
            this.getLogger().log(Level.SEVERE, "> Connection Result: FAILED");
            this.getLogger().log(Level.SEVERE, "> Double-check the Host and Credentials you specified in the \"" + this.getType() + ".yml\" under /plugins/" + this.plugin.getName() + "/" + this.getType() + ".yml");
            this.getLogger().log(Level.SEVERE, "An Exception occured while opening a Database Connection", x);
            this.callback.onLoad(this, null);
            return null;
        }
    }
}

