/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.Objects;

import java.util.List;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunMachine;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.BlockFace;

public class MultiBlock {
    private Material[] blocks;
    private BlockFace trigger;
    private boolean isSymmetric;

    @Deprecated
    public MultiBlock(Material[] build, Material trigger) {
        this.blocks = build;
        this.isSymmetric = MultiBlock.isSymmetric(build);
        this.trigger = MultiBlock.convertTriggerMaterialToBlockFace(build, trigger);
    }

    public MultiBlock(Material[] build, BlockFace trigger) {
        this.blocks = build;
        this.trigger = trigger;
        this.isSymmetric = MultiBlock.isSymmetric(build);
    }

    private static boolean isSymmetric(Material[] blocks) {
        return blocks[0] == blocks[2] && blocks[3] == blocks[5] && blocks[6] == blocks[8];
    }

    public Material[] getBuild() {
        return this.blocks;
    }

    public BlockFace getTriggerBlock() {
        return this.trigger;
    }

    public void register() {
        SlimefunPlugin.getUtilities().allMultiblocks.add(this);
    }

    public static List<MultiBlock> list() {
        return SlimefunPlugin.getUtilities().allMultiblocks;
    }

    public boolean isMultiBlock(SlimefunItem machine) {
        if (machine instanceof SlimefunMachine) {
            return this.isMultiBlock(((SlimefunMachine)machine).toMultiBlock());
        }
        return false;
    }

    public boolean isMultiBlock(MultiBlock mb) {
        if (mb == null) {
            return false;
        }
        if (this.trigger == mb.getTriggerBlock()) {
            for (int i = 0; i < mb.getBuild().length; ++i) {
                if (this.compareBlocks(this.blocks[i], mb.getBuild()[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean compareBlocks(Material a, Material b) {
        if (b != null) {
            if (Tag.LOGS.isTagged((Keyed)b)) {
                return Tag.LOGS.isTagged((Keyed)a);
            }
            if (Tag.WOODEN_FENCES.isTagged((Keyed)b)) {
                return Tag.WOODEN_FENCES.isTagged((Keyed)a);
            }
            if (Tag.WOODEN_SLABS.isTagged((Keyed)b)) {
                return Tag.WOODEN_SLABS.isTagged((Keyed)a);
            }
            if (Tag.WOODEN_TRAPDOORS.isTagged((Keyed)b)) {
                return Tag.WOODEN_TRAPDOORS.isTagged((Keyed)a);
            }
            if (b != a) {
                return false;
            }
        }
        return true;
    }

    public boolean isSymmetric() {
        return this.isSymmetric;
    }

    @Deprecated
    public static BlockFace convertTriggerMaterialToBlockFace(Material[] build, Material trigger) {
        for (int i = 1; i < 9; i += 3) {
            if (trigger != build[i]) continue;
            switch (i) {
                case 1: {
                    return BlockFace.DOWN;
                }
                case 4: {
                    return BlockFace.SELF;
                }
                case 7: {
                    return BlockFace.UP;
                }
            }
        }
        return null;
    }
}

