/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.cscorelib2.materials;

import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import lombok.NonNull;
import me.mrCookieSlime.Slimefun.cscorelib2.materials.MaterialCollections;
import org.bukkit.Material;

public final class MaterialConverter {
    private MaterialConverter() {
    }

    public static Optional<Material> getSaplingFromLog(@NonNull Material log) {
        if (log == null) {
            throw new NullPointerException("log is marked non-null but is null");
        }
        return MaterialConverter.convert(log, MaterialCollections.getAllLogs()::contains, type -> type.substring(0, type.lastIndexOf(95)).replace("STRIPPED_", "") + "_SAPLING");
    }

    public static Optional<Material> getPlanksFromLog(@NonNull Material log) {
        if (log == null) {
            throw new NullPointerException("log is marked non-null but is null");
        }
        return MaterialConverter.convert(log, MaterialCollections.getAllLogs()::contains, type -> type.substring(0, type.lastIndexOf(95)).replace("STRIPPED_", "") + "_PLANKS");
    }

    public static Optional<Material> getGlassFromPane(@NonNull Material pane) {
        if (pane == null) {
            throw new NullPointerException("pane is marked non-null but is null");
        }
        return MaterialConverter.convert(pane, MaterialCollections.getAllStainedGlassPaneColors()::contains, type -> type.substring(0, type.length() - "_PANE".length()));
    }

    public static Optional<Material> getPaneFromGlass(@NonNull Material glass) {
        if (glass == null) {
            throw new NullPointerException("glass is marked non-null but is null");
        }
        return MaterialConverter.convert(glass, MaterialCollections.getAllStainedGlassColors()::contains, type -> type + "_PANE");
    }

    private static Optional<Material> convert(Material type, Predicate<Material> predicate, UnaryOperator<String> converter) {
        if (!predicate.test(type)) {
            return Optional.empty();
        }
        return Optional.ofNullable(Material.getMaterial((String)((String)converter.apply(type.name()))));
    }
}

