/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun;

import io.github.thebusybiscuit.slimefun4.core.commands.SlimefunCommand;
import io.github.thebusybiscuit.slimefun4.core.commands.SlimefunTabCompleter;
import io.github.thebusybiscuit.slimefun4.core.services.BlockDataService;
import io.github.thebusybiscuit.slimefun4.core.services.CustomItemDataService;
import io.github.thebusybiscuit.slimefun4.core.services.CustomTextureService;
import io.github.thebusybiscuit.slimefun4.core.services.LocalizationService;
import io.github.thebusybiscuit.slimefun4.core.services.MetricsService;
import io.github.thebusybiscuit.slimefun4.core.services.github.GitHubService;
import io.github.thebusybiscuit.slimefun4.core.services.github.GitHubTask;
import io.github.thebusybiscuit.slimefun4.implementation.geo.resources.NetherIceResource;
import io.github.thebusybiscuit.slimefun4.implementation.geo.resources.OilResource;
import io.github.thebusybiscuit.slimefun4.implementation.geo.resources.SaltResource;
import io.github.thebusybiscuit.slimefun4.implementation.geo.resources.UraniumResource;
import java.io.File;
import java.util.logging.Level;
import me.mrCookieSlime.CSCoreLibPlugin.CSCoreLib;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.CSCoreLibPlugin.PluginUtils;
import me.mrCookieSlime.Slimefun.GEO.OreGenSystem;
import me.mrCookieSlime.Slimefun.GPS.GPSNetwork;
import me.mrCookieSlime.Slimefun.Lists.SlimefunItems;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.AContainer;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.AGenerator;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.AReactor;
import me.mrCookieSlime.Slimefun.Objects.tasks.ArmorTask;
import me.mrCookieSlime.Slimefun.Setup.Files;
import me.mrCookieSlime.Slimefun.Setup.MiscSetup;
import me.mrCookieSlime.Slimefun.Setup.ResearchSetup;
import me.mrCookieSlime.Slimefun.Setup.SlimefunSetup;
import me.mrCookieSlime.Slimefun.Setup.WikiSetup;
import me.mrCookieSlime.Slimefun.ancient_altar.AncientAltarListener;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.PlayerProfile;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.api.SlimefunBackup;
import me.mrCookieSlime.Slimefun.api.TickerTask;
import me.mrCookieSlime.Slimefun.api.inventory.UniversalBlockMenu;
import me.mrCookieSlime.Slimefun.autosave.BlockAutoSaver;
import me.mrCookieSlime.Slimefun.autosave.PlayerAutoSaver;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.ProtectionManager;
import me.mrCookieSlime.Slimefun.cscorelib2.recipes.RecipeSnapshot;
import me.mrCookieSlime.Slimefun.cscorelib2.reflection.ReflectionUtils;
import me.mrCookieSlime.Slimefun.cscorelib2.updater.BukkitUpdater;
import me.mrCookieSlime.Slimefun.cscorelib2.updater.GitHubBuildsUpdater;
import me.mrCookieSlime.Slimefun.cscorelib2.updater.Updater;
import me.mrCookieSlime.Slimefun.hooks.SlimefunHooks;
import me.mrCookieSlime.Slimefun.listeners.AndroidKillingListener;
import me.mrCookieSlime.Slimefun.listeners.ArmorListener;
import me.mrCookieSlime.Slimefun.listeners.AutonomousToolsListener;
import me.mrCookieSlime.Slimefun.listeners.BackpackListener;
import me.mrCookieSlime.Slimefun.listeners.BlockListener;
import me.mrCookieSlime.Slimefun.listeners.BowListener;
import me.mrCookieSlime.Slimefun.listeners.CoolerListener;
import me.mrCookieSlime.Slimefun.listeners.DamageListener;
import me.mrCookieSlime.Slimefun.listeners.FurnaceListener;
import me.mrCookieSlime.Slimefun.listeners.GearListener;
import me.mrCookieSlime.Slimefun.listeners.GuideOnJoinListener;
import me.mrCookieSlime.Slimefun.listeners.ItemListener;
import me.mrCookieSlime.Slimefun.listeners.ItemPickupListener;
import me.mrCookieSlime.Slimefun.listeners.NetworkListener;
import me.mrCookieSlime.Slimefun.listeners.PlayerQuitListener;
import me.mrCookieSlime.Slimefun.listeners.TalismanListener;
import me.mrCookieSlime.Slimefun.listeners.TeleporterListener;
import me.mrCookieSlime.Slimefun.listeners.ToolListener;
import me.mrCookieSlime.Slimefun.listeners.WorldListener;
import me.mrCookieSlime.Slimefun.utils.Settings;
import me.mrCookieSlime.Slimefun.utils.Utilities;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class SlimefunPlugin
extends JavaPlugin {
    public static SlimefunPlugin instance;
    private RecipeSnapshot recipeSnapshot;
    private final CustomItemDataService itemDataService = new CustomItemDataService((Plugin)this, "slimefun_item");
    private final CustomTextureService textureService = new CustomTextureService((Plugin)this);
    private final BlockDataService blockDataService = new BlockDataService((Plugin)this, "slimefun_block");
    private final GitHubService gitHubService = new GitHubService("TheBusyBiscuit/Slimefun4");
    private TickerTask ticker;
    private LocalizationService local;
    private Config researches;
    private Config items;
    private Config whitelist;
    private Config config;
    private GPSNetwork gps;
    private ProtectionManager protections;
    private Utilities utilities;
    private Settings settings;
    private SlimefunHooks hooks;
    private final String[] supported = new String[]{"v1_14_", "v1_15_"};

    public void onEnable() {
        if (this.getServer().getPluginManager().isPluginEnabled("CS-CoreLib")) {
            Updater updater;
            String currentVersion = ReflectionUtils.getVersion();
            if (currentVersion.startsWith("v")) {
                boolean compatibleVersion = false;
                StringBuilder versions = new StringBuilder();
                int i = 0;
                for (String version : this.supported) {
                    if (currentVersion.startsWith(version)) {
                        compatibleVersion = true;
                    }
                    String s = version.substring(1).replaceFirst("_", ".").replace("_", ".X");
                    if (i == 0) {
                        versions.append(s);
                    } else if (i == this.supported.length - 1) {
                        versions.append(" or ").append(s);
                    } else {
                        versions.append(", ").append(s);
                    }
                    ++i;
                }
                if (!compatibleVersion) {
                    this.getLogger().log(Level.SEVERE, "### Slimefun was not installed correctly!");
                    this.getLogger().log(Level.SEVERE, "###");
                    this.getLogger().log(Level.SEVERE, "### You are using the wrong Version of Minecraft!");
                    this.getLogger().log(Level.SEVERE, "###");
                    this.getLogger().log(Level.SEVERE, "### You are using Minecraft " + ReflectionUtils.getVersion());
                    this.getLogger().log(Level.SEVERE, "### but Slimefun v" + this.getDescription().getVersion() + " requires you to be using");
                    this.getLogger().log(Level.SEVERE, "### Minecraft {0}", versions);
                    this.getLogger().log(Level.SEVERE, "###");
                    this.getLogger().log(Level.SEVERE, "### Please use an older Version of Slimefun and disable auto-updating");
                    this.getLogger().log(Level.SEVERE, "### or consider updating your Server Software.");
                    this.getServer().getPluginManager().disablePlugin((Plugin)this);
                    return;
                }
            }
            instance = this;
            this.getLogger().log(Level.INFO, "Loading Files...");
            Files files = new Files();
            files.cleanup();
            this.getLogger().log(Level.INFO, "Loading Config...");
            PluginUtils utils = new PluginUtils((Plugin)this);
            utils.setupConfig();
            this.config = utils.getConfig();
            this.settings = new Settings(this.config);
            this.researches = new Config(files.researches);
            this.items = new Config(files.items);
            this.whitelist = new Config(files.whitelist);
            this.local = new LocalizationService(this);
            this.utilities = new Utilities();
            this.gps = new GPSNetwork();
            new MetricsService(this);
            if (this.getDescription().getVersion().equals("UNOFFICIAL")) {
                this.getLogger().log(Level.WARNING, "It looks like you are using an unofficially modified build of Slimefun!");
                this.getLogger().log(Level.WARNING, "Auto-Updates have been disabled, this build is not considered safe.");
                this.getLogger().log(Level.WARNING, "Do not report bugs encountered in this Version of Slimefun.");
            }
            if ((updater = this.getDescription().getVersion().startsWith("DEV - ") ? new GitHubBuildsUpdater((Plugin)this, this.getFile(), "TheBusyBiscuit/Slimefun4/master") : (this.getDescription().getVersion().startsWith("RC - ") ? new GitHubBuildsUpdater((Plugin)this, this.getFile(), "TheBusyBiscuit/Slimefun4/stable", "RC - ") : new BukkitUpdater((Plugin)this, this.getFile(), 53485))) != null && this.config.getBoolean("options.auto-update")) {
                updater.start();
            }
            String[] storage = new String[]{"blocks", "stored-blocks", "stored-inventories", "stored-chunks", "universal-inventories", "waypoints", "block-backups"};
            String[] general = new String[]{"scripts", "generators", "error-reports", "cache/github"};
            for (String s : storage) {
                this.createDir("data-storage/Slimefun/" + s);
            }
            for (String s : general) {
                this.createDir("plugins/Slimefun/" + s);
            }
            this.getLogger().log(Level.INFO, "Loading Items...");
            MiscSetup.setupItemSettings();
            try {
                SlimefunSetup.setupItems();
            }
            catch (Exception x) {
                this.getLogger().log(Level.SEVERE, "An Error occured while initializing SlimefunItems for Slimefun " + Slimefun.getVersion(), x);
            }
            MiscSetup.loadDescriptions();
            this.getLogger().log(Level.INFO, "Loading Researches...");
            ResearchSetup.setupResearches();
            this.settings.researchesEnabled = SlimefunPlugin.getResearchCfg().getBoolean("enable-researching");
            this.settings.smelteryFireBreakChance = (Integer)Slimefun.getItemValue("SMELTERY", "chance.fireBreak");
            MiscSetup.setupMisc();
            WikiSetup.addWikiPages(this);
            this.textureService.setup(this.utilities.allItems);
            this.getLogger().log(Level.INFO, "Loading World Generators...");
            OreGenSystem.registerResource(new OilResource());
            OreGenSystem.registerResource(new NetherIceResource());
            OreGenSystem.registerResource(new UraniumResource());
            OreGenSystem.registerResource(new SaltResource());
            this.gitHubService.connect(this.config.getBoolean("options.print-out-github-data-retrieving"));
            new ArmorListener(this);
            new ItemListener(this);
            new BlockListener(this);
            new GearListener(this);
            new AutonomousToolsListener(this);
            new DamageListener(this);
            new BowListener(this);
            new ToolListener(this);
            new FurnaceListener(this);
            new TeleporterListener(this);
            new AndroidKillingListener(this);
            new NetworkListener(this);
            new ItemPickupListener(this);
            if (this.config.getBoolean("items.talismans")) {
                new TalismanListener(this);
            }
            if (this.config.getBoolean("items.backpacks")) {
                new BackpackListener(this);
            }
            if (this.config.getBoolean("items.coolers")) {
                new CoolerListener(this);
            }
            if (this.config.getBoolean("options.give-guide-on-first-join")) {
                new GuideOnJoinListener(this);
            }
            new WorldListener(this);
            new PlayerQuitListener(this);
            this.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this, () -> {
                this.recipeSnapshot = new RecipeSnapshot((Plugin)this);
                this.protections = new ProtectionManager(this.getServer());
                MiscSetup.loadItems(this.settings);
                for (World world : Bukkit.getWorlds()) {
                    new BlockStorage(world);
                }
                if (SlimefunItem.getByID("ANCIENT_ALTAR") != null) {
                    new AncientAltarListener(instance);
                }
            }, 0L);
            SlimefunCommand command = new SlimefunCommand(this);
            this.getCommand("slimefun").setExecutor((CommandExecutor)command);
            this.getCommand("slimefun").setTabCompleter((TabCompleter)new SlimefunTabCompleter(command));
            if (this.config.getBoolean("options.enable-armor-effects")) {
                this.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this, (Runnable)new ArmorTask(), 0L, (long)this.config.getInt("options.armor-update-interval") * 20L);
            }
            this.ticker = new TickerTask();
            this.getServer().getScheduler().runTaskTimer((Plugin)this, (Runnable)new PlayerAutoSaver(), 2000L, (long)this.settings.blocksAutoSaveDelay * 60L * 20L);
            this.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this, (Runnable)new BlockAutoSaver(), 2000L, (long)this.settings.blocksAutoSaveDelay * 60L * 20L);
            this.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this, () -> {
                try {
                    this.ticker.run();
                }
                catch (Exception x) {
                    this.getLogger().log(Level.SEVERE, "An Exception was caught while ticking the Block Tickers Task for Slimefun v" + Slimefun.getVersion(), x);
                    this.ticker.abortTick();
                }
            }, 100L, (long)this.config.getInt("URID.custom-ticker-delay"));
            this.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this, (Runnable)new GitHubTask(this.gitHubService), 80L, 72000L);
            this.getLogger().log(Level.INFO, "Finished!");
            this.hooks = new SlimefunHooks(this);
            this.utilities.oreWasherOutputs = new ItemStack[]{SlimefunItems.IRON_DUST, SlimefunItems.GOLD_DUST, SlimefunItems.ALUMINUM_DUST, SlimefunItems.COPPER_DUST, SlimefunItems.ZINC_DUST, SlimefunItems.TIN_DUST, SlimefunItems.LEAD_DUST, SlimefunItems.SILVER_DUST, SlimefunItems.MAGNESIUM_DUST};
            CSCoreLib.getLib().filterLog("([A-Za-z0-9_]{3,16}) issued server command: /sf elevator (.{0,})");
        } else {
            this.getLogger().log(Level.INFO, "#################### - INFO - ####################");
            this.getLogger().log(Level.INFO, " ");
            this.getLogger().log(Level.INFO, "Slimefun could not be loaded (yet).");
            this.getLogger().log(Level.INFO, "It appears that you have not installed CS-CoreLib.");
            this.getLogger().log(Level.INFO, "Please download and install CS-CoreLib manually:");
            this.getLogger().log(Level.INFO, "https://thebusybiscuit.github.io/builds/TheBusyBiscuit/CS-CoreLib/master/");
            this.getCommand("slimefun").setExecutor((sender, cmd, label, args) -> {
                sender.sendMessage("You have forgotten to install CS-CoreLib! Slimefun is disabled.");
                sender.sendMessage("https://thebusybiscuit.github.io/builds/TheBusyBiscuit/CS-CoreLib/master/");
                return true;
            });
        }
    }

    public void onDisable() {
        if (instance == null) {
            return;
        }
        Bukkit.getScheduler().cancelTasks((Plugin)this);
        if (this.ticker != null) {
            this.ticker.halt();
            this.ticker.run();
        }
        PlayerProfile.iterator().forEachRemaining(profile -> {
            if (profile.isDirty()) {
                profile.save();
            }
        });
        for (World world : Bukkit.getWorlds()) {
            try {
                BlockStorage storage = BlockStorage.getStorage(world);
                if (storage != null) {
                    storage.save(true);
                    continue;
                }
                this.getLogger().log(Level.SEVERE, "Could not save Slimefun Blocks for World \"" + world.getName() + "\"");
            }
            catch (Exception x) {
                this.getLogger().log(Level.SEVERE, "An Error occured while saving Slimefun-Blocks in World '" + world.getName() + "' for Slimefun " + Slimefun.getVersion());
            }
        }
        for (UniversalBlockMenu menu : this.utilities.universalInventories.values()) {
            menu.save();
        }
        SlimefunBackup.start();
        AContainer.processing = null;
        AContainer.progress = null;
        AGenerator.processing = null;
        AGenerator.progress = null;
        AReactor.processing = null;
        AReactor.progress = null;
        instance = null;
        for (Player p : Bukkit.getOnlinePlayers()) {
            p.closeInventory();
        }
    }

    private void createDir(String path) {
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public static Config getCfg() {
        return SlimefunPlugin.instance.config;
    }

    public static Config getResearchCfg() {
        return SlimefunPlugin.instance.researches;
    }

    public static Config getItemCfg() {
        return SlimefunPlugin.instance.items;
    }

    public static Config getWhitelist() {
        return SlimefunPlugin.instance.whitelist;
    }

    @Deprecated
    public static int randomize(int max) {
        if (max < 1) {
            return 0;
        }
        return CSCoreLib.randomizer().nextInt(max);
    }

    @Deprecated
    public static boolean chance(int max, int percentage) {
        if (max < 1) {
            return false;
        }
        return CSCoreLib.randomizer().nextInt(max) <= percentage;
    }

    public GPSNetwork getGPS() {
        return this.gps;
    }

    public static SlimefunHooks getHooks() {
        return SlimefunPlugin.instance.hooks;
    }

    public static Utilities getUtilities() {
        return SlimefunPlugin.instance.utilities;
    }

    public static Settings getSettings() {
        return SlimefunPlugin.instance.settings;
    }

    public static TickerTask getTicker() {
        return SlimefunPlugin.instance.ticker;
    }

    public static boolean isActive() {
        return instance != null;
    }

    public static ProtectionManager getProtectionManager() {
        return SlimefunPlugin.instance.protections;
    }

    public static LocalizationService getLocal() {
        return SlimefunPlugin.instance.local;
    }

    public static RecipeSnapshot getMinecraftRecipes() {
        return SlimefunPlugin.instance.recipeSnapshot;
    }

    public static CustomItemDataService getItemDataService() {
        return SlimefunPlugin.instance.itemDataService;
    }

    public static CustomTextureService getItemTextureService() {
        return SlimefunPlugin.instance.textureService;
    }

    public static BlockDataService getBlockDataService() {
        return SlimefunPlugin.instance.blockDataService;
    }

    public static GitHubService getGitHubService() {
        return SlimefunPlugin.instance.gitHubService;
    }
}

