/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.utils;

import java.util.Arrays;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public final class ChestMenuUtils {
    private static final ItemStack UI_BACKGROUND = new SlimefunItemStack("_UI_BACKGROUND", Material.GRAY_STAINED_GLASS_PANE, " ", new String[0]);
    private static final ItemStack BACK_BUTTON = new SlimefunItemStack("_UI_BACK", Material.ENCHANTED_BOOK, "&7\u21e6 Back", new String[0]);
    private static final ItemStack MENU_BUTTON = new SlimefunItemStack("_UI_MENU", Material.ENCHANTED_BOOK, "&eSettings / Info", "", "&7\u21e8 Click to see more");
    private static final ItemStack SEARCH_BUTTON = new SlimefunItemStack("_UI_SEARCH", Material.NAME_TAG, "&bSearch", new String[0]);
    private static final ItemStack PREV_BUTTON_ACTIVE = new SlimefunItemStack("_UI_PREVIOUS_ACTIVE", Material.LIME_STAINED_GLASS_PANE, "&r\u21e6 Previous Page", new String[0]);
    private static final ItemStack NEXT_BUTTON_ACTIVE = new SlimefunItemStack("_UI_NEXT_ACTIVE", Material.LIME_STAINED_GLASS_PANE, "&rNext Page \u21e8", new String[0]);
    private static final ItemStack PREV_BUTTON_INACTIVE = new SlimefunItemStack("_UI_PREVIOUS_INACTIVE", Material.BLACK_STAINED_GLASS_PANE, "&8\u21e6 Previous Page", new String[0]);
    private static final ItemStack NEXT_BUTTON_INACTIVE = new SlimefunItemStack("_UI_NEXT_INACTIVE", Material.BLACK_STAINED_GLASS_PANE, "&8Next Page \u21e8", new String[0]);
    private static final ChestMenu.MenuClickHandler CLICK_HANDLER = (p, s, i, a) -> false;

    private ChestMenuUtils() {
    }

    public static final ItemStack getBackground() {
        return UI_BACKGROUND;
    }

    public static final ChestMenu.MenuClickHandler getEmptyClickHandler() {
        return CLICK_HANDLER;
    }

    public static ItemStack getBackButton() {
        return BACK_BUTTON;
    }

    public static ItemStack getMenuButton() {
        return MENU_BUTTON;
    }

    public static ItemStack getSearchButton() {
        return SEARCH_BUTTON;
    }

    public static ItemStack getPreviousButton(int page, int pages) {
        if (pages == 1 || page == 1) {
            return new CustomItem(PREV_BUTTON_INACTIVE, meta -> meta.setLore(Arrays.asList("", ChatColor.GRAY + "(" + page + " / " + pages + ")")));
        }
        return new CustomItem(PREV_BUTTON_ACTIVE, meta -> meta.setLore(Arrays.asList("", ChatColor.GRAY + "(" + page + " / " + pages + ")")));
    }

    public static ItemStack getNextButton(int page, int pages) {
        if (pages == 1 || page == pages) {
            return new CustomItem(NEXT_BUTTON_INACTIVE, meta -> meta.setLore(Arrays.asList("", ChatColor.GRAY + "(" + page + " / " + pages + ")")));
        }
        return new CustomItem(NEXT_BUTTON_ACTIVE, meta -> meta.setLore(Arrays.asList("", ChatColor.GRAY + "(" + page + " / " + pages + ")")));
    }
}

