/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core;

import io.github.thebusybiscuit.slimefun4.api.blocks.BlockLocation;
import io.github.thebusybiscuit.slimefun4.api.blocks.SlimefunBlock;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.cscorelib2.collections.OptionalMap;
import org.bukkit.block.Block;
import org.bukkit.block.TileState;

public class SlimefunWorld {
    private final UUID uuid;
    private final OptionalMap<BlockLocation, SlimefunBlock> blocks = new OptionalMap(HashMap::new);

    public SlimefunWorld(UUID uuid) {
        this.uuid = uuid;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public Optional<SlimefunBlock> getBlock(Block b) {
        Optional<String> blockData;
        if (b.getState() instanceof TileState && (blockData = SlimefunPlugin.getBlockDataService().getBlockData((TileState)b.getState())).isPresent()) {
            return Optional.of(new SlimefunBlock(blockData.get()));
        }
        return this.blocks.get(new BlockLocation(b));
    }

    public boolean isBlock(Block b, String id) {
        if (id == null) {
            throw new IllegalArgumentException("Cannot check blocks for id: null");
        }
        Optional<SlimefunBlock> block = this.getBlock(b);
        return block.isPresent() && block.get().getID().equals(id);
    }
}

