/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.Objects.SlimefunItem;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.MultiBlock;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.interfaces.RecipeDisplayItem;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.inventory.ItemStack;

public class SlimefunMachine
extends SlimefunItem
implements RecipeDisplayItem {
    protected final List<ItemStack[]> recipes = new ArrayList<ItemStack[]>();
    protected final List<ItemStack> shownRecipes = new ArrayList<ItemStack>();
    protected final BlockFace trigger;

    @Deprecated
    public SlimefunMachine(Category category, ItemStack item, String id, ItemStack[] recipe, ItemStack[] machineRecipes, Material trigger) {
        this(category, item, id, recipe, machineRecipes, SlimefunMachine.convertTriggerMaterial(recipe, trigger));
    }

    @Deprecated
    public SlimefunMachine(Category category, ItemStack item, String id, ItemStack[] recipe, ItemStack[] machineRecipes, Material trigger, boolean ghost) {
        this(category, item, id, recipe, machineRecipes, SlimefunMachine.convertTriggerMaterial(recipe, trigger), ghost);
    }

    @Deprecated
    public SlimefunMachine(Category category, ItemStack item, String id, ItemStack[] recipe, ItemStack[] machineRecipes, Material trigger, String[] keys, Object[] values) {
        this(category, item, id, recipe, machineRecipes, SlimefunMachine.convertTriggerMaterial(recipe, trigger), keys, values);
    }

    public SlimefunMachine(Category category, ItemStack item, String id, ItemStack[] recipe, ItemStack[] machineRecipes, BlockFace trigger) {
        super(category, item, id, RecipeType.MULTIBLOCK, recipe);
        this.shownRecipes.addAll(Arrays.asList(machineRecipes));
        this.trigger = trigger;
    }

    public SlimefunMachine(Category category, ItemStack item, String id, ItemStack[] recipe, ItemStack[] machineRecipes, BlockFace trigger, boolean ghost) {
        super(category, item, id, RecipeType.MULTIBLOCK, recipe, ghost);
        this.shownRecipes.addAll(Arrays.asList(machineRecipes));
        this.trigger = trigger;
    }

    public SlimefunMachine(Category category, ItemStack item, String id, ItemStack[] recipe, ItemStack[] machineRecipes, BlockFace trigger, String[] keys, Object[] values) {
        super(category, item, id, RecipeType.MULTIBLOCK, recipe, keys, values);
        this.shownRecipes.addAll(Arrays.asList(machineRecipes));
        this.trigger = trigger;
    }

    public List<ItemStack[]> getRecipes() {
        return this.recipes;
    }

    @Override
    public List<ItemStack> getDisplayRecipes() {
        return this.shownRecipes;
    }

    public void addRecipe(ItemStack[] input, ItemStack output) {
        if (output == null) {
            throw new IllegalArgumentException("Recipes must have an Output!");
        }
        this.recipes.add(input);
        this.recipes.add(new ItemStack[]{output});
    }

    @Override
    public void postRegister() {
        this.toMultiBlock().register();
    }

    @Override
    public void install() {
        for (ItemStack recipeItem : this.shownRecipes) {
            SlimefunItem item = SlimefunItem.getByItem(recipeItem);
            if (item != null && SlimefunItem.isDisabled(recipeItem)) continue;
            this.recipes.add(new ItemStack[]{recipeItem});
        }
    }

    private static Material[] convertItemStacksToMaterial(ItemStack[] items) {
        ArrayList<Material> mats = new ArrayList<Material>();
        for (ItemStack item : items) {
            if (item == null) {
                mats.add(null);
                continue;
            }
            if (item.getType() == Material.FLINT_AND_STEEL) {
                mats.add(Material.FIRE);
                continue;
            }
            mats.add(item.getType());
        }
        return mats.toArray(new Material[mats.size()]);
    }

    public MultiBlock toMultiBlock() {
        return new MultiBlock(SlimefunMachine.convertItemStacksToMaterial(this.getRecipe()), this.trigger);
    }

    public Iterator<ItemStack[]> recipeIterator() {
        return this.recipes.iterator();
    }

    @Deprecated
    private static BlockFace convertTriggerMaterial(ItemStack[] recipe, Material trigger) {
        return MultiBlock.convertTriggerMaterialToBlockFace(SlimefunMachine.convertItemStacksToMaterial(recipe), trigger);
    }
}

