/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.api.item_transport;

import java.util.ArrayList;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.Item.CustomItem;
import me.mrCookieSlime.Slimefun.Setup.SlimefunManager;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.UniversalBlockMenu;
import me.mrCookieSlime.Slimefun.api.item_transport.ChestManipulator;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemSlot;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import org.bukkit.block.Block;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class CargoManager {
    private static int[] slots = new int[]{19, 20, 21, 28, 29, 30, 37, 38, 39};

    public static ItemStack withdraw(Block node, BlockStorage storage, Block target, ItemStack template) {
        block7: {
            block8: {
                block6: {
                    if (!storage.hasUniversalInventory(target)) break block6;
                    UniversalBlockMenu menu = storage.getUniversalInventory(target);
                    for (int slot : menu.getPreset().getSlotsAccessedByItemTransport(menu, ItemTransportFlow.WITHDRAW, null)) {
                        ItemStack is = menu.getItemInSlot(slot);
                        if (!SlimefunManager.isItemSimiliar(is, template, true, SlimefunManager.DataType.ALWAYS) || !CargoManager.matchesFilter(node, is, -1)) continue;
                        if (is.getAmount() > template.getAmount()) {
                            menu.replaceExistingItem(slot, (ItemStack)new CustomItem(is, is.getAmount() - template.getAmount()));
                            return template;
                        }
                        menu.replaceExistingItem(slot, null);
                        return is.clone();
                    }
                    break block7;
                }
                if (!storage.hasInventory(target.getLocation())) break block8;
                BlockMenu menu = BlockStorage.getInventory(target.getLocation());
                for (int slot : menu.getPreset().getSlotsAccessedByItemTransport(menu, ItemTransportFlow.WITHDRAW, null)) {
                    ItemStack is = menu.getItemInSlot(slot);
                    if (!SlimefunManager.isItemSimiliar(is, template, true, SlimefunManager.DataType.ALWAYS) || !CargoManager.matchesFilter(node, is, -1)) continue;
                    if (is.getAmount() > template.getAmount()) {
                        menu.replaceExistingItem(slot, (ItemStack)new CustomItem(is, is.getAmount() - template.getAmount()));
                        return template;
                    }
                    menu.replaceExistingItem(slot, null);
                    return is.clone();
                }
                break block7;
            }
            if (!(target.getState() instanceof InventoryHolder)) break block7;
            Inventory inv = ((InventoryHolder)target.getState()).getInventory();
            for (int slot = 0; slot < inv.getContents().length; ++slot) {
                ItemStack is = inv.getContents()[slot];
                if (!SlimefunManager.isItemSimiliar(is, template, true, SlimefunManager.DataType.ALWAYS) || !CargoManager.matchesFilter(node, is, -1)) continue;
                if (is.getAmount() > template.getAmount()) {
                    inv.setItem(slot, ChestManipulator.trigger(target, slot, is, (ItemStack)new CustomItem(is, is.getAmount() - template.getAmount())));
                    return template;
                }
                inv.setItem(slot, ChestManipulator.trigger(target, slot, is, (ItemStack)new CustomItem(is, is.getAmount() - template.getAmount())));
                return is.clone();
            }
        }
        return null;
    }

    public static ItemSlot withdraw(Block node, BlockStorage storage, Block target, int index) {
        block4: {
            block5: {
                block3: {
                    if (!storage.hasUniversalInventory(target)) break block3;
                    UniversalBlockMenu menu = storage.getUniversalInventory(target);
                    for (int slot : menu.getPreset().getSlotsAccessedByItemTransport(menu, ItemTransportFlow.WITHDRAW, null)) {
                        ItemStack is = menu.getItemInSlot(slot);
                        if (!CargoManager.matchesFilter(node, is, index)) continue;
                        menu.replaceExistingItem(slot, null);
                        return new ItemSlot(is.clone(), slot);
                    }
                    break block4;
                }
                if (!storage.hasInventory(target.getLocation())) break block5;
                BlockMenu menu = BlockStorage.getInventory(target.getLocation());
                for (int slot : menu.getPreset().getSlotsAccessedByItemTransport(menu, ItemTransportFlow.WITHDRAW, null)) {
                    ItemStack is = menu.getItemInSlot(slot);
                    if (!CargoManager.matchesFilter(node, is, index)) continue;
                    menu.replaceExistingItem(slot, null);
                    return new ItemSlot(is.clone(), slot);
                }
                break block4;
            }
            if (!(target.getState() instanceof InventoryHolder)) break block4;
            Inventory inv = ((InventoryHolder)target.getState()).getInventory();
            for (int slot = 0; slot < inv.getContents().length; ++slot) {
                ItemStack is = inv.getContents()[slot];
                if (!CargoManager.matchesFilter(node, is, index)) continue;
                inv.setItem(slot, ChestManipulator.trigger(target, slot, is, null));
                return new ItemSlot(is.clone(), slot);
            }
        }
        return null;
    }

    public static ItemStack insert(Block node, BlockStorage storage, Block target, ItemStack stack, int index) {
        block14: {
            block15: {
                block13: {
                    if (!CargoManager.matchesFilter(node, stack, index)) {
                        return stack;
                    }
                    if (!storage.hasUniversalInventory(target)) break block13;
                    UniversalBlockMenu menu = storage.getUniversalInventory(target);
                    for (int slot : menu.getPreset().getSlotsAccessedByItemTransport(menu, ItemTransportFlow.INSERT, stack)) {
                        ItemStack is;
                        ItemStack itemStack = is = menu.getItemInSlot(slot) == null ? null : menu.getItemInSlot(slot).clone();
                        if (is == null) {
                            menu.replaceExistingItem(slot, stack.clone());
                            return null;
                        }
                        if (!SlimefunManager.isItemSimiliar((ItemStack)new CustomItem(is, 1), (ItemStack)new CustomItem(stack, 1), true, SlimefunManager.DataType.ALWAYS) || is.getAmount() >= is.getType().getMaxStackSize()) continue;
                        int amount = is.getAmount() + stack.getAmount();
                        if (amount > is.getType().getMaxStackSize()) {
                            is.setAmount(is.getType().getMaxStackSize());
                            stack.setAmount(amount - is.getType().getMaxStackSize());
                        } else {
                            is.setAmount(amount);
                            stack = null;
                        }
                        menu.replaceExistingItem(slot, is);
                        return stack;
                    }
                    break block14;
                }
                if (!storage.hasInventory(target.getLocation())) break block15;
                BlockMenu menu = BlockStorage.getInventory(target.getLocation());
                for (int slot : menu.getPreset().getSlotsAccessedByItemTransport(menu, ItemTransportFlow.INSERT, stack)) {
                    ItemStack is;
                    ItemStack itemStack = is = menu.getItemInSlot(slot) == null ? null : menu.getItemInSlot(slot).clone();
                    if (is == null) {
                        menu.replaceExistingItem(slot, stack.clone());
                        return null;
                    }
                    if (!SlimefunManager.isItemSimiliar((ItemStack)new CustomItem(is, 1), (ItemStack)new CustomItem(stack, 1), true, SlimefunManager.DataType.ALWAYS) || is.getAmount() >= is.getType().getMaxStackSize()) continue;
                    int amount = is.getAmount() + stack.getAmount();
                    if (amount > is.getType().getMaxStackSize()) {
                        is.setAmount(is.getType().getMaxStackSize());
                        stack.setAmount(amount - is.getType().getMaxStackSize());
                    } else {
                        is.setAmount(amount);
                        stack = null;
                    }
                    menu.replaceExistingItem(slot, is);
                    return stack;
                }
                break block14;
            }
            if (!(target.getState() instanceof InventoryHolder)) break block14;
            Inventory inv = ((InventoryHolder)target.getState()).getInventory();
            for (int slot = 0; slot < inv.getContents().length; ++slot) {
                ItemStack is = inv.getContents()[slot];
                if (is == null) {
                    inv.setItem(slot, ChestManipulator.trigger(target, slot, null, stack.clone()));
                    return null;
                }
                if (!SlimefunManager.isItemSimiliar((ItemStack)new CustomItem(is, 1), (ItemStack)new CustomItem(stack, 1), true, SlimefunManager.DataType.ALWAYS) || is.getAmount() >= is.getType().getMaxStackSize()) continue;
                ItemStack prev = is.clone();
                int amount = is.getAmount() + stack.getAmount();
                if (amount > is.getType().getMaxStackSize()) {
                    is.setAmount(is.getType().getMaxStackSize());
                    stack.setAmount(amount - is.getType().getMaxStackSize());
                } else {
                    is.setAmount(amount);
                    stack = null;
                }
                inv.setItem(slot, ChestManipulator.trigger(target, slot, prev, is));
                return stack;
            }
        }
        return stack;
    }

    public static boolean matchesFilter(Block block, ItemStack item, int index) {
        if (item == null) {
            return false;
        }
        String id = BlockStorage.checkID(block);
        if (id.equals("CARGO_NODE_OUTPUT")) {
            return true;
        }
        Config blockInfo = BlockStorage.getBlockInfo(block);
        BlockMenu menu = BlockStorage.getInventory(block.getLocation());
        boolean lore = blockInfo.getString("filter-lore").equals("true");
        boolean data = blockInfo.getString("filter-durability").equals("true");
        if (blockInfo.getString("filter-type").equals("whitelist")) {
            ArrayList<CustomItem> items = new ArrayList<CustomItem>();
            for (int slot : slots) {
                ItemStack template = menu.getItemInSlot(slot);
                if (template == null) continue;
                items.add(new CustomItem(template, 1));
            }
            if (items.isEmpty()) {
                return false;
            }
            if (index >= 0) {
                if (++index > items.size() - 1) {
                    index = 0;
                }
                BlockStorage.addBlockInfo(block, "index", String.valueOf(index));
                return SlimefunManager.isItemSimiliar(item, (ItemStack)items.get(index), lore, data ? SlimefunManager.DataType.ALWAYS : SlimefunManager.DataType.NEVER);
            }
            Object object = items.iterator();
            while (object.hasNext()) {
                ItemStack stack = (ItemStack)object.next();
                if (!SlimefunManager.isItemSimiliar(item, stack, lore, data ? SlimefunManager.DataType.ALWAYS : SlimefunManager.DataType.NEVER)) continue;
                return true;
            }
            return false;
        }
        for (int slot : slots) {
            if (menu.getItemInSlot(slot) == null || !SlimefunManager.isItemSimiliar(item, (ItemStack)new CustomItem(menu.getItemInSlot(slot), 1), lore, data ? SlimefunManager.DataType.ALWAYS : SlimefunManager.DataType.NEVER)) continue;
            return false;
        }
        return true;
    }
}

