/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.Objects;

import io.github.thebusybiscuit.slimefun4.api.events.ResearchUnlockEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import me.mrCookieSlime.CSCoreLibPlugin.general.Particles.FireworkShow;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.PlayerProfile;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class Research {
    private static final int[] research_progress = new int[]{23, 44, 57, 92};
    private int id;
    private String name;
    private List<SlimefunItem> items;
    private int cost;
    private boolean enabled;

    public Research(int id, String name, int cost) {
        this.id = id;
        this.name = name;
        this.cost = cost;
        this.items = new ArrayList<SlimefunItem>();
        this.enabled = true;
    }

    public boolean isEnabled() {
        return SlimefunPlugin.getSettings().researchesEnabled && this.enabled;
    }

    public int getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    @Deprecated
    public int getLevel() {
        return this.getCost();
    }

    @Deprecated
    public void setLevel(int level) {
        this.setCost(level);
    }

    public int getCost() {
        return this.cost;
    }

    public void setCost(int cost) {
        this.cost = cost;
    }

    public void addItems(SlimefunItem ... items) {
        for (SlimefunItem item : items) {
            if (item == null) continue;
            item.bindToResearch(this);
        }
    }

    public List<SlimefunItem> getAffectedItems() {
        return this.items;
    }

    @Deprecated
    public boolean hasUnlocked(Player p) {
        return this.hasUnlocked(p.getUniqueId());
    }

    @Deprecated
    public boolean hasUnlocked(UUID uuid) {
        return PlayerProfile.fromUUID(uuid).hasUnlocked(this);
    }

    public boolean canUnlock(Player p) {
        if (!this.isEnabled()) {
            return true;
        }
        return p.getGameMode() == GameMode.CREATIVE && SlimefunPlugin.getSettings().researchesFreeInCreative || p.getLevel() >= this.cost;
    }

    @Deprecated
    public void lock(Player p) {
        PlayerProfile.get((OfflinePlayer)p).setResearched(this, false);
        SlimefunPlugin.getLocal().sendMessage((CommandSender)p, "commands.research.reset-target", true);
    }

    public void unlock(Player p, boolean instant) {
        if (!instant) {
            Slimefun.runSync(() -> {
                p.playSound(p.getLocation(), Sound.ENTITY_BAT_TAKEOFF, 0.7f, 1.0f);
                SlimefunPlugin.getLocal().sendMessage((CommandSender)p, "messages.research.progress", true, msg -> msg.replace("%research%", this.getName()).replace("%progress%", "0%"));
            }, 10L);
        }
        PlayerProfile.get((OfflinePlayer)p, profile -> {
            if (!profile.hasUnlocked(this)) {
                Runnable runnable = () -> {
                    profile.setResearched(this, true);
                    SlimefunPlugin.getLocal().sendMessage((CommandSender)p, "messages.unlocked", true, msg -> msg.replace("%research%", this.getName()));
                    if (SlimefunPlugin.getCfg().getBoolean("options.research-unlock-fireworks")) {
                        FireworkShow.launchRandom((Player)p, (int)1);
                    }
                };
                Slimefun.runSync(() -> {
                    ResearchUnlockEvent event = new ResearchUnlockEvent(p, this);
                    Bukkit.getPluginManager().callEvent((Event)event);
                    if (!event.isCancelled()) {
                        if (instant) {
                            runnable.run();
                        } else if (!SlimefunPlugin.getUtilities().researching.contains(p.getUniqueId())) {
                            SlimefunPlugin.getUtilities().researching.add(p.getUniqueId());
                            SlimefunPlugin.getLocal().sendMessage((CommandSender)p, "messages.research.start", true, msg -> msg.replace("%research%", this.getName()));
                            for (int i = 1; i < research_progress.length + 1; ++i) {
                                int j = i;
                                Slimefun.runSync(() -> {
                                    p.playSound(p.getLocation(), Sound.ENTITY_BAT_TAKEOFF, 0.7f, 1.0f);
                                    SlimefunPlugin.getLocal().sendMessage((CommandSender)p, "messages.research.progress", true, msg -> msg.replace("%research%", this.getName()).replace("%progress%", research_progress[j - 1] + "%"));
                                }, (long)i * 20L);
                            }
                            Slimefun.runSync(() -> {
                                runnable.run();
                                SlimefunPlugin.getUtilities().researching.remove(p.getUniqueId());
                            }, (long)(research_progress.length + 1) * 20L);
                        }
                    }
                });
            }
        });
    }

    public void register() {
        SlimefunPlugin.getResearchCfg().setDefaultValue("enable-researching", (Object)true);
        if (SlimefunPlugin.getResearchCfg().contains(this.getID() + ".enabled") && !SlimefunPlugin.getResearchCfg().getBoolean(this.getID() + ".enabled")) {
            Iterator<SlimefunItem> iterator = this.items.iterator();
            while (iterator.hasNext()) {
                SlimefunItem item = iterator.next();
                if (item != null) {
                    item.bindToResearch(null);
                }
                iterator.remove();
            }
            return;
        }
        SlimefunPlugin.getResearchCfg().setDefaultValue(this.getID() + ".name", (Object)this.getName());
        SlimefunPlugin.getResearchCfg().setDefaultValue(this.getID() + ".cost", (Object)this.getCost());
        SlimefunPlugin.getResearchCfg().setDefaultValue(this.getID() + ".enabled", (Object)true);
        this.name = SlimefunPlugin.getResearchCfg().getString(this.getID() + ".name");
        this.cost = SlimefunPlugin.getResearchCfg().getInt(this.getID() + ".cost");
        this.enabled = SlimefunPlugin.getResearchCfg().getBoolean(this.getID() + ".enabled");
        SlimefunPlugin.getUtilities().allResearches.add(this);
        if (SlimefunPlugin.getSettings().printOutLoading) {
            Slimefun.getLogger().log(Level.INFO, "Loaded Research \"" + this.getName() + "\"");
        }
    }

    public static List<Research> list() {
        return SlimefunPlugin.getUtilities().allResearches;
    }

    public static boolean isResearching(Player p) {
        return SlimefunPlugin.getUtilities().researching.contains(p.getUniqueId());
    }

    @Deprecated
    public static void sendStats(CommandSender sender, Player p) {
        PlayerProfile.get((OfflinePlayer)p).sendStats(sender);
    }

    @Deprecated
    public static String getTitle(Player p, Collection<Research> researched) {
        return PlayerProfile.get((OfflinePlayer)p).getTitle();
    }

    public static Research getByID(int id) {
        for (Research research : Research.list()) {
            if (research.getID() != id) continue;
            return research;
        }
        return null;
    }

    @Deprecated
    public static List<Research> getResearches(UUID uuid) {
        ArrayList<Research> researched = new ArrayList<Research>();
        for (Research r : Research.list()) {
            if (!r.hasUnlocked(uuid)) continue;
            researched.add(r);
        }
        return researched;
    }

    @Deprecated
    public static List<Research> getResearches(String uuid) {
        return Research.getResearches(UUID.fromString(uuid));
    }

    public String toString() {
        return "Research {" + this.id + ',' + this.name + "}";
    }
}

