/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.cscorelib2.players;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownServiceException;
import java.util.Iterator;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Pattern;
import lombok.NonNull;

public final class MinecraftAccount {
    private static final Pattern UUID_PATTERN = Pattern.compile("(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})");
    private static final String ERROR_TOKEN = "error";
    private static final JsonParser JSON_PARSER = new JsonParser();
    private static final Pattern NAME_PATTERN = Pattern.compile("[\\w_]+");

    private MinecraftAccount() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<UUID> getUUID(@NonNull String name) throws TooManyRequestsException {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (NAME_PATTERN.matcher(name).matches()) {
            throw new IllegalArgumentException("\"" + name + "\" is not a valid Minecraft Username!");
        }
        Optional<URL> url = MinecraftAccount.getURL("https://api.mojang.com/users/profiles/minecraft/" + name);
        if (!url.isPresent()) return Optional.empty();
        try (InputStreamReader reader = new InputStreamReader(url.get().openStream());){
            JsonElement element = JSON_PARSER.parse((Reader)reader);
            if (element instanceof JsonNull) return Optional.empty();
            JsonObject obj = element.getAsJsonObject();
            if (obj.has(ERROR_TOKEN)) {
                String error = obj.get(ERROR_TOKEN).getAsString();
                if (!error.equals("TooManyRequestsException")) throw new UnknownServiceException(error);
                throw new TooManyRequestsException(url.orElse(null));
            }
            String id = obj.get("id").getAsString();
            Optional<UUID> optional = Optional.ofNullable(UUID.fromString(UUID_PATTERN.matcher(id).replaceAll("$1-$2-$3-$4-$5")));
            return optional;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return Optional.empty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<String> getSkin(@NonNull UUID uuid) throws TooManyRequestsException {
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        Optional<URL> url = MinecraftAccount.getURL("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid.toString().replace("-", "") + "?unsigned=false");
        if (!url.isPresent()) return Optional.empty();
        try (InputStreamReader reader = new InputStreamReader(url.get().openStream());){
            JsonElement el;
            JsonElement element = JSON_PARSER.parse((Reader)reader);
            if (element instanceof JsonNull) return Optional.empty();
            JsonObject obj = element.getAsJsonObject();
            if (obj.has(ERROR_TOKEN)) {
                String error = obj.get(ERROR_TOKEN).getAsString();
                if (!error.equals("TooManyRequestsException")) throw new UnknownServiceException(error);
                throw new TooManyRequestsException(url.orElse(null));
            }
            JsonArray properties = obj.get("properties").getAsJsonArray();
            Iterator iterator = properties.iterator();
            do {
                if (!iterator.hasNext()) return Optional.empty();
            } while (!(el = (JsonElement)iterator.next()).isJsonObject() || !el.getAsJsonObject().get("name").getAsString().equals("textures"));
            Optional<String> optional = Optional.ofNullable(el.getAsJsonObject().get("value").getAsString());
            return optional;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return Optional.empty();
    }

    private static Optional<URL> getURL(String url) {
        try {
            return Optional.ofNullable(new URL(url));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }

    public static class TooManyRequestsException
    extends Exception {
        private static final long serialVersionUID = -7137562700404366948L;
        private final URL url;

        @Override
        public String getMessage() {
            return "Sent too many Requests to the Server! URL: " + this.url;
        }

        public TooManyRequestsException(URL url) {
            this.url = url;
        }
    }
}

