/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.cscorelib2.item;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.NonNull;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.meta.ItemMeta;

public class ImmutableItemMeta {
    private final Optional<String> displayName;
    private final Optional<List<String>> lore;
    private final Optional<Integer> customModelData;
    private final Set<ItemFlag> itemFlags;
    private final Map<Enchantment, Integer> enchants;

    public ImmutableItemMeta(@NonNull ItemMeta meta) {
        if (meta == null) {
            throw new NullPointerException("meta is marked non-null but is null");
        }
        this.displayName = meta.hasDisplayName() ? Optional.of(meta.getDisplayName()) : Optional.empty();
        this.lore = meta.hasLore() ? Optional.of(meta.getLore()) : Optional.empty();
        this.customModelData = meta.hasCustomModelData() ? Optional.of(meta.getCustomModelData()) : Optional.empty();
        this.itemFlags = meta.getItemFlags();
        this.enchants = meta.getEnchants();
    }

    public Optional<String> getDisplayName() {
        return this.displayName;
    }

    public Optional<List<String>> getLore() {
        return this.lore;
    }

    public Optional<Integer> getCustomModelData() {
        return this.customModelData;
    }

    public Set<ItemFlag> getItemFlags() {
        return this.itemFlags;
    }

    public Map<Enchantment, Integer> getEnchants() {
        return this.enchants;
    }
}

