/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.GPS;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Variable;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ClickAction;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.Item.CustomItem;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.MenuHelper;
import me.mrCookieSlime.CSCoreLibPlugin.general.Math.DoubleHandler;
import me.mrCookieSlime.CSCoreLibPlugin.general.World.CustomSkull;
import me.mrCookieSlime.Slimefun.GEO.OreGenResource;
import me.mrCookieSlime.Slimefun.GEO.OreGenSystem;
import me.mrCookieSlime.Slimefun.GPS.NetworkStatus;
import me.mrCookieSlime.Slimefun.GPS.TeleportationSequence;
import me.mrCookieSlime.Slimefun.Setup.Messages;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;

public class GPSNetwork {
    private Map<UUID, Set<Location>> transmitters = new HashMap<UUID, Set<Location>>();
    private int[] border = new int[]{0, 1, 3, 5, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 26, 27, 35, 36, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53};
    private int[] inventory = new int[]{19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34, 37, 38, 39, 40, 41, 42, 43};
    private static final int[] teleporter_border = new int[]{0, 1, 2, 3, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 26, 27, 35, 36, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53};
    private static final int[] teleporter_inventory = new int[]{19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34, 37, 38, 39, 40, 41, 42, 43};

    public void updateTransmitter(Block b, UUID uuid, NetworkStatus status) {
        Set<Object> set = new HashSet();
        if (this.transmitters.containsKey(uuid)) {
            set = this.transmitters.get(uuid);
        }
        if (status.equals((Object)NetworkStatus.ONLINE)) {
            if (!set.contains(b.getLocation())) {
                set.add(b.getLocation());
                this.transmitters.put(uuid, set);
            }
        } else {
            set.remove(b.getLocation());
            this.transmitters.put(uuid, set);
        }
    }

    public int getNetworkComplexity(UUID uuid) {
        if (!this.transmitters.containsKey(uuid)) {
            return 0;
        }
        int level = 0;
        for (Location l : this.transmitters.get(uuid)) {
            level += l.getBlockY();
        }
        return level;
    }

    public int countTransmitters(UUID uuid) {
        if (!this.transmitters.containsKey(uuid)) {
            return 0;
        }
        return this.transmitters.get(uuid).size();
    }

    public void openTransmitterControlPanel(Player p) throws Exception {
        ChestMenu menu = new ChestMenu("&9Control Panel");
        for (int slot : this.border) {
            menu.addItem(slot, (ItemStack)new CustomItem(new MaterialData(Material.STAINED_GLASS_PANE, 7), " ", new String[0]), new ChestMenu.MenuClickHandler(){

                public boolean onClick(Player arg0, int arg1, ItemStack arg2, ClickAction arg3) {
                    return false;
                }
            });
        }
        menu.addItem(2, (ItemStack)new CustomItem(CustomSkull.getItem((String)"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYjBjOWMxYTAyMmY0MGI3M2YxNGI0Y2JhMzdjNzE4YzZhNTMzZjNhMjg2NGI2NTM2ZDVmNDU2OTM0Y2MxZiJ9fX0="), "&7Transmitter Overview &e(Selected)"));
        menu.addMenuClickHandler(2, new ChestMenu.MenuClickHandler(){

            public boolean onClick(Player arg0, int arg1, ItemStack arg2, ClickAction arg3) {
                return false;
            }
        });
        menu.addItem(4, (ItemStack)new CustomItem(CustomSkull.getItem((String)"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZGRjZmJhNThmYWYxZjY0ODQ3ODg0MTExODIyYjY0YWZhMjFkN2ZjNjJkNDQ4MWYxNGYzZjNiY2I2MzMwIn19fQ=="), "&7Network Info", new String[]{"", "&8\u21e8 &7Status: " + (this.getNetworkComplexity(p.getUniqueId()) > 0 ? "&2&lONLINE" : "&4&lOFFLINE"), "&8\u21e8 &7Complexity: &r" + this.getNetworkComplexity(p.getUniqueId())}));
        menu.addMenuClickHandler(4, new ChestMenu.MenuClickHandler(){

            public boolean onClick(Player arg0, int arg1, ItemStack arg2, ClickAction arg3) {
                return false;
            }
        });
        menu.addItem(6, (ItemStack)new CustomItem(CustomSkull.getItem((String)"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYzljODg4MWU0MjkxNWE5ZDI5YmI2MWExNmZiMjZkMDU5OTEzMjA0ZDI2NWRmNWI0MzliM2Q3OTJhY2Q1NiJ9fX0="), "&7Waypoint Overview &r(Select)"));
        menu.addMenuClickHandler(6, new ChestMenu.MenuClickHandler(){

            public boolean onClick(Player arg0, int arg1, ItemStack arg2, ClickAction arg3) {
                try {
                    GPSNetwork.this.openWaypointControlPanel(arg0);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return false;
            }
        });
        int index = 0;
        for (Location l : this.getTransmitters(p.getUniqueId())) {
            int slot;
            if (index >= this.inventory.length) break;
            slot = this.inventory[index];
            menu.addItem(slot, (ItemStack)new CustomItem(CustomSkull.getItem((String)"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYjBjOWMxYTAyMmY0MGI3M2YxNGI0Y2JhMzdjNzE4YzZhNTMzZjNhMjg2NGI2NTM2ZDVmNDU2OTM0Y2MxZiJ9fX0="), "&bGPS Transmitter", new String[]{"&8\u21e8 &7World: &r" + l.getWorld().getName(), "&8\u21e8 &7X: &r" + l.getX(), "&8\u21e8 &7Y: &r" + l.getY(), "&8\u21e8 &7Z: &r" + l.getZ(), "", "&8\u21e8 &7Signal Strength: &r" + l.getBlockY(), "&8\u21e8 &7Ping: &r" + DoubleHandler.fixDouble((double)(1000.0 / l.getY())) + "ms"}));
            menu.addMenuClickHandler(slot, new ChestMenu.MenuClickHandler(){

                public boolean onClick(Player arg0, int arg1, ItemStack arg2, ClickAction arg3) {
                    return false;
                }
            });
            ++index;
        }
        menu.open(new Player[]{p});
    }

    public static ItemStack getPlanet(Map.Entry<String, Location> entry) throws Exception {
        Location l = entry.getValue();
        if (entry.getKey().startsWith("&4Deathpoint")) {
            return CustomSkull.getItem((String)"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMWFlMzg1NWY5NTJjZDRhMDNjMTQ4YTk0NmUzZjgxMmE1OTU1YWQzNWNiY2I1MjYyN2VhNGFjZDQ3ZDMwODEifX19");
        }
        if (l.getWorld().getEnvironment().equals((Object)World.Environment.NETHER)) {
            return CustomSkull.getItem((String)"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZDgzNTcxZmY1ODlmMWE1OWJiMDJiODA4MDBmYzczNjExNmUyN2MzZGNmOWVmZWJlZGU4Y2YxZmRkZSJ9fX0=");
        }
        if (l.getWorld().getEnvironment().equals((Object)World.Environment.THE_END)) {
            return CustomSkull.getItem((String)"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYzZjYWM1OWIyYWFlNDg5YWEwNjg3YjVkODAyYjI1NTVlYjE0YTQwYmQ2MmIyMWViMTE2ZmE1NjljZGI3NTYifX19");
        }
        return CustomSkull.getItem((String)"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYzljODg4MWU0MjkxNWE5ZDI5YmI2MWExNmZiMjZkMDU5OTEzMjA0ZDI2NWRmNWI0MzliM2Q3OTJhY2Q1NiJ9fX0=");
    }

    public void openWaypointControlPanel(Player p) throws Exception {
        ChestMenu menu = new ChestMenu("&9Control Panel");
        for (int slot : this.border) {
            menu.addItem(slot, (ItemStack)new CustomItem(new MaterialData(Material.STAINED_GLASS_PANE, 7), " ", new String[0]), new ChestMenu.MenuClickHandler(){

                public boolean onClick(Player arg0, int arg1, ItemStack arg2, ClickAction arg3) {
                    return false;
                }
            });
        }
        menu.addItem(2, (ItemStack)new CustomItem(CustomSkull.getItem((String)"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYjBjOWMxYTAyMmY0MGI3M2YxNGI0Y2JhMzdjNzE4YzZhNTMzZjNhMjg2NGI2NTM2ZDVmNDU2OTM0Y2MxZiJ9fX0="), "&7Transmitter Overview &r(Select)"));
        menu.addMenuClickHandler(2, new ChestMenu.MenuClickHandler(){

            public boolean onClick(Player arg0, int arg1, ItemStack arg2, ClickAction arg3) {
                try {
                    GPSNetwork.this.openTransmitterControlPanel(arg0);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return false;
            }
        });
        menu.addItem(4, (ItemStack)new CustomItem(CustomSkull.getItem((String)"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZGRjZmJhNThmYWYxZjY0ODQ3ODg0MTExODIyYjY0YWZhMjFkN2ZjNjJkNDQ4MWYxNGYzZjNiY2I2MzMwIn19fQ=="), "&7Network Info", new String[]{"", "&8\u21e8 &7Status: " + (this.getNetworkComplexity(p.getUniqueId()) > 0 ? "&2&lONLINE" : "&4&lOFFLINE"), "&8\u21e8 &7Complexity: &r" + this.getNetworkComplexity(p.getUniqueId())}));
        menu.addMenuClickHandler(4, new ChestMenu.MenuClickHandler(){

            public boolean onClick(Player arg0, int arg1, ItemStack arg2, ClickAction arg3) {
                return false;
            }
        });
        menu.addItem(6, (ItemStack)new CustomItem(CustomSkull.getItem((String)"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYzljODg4MWU0MjkxNWE5ZDI5YmI2MWExNmZiMjZkMDU5OTEzMjA0ZDI2NWRmNWI0MzliM2Q3OTJhY2Q1NiJ9fX0="), "&7Waypoint Overview &e(Selected)"));
        menu.addMenuClickHandler(6, new ChestMenu.MenuClickHandler(){

            public boolean onClick(Player arg0, int arg1, ItemStack arg2, ClickAction arg3) {
                return false;
            }
        });
        int index = 0;
        for (final Map.Entry<String, Location> entry : this.getWaypoints(p.getUniqueId()).entrySet()) {
            int slot;
            if (index >= this.inventory.length) break;
            slot = this.inventory[index];
            Location l = entry.getValue();
            ItemStack globe = GPSNetwork.getPlanet(entry);
            menu.addItem(slot, (ItemStack)new CustomItem(globe, entry.getKey(), new String[]{"&8\u21e8 &7World: &r" + l.getWorld().getName(), "&8\u21e8 &7X: &r" + l.getX(), "&8\u21e8 &7Y: &r" + l.getY(), "&8\u21e8 &7Z: &r" + l.getZ(), "", "&8\u21e8 &cClick to delete"}));
            menu.addMenuClickHandler(slot, new ChestMenu.MenuClickHandler(){

                public boolean onClick(Player arg0, int arg1, ItemStack arg2, ClickAction arg3) {
                    String id = ChatColor.stripColor((String)ChatColor.translateAlternateColorCodes((char)'&', (String)((String)entry.getKey()))).toUpperCase().replace(" ", "_");
                    Config cfg = new Config("data-storage/Slimefun/waypoints/" + arg0.getUniqueId().toString() + ".yml");
                    cfg.setValue(id, null);
                    cfg.save();
                    arg0.playSound(arg0.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                    try {
                        GPSNetwork.this.openWaypointControlPanel(arg0);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return false;
                }
            });
            ++index;
        }
        menu.open(new Player[]{p});
    }

    public Map<String, Location> getWaypoints(UUID uuid) {
        HashMap<String, Location> map = new HashMap<String, Location>();
        Config cfg = new Config("data-storage/Slimefun/waypoints/" + uuid.toString() + ".yml");
        for (String key : cfg.getKeys()) {
            if (!cfg.contains(key + ".world") || Bukkit.getWorld((String)cfg.getString(key + ".world")) == null) continue;
            map.put(cfg.getString(key + ".name"), cfg.getLocation(key));
        }
        return map;
    }

    public void addWaypoint(Player p, final Location l) {
        if (this.getWaypoints(p.getUniqueId()).size() + 2 > this.inventory.length) {
            Messages.local.sendTranslation((CommandSender)p, "gps.waypoint.max", true, new Variable[0]);
            return;
        }
        Messages.local.sendTranslation((CommandSender)p, "gps.waypoint.new", true, new Variable[0]);
        p.playSound(p.getLocation(), Sound.BLOCK_NOTE_PLING, 0.5f, 1.0f);
        MenuHelper.awaitChatInput((Player)p, (MenuHelper.ChatHandler)new MenuHelper.ChatHandler(){

            public boolean onChat(Player p, String message) {
                GPSNetwork.this.addWaypoint(p, message, l);
                return false;
            }
        });
    }

    public void addWaypoint(Player p, String name, Location l) {
        if (this.getWaypoints(p.getUniqueId()).size() + 2 > this.inventory.length) {
            Messages.local.sendTranslation((CommandSender)p, "gps.waypoint.max", true, new Variable[0]);
            return;
        }
        Config cfg = new Config("data-storage/Slimefun/waypoints/" + p.getUniqueId().toString() + ".yml");
        String id = ChatColor.stripColor((String)ChatColor.translateAlternateColorCodes((char)'&', (String)name)).toUpperCase().replace(" ", "_");
        cfg.setValue(id, (Object)l);
        cfg.setValue(id + ".name", (Object)name);
        cfg.save();
        p.playSound(p.getLocation(), Sound.BLOCK_NOTE_PLING, 1.0f, 1.0f);
        Messages.local.sendTranslation((CommandSender)p, "gps.waypoint.added", true, new Variable[0]);
    }

    public Set<Location> getTransmitters(UUID uuid) {
        return this.transmitters.containsKey(uuid) ? this.transmitters.get(uuid) : new HashSet<Location>();
    }

    public void scanChunk(Player p, Chunk chunk) {
        if (this.getNetworkComplexity(p.getUniqueId()) < 600) {
            Messages.local.sendTranslation((CommandSender)p, "gps.insufficient-complexity", true, new Variable[]{new Variable("%complexity%", String.valueOf(600))});
            return;
        }
        ChestMenu menu = new ChestMenu("&4Scan Results");
        int index = 0;
        for (OreGenResource resource : OreGenSystem.listResources()) {
            int supply = OreGenSystem.getSupplies(resource, chunk, true);
            menu.addItem(index, (ItemStack)new CustomItem(resource.getIcon(), "&7Resource: &e" + resource.getName(), new String[]{"", "&7Scanned Chunk:", "&8\u21e8 &7X: " + chunk.getX() + " Z: " + chunk.getZ(), "", "&7Result: &e" + supply + " " + resource.getMeasurementUnit()}), new ChestMenu.MenuClickHandler(){

                public boolean onClick(Player arg0, int arg1, ItemStack arg2, ClickAction arg3) {
                    return false;
                }
            });
            ++index;
        }
        menu.open(new Player[]{p});
    }

    public static void openTeleporterGUI(Player p, UUID uuid, Block b, final int complexity) throws Exception {
        if (TeleportationSequence.players.contains(p.getUniqueId())) {
            return;
        }
        p.playSound(p.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
        TeleportationSequence.players.add(p.getUniqueId());
        ChestMenu menu = new ChestMenu("&3Teleporter");
        menu.addMenuCloseHandler(new ChestMenu.MenuCloseHandler(){

            public void onClose(Player p) {
                TeleportationSequence.players.remove(p.getUniqueId());
            }
        });
        for (int slot : teleporter_border) {
            menu.addItem(slot, (ItemStack)new CustomItem(new MaterialData(Material.STAINED_GLASS_PANE, 7), " ", new String[0]), new ChestMenu.MenuClickHandler(){

                public boolean onClick(Player arg0, int arg1, ItemStack arg2, ClickAction arg3) {
                    return false;
                }
            });
        }
        menu.addItem(4, (ItemStack)new CustomItem(CustomSkull.getItem((String)"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYzljODg4MWU0MjkxNWE5ZDI5YmI2MWExNmZiMjZkMDU5OTEzMjA0ZDI2NWRmNWI0MzliM2Q3OTJhY2Q1NiJ9fX0="), "&7Waypoint Overview &e(Select a Destination)"));
        menu.addMenuClickHandler(4, new ChestMenu.MenuClickHandler(){

            public boolean onClick(Player arg0, int arg1, ItemStack arg2, ClickAction arg3) {
                return false;
            }
        });
        final Location source = new Location(b.getWorld(), (double)b.getX() + 0.5, (double)b.getY() + 2.0, (double)b.getZ() + 0.5);
        int index = 0;
        for (Map.Entry<String, Location> entry : Slimefun.getGPSNetwork().getWaypoints(uuid).entrySet()) {
            if (index >= teleporter_inventory.length) break;
            int slot = teleporter_inventory[index];
            final Location l = entry.getValue();
            ItemStack globe = GPSNetwork.getPlanet(entry);
            menu.addItem(slot, (ItemStack)new CustomItem(globe, entry.getKey(), new String[]{"&8\u21e8 &7World: &r" + l.getWorld().getName(), "&8\u21e8 &7X: &r" + l.getX(), "&8\u21e8 &7Y: &r" + l.getY(), "&8\u21e8 &7Z: &r" + l.getZ(), "&8\u21e8 &7Estimated Teleportation Time: &r" + 50 / TeleportationSequence.getSpeed(Slimefun.getGPSNetwork().getNetworkComplexity(uuid), source, l) + "s", "", "&8\u21e8 &cClick to select"}));
            menu.addMenuClickHandler(slot, new ChestMenu.MenuClickHandler(){

                public boolean onClick(Player p, int arg1, ItemStack arg2, ClickAction arg3) {
                    p.closeInventory();
                    TeleportationSequence.start(p.getUniqueId(), complexity, source, l, false);
                    return false;
                }
            });
            ++index;
        }
        menu.open(new Player[]{p});
    }
}

