/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.cscorelib2.chat;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.ChatInput;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.IChatInput;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.plugin.Plugin;

class ChatInputListener
implements Listener {
    private Plugin plugin;
    protected Map<UUID, IChatInput> handlers;

    protected ChatInputListener(Plugin plugin) {
        this.plugin = plugin;
        this.handlers = new HashMap<UUID, IChatInput>();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, plugin);
    }

    @EventHandler
    public void onDisable(PluginDisableEvent e) {
        if (e.getPlugin() == this.plugin) {
            ChatInput.listener = null;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onChat(AsyncPlayerChatEvent e) {
        Player p = e.getPlayer();
        IChatInput handler = this.handlers.get(p.getUniqueId());
        String msg = e.getMessage().replace('\u00a7', '&');
        if (handler != null && handler.test(msg)) {
            this.handlers.remove(p.getUniqueId());
            this.plugin.getServer().getScheduler().runTask(this.plugin, () -> handler.onChat(p, msg));
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onComamnd(PlayerCommandPreprocessEvent e) {
        Player p = e.getPlayer();
        IChatInput handler = this.handlers.get(p.getUniqueId());
        if (handler != null && handler.test(e.getMessage())) {
            this.handlers.remove(p.getUniqueId());
            handler.onChat(p, e.getMessage());
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onLeave(PlayerQuitEvent e) {
        this.handlers.remove(e.getPlayer().getUniqueId());
    }

    @EventHandler
    public void onKick(PlayerKickEvent e) {
        this.handlers.remove(e.getPlayer().getUniqueId());
    }
}

