/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api;

import io.github.thebusybiscuit.slimefun4.api.items.ItemRestriction;
import java.util.Set;
import java.util.stream.Collectors;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.api.PlayerProfile;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public interface SlimefunAPI {
    public void addItemRestriction(ItemRestriction var1);

    public Set<ItemRestriction> getItemRestrictions();

    default public boolean isAllowedToUse(Player p, ItemStack item, boolean sendWarnings) {
        PlayerProfile profile = PlayerProfile.get((OfflinePlayer)p);
        SlimefunItem sfItem = SlimefunItem.getByItem(item);
        for (ItemRestriction restriction : this.getItemRestrictions()) {
            if (restriction.isAllowed(profile, p, sfItem, item)) continue;
            if (sendWarnings) {
                restriction.warnPlayer(profile, p, sfItem, item);
            }
            return false;
        }
        return true;
    }

    public Set<Category> getCategories();

    default public Set<SlimefunItem> getItems() {
        return this.getCategories().stream().flatMap(cat -> cat.getItems().stream()).collect(Collectors.toSet());
    }
}

