/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.hooks.github;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.List;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.hooks.github.Contributor;
import me.mrCookieSlime.Slimefun.hooks.github.GitHubConnector;

public class ContributionsConnector
extends GitHubConnector {
    private static final List<String> blacklist = Arrays.asList("invalid-email-address", "renovate-bot", "ImgBotApp");
    private final String prefix;
    private final String repository;
    private final String role;

    public ContributionsConnector(String prefix, String repository, String role) {
        this.prefix = prefix;
        this.repository = repository;
        this.role = role;
    }

    @Override
    public void onSuccess(JsonElement element) {
        this.computeContributors(element.getAsJsonArray());
    }

    @Override
    public String getRepository() {
        return this.repository;
    }

    @Override
    public String getFileName() {
        return this.prefix + "_contributors";
    }

    @Override
    public String getURLSuffix() {
        return "/contributors";
    }

    private void computeContributors(JsonArray array) {
        for (int i = 0; i < array.size(); ++i) {
            JsonObject object = array.get(i).getAsJsonObject();
            String name = object.get("login").getAsString();
            int commits = object.get("contributions").getAsInt();
            String profile = object.get("html_url").getAsString();
            if (blacklist.contains(name)) continue;
            Contributor contributor = SlimefunPlugin.getUtilities().contributors.computeIfAbsent(name, key -> new Contributor(name, profile));
            contributor.setContribution(this.role, commits);
        }
    }
}

