/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.api;

import io.github.thebusybiscuit.slimefun4.api.ErrorReport;
import java.text.DecimalFormat;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import me.mrCookieSlime.CSCoreLibPlugin.general.Chat.TellRawMessage;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.ChatColors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TickerTask
implements Runnable {
    private static final DecimalFormat decimalFormat = new DecimalFormat("#.###");
    private boolean halted = false;
    protected final Map<Location, Location> move = new HashMap<Location, Location>();
    protected final Map<Location, Boolean> delete = new HashMap<Location, Boolean>();
    private final Map<Location, Long> blockTimings = new HashMap<Location, Long>();
    private final Set<BlockTicker> tickers = new HashSet<BlockTicker>();
    private int skipped = 0;
    private int chunks = 0;
    private int machines = 0;
    private long time = 0L;
    private final Map<String, Integer> chunkItemCount = new HashMap<String, Integer>();
    private final Map<String, Integer> machineCount = new HashMap<String, Integer>();
    private final Map<String, Long> machineTimings = new HashMap<String, Long>();
    private final Map<String, Long> chunkTimings = new HashMap<String, Long>();
    private final Set<String> chunksSkipped = new HashSet<String>();
    private final Map<Location, Integer> buggedBlocks = new HashMap<Location, Integer>();
    private boolean running = false;

    public void abortTick() {
        this.running = false;
    }

    @Override
    public void run() {
        if (this.running) {
            return;
        }
        this.running = true;
        long timestamp = System.nanoTime();
        this.skipped = 0;
        this.chunks = 0;
        this.machines = 0;
        this.chunkItemCount.clear();
        this.machineCount.clear();
        this.time = 0L;
        this.chunkTimings.clear();
        this.chunksSkipped.clear();
        this.machineTimings.clear();
        this.blockTimings.clear();
        HashMap<Location, Integer> bugged = new HashMap<Location, Integer>(this.buggedBlocks);
        this.buggedBlocks.clear();
        HashMap<Location, Boolean> remove = new HashMap<Location, Boolean>(this.delete);
        for (Map.Entry entry : remove.entrySet()) {
            BlockStorage._integrated_removeBlockInfo((Location)entry.getKey(), (Boolean)entry.getValue());
            this.delete.remove(entry.getKey());
        }
        if (!this.halted) {
            for (String string : BlockStorage.getTickingChunks()) {
                long timestamp2 = System.nanoTime();
                ++this.chunks;
                for (Location l : BlockStorage.getTickingLocations(string)) {
                    if (l.getWorld().isChunkLoaded(l.getBlockX() >> 4, l.getBlockZ() >> 4)) {
                        Block b = l.getBlock();
                        SlimefunItem item = BlockStorage.check(l);
                        if (item != null && item.getBlockTicker() != null) {
                            ++this.machines;
                            try {
                                item.getBlockTicker().update();
                                if (item.getBlockTicker().isSynchronized()) {
                                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)SlimefunPlugin.instance, () -> {
                                        try {
                                            long timestamp3 = System.nanoTime();
                                            item.getBlockTicker().tick(b, item, BlockStorage.getLocationInfo(l));
                                            Long machinetime = this.machineTimings.get(item.getID());
                                            Integer chunk = this.chunkItemCount.get(c);
                                            Integer machine = this.machineCount.get(item.getID());
                                            this.machineTimings.put(item.getID(), (machinetime != null ? machinetime : 0L) + (System.nanoTime() - timestamp3));
                                            this.chunkItemCount.put(c, (chunk != null ? chunk : 0) + 1);
                                            this.machineCount.put(item.getID(), (machine != null ? machine : 0) + 1);
                                            this.blockTimings.put(l, System.nanoTime() - timestamp3);
                                        }
                                        catch (Exception x) {
                                            int errors = bugged.getOrDefault(l, 0);
                                            this.reportErrors(l, item, x, errors);
                                        }
                                    });
                                } else {
                                    long timestamp3 = System.nanoTime();
                                    item.getBlockTicker().tick(b, item, BlockStorage.getLocationInfo(l));
                                    this.machineTimings.merge(item.getID(), System.nanoTime() - timestamp3, Long::sum);
                                    this.chunkItemCount.merge(string, 1, Integer::sum);
                                    this.machineCount.merge(item.getID(), 1, Integer::sum);
                                    this.blockTimings.put(l, System.nanoTime() - timestamp3);
                                }
                                this.tickers.add(item.getBlockTicker());
                            }
                            catch (Exception x) {
                                int errors = bugged.getOrDefault(l, 0);
                                this.reportErrors(l, item, x, errors);
                            }
                            continue;
                        }
                        ++this.skipped;
                        continue;
                    }
                    this.skipped += BlockStorage.getTickingLocations(string).size();
                    this.chunksSkipped.add(string);
                    --this.chunks;
                    break;
                }
                this.chunkTimings.put(string, System.nanoTime() - timestamp2);
            }
        }
        for (Map.Entry entry : this.move.entrySet()) {
            BlockStorage._integrated_moveLocationInfo((Location)entry.getKey(), (Location)entry.getValue());
        }
        this.move.clear();
        Iterator<BlockTicker> iterator = this.tickers.iterator();
        while (iterator.hasNext()) {
            iterator.next().startNewTick();
            iterator.remove();
        }
        this.time = System.nanoTime() - timestamp;
        this.running = false;
    }

    private void reportErrors(Location l, SlimefunItem item, Exception x, int errors) {
        if (++errors == 1) {
            new ErrorReport(x, this, l, item);
            this.buggedBlocks.put(l, errors);
        } else if (errors == 4) {
            Slimefun.getLogger().log(Level.SEVERE, "X: " + l.getBlockX() + " Y: " + l.getBlockY() + " Z: " + l.getBlockZ() + '(' + item.getID() + ")");
            Slimefun.getLogger().log(Level.SEVERE, "has thrown 4 Exceptions in the last 4 Ticks, the Block has been terminated.");
            Slimefun.getLogger().log(Level.SEVERE, "Check your /plugins/Slimefun/error-reports/ folder for details.");
            Slimefun.getLogger().log(Level.SEVERE, " ");
            BlockStorage._integrated_removeBlockInfo(l, true);
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)SlimefunPlugin.instance, () -> l.getBlock().setType(Material.AIR));
        } else {
            this.buggedBlocks.put(l, errors);
        }
    }

    public String getTime() {
        return this.toMillis(this.time);
    }

    public void info(CommandSender sender) {
        int hidden;
        Object hover;
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&2== &aSlimefun Diagnostic Tool &2=="));
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&6Halted: &e&l" + String.valueOf(this.halted).toUpperCase())));
        sender.sendMessage("");
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&6Impact: &e" + this.toMillis(this.time))));
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&6Ticked Chunks: &e" + this.chunks)));
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&6Ticked Machines: &e" + this.machines)));
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&6Skipped Machines: &e" + this.skipped)));
        sender.sendMessage("");
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&6Ticking Machines:"));
        List timings = this.machineCount.keySet().stream().map(key -> new AbstractMap.SimpleEntry<String, Long>((String)key, this.machineTimings.getOrDefault(key, 0L))).sorted((o1, o2) -> ((Long)o2.getValue()).compareTo((Long)o1.getValue())).collect(Collectors.toList());
        if (sender instanceof Player) {
            TellRawMessage tellraw = new TellRawMessage();
            tellraw.addText("   &7&oHover for more Info");
            hover = new StringBuilder();
            hidden = 0;
            for (Map.Entry entry : timings) {
                int count = this.machineCount.get(entry.getKey());
                if ((Long)entry.getValue() > 500000L) {
                    ((StringBuilder)hover).append("\n&c").append((String)entry.getKey()).append(" - ").append(count).append("x &7(").append(this.toMillis((Long)entry.getValue())).append(", ").append(this.toMillis((Long)entry.getValue() / (long)count)).append(" avg/machine)");
                    continue;
                }
                ++hidden;
            }
            ((StringBuilder)hover).append("\n\n&c+ &4").append(hidden).append(" Hidden");
            tellraw.addHoverEvent(TellRawMessage.HoverAction.SHOW_TEXT, ((StringBuilder)hover).toString());
            try {
                tellraw.send(new Player[]{(Player)sender});
            }
            catch (Exception x) {
                Slimefun.getLogger().log(Level.SEVERE, "An Error occurred while sending a Timings Summary for Slimefun " + Slimefun.getVersion(), x);
            }
        } else {
            int hidden2 = 0;
            for (Map.Entry entry : timings) {
                int count = this.machineCount.get(entry.getKey());
                if ((Long)entry.getValue() > 500000L) {
                    sender.sendMessage(ChatColors.color("  &e" + (String)entry.getKey() + " - " + count + "x &7(" + this.toMillis((Long)entry.getValue()) + ", " + this.toMillis((Long)entry.getValue() / (long)count) + " avg/machine)"));
                    continue;
                }
                ++hidden2;
            }
            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&c+ &4" + hidden2 + " Hidden")));
        }
        sender.sendMessage("");
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&6Ticking Chunks:"));
        timings = this.chunkTimings.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).collect(Collectors.toList());
        if (sender instanceof Player) {
            TellRawMessage tellraw = new TellRawMessage();
            tellraw.addText("   &7&oHover for more Info");
            hover = new StringBuilder();
            hidden = 0;
            for (Map.Entry entry : timings) {
                if (this.chunksSkipped.contains(entry.getKey())) continue;
                if ((Long)entry.getValue() > 0L) {
                    ((StringBuilder)hover).append("\n&c").append(((String)entry.getKey()).replace("CraftChunk", "")).append(" - ").append(this.chunkItemCount.getOrDefault(entry.getKey(), 0)).append("x &7(").append(this.toMillis((Long)entry.getValue())).append(")");
                    continue;
                }
                ++hidden;
            }
            ((StringBuilder)hover).append("\n\n&c+ &4").append(hidden).append(" Hidden");
            tellraw.addHoverEvent(TellRawMessage.HoverAction.SHOW_TEXT, ((StringBuilder)hover).toString());
            try {
                tellraw.send(new Player[]{(Player)sender});
            }
            catch (Exception x) {
                Slimefun.getLogger().log(Level.SEVERE, "An Error occurred while sending a Timings Summary for Slimefun " + Slimefun.getVersion(), x);
            }
        } else {
            int hidden3 = 0;
            for (Map.Entry entry : timings) {
                if (this.chunksSkipped.contains(entry.getKey())) continue;
                if ((Long)entry.getValue() > 0L) {
                    sender.sendMessage("  &c" + ((String)entry.getKey()).replace("CraftChunk", "") + " - " + this.chunkItemCount.getOrDefault(entry.getKey(), 0) + "x &7(" + this.toMillis((Long)entry.getValue()) + ")");
                    continue;
                }
                ++hidden3;
            }
            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&c+ &4" + hidden3 + " Hidden")));
        }
    }

    public long getTimings(Block b) {
        return this.blockTimings.getOrDefault(b.getLocation(), 0L);
    }

    public long getTimings(String item) {
        return this.machineTimings.getOrDefault(item, 0L);
    }

    public long getTimings(Chunk c) {
        return this.chunkTimings.getOrDefault(c.toString(), 0L);
    }

    public void addBlockTimings(Location l, long time) {
        this.blockTimings.put(l, time);
    }

    public boolean isHalted() {
        return this.halted;
    }

    public void halt() {
        this.halted = true;
    }

    private String toMillis(long time) {
        return decimalFormat.format((float)time / 1000000.0f) + "ms";
    }

    public String toString() {
        return "TickerTask {\n     HALTED = " + this.halted + "\n     tickers = " + this.tickers + "\n     move = " + this.move + "\n     delete = " + this.delete + "\n     chunks = " + this.chunkItemCount + "\n     machines = " + this.machineCount + "\n     machinetime = " + this.machineTimings + "\n     chunktime = " + this.chunkTimings + "\n     skipped = " + this.chunksSkipped + "\n}";
    }
}

