/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.guides;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import me.mrCookieSlime.CSCoreLibPlugin.CSCoreLib;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.Item.CustomItem;
import me.mrCookieSlime.CSCoreLibPlugin.general.World.CustomSkull;
import me.mrCookieSlime.Slimefun.Setup.SlimefunManager;
import me.mrCookieSlime.Slimefun.SlimefunGuide;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.ChatColors;
import me.mrCookieSlime.Slimefun.guides.SlimefunGuideLayout;
import me.mrCookieSlime.Slimefun.hooks.github.Contributor;
import me.mrCookieSlime.Slimefun.hooks.github.IntegerFormat;
import me.mrCookieSlime.Slimefun.utils.ChatUtils;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public final class GuideSettings {
    private static final int[] SLOTS = new int[]{0, 2, 4, 6, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35};

    private GuideSettings() {
    }

    public static void openSettings(Player p, ItemStack guide) {
        ChestMenu menu = new ChestMenu("Settings / Info");
        menu.setEmptySlotsClickable(false);
        menu.addMenuOpeningHandler(pl -> pl.playSound(pl.getLocation(), Sound.BLOCK_NOTE_BLOCK_HARP, 0.7f, 0.7f));
        menu.addItem(1, (ItemStack)new CustomItem(GuideSettings.getItem(SlimefunGuideLayout.CHEST), "&e\u21e6 Back", new String[]{"", "&7Go back to your Slimefun Guide"}));
        menu.addMenuClickHandler(1, (pl, slot, item, action) -> {
            SlimefunGuide.openGuide(pl, guide);
            return false;
        });
        for (int i : SLOTS) {
            menu.addItem(i, (ItemStack)new CustomItem(new ItemStack(Material.GRAY_STAINED_GLASS_PANE), " "));
            menu.addMenuClickHandler(i, (pl, slot, item, action) -> false);
        }
        if (SlimefunManager.isItemSimiliar(guide, GuideSettings.getItem(SlimefunGuideLayout.CHEST), true)) {
            if (p.hasPermission("slimefun.cheat.items")) {
                menu.addItem(19, (ItemStack)new CustomItem(new ItemStack(Material.CHEST), "&7Guide Layout: &eChest GUI", new String[]{"", "&aChest GUI", "&7Book GUI", "&7Cheat Sheet", "", "&e Click &8\u21e8 &7Change Layout"}));
                menu.addMenuClickHandler(19, (pl, slot, item, action) -> {
                    pl.getInventory().setItemInMainHand(GuideSettings.getItem(SlimefunGuideLayout.BOOK));
                    GuideSettings.openSettings(pl, pl.getInventory().getItemInMainHand());
                    return false;
                });
            } else {
                menu.addItem(19, (ItemStack)new CustomItem(new ItemStack(Material.CHEST), "&7Guide Layout: &eChest GUI", new String[]{"", "&aChest GUI", "&7Book GUI", "", "&e Click &8\u21e8 &7Change Layout"}));
                menu.addMenuClickHandler(19, (pl, slot, item, action) -> {
                    pl.getInventory().setItemInMainHand(GuideSettings.getItem(SlimefunGuideLayout.BOOK));
                    GuideSettings.openSettings(pl, pl.getInventory().getItemInMainHand());
                    return false;
                });
            }
        } else if (SlimefunManager.isItemSimiliar(guide, GuideSettings.getItem(SlimefunGuideLayout.BOOK), true)) {
            if (p.hasPermission("slimefun.cheat.items")) {
                menu.addItem(19, (ItemStack)new CustomItem(new ItemStack(Material.BOOK), "&7Guide Layout: &eBook GUI", new String[]{"", "&7Chest GUI", "&aBook GUI", "&7Cheat Sheet", "", "&e Click &8\u21e8 &7Change Layout"}));
                menu.addMenuClickHandler(19, (pl, slot, item, action) -> {
                    pl.getInventory().setItemInMainHand(GuideSettings.getItem(SlimefunGuideLayout.CHEAT_SHEET));
                    GuideSettings.openSettings(pl, pl.getInventory().getItemInMainHand());
                    return false;
                });
            } else {
                menu.addItem(19, (ItemStack)new CustomItem(new ItemStack(Material.BOOK), "&7Guide Layout: &eBook GUI", new String[]{"", "&7Chest GUI", "&aBook GUI", "", "&e Click &8\u21e8 &7Change Layout"}));
                menu.addMenuClickHandler(19, (pl, slot, item, action) -> {
                    pl.getInventory().setItemInMainHand(GuideSettings.getItem(SlimefunGuideLayout.CHEST));
                    GuideSettings.openSettings(pl, pl.getInventory().getItemInMainHand());
                    return false;
                });
            }
        } else if (SlimefunManager.isItemSimiliar(guide, GuideSettings.getItem(SlimefunGuideLayout.CHEAT_SHEET), true)) {
            menu.addItem(19, (ItemStack)new CustomItem(new ItemStack(Material.COMMAND_BLOCK), "&7Guide Layout: &eCheat Sheet", new String[]{"", "&7Chest GUI", "&7Book GUI", "&aCheat Sheet", "", "&e Click &8\u21e8 &7Change Layout"}));
            menu.addMenuClickHandler(19, (pl, slot, item, action) -> {
                pl.getInventory().setItemInMainHand(GuideSettings.getItem(SlimefunGuideLayout.CHEST));
                GuideSettings.openSettings(pl, pl.getInventory().getItemInMainHand());
                return false;
            });
        }
        menu.addItem(3, (ItemStack)new CustomItem(new ItemStack(Material.WRITABLE_BOOK), "&aCredits", new String[]{"", "&7Slimefun Version: &a" + Slimefun.getVersion(), "&7CS-CoreLib Version: &a" + CSCoreLib.getLib().getDescription().getVersion(), "&7Installed Addons: &b" + Slimefun.getInstalledAddons().size(), "&7Contributors: &e" + SlimefunPlugin.getUtilities().contributors.size(), "", "&7\u21e8 Click to see the people behind this Plugin"}));
        menu.addMenuClickHandler(3, (pl, slot, item, action) -> {
            GuideSettings.openCredits(pl, 0);
            return false;
        });
        try {
            menu.addItem(5, (ItemStack)new CustomItem(new ItemStack(Material.COMPARATOR), "&eSource Code", new String[]{"", "&7Bytes of Code: &6" + IntegerFormat.formatBigNumber(SlimefunPlugin.getUtilities().codeBytes), "&7Last Update: &a" + IntegerFormat.timeDelta(SlimefunPlugin.getUtilities().lastUpdate) + " ago", "&7Forks: &e" + SlimefunPlugin.getUtilities().forks, "&7Stars: &e" + SlimefunPlugin.getUtilities().stars, "", "&7&oSlimefun 4 is a community project,", "&7&othe source code is available on GitHub", "&7&oand if you want to keep this Plugin alive,", "&7&othen please consider contributing to it", "", "&7\u21e8 Click to go to GitHub"}));
            menu.addMenuClickHandler(5, (pl, slot, item, action) -> {
                pl.closeInventory();
                ChatUtils.sendURL(pl, "https://github.com/TheBusyBiscuit/Slimefun4");
                return false;
            });
        }
        catch (Exception x) {
            Slimefun.getLogger().log(Level.SEVERE, "An Error occured while creating the Info-Panel for Slimefun " + Slimefun.getVersion(), x);
        }
        menu.addItem(7, (ItemStack)new CustomItem(new ItemStack(Material.KNOWLEDGE_BOOK), "&3Slimefun Wiki", new String[]{"", "&7Do you need help with an Item or machine?", "&7You cannot figure out what to do?", "&7Check out our community-maintained Wiki", "&7and become one of our Editors!", "", "&7\u21e8 Click to go to the official Slimefun Wiki"}));
        menu.addMenuClickHandler(7, (pl, slot, item, action) -> {
            pl.closeInventory();
            ChatUtils.sendURL(pl, "https://github.com/TheBusyBiscuit/Slimefun4/wiki");
            return false;
        });
        menu.addItem(20, (ItemStack)new CustomItem(new ItemStack(Material.REDSTONE), "&4Report a bug", new String[]{"", "&7Open Issues: &a" + SlimefunPlugin.getUtilities().issues, "&7Pending Pull Requests: &a" + SlimefunPlugin.getUtilities().prs, "", "&7\u21e8 Click to go to the Slimefun Bug Tracker"}));
        menu.addMenuClickHandler(20, (pl, slot, item, action) -> {
            pl.closeInventory();
            ChatUtils.sendURL(pl, "https://github.com/TheBusyBiscuit/Slimefun4/issues");
            return false;
        });
        menu.open(new Player[]{p});
    }

    private static void openCredits(Player p, int page) {
        int i;
        ChestMenu menu = new ChestMenu("Credits");
        menu.setEmptySlotsClickable(false);
        menu.addMenuOpeningHandler(pl -> pl.playSound(pl.getLocation(), Sound.BLOCK_NOTE_BLOCK_HARP, 0.7f, 0.7f));
        for (i = 0; i < 9; ++i) {
            if (i != 1) {
                menu.addItem(i, (ItemStack)new CustomItem(new ItemStack(Material.GRAY_STAINED_GLASS_PANE), " "));
                menu.addMenuClickHandler(i, (pl, slot, item, action) -> false);
                continue;
            }
            menu.addItem(1, (ItemStack)new CustomItem(GuideSettings.getItem(SlimefunGuideLayout.CHEST), "&e\u21e6 Back", new String[]{"", "&7Go back to the Settings Panel"}));
            menu.addMenuClickHandler(1, (pl, slot, item, action) -> {
                GuideSettings.openSettings(pl, p.getInventory().getItemInMainHand());
                return false;
            });
        }
        for (i = 45; i < 54; ++i) {
            if (i == 46 || i == 52) continue;
            menu.addItem(i, (ItemStack)new CustomItem(new ItemStack(Material.GRAY_STAINED_GLASS_PANE), " "));
            menu.addMenuClickHandler(i, (pl, slot, item, action) -> false);
        }
        ArrayList contributors = new ArrayList(SlimefunPlugin.getUtilities().contributors.values());
        contributors.sort(Comparator.comparingInt(Contributor::index));
        boolean hasPrevious = page > 0;
        boolean hasNext = false;
        for (int i2 = page * 36; i2 < contributors.size(); ++i2) {
            if (i2 >= (page + 1) * 36) {
                hasNext = true;
                break;
            }
            Contributor contributor = (Contributor)contributors.get(i2);
            ItemStack skull = new ItemStack(Material.PLAYER_HEAD);
            try {
                skull = CustomSkull.getItem((String)contributor.getTexture());
            }
            catch (Exception e) {
                Slimefun.getLogger().log(Level.SEVERE, "An Error occured while inserting a Contributors head.", e);
            }
            SkullMeta meta = (SkullMeta)skull.getItemMeta();
            meta.setDisplayName(ChatColor.GRAY + contributor.getName());
            LinkedList<String> lore = new LinkedList<String>();
            lore.add("");
            for (Map.Entry<String, Integer> entry : contributor.getContributions().entrySet()) {
                lore.add(ChatColors.color(entry.getKey() + " &7(" + entry.getValue() + " Commit" + (entry.getValue() > 1 ? "s" : "") + ")"));
            }
            lore.add("");
            lore.add("&7\u21e8 Click to visit " + contributor.getName() + "'s profile");
            meta.setLore(lore);
            skull.setItemMeta((ItemMeta)meta);
            menu.addItem(i2 + 9, skull);
            menu.addMenuClickHandler(i2 + 9, (pl, slot, item, action) -> {
                pl.closeInventory();
                ChatUtils.sendURL(pl, contributor.getProfile());
                return false;
            });
        }
        if (hasPrevious) {
            menu.addItem(46, (ItemStack)new CustomItem(Material.LIME_STAINED_GLASS_PANE, "&e<- Previous", new String[0]));
            menu.addMenuClickHandler(46, (pl, slot, item, action) -> {
                GuideSettings.openCredits(pl, page - 1);
                return false;
            });
        } else {
            menu.addItem(46, (ItemStack)new CustomItem(Material.BLACK_STAINED_GLASS_PANE, " ", new String[0]));
            menu.addMenuClickHandler(46, (pl, slot, item, action) -> false);
        }
        if (hasNext) {
            menu.addItem(52, (ItemStack)new CustomItem(Material.LIME_STAINED_GLASS_PANE, "&e<- Previous", new String[0]));
            menu.addMenuClickHandler(52, (pl, slot, item, action) -> {
                GuideSettings.openCredits(pl, page + 1);
                return false;
            });
        } else {
            menu.addItem(52, (ItemStack)new CustomItem(Material.BLACK_STAINED_GLASS_PANE, " ", new String[0]));
            menu.addMenuClickHandler(52, (pl, slot, item, action) -> false);
        }
        menu.open(new Player[]{p});
    }

    private static ItemStack getItem(SlimefunGuideLayout layout) {
        return SlimefunGuide.getItem(layout);
    }
}

