/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.api.energy;

import java.math.BigDecimal;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public final class ItemEnergy {
    private ItemEnergy() {
    }

    public static float getStoredEnergy(ItemStack item) {
        if (item == null || item.getType() == Material.AIR || item.getAmount() < 1) {
            return 0.0f;
        }
        if (!item.hasItemMeta() || !item.getItemMeta().hasLore()) {
            return 0.0f;
        }
        for (String line : item.getItemMeta().getLore()) {
            if (!line.startsWith(ChatColor.translateAlternateColorCodes((char)'&', (String)"&c&o&8\u21e8 &e\u26a1 &7")) || !line.contains(" / ") || !line.endsWith(" J")) continue;
            return Float.valueOf(line.split(" / ")[0].replace(ChatColor.translateAlternateColorCodes((char)'&', (String)"&c&o&8\u21e8 &e\u26a1 &7"), "")).floatValue();
        }
        return 0.0f;
    }

    public static float getMaxEnergy(ItemStack item) {
        if (item == null || item.getType() == Material.AIR || item.getAmount() < 1) {
            return 0.0f;
        }
        if (!item.hasItemMeta() || !item.getItemMeta().hasLore()) {
            return 0.0f;
        }
        for (String line : item.getItemMeta().getLore()) {
            if (!line.startsWith(ChatColor.translateAlternateColorCodes((char)'&', (String)"&c&o&8\u21e8 &e\u26a1 &7")) || !line.contains(" / ") || !line.endsWith(" J")) continue;
            return Float.valueOf(line.split(" / ")[1].replace(" J", "")).floatValue();
        }
        return 0.0f;
    }

    public static float addStoredEnergy(ItemStack item, float energy) {
        if (item == null || item.getType() == Material.AIR || item.getAmount() < 1) {
            return 0.0f;
        }
        if (!item.hasItemMeta() || !item.getItemMeta().hasLore()) {
            return 0.0f;
        }
        float rest = 0.0f;
        float capacity = ItemEnergy.getMaxEnergy(item);
        if ((int)capacity == 0) {
            return rest;
        }
        float stored = ItemEnergy.getStoredEnergy(item);
        if (stored + energy > capacity) {
            rest = stored + energy - capacity;
            stored = capacity;
        } else {
            stored = stored + energy < 0.0f ? 0.0f : (stored += energy);
        }
        List lore = item.getItemMeta().getLore();
        int index = -1;
        for (int i = 0; i < lore.size(); ++i) {
            String line = (String)lore.get(i);
            if (!line.startsWith(ChatColor.translateAlternateColorCodes((char)'&', (String)"&c&o&8\u21e8 &e\u26a1 &7")) || !line.contains(" / ") || !line.endsWith(" J")) continue;
            index = i;
            break;
        }
        BigDecimal decimal = BigDecimal.valueOf(stored).setScale(2, 4);
        lore.set(index, ChatColor.translateAlternateColorCodes((char)'&', (String)"&c&o&8\u21e8 &e\u26a1 &7") + decimal.floatValue() + " / " + capacity + " J");
        ItemMeta im = item.getItemMeta();
        im.setLore(lore);
        item.setItemMeta(im);
        return rest;
    }

    public static ItemStack chargeItem(ItemStack item, float energy) {
        ItemEnergy.addStoredEnergy(item, energy);
        return item;
    }

    public static void chargeInventory(Player p, float energy) {
        p.getInventory().setItemInMainHand(ItemEnergy.chargeItem(p.getInventory().getItemInMainHand(), energy));
        p.getInventory().setItemInOffHand(ItemEnergy.chargeItem(p.getInventory().getItemInOffHand(), energy));
        p.getInventory().setHelmet(ItemEnergy.chargeItem(p.getInventory().getHelmet(), energy));
        p.getInventory().setChestplate(ItemEnergy.chargeItem(p.getInventory().getChestplate(), energy));
        p.getInventory().setLeggings(ItemEnergy.chargeItem(p.getInventory().getLeggings(), energy));
        p.getInventory().setBoots(ItemEnergy.chargeItem(p.getInventory().getBoots(), energy));
    }
}

