/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.guides;

import java.util.ArrayList;
import me.mrCookieSlime.CSCoreLibPlugin.PlayerRunnable;
import me.mrCookieSlime.CSCoreLibPlugin.general.Chat.TellRawMessage;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.CustomBookOverlay;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.Item.CustomItem;
import me.mrCookieSlime.CSCoreLibPlugin.general.String.StringUtils;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.LockedCategory;
import me.mrCookieSlime.Slimefun.Objects.Research;
import me.mrCookieSlime.Slimefun.Objects.SeasonalCategory;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.SlimefunGuide;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.GuideHandler;
import me.mrCookieSlime.Slimefun.api.PlayerProfile;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.guides.ISlimefunGuide;
import me.mrCookieSlime.Slimefun.guides.SlimefunGuideLayout;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class BookSlimefunGuide
implements ISlimefunGuide {
    @Override
    public SlimefunGuideLayout getLayout() {
        return SlimefunGuideLayout.BOOK;
    }

    @Override
    public ItemStack getItem() {
        return new CustomItem(new ItemStack(Material.ENCHANTED_BOOK), "&aSlimefun Guide &7(Book GUI)", new String[]{"", "&eRight Click &8\u21e8 &7Browse Items", "&eShift + Right Click &8\u21e8 &7Open Settings / Credits"});
    }

    @Override
    public void openMainMenu(final PlayerProfile profile, final boolean survival, int page) {
        Player p = profile.getPlayer();
        if (p == null) {
            return;
        }
        if (survival) {
            profile.getGuideHistory().clear();
        }
        ArrayList<TellRawMessage> pages = new ArrayList<TellRawMessage>();
        ArrayList<String> texts = new ArrayList<String>();
        ArrayList<String> tooltips = new ArrayList<String>();
        ArrayList<PlayerRunnable> actions = new ArrayList<PlayerRunnable>();
        int tier = 0;
        for (final Category category : Category.list()) {
            boolean locked = true;
            for (SlimefunItem item : category.getItems()) {
                if (!Slimefun.isEnabled(p, item, false)) continue;
                locked = false;
                break;
            }
            if (locked) continue;
            if (tier < category.getTier()) {
                if (survival) {
                    for (final GuideHandler handler : Slimefun.getGuideHandlers(tier)) {
                        handler.addEntry(texts, tooltips);
                        actions.add(new PlayerRunnable(2){

                            public void run(Player p) {
                                handler.run(p, survival, true);
                            }
                        });
                    }
                }
                if ((tier = category.getTier()) > 1) {
                    for (int i = 0; i < 10 && texts.size() % 10 != 0; ++i) {
                        texts.add(" ");
                        tooltips.add(null);
                        actions.add(null);
                    }
                }
                texts.add(ChatColor.translateAlternateColorCodes((char)'&', (String)("&8\u21e8 &6Tier " + tier)));
                tooltips.add(null);
                actions.add(null);
            }
            if (category instanceof LockedCategory && !((LockedCategory)category).hasUnlocked(p, profile)) {
                StringBuilder parents = new StringBuilder(ChatColor.translateAlternateColorCodes((char)'&', (String)"&4&lLOCKED\n\n&7In order to unlock this Category,\n&7you need to unlock all Items from\n&7the following Categories first:\n"));
                for (Category parent : ((LockedCategory)category).getParents()) {
                    parents.append(ChatColor.translateAlternateColorCodes((char)'&', (String)("\n&c" + StringUtils.formatItemName((ItemStack)parent.getItem(), (boolean)false))));
                }
                texts.add(ChatColor.translateAlternateColorCodes((char)'&', (String)this.shorten("&c", StringUtils.formatItemName((ItemStack)category.getItem(), (boolean)false))));
                tooltips.add(parents.toString());
                actions.add(null);
                continue;
            }
            if (category instanceof SeasonalCategory) {
                if (!((SeasonalCategory)category).isUnlocked()) continue;
                texts.add(ChatColor.translateAlternateColorCodes((char)'&', (String)this.shorten("&a", StringUtils.formatItemName((ItemStack)category.getItem(), (boolean)false))));
                tooltips.add(ChatColor.translateAlternateColorCodes((char)'&', (String)("&eClick to open the following Category:\n" + StringUtils.formatItemName((ItemStack)category.getItem(), (boolean)false))));
                actions.add(new PlayerRunnable(1){

                    public void run(Player p) {
                        Slimefun.runSync(() -> BookSlimefunGuide.this.openCategory(profile, category, survival, 1), 1L);
                    }
                });
                continue;
            }
            texts.add(ChatColor.translateAlternateColorCodes((char)'&', (String)this.shorten("&a", StringUtils.formatItemName((ItemStack)category.getItem(), (boolean)false))));
            tooltips.add(ChatColor.translateAlternateColorCodes((char)'&', (String)("&eClick to open the following Category:\n" + StringUtils.formatItemName((ItemStack)category.getItem(), (boolean)false))));
            actions.add(new PlayerRunnable(1){

                public void run(Player p) {
                    Slimefun.runSync(() -> BookSlimefunGuide.this.openCategory(profile, category, survival, 1), 1L);
                }
            });
        }
        if (survival) {
            for (final GuideHandler handler : Slimefun.getGuideHandlers(tier)) {
                handler.addEntry(texts, tooltips);
                actions.add(new PlayerRunnable(2){

                    public void run(Player p) {
                        handler.run(p, survival, true);
                    }
                });
            }
        }
        for (int i = 0; i < texts.size(); i += 10) {
            TellRawMessage pageMessage = new TellRawMessage();
            pageMessage.addText(ChatColor.translateAlternateColorCodes((char)'&', (String)"&b&l- Slimefun Guide -\n\n"));
            for (int j = i; j < texts.size() && j < i + 10; ++j) {
                pageMessage.addText((String)texts.get(j) + "\n");
                if (tooltips.get(j) != null) {
                    pageMessage.addHoverEvent(TellRawMessage.HoverAction.SHOW_TEXT, (String)tooltips.get(j));
                }
                if (actions.get(j) == null) continue;
                pageMessage.addClickEvent((PlayerRunnable)actions.get(j));
            }
            pages.add(pageMessage);
        }
        new CustomBookOverlay("Slimefun Guide", "TheBusyBiscuit", pages.toArray(new TellRawMessage[0])).open(p);
    }

    @Override
    public void openCategory(final PlayerProfile profile, final Category category, final boolean survival, final int page) {
        Player p = profile.getPlayer();
        if (p == null) {
            return;
        }
        if (category.getItems().size() < 250) {
            if (survival) {
                profile.getGuideHistory().add(category);
            }
            ArrayList<TellRawMessage> pages = new ArrayList<TellRawMessage>();
            ArrayList<String> texts = new ArrayList<String>();
            ArrayList<String> tooltips = new ArrayList<String>();
            ArrayList<PlayerRunnable> actions = new ArrayList<PlayerRunnable>();
            for (final SlimefunItem item : category.getItems()) {
                if (Slimefun.hasPermission(p, item, false)) {
                    if (!Slimefun.isEnabled(p, item, false)) continue;
                    if (survival && !Slimefun.hasUnlocked(p, item, false) && item.getResearch() != null) {
                        final Research research = item.getResearch();
                        texts.add(ChatColor.translateAlternateColorCodes((char)'&', (String)this.shorten("&7", StringUtils.formatItemName((ItemStack)item.getItem(), (boolean)false))));
                        tooltips.add(ChatColor.translateAlternateColorCodes((char)'&', (String)(StringUtils.formatItemName((ItemStack)item.getItem(), (boolean)false) + "\n&c&lLOCKED\n\n&7Cost: " + (p.getLevel() >= research.getCost() ? "&b" : "&4") + research.getCost() + " Levels\n\n&a> Click to unlock")));
                        actions.add(new PlayerRunnable(2){

                            public void run(Player p) {
                                if (!Research.isResearching(p)) {
                                    if (research.canUnlock(p)) {
                                        if (profile.hasUnlocked(research)) {
                                            BookSlimefunGuide.this.openCategory(profile, category, true, page);
                                        } else {
                                            if (p.getGameMode() != GameMode.CREATIVE || !SlimefunPlugin.getSettings().researchesFreeInCreative) {
                                                p.setLevel(p.getLevel() - research.getCost());
                                            }
                                            if (p.getGameMode() == GameMode.CREATIVE) {
                                                research.unlock(p, true);
                                                Slimefun.runSync(() -> BookSlimefunGuide.this.openCategory(profile, category, survival, page), 1L);
                                            } else {
                                                research.unlock(p, false);
                                                Slimefun.runSync(() -> BookSlimefunGuide.this.openCategory(profile, category, survival, page), 103L);
                                            }
                                        }
                                    } else {
                                        SlimefunPlugin.getLocal().sendMessage((CommandSender)p, "messages.not-enough-xp", true);
                                    }
                                }
                            }
                        });
                        continue;
                    }
                    texts.add(ChatColor.translateAlternateColorCodes((char)'&', (String)this.shorten("&a", StringUtils.formatItemName((ItemStack)item.getItem(), (boolean)false))));
                    StringBuilder tooltip = new StringBuilder();
                    tooltip.append(StringUtils.formatItemName((ItemStack)item.getItem(), (boolean)false));
                    if (item.getItem().hasItemMeta() && item.getItem().getItemMeta().hasLore()) {
                        for (String line : item.getItem().getItemMeta().getLore()) {
                            tooltip.append("\n" + line);
                        }
                    }
                    tooltip.append(ChatColor.translateAlternateColorCodes((char)'&', (String)"\n\n&e&oClick for more Info"));
                    tooltips.add(tooltip.toString());
                    actions.add(new PlayerRunnable(2){

                        public void run(Player p) {
                            BookSlimefunGuide.this.displayItem(profile, item, true);
                        }
                    });
                    continue;
                }
                texts.add(ChatColor.translateAlternateColorCodes((char)'&', (String)this.shorten("&4", StringUtils.formatItemName((ItemStack)item.getItem(), (boolean)false))));
                tooltips.add(ChatColor.translateAlternateColorCodes((char)'&', (String)"&cNo Permission!"));
                actions.add(null);
            }
            for (int i = 0; i < texts.size(); i += 10) {
                TellRawMessage pageMessage = new TellRawMessage();
                pageMessage.addText(ChatColor.translateAlternateColorCodes((char)'&', (String)"&b&l- Slimefun Guide -\n\n"));
                for (int j = i; j < texts.size() && j < i + 10; ++j) {
                    pageMessage.addText((String)texts.get(j) + "\n");
                    if (tooltips.get(j) != null) {
                        pageMessage.addHoverEvent(TellRawMessage.HoverAction.SHOW_TEXT, (String)tooltips.get(j));
                    }
                    if (actions.get(j) == null) continue;
                    pageMessage.addClickEvent((PlayerRunnable)actions.get(j));
                }
                pageMessage.addText("\n");
                pageMessage.addText(ChatColor.translateAlternateColorCodes((char)'&', (String)"&6\u21e6 &lBack"));
                pageMessage.addHoverEvent(TellRawMessage.HoverAction.SHOW_TEXT, ChatColor.translateAlternateColorCodes((char)'&', (String)"&eClick to go back to the Category Overview"));
                pageMessage.addClickEvent(new PlayerRunnable(2){

                    public void run(Player p) {
                        BookSlimefunGuide.this.openMainMenu(profile, survival, 1);
                    }
                });
                pages.add(pageMessage);
            }
            new CustomBookOverlay("Slimefun Guide", "TheBusyBiscuit", pages.toArray(new TellRawMessage[0])).open(p);
        } else {
            p.sendMessage(ChatColor.RED + "That Category is too big to open :/");
        }
    }

    @Override
    public void openSearch(PlayerProfile profile, String input, boolean survival, boolean addToHistory) {
        SlimefunGuide.openSearch(profile, input, survival, addToHistory);
    }

    @Override
    public void displayItem(PlayerProfile profile, ItemStack item, boolean addToHistory) {
        SlimefunGuide.displayItem(profile, item, addToHistory);
    }

    @Override
    public void displayItem(PlayerProfile profile, SlimefunItem item, boolean addToHistory) {
        SlimefunGuide.displayItem(profile, item, addToHistory);
    }
}

