/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.cscorelib2.collections;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.stream.Stream;

public class CappedLinkedList<T>
implements Iterable<T> {
    private int size;
    private final LinkedList<T> list;

    public CappedLinkedList(int size) {
        this.size = size;
        this.list = new LinkedList();
    }

    public void clear() {
        this.list.clear();
    }

    public void add(T obj) {
        this.list.add(obj);
        if (this.list.size() > this.size) {
            this.list.removeFirst();
        }
    }

    public void setSize(int size) {
        if (size < 1) {
            throw new IllegalArgumentException("A CappedLinkedList must have a size of at least 1");
        }
        this.size = size;
        while (this.size() > size) {
            this.list.removeFirst();
        }
    }

    public int size() {
        return this.list.size();
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.list.iterator();
    }

    public Stream<T> stream() {
        return this.list.stream();
    }

    public int getSize() {
        return this.size;
    }
}

