/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.stream.Collectors;
import me.mrCookieSlime.CSCoreLibPlugin.PlayerRunnable;
import me.mrCookieSlime.CSCoreLibPlugin.general.Chat.TellRawMessage;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.CustomBookOverlay;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.Item.CustomItem;
import me.mrCookieSlime.CSCoreLibPlugin.general.String.StringUtils;
import me.mrCookieSlime.CSCoreLibPlugin.general.World.CustomSkull;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.LockedCategory;
import me.mrCookieSlime.Slimefun.Objects.Research;
import me.mrCookieSlime.Slimefun.Objects.SeasonalCategory;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.interfaces.RecipeDisplayItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.multiblocks.MultiBlockMachine;
import me.mrCookieSlime.Slimefun.Setup.SlimefunManager;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.GuideHandler;
import me.mrCookieSlime.Slimefun.api.PlayerProfile;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.api.SlimefunGuideLayout;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.ChatInput;
import me.mrCookieSlime.Slimefun.cscorelib2.inventory.ItemUtils;
import me.mrCookieSlime.Slimefun.cscorelib2.math.DoubleHandler;
import me.mrCookieSlime.Slimefun.hooks.github.Contributor;
import me.mrCookieSlime.Slimefun.hooks.github.IntegerFormat;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;

public final class SlimefunGuide {
    private static final int CATEGORY_SIZE = 36;
    private static final int[] SLOTS = new int[]{0, 2, 3, 5, 6, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35};

    private SlimefunGuide() {
    }

    @Deprecated
    public static ItemStack getItem() {
        return SlimefunGuide.getItem(SlimefunGuideLayout.CHEST);
    }

    public static ItemStack getItem(SlimefunGuideLayout design) {
        switch (design) {
            case BOOK: {
                return new CustomItem(new ItemStack(Material.ENCHANTED_BOOK), "&aSlimefun Guide &7(Book GUI)", new String[]{"", "&eRight Click &8\u21e8 &7Browse Items", "&eShift + Right Click &8\u21e8 &7Open Settings / Credits"});
            }
            case CHEAT_SHEET: {
                return new CustomItem(new ItemStack(Material.ENCHANTED_BOOK), "&cSlimefun Guide &4(Cheat Sheet)", new String[]{"", "&4&lOnly openable by Admins", "", "&eRight Click &8\u21e8 &7Browse Items", "&eShift + Right Click &8\u21e8 &7Open Settings / Credits"});
            }
            case CHEST: {
                return new CustomItem(new ItemStack(Material.ENCHANTED_BOOK), "&aSlimefun Guide &7(Chest GUI)", new String[]{"", "&eRight Click &8\u21e8 &7Browse Items", "&eShift + Right Click &8\u21e8 &7Open Settings / Credits"});
            }
        }
        return null;
    }

    @Deprecated
    public static ItemStack getItem(boolean book) {
        return SlimefunGuide.getItem(book ? SlimefunGuideLayout.BOOK : SlimefunGuideLayout.CHEST);
    }

    @Deprecated
    public static ItemStack getDeprecatedItem(boolean book) {
        return new CustomItem(new ItemStack(Material.ENCHANTED_BOOK), "&eSlimefun Guide &7(Right Click)", new String[]{book ? "" : "&2", "&rThis is your basic Guide for Slimefun", "&rYou can see all Items added by this Plugin", "&ror its Addons including their Recipes", "&ra bit of information and more"});
    }

    public static void openSettings(Player p, ItemStack guide) {
        ChestMenu menu = new ChestMenu("Settings / Info");
        menu.setEmptySlotsClickable(false);
        menu.addMenuOpeningHandler(pl -> pl.playSound(pl.getLocation(), Sound.BLOCK_NOTE_BLOCK_HARP, 0.7f, 0.7f));
        for (int i : SLOTS) {
            menu.addItem(i, (ItemStack)new CustomItem(new ItemStack(Material.GRAY_STAINED_GLASS_PANE), " "));
            menu.addMenuClickHandler(i, (pl, slot, item, action) -> false);
        }
        if (SlimefunManager.isItemSimiliar(guide, SlimefunGuide.getItem(SlimefunGuideLayout.CHEST), true)) {
            if (p.hasPermission("slimefun.cheat.items")) {
                menu.addItem(19, (ItemStack)new CustomItem(new ItemStack(Material.CHEST), "&7Guide Layout: &eChest GUI", new String[]{"", "&aChest GUI", "&7Book GUI", "&7Cheat Sheet", "", "&e Click &8\u21e8 &7Change Layout"}));
                menu.addMenuClickHandler(19, (pl, slot, item, action) -> {
                    pl.getInventory().setItemInMainHand(SlimefunGuide.getItem(SlimefunGuideLayout.BOOK));
                    SlimefunGuide.openSettings(pl, pl.getInventory().getItemInMainHand());
                    return false;
                });
            } else {
                menu.addItem(19, (ItemStack)new CustomItem(new ItemStack(Material.CHEST), "&7Guide Layout: &eChest GUI", new String[]{"", "&aChest GUI", "&7Book GUI", "", "&e Click &8\u21e8 &7Change Layout"}));
                menu.addMenuClickHandler(19, (pl, slot, item, action) -> {
                    pl.getInventory().setItemInMainHand(SlimefunGuide.getItem(SlimefunGuideLayout.BOOK));
                    SlimefunGuide.openSettings(pl, pl.getInventory().getItemInMainHand());
                    return false;
                });
            }
        } else if (SlimefunManager.isItemSimiliar(guide, SlimefunGuide.getItem(SlimefunGuideLayout.BOOK), true)) {
            if (p.hasPermission("slimefun.cheat.items")) {
                menu.addItem(19, (ItemStack)new CustomItem(new ItemStack(Material.CHEST), "&7Guide Layout: &eBook GUI", new String[]{"", "&7Chest GUI", "&aBook GUI", "&7Cheat Sheet", "", "&e Click &8\u21e8 &7Change Layout"}));
                menu.addMenuClickHandler(19, (pl, slot, item, action) -> {
                    pl.getInventory().setItemInMainHand(SlimefunGuide.getItem(SlimefunGuideLayout.CHEAT_SHEET));
                    SlimefunGuide.openSettings(pl, pl.getInventory().getItemInMainHand());
                    return false;
                });
            } else {
                menu.addItem(19, (ItemStack)new CustomItem(new ItemStack(Material.CHEST), "&7Guide Layout: &eBook GUI", new String[]{"", "&7Chest GUI", "&aBook GUI", "", "&e Click &8\u21e8 &7Change Layout"}));
                menu.addMenuClickHandler(19, (pl, slot, item, action) -> {
                    pl.getInventory().setItemInMainHand(SlimefunGuide.getItem(SlimefunGuideLayout.CHEST));
                    SlimefunGuide.openSettings(pl, pl.getInventory().getItemInMainHand());
                    return false;
                });
            }
        } else if (SlimefunManager.isItemSimiliar(guide, SlimefunGuide.getItem(SlimefunGuideLayout.CHEAT_SHEET), true)) {
            menu.addItem(19, (ItemStack)new CustomItem(new ItemStack(Material.CHEST), "&7Guide Layout: &eCheat Sheet", new String[]{"", "&7Chest GUI", "&7Book GUI", "&aCheat Sheet", "", "&e Click &8\u21e8 &7Change Layout"}));
            menu.addMenuClickHandler(19, (pl, slot, item, action) -> {
                pl.getInventory().setItemInMainHand(SlimefunGuide.getItem(SlimefunGuideLayout.CHEST));
                SlimefunGuide.openSettings(pl, pl.getInventory().getItemInMainHand());
                return false;
            });
        }
        menu.addItem(1, (ItemStack)new CustomItem(new ItemStack(Material.WRITABLE_BOOK), "&aCredits", new String[]{"", "&7Version: &a" + SlimefunPlugin.instance.getDescription().getVersion(), "&7Contributors: &e" + SlimefunPlugin.getUtilities().contributors.size(), "", "&7\u21e8 Click to see the people behind this Plugin"}));
        menu.addMenuClickHandler(1, (pl, slot, item, action) -> {
            SlimefunGuide.openCredits(pl, guide);
            return false;
        });
        try {
            menu.addItem(4, (ItemStack)new CustomItem(new ItemStack(Material.COMPARATOR), "&eSource Code", new String[]{"", "&7Bytes of Code: &6" + IntegerFormat.formatBigNumber(SlimefunPlugin.getUtilities().codeBytes), "&7Last Update: &a" + IntegerFormat.timeDelta(SlimefunPlugin.getUtilities().lastUpdate) + " ago", "&7Forks: &e" + SlimefunPlugin.getUtilities().forks, "&7Stars: &e" + SlimefunPlugin.getUtilities().stars, "", "&7&oSlimefun 4 is a community project,", "&7&othe source code is available on GitHub", "&7&oand if you want to keep this Plugin alive,", "&7&othen please consider contributing to it", "", "&7\u21e8 Click to go to GitHub"}));
            menu.addMenuClickHandler(4, (pl, slot, item, action) -> {
                pl.closeInventory();
                pl.sendMessage("");
                pl.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7&ohttps://github.com/TheBusyBiscuit/Slimefun4"));
                pl.sendMessage("");
                return false;
            });
        }
        catch (Exception x) {
            Slimefun.getLogger().log(Level.SEVERE, "An Error occured while creating the Info-Panel for Slimefun " + Slimefun.getVersion(), x);
        }
        menu.addItem(7, (ItemStack)new CustomItem(new ItemStack(Material.REDSTONE), "&4Bug Tracker", new String[]{"", "&7Unsolved Issues: &a" + SlimefunPlugin.getUtilities().issues, "", "&7\u21e8 Click to go to the Slimefun Bug Tracker"}));
        menu.addMenuClickHandler(7, (pl, slot, item, action) -> {
            pl.closeInventory();
            pl.sendMessage("");
            pl.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7&ohttps://github.com/TheBusyBiscuit/Slimefun4/issues"));
            pl.sendMessage("");
            return false;
        });
        menu.open(new Player[]{p});
    }

    private static void openCredits(Player p, ItemStack guide) {
        ChestMenu menu = new ChestMenu("Credits");
        menu.setEmptySlotsClickable(false);
        menu.addMenuOpeningHandler(pl -> pl.playSound(pl.getLocation(), Sound.BLOCK_NOTE_BLOCK_HARP, 0.7f, 0.7f));
        for (int i = 0; i < 9; ++i) {
            if (i != 4) {
                menu.addItem(i, (ItemStack)new CustomItem(new ItemStack(Material.GRAY_STAINED_GLASS_PANE), " "));
                menu.addMenuClickHandler(i, (pl, slot, item, action) -> false);
                continue;
            }
            menu.addItem(4, (ItemStack)new CustomItem(new ItemStack(Material.EMERALD), "&7\u21e6 Back to Settings"));
            menu.addMenuClickHandler(4, (pl, slot, item, action) -> {
                SlimefunGuide.openSettings(pl, guide);
                return false;
            });
        }
        int index = 9;
        double total = 1.0 * (double)SlimefunPlugin.getUtilities().contributors.stream().mapToInt(Contributor::getCommits).sum();
        for (Contributor contributor : SlimefunPlugin.getUtilities().contributors) {
            ItemStack skull = new ItemStack(Material.PLAYER_HEAD);
            try {
                String texture = contributor.getTexture();
                if (texture != null) {
                    skull = CustomSkull.getItem((String)texture);
                }
            }
            catch (Exception x) {
                Slimefun.getLogger().log(Level.SEVERE, "An Error occured while fetching a Contributor Head for Slimefun " + Slimefun.getVersion(), x);
            }
            SkullMeta meta = (SkullMeta)skull.getItemMeta();
            meta.setDisplayName(ChatColor.GOLD + contributor.getName());
            if (contributor.getCommits() > 0) {
                double percentage = DoubleHandler.fixDouble((double)contributor.getCommits() * 100.0 / total, 2);
                meta.setLore(Arrays.asList("", ChatColor.translateAlternateColorCodes((char)'&', (String)("&7Role: &r" + contributor.getJob())), ChatColor.translateAlternateColorCodes((char)'&', (String)("&7Contributions: &r" + contributor.getCommits() + " commits &7(&r" + percentage + "%&7)")), "", ChatColor.translateAlternateColorCodes((char)'&', (String)"&7\u21e8 Click to view my GitHub profile")));
            } else {
                meta.setLore(Arrays.asList("", ChatColor.translateAlternateColorCodes((char)'&', (String)("&7Role: &r" + contributor.getJob()))));
            }
            skull.setItemMeta((ItemMeta)meta);
            menu.addItem(index, skull);
            menu.addMenuClickHandler(index, (pl, slot, item, action) -> {
                if (contributor.getCommits() > 0) {
                    pl.closeInventory();
                    pl.sendMessage("");
                    pl.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&7&o" + contributor.getProfile())));
                    pl.sendMessage("");
                }
                return false;
            });
            ++index;
        }
        menu.open(new Player[]{p});
    }

    public static void openCheatMenu(Player p) {
        SlimefunGuide.openMainMenuAsync(p, false, false, 1);
    }

    public static void openGuide(Player p, boolean book) {
        if (!SlimefunPlugin.getWhitelist().getBoolean(p.getWorld().getName() + ".enabled")) {
            return;
        }
        if (!SlimefunPlugin.getWhitelist().getBoolean(p.getWorld().getName() + ".enabled-items.SLIMEFUN_GUIDE")) {
            return;
        }
        Object last = null;
        Optional<PlayerProfile> profile = PlayerProfile.find((OfflinePlayer)p);
        if (profile.isPresent()) {
            last = SlimefunGuide.getLastEntry(profile.get(), false);
        }
        if (last == null) {
            SlimefunGuide.openMainMenuAsync(p, true, book, 1);
        } else {
            SlimefunGuide.handleHistory(p, last, book, false);
        }
    }

    private static void openMainMenuAsync(Player player, boolean survival, boolean book, int selected_page) {
        if (!PlayerProfile.get((OfflinePlayer)player, profile -> Slimefun.runSync(() -> SlimefunGuide.openMainMenu(profile, survival, book, selected_page)))) {
            Slimefun.getLocal().sendMessage((CommandSender)player, "messages.opening-guide");
        }
    }

    private static void openMainMenu(PlayerProfile profile, final boolean survival, final boolean book, int selected_page) {
        Player p = profile.getPlayer();
        if (p == null) {
            return;
        }
        if (survival) {
            profile.getGuideHistory().clear();
        }
        if (book) {
            ArrayList<TellRawMessage> pages = new ArrayList<TellRawMessage>();
            ArrayList<String> texts = new ArrayList<String>();
            ArrayList<String> tooltips = new ArrayList<String>();
            ArrayList<PlayerRunnable> actions = new ArrayList<PlayerRunnable>();
            int tier = 0;
            for (final Category category : Category.list()) {
                boolean locked = true;
                for (SlimefunItem slimefunItem : category.getItems()) {
                    if (!Slimefun.isEnabled(p, slimefunItem, false)) continue;
                    locked = false;
                    break;
                }
                if (locked) continue;
                if (tier < category.getTier()) {
                    if (survival) {
                        for (final GuideHandler guideHandler : Slimefun.getGuideHandlers(tier)) {
                            guideHandler.addEntry(texts, tooltips);
                            actions.add(new PlayerRunnable(2){

                                public void run(Player p) {
                                    guideHandler.run(p, survival, book);
                                }
                            });
                        }
                    }
                    if ((tier = category.getTier()) > 1) {
                        for (int i = 0; i < 10 && texts.size() % 10 != 0; ++i) {
                            texts.add(" ");
                            tooltips.add(null);
                            actions.add(null);
                        }
                    }
                    texts.add(ChatColor.translateAlternateColorCodes((char)'&', (String)("&8\u21e8 &6Tier " + tier)));
                    tooltips.add(null);
                    actions.add(null);
                }
                if (category instanceof LockedCategory && !((LockedCategory)category).hasUnlocked(p, profile)) {
                    StringBuilder parents = new StringBuilder(ChatColor.translateAlternateColorCodes((char)'&', (String)"&4&lLOCKED\n\n&7In order to unlock this Category,\n&7you need to unlock all Items from\n&7the following Categories first:\n"));
                    for (Category parent : ((LockedCategory)category).getParents()) {
                        parents.append(ChatColor.translateAlternateColorCodes((char)'&', (String)("\n&c" + StringUtils.formatItemName((ItemStack)parent.getItem(), (boolean)false))));
                    }
                    texts.add(ChatColor.translateAlternateColorCodes((char)'&', (String)SlimefunGuide.shorten("&c", StringUtils.formatItemName((ItemStack)category.getItem(), (boolean)false))));
                    tooltips.add(parents.toString());
                    actions.add(null);
                    continue;
                }
                if (category instanceof SeasonalCategory) {
                    if (!((SeasonalCategory)category).isUnlocked()) continue;
                    texts.add(ChatColor.translateAlternateColorCodes((char)'&', (String)SlimefunGuide.shorten("&a", StringUtils.formatItemName((ItemStack)category.getItem(), (boolean)false))));
                    tooltips.add(ChatColor.translateAlternateColorCodes((char)'&', (String)("&eClick to open the following Category:\n" + StringUtils.formatItemName((ItemStack)category.getItem(), (boolean)false))));
                    actions.add(new PlayerRunnable(1){

                        public void run(Player p) {
                            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)SlimefunPlugin.instance, () -> SlimefunGuide.openCategory(p, category, survival, 1, book), 1L);
                        }
                    });
                    continue;
                }
                texts.add(ChatColor.translateAlternateColorCodes((char)'&', (String)SlimefunGuide.shorten("&a", StringUtils.formatItemName((ItemStack)category.getItem(), (boolean)false))));
                tooltips.add(ChatColor.translateAlternateColorCodes((char)'&', (String)("&eClick to open the following Category:\n" + StringUtils.formatItemName((ItemStack)category.getItem(), (boolean)false))));
                actions.add(new PlayerRunnable(1){

                    public void run(Player p) {
                        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)SlimefunPlugin.instance, () -> SlimefunGuide.openCategory(p, category, survival, 1, book), 1L);
                    }
                });
            }
            if (survival) {
                for (final GuideHandler handler : Slimefun.getGuideHandlers(tier)) {
                    handler.addEntry(texts, tooltips);
                    actions.add(new PlayerRunnable(2){

                        public void run(Player p) {
                            handler.run(p, survival, book);
                        }
                    });
                }
            }
            for (int i = 0; i < texts.size(); i += 10) {
                TellRawMessage page = new TellRawMessage();
                page.addText(ChatColor.translateAlternateColorCodes((char)'&', (String)"&b&l- Slimefun Guide -\n\n"));
                for (int j = i; j < texts.size() && j < i + 10; ++j) {
                    page.addText((String)texts.get(j) + "\n");
                    if (tooltips.get(j) != null) {
                        page.addHoverEvent(TellRawMessage.HoverAction.SHOW_TEXT, (String)tooltips.get(j));
                    }
                    if (actions.get(j) == null) continue;
                    page.addClickEvent((PlayerRunnable)actions.get(j));
                }
                pages.add(page);
            }
            new CustomBookOverlay("Slimefun Guide", "TheBusyBiscuit", pages.toArray(new TellRawMessage[pages.size()])).open(p);
        } else {
            ChestMenu menu = new ChestMenu("Slimefun Guide");
            menu.setEmptySlotsClickable(false);
            menu.addMenuOpeningHandler(pl -> pl.playSound(pl.getLocation(), Sound.ITEM_BOOK_PAGE_TURN, 1.0f, 1.0f));
            List<Category> categories = SlimefunPlugin.getUtilities().enabledCategories;
            List handlers = SlimefunPlugin.getUtilities().guideHandlers.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            int index = 9;
            int pages = 1;
            SlimefunGuide.fillInv(menu, !survival);
            int target = 36 * (selected_page - 1) - 1;
            while (target < categories.size() + handlers.size() - 1) {
                if (index >= 45) {
                    ++pages;
                    break;
                }
                if (++target >= categories.size()) {
                    if (!survival) break;
                    index = ((GuideHandler)handlers.get(target - categories.size())).next(p, index, menu);
                    continue;
                }
                Category category = categories.get(target);
                boolean locked = true;
                for (SlimefunItem slimefunItem : category.getItems()) {
                    if (!Slimefun.isEnabled(p, slimefunItem, false)) continue;
                    locked = false;
                    break;
                }
                if (locked) continue;
                if (!(category instanceof LockedCategory)) {
                    if (!(category instanceof SeasonalCategory)) {
                        menu.addItem(index, category.getItem());
                        menu.addMenuClickHandler(index, (pl, slot, item, action) -> {
                            SlimefunGuide.openCategory(pl, category, survival, 1, book);
                            return false;
                        });
                        ++index;
                        continue;
                    }
                    if (!((SeasonalCategory)category).isUnlocked()) continue;
                    menu.addItem(index, category.getItem());
                    menu.addMenuClickHandler(index, (pl, slot, item, action) -> {
                        SlimefunGuide.openCategory(pl, category, survival, 1, book);
                        return false;
                    });
                    ++index;
                    continue;
                }
                if (!survival || ((LockedCategory)category).hasUnlocked(p, profile)) {
                    menu.addItem(index, category.getItem());
                    menu.addMenuClickHandler(index, (pl, slot, item, action) -> {
                        SlimefunGuide.openCategory(pl, category, survival, 1, book);
                        return false;
                    });
                    ++index;
                    continue;
                }
                ArrayList parents = new ArrayList();
                parents.add("");
                parents.add(ChatColor.translateAlternateColorCodes((char)'&', (String)"&rYou need to unlock all Items"));
                parents.add(ChatColor.translateAlternateColorCodes((char)'&', (String)"&rfrom the following Categories first:"));
                parents.add("");
                for (Category parent : ((LockedCategory)category).getParents()) {
                    parents.add(parent.getItem().getItemMeta().getDisplayName());
                }
                menu.addItem(index, (ItemStack)new CustomItem(Material.BARRIER, "&4LOCKED &7- &r" + category.getItem().getItemMeta().getDisplayName(), parents.toArray(new String[0])));
                menu.addMenuClickHandler(index, (pl, slot, item, action) -> false);
                ++index;
            }
            int finalPages = pages;
            menu.addItem(46, (ItemStack)new CustomItem(new ItemStack(Material.LIME_STAINED_GLASS_PANE), "&r\u21e6 Previous Page", new String[]{"", "&7(" + selected_page + " / " + pages + ")"}));
            menu.addMenuClickHandler(46, (pl, slot, item, action) -> {
                int next = selected_page - 1;
                if (next < 1) {
                    next = finalPages;
                }
                if (next != selected_page) {
                    SlimefunGuide.openMainMenuAsync(pl, survival, book, next);
                }
                return false;
            });
            menu.addItem(52, (ItemStack)new CustomItem(new ItemStack(Material.LIME_STAINED_GLASS_PANE), "&rNext Page \u21e8", new String[]{"", "&7(" + selected_page + " / " + pages + ")"}));
            menu.addMenuClickHandler(52, (pl, slot, item, action) -> {
                int next = selected_page + 1;
                if (next > finalPages) {
                    next = 1;
                }
                if (next != selected_page) {
                    SlimefunGuide.openMainMenuAsync(pl, survival, book, next);
                }
                return false;
            });
            menu.open(new Player[]{p});
        }
    }

    private static String shorten(String string, String string2) {
        if (ChatColor.stripColor((String)(string + string2)).length() > 19) {
            return (string + ChatColor.stripColor((String)string2)).substring(0, 18) + "...";
        }
        return string + ChatColor.stripColor((String)string2);
    }

    private static void openCategory(Player p, final Category category, final boolean survival, final int selected_page, final boolean book) {
        if (category == null) {
            return;
        }
        if (book && category.getItems().size() < 250) {
            ArrayList<TellRawMessage> pages = new ArrayList<TellRawMessage>();
            ArrayList<String> texts = new ArrayList<String>();
            ArrayList<String> tooltips = new ArrayList<String>();
            ArrayList<PlayerRunnable> actions = new ArrayList<PlayerRunnable>();
            for (final SlimefunItem item2 : category.getItems()) {
                if (Slimefun.hasPermission(p, item2, false)) {
                    if (!Slimefun.isEnabled(p, item2, false)) continue;
                    if (survival && !Slimefun.hasUnlocked(p, item2, false) && item2.getResearch() != null) {
                        final Research research = item2.getResearch();
                        texts.add(ChatColor.translateAlternateColorCodes((char)'&', (String)SlimefunGuide.shorten("&7", StringUtils.formatItemName((ItemStack)item2.getItem(), (boolean)false))));
                        tooltips.add(ChatColor.translateAlternateColorCodes((char)'&', (String)(StringUtils.formatItemName((ItemStack)item2.getItem(), (boolean)false) + "\n&c&lLOCKED\n\n&7Cost: " + (p.getLevel() >= research.getCost() ? "&b" : "&4") + research.getCost() + " Levels\n\n&a> Click to unlock")));
                        actions.add(new PlayerRunnable(2){

                            public void run(Player p) {
                                if (!Research.isResearching(p)) {
                                    if (research.canUnlock(p)) {
                                        PlayerProfile profile = PlayerProfile.get((OfflinePlayer)p);
                                        if (profile.hasUnlocked(research)) {
                                            SlimefunGuide.openCategory(p, category, true, selected_page, book);
                                        } else {
                                            if (p.getGameMode() != GameMode.CREATIVE || !SlimefunPlugin.getSettings().researchesFreeInCreative) {
                                                p.setLevel(p.getLevel() - research.getCost());
                                            }
                                            if (p.getGameMode() == GameMode.CREATIVE) {
                                                research.unlock(p, true);
                                                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)SlimefunPlugin.instance, () -> SlimefunGuide.openCategory(p, category, survival, selected_page, book), 1L);
                                            } else {
                                                research.unlock(p, false);
                                                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)SlimefunPlugin.instance, () -> SlimefunGuide.openCategory(p, category, survival, selected_page, book), 103L);
                                            }
                                        }
                                    } else {
                                        SlimefunPlugin.getLocal().sendMessage((CommandSender)p, "messages.not-enough-xp", true);
                                    }
                                }
                            }
                        });
                        continue;
                    }
                    texts.add(ChatColor.translateAlternateColorCodes((char)'&', (String)SlimefunGuide.shorten("&a", StringUtils.formatItemName((ItemStack)item2.getItem(), (boolean)false))));
                    StringBuilder tooltip = new StringBuilder();
                    tooltip.append(StringUtils.formatItemName((ItemStack)item2.getItem(), (boolean)false));
                    if (item2.getItem().hasItemMeta() && item2.getItem().getItemMeta().hasLore()) {
                        for (String line : item2.getItem().getItemMeta().getLore()) {
                            tooltip.append("\n" + line);
                        }
                    }
                    tooltip.append(ChatColor.translateAlternateColorCodes((char)'&', (String)"\n\n&e&oClick for more Info"));
                    tooltips.add(tooltip.toString());
                    actions.add(new PlayerRunnable(2){

                        public void run(Player p) {
                            SlimefunGuide.displayItem(p, item2.getItem(), true, book, 0);
                        }
                    });
                    continue;
                }
                texts.add(ChatColor.translateAlternateColorCodes((char)'&', (String)SlimefunGuide.shorten("&4", StringUtils.formatItemName((ItemStack)item2.getItem(), (boolean)false))));
                tooltips.add(ChatColor.translateAlternateColorCodes((char)'&', (String)"&cNo Permission!"));
                actions.add(null);
            }
            for (int i = 0; i < texts.size(); i += 10) {
                TellRawMessage page = new TellRawMessage();
                page.addText(ChatColor.translateAlternateColorCodes((char)'&', (String)"&b&l- Slimefun Guide -\n\n"));
                for (int j = i; j < texts.size() && j < i + 10; ++j) {
                    page.addText((String)texts.get(j) + "\n");
                    if (tooltips.get(j) != null) {
                        page.addHoverEvent(TellRawMessage.HoverAction.SHOW_TEXT, (String)tooltips.get(j));
                    }
                    if (actions.get(j) == null) continue;
                    page.addClickEvent((PlayerRunnable)actions.get(j));
                }
                page.addText("\n");
                page.addText(ChatColor.translateAlternateColorCodes((char)'&', (String)"&6\u21e6 &lBack"));
                page.addHoverEvent(TellRawMessage.HoverAction.SHOW_TEXT, ChatColor.translateAlternateColorCodes((char)'&', (String)"&eClick to go back to the Category Overview"));
                page.addClickEvent(new PlayerRunnable(2){

                    public void run(Player p) {
                        SlimefunGuide.openMainMenuAsync(p, survival, true, 1);
                    }
                });
                pages.add(page);
            }
            new CustomBookOverlay("Slimefun Guide", "TheBusyBiscuit", pages.toArray(new TellRawMessage[pages.size()])).open(p);
        } else {
            int target;
            int i;
            ChestMenu menu = new ChestMenu("Slimefun Guide");
            menu.setEmptySlotsClickable(false);
            menu.addMenuOpeningHandler(pl -> pl.playSound(pl.getLocation(), Sound.ITEM_BOOK_PAGE_TURN, 1.0f, 1.0f));
            int index = 9;
            int pages = (category.getItems().size() - 1) / 36 + 1;
            for (i = 0; i < 4; ++i) {
                menu.addItem(i, (ItemStack)new CustomItem(new ItemStack(Material.GRAY_STAINED_GLASS_PANE), " "));
                menu.addMenuClickHandler(i, (pl, slot, item, action) -> false);
            }
            menu.addItem(4, (ItemStack)new CustomItem(new ItemStack(Material.ENCHANTED_BOOK), "&7\u21e6 Back"));
            menu.addMenuClickHandler(4, (pl, slot, item, action) -> {
                SlimefunGuide.openMainMenuAsync(pl, survival, book, 1);
                return false;
            });
            for (i = 5; i < 9; ++i) {
                menu.addItem(i, (ItemStack)new CustomItem(new ItemStack(Material.GRAY_STAINED_GLASS_PANE), " "));
                menu.addMenuClickHandler(i, (pl, slot, item, action) -> false);
            }
            for (i = 45; i < 54; ++i) {
                menu.addItem(i, (ItemStack)new CustomItem(new ItemStack(Material.GRAY_STAINED_GLASS_PANE), " "));
                menu.addMenuClickHandler(i, (pl, slot, item, action) -> false);
            }
            menu.addItem(46, (ItemStack)new CustomItem(new ItemStack(Material.LIME_STAINED_GLASS_PANE), "&r\u21e6 Previous Page", new String[]{"", "&7(" + selected_page + " / " + pages + ")"}));
            menu.addMenuClickHandler(46, (pl, slot, item, action) -> {
                int next = selected_page - 1;
                if (next < 1) {
                    next = pages;
                }
                if (next != selected_page) {
                    SlimefunGuide.openCategory(pl, category, survival, next, book);
                }
                return false;
            });
            menu.addItem(52, (ItemStack)new CustomItem(new ItemStack(Material.LIME_STAINED_GLASS_PANE), "&rNext Page \u21e8", new String[]{"", "&7(" + selected_page + " / " + pages + ")"}));
            menu.addMenuClickHandler(52, (pl, slot, item, action) -> {
                int next = selected_page + 1;
                if (next > pages) {
                    next = 1;
                }
                if (next != selected_page) {
                    SlimefunGuide.openCategory(pl, category, survival, next, book);
                }
                return false;
            });
            PlayerProfile profile2 = PlayerProfile.get((OfflinePlayer)p);
            int categoryIndex = 36 * (selected_page - 1);
            for (int i2 = 0; i2 < 36 && (target = categoryIndex + i2) < category.getItems().size(); ++i2) {
                SlimefunItem sfitem = category.getItems().get(target);
                if (!Slimefun.isEnabled(p, sfitem, false)) continue;
                Research research = sfitem.getResearch();
                if (survival && research != null && !profile2.hasUnlocked(research)) {
                    if (Slimefun.hasPermission(p, sfitem, false)) {
                        menu.addItem(index, (ItemStack)new CustomItem(Material.BARRIER, "&r" + ItemUtils.getItemName(sfitem.getItem()), new String[]{"&4&lLOCKED", "", "&a> Click to unlock", "", "&7Cost: &b" + research.getCost() + " Level"}));
                        menu.addMenuClickHandler(index, (pl, slot, item, action) -> {
                            if (!Research.isResearching(pl)) {
                                if (research.canUnlock(pl)) {
                                    if (profile2.hasUnlocked(research)) {
                                        SlimefunGuide.openCategory(p, category, true, selected_page, book);
                                    } else {
                                        if (pl.getGameMode() != GameMode.CREATIVE || !SlimefunPlugin.getSettings().researchesFreeInCreative) {
                                            pl.setLevel(pl.getLevel() - research.getCost());
                                        }
                                        if (pl.getGameMode() == GameMode.CREATIVE) {
                                            research.unlock(pl, SlimefunPlugin.getSettings().researchesFreeInCreative);
                                            SlimefunGuide.openCategory(pl, category, survival, selected_page, book);
                                        } else {
                                            research.unlock(pl, false);
                                            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)SlimefunPlugin.instance, () -> SlimefunGuide.openCategory(pl, category, survival, selected_page, book), 103L);
                                        }
                                    }
                                } else {
                                    SlimefunPlugin.getLocal().sendMessage((CommandSender)pl, "messages.not-enough-xp", true);
                                }
                            }
                            return false;
                        });
                        ++index;
                        continue;
                    }
                    List<String> message = sfitem.getNoPermissionTooltip();
                    menu.addItem(index, (ItemStack)new CustomItem(Material.BARRIER, StringUtils.formatItemName((ItemStack)sfitem.getItem(), (boolean)false), message.toArray(new String[message.size()])));
                    menu.addMenuClickHandler(index, (pl, slot, item, action) -> false);
                    ++index;
                    continue;
                }
                menu.addItem(index, sfitem.getItem());
                menu.addMenuClickHandler(index, (pl, slot, item, action) -> {
                    if (survival) {
                        SlimefunGuide.displayItem(pl, item, true, book, 0);
                    } else if (sfitem instanceof MultiBlockMachine) {
                        SlimefunPlugin.getLocal().sendMessage((CommandSender)pl, "guide.cheat.no-multiblocks");
                    } else {
                        pl.getInventory().addItem(new ItemStack[]{item});
                    }
                    return false;
                });
                ++index;
            }
            menu.open(new Player[]{p});
        }
        if (survival) {
            PlayerProfile.get((OfflinePlayer)p, profile -> profile.getGuideHistory().add(category));
        }
    }

    public static void openSearch(Player player, String input, boolean cheat, boolean addToHistory) {
        PlayerProfile.get((OfflinePlayer)player, profile -> {
            ChestMenu menu = new ChestMenu("Searching for: " + SlimefunGuide.shorten("", input));
            menu.setEmptySlotsClickable(false);
            SlimefunGuide.fillInv(menu, cheat);
            SlimefunGuide.addBackButton(menu, 1, profile, cheat);
            String searchTerm = input.toLowerCase();
            int index = 9;
            for (SlimefunItem item : SlimefunItem.list()) {
                String itemName = ChatColor.stripColor((String)item.getItem().getItemMeta().getDisplayName()).toLowerCase();
                if (itemName.isEmpty()) continue;
                if (index == 44) break;
                if (!itemName.equals(searchTerm) && !itemName.contains(searchTerm)) continue;
                menu.addItem(index, item.getItem());
                menu.addMenuClickHandler(index, (pl, slot, itm, action) -> {
                    if (cheat) {
                        pl.getInventory().addItem(new ItemStack[]{itm});
                    } else {
                        SlimefunGuide.displayItem(pl, itm, true, false, 0);
                    }
                    return false;
                });
                ++index;
            }
            if (addToHistory) {
                profile.getGuideHistory().add(searchTerm);
            }
            menu.open(new Player[]{player});
        });
    }

    private static void fillInv(ChestMenu menu, boolean cheat) {
        int i2;
        for (i2 = 0; i2 < 9; ++i2) {
            menu.addItem(i2, (ItemStack)new CustomItem(new ItemStack(Material.GRAY_STAINED_GLASS_PANE), " "));
            menu.addMenuClickHandler(i2, (arg0, arg1, arg2, arg3) -> false);
        }
        menu.addItem(7, (ItemStack)new CustomItem(Material.NAME_TAG, SlimefunPlugin.getLocal().getMessage("guide.search.name"), SlimefunPlugin.getLocal().getMessagesArray("guide.search.lore")));
        menu.addMenuClickHandler(7, (player, i, itemStack, clickAction) -> {
            player.closeInventory();
            SlimefunPlugin.getLocal().sendMessage((CommandSender)player, "search.message");
            ChatInput.waitForPlayer((Plugin)SlimefunPlugin.instance, player, msg -> SlimefunGuide.openSearch(player, msg, cheat, true));
            return false;
        });
        for (i2 = 45; i2 < 54; ++i2) {
            menu.addItem(i2, (ItemStack)new CustomItem(new ItemStack(Material.GRAY_STAINED_GLASS_PANE), " "));
            menu.addMenuClickHandler(i2, (arg0, arg1, arg2, arg3) -> false);
        }
    }

    private static void addBackButton(ChestMenu menu, int slot, PlayerProfile profile, boolean cheat) {
        LinkedList<Object> playerHistory = profile.getGuideHistory();
        if (playerHistory.size() > 1) {
            menu.addItem(slot, (ItemStack)new CustomItem(new ItemStack(Material.ENCHANTED_BOOK), "&7\u21e6 Back", new String[]{"", "&rLeft Click: &7Go back to previous Page", "&rShift + left Click: &7Go back to Main Menu"}));
            menu.addMenuClickHandler(slot, (pl, s, is, action) -> {
                if (action.isShiftClicked()) {
                    SlimefunGuide.openMainMenu(profile, !cheat, false, 1);
                } else {
                    Object last = SlimefunGuide.getLastEntry(profile, true);
                    SlimefunGuide.handleHistory(pl, last, false, cheat);
                }
                return false;
            });
        } else {
            menu.addItem(slot, (ItemStack)new CustomItem(new ItemStack(Material.ENCHANTED_BOOK), "&7\u21e6 Back", new String[]{"", "&rLeft Click: &7Go back to Main Menu"}));
            menu.addMenuClickHandler(slot, (pl, s, is, action) -> {
                SlimefunGuide.openMainMenu(profile, !cheat, false, 1);
                return false;
            });
        }
    }

    private static Object getLastEntry(PlayerProfile profile, boolean remove) {
        LinkedList<Object> history = profile.getGuideHistory();
        if (remove && !history.isEmpty()) {
            history.removeLast();
        }
        return history.isEmpty() ? null : history.getLast();
    }

    private static void displayItem(Player p, ItemStack item, boolean addToHistory, boolean book, int page) {
        if (item == null || item.getType() == Material.AIR) {
            return;
        }
        SlimefunItem sfItem = SlimefunItem.getByItem(item);
        if (sfItem == null && !SlimefunPlugin.getSettings().guideShowVanillaRecipes) {
            return;
        }
        ItemStack[] recipe = new ItemStack[9];
        ItemStack recipeType = null;
        ItemStack recipeOutput = item;
        ChestMenu menu = new ChestMenu("Slimefun Guide");
        menu.setEmptySlotsClickable(false);
        menu.addMenuOpeningHandler(pl -> pl.playSound(pl.getLocation(), Sound.ITEM_BOOK_PAGE_TURN, 1.0f, 1.0f));
        if (sfItem != null) {
            recipe = sfItem.getRecipe();
            recipeType = sfItem.getRecipeType().toItem();
            recipeOutput = sfItem.getRecipeOutput() != null ? sfItem.getRecipeOutput() : sfItem.getItem();
        } else {
            Recipe r;
            ArrayList<Recipe> recipes = new ArrayList<Recipe>();
            Iterator iterator = Bukkit.recipeIterator();
            while (iterator.hasNext()) {
                r = (Recipe)iterator.next();
                if (!SlimefunManager.isItemSimiliar((ItemStack)new CustomItem(r.getResult(), 1), item, true)) continue;
                recipes.add(r);
            }
            if (recipes.isEmpty()) {
                return;
            }
            r = (Recipe)recipes.get(page);
            if (recipes.size() > page + 1) {
                menu.addItem(1, (ItemStack)new CustomItem(new ItemStack(Material.ENCHANTED_BOOK), "&7Next \u21e8", new String[]{"", "&e&l! &rThere are multiple recipes for this Item"}));
                menu.addMenuClickHandler(1, (pl, slot, itemstack, action) -> {
                    SlimefunGuide.displayItem(pl, itemstack, false, book, page + 1);
                    return false;
                });
            }
            if (r instanceof ShapedRecipe) {
                String[] shape = ((ShapedRecipe)r).getShape();
                for (int i = 0; i < shape.length; ++i) {
                    for (int j = 0; j < shape[i].length(); ++j) {
                        recipe[i * 3 + j] = (ItemStack)((ShapedRecipe)r).getIngredientMap().get(Character.valueOf(shape[i].charAt(j)));
                    }
                }
                recipeType = RecipeType.SHAPED_RECIPE.toItem();
                recipeOutput = r.getResult();
            } else if (r instanceof ShapelessRecipe) {
                List ingredients = ((ShapelessRecipe)r).getIngredientList();
                for (int i = 0; i < ingredients.size(); ++i) {
                    recipe[i] = (ItemStack)ingredients.get(i);
                }
                recipeType = RecipeType.SHAPELESS_RECIPE.toItem();
                recipeOutput = r.getResult();
            } else if (r instanceof FurnaceRecipe) {
                recipe[4] = ((FurnaceRecipe)r).getInput();
                recipeType = RecipeType.FURNACE.toItem();
                recipeOutput = r.getResult();
            }
        }
        PlayerProfile profile = PlayerProfile.get((OfflinePlayer)p);
        SlimefunGuide.addBackButton(menu, 0, profile, false);
        LinkedList<Object> history = profile.getGuideHistory();
        if (addToHistory) {
            history.add(sfItem != null ? sfItem : item);
        }
        if (history.size() > 1) {
            menu.addItem(0, (ItemStack)new CustomItem(new ItemStack(Material.ENCHANTED_BOOK), "&7\u21e6 Back", new String[]{"", "&rLeft Click: &7Go back to previous Page", "&rShift + left Click: &7Go back to Main Menu"}));
            menu.addMenuClickHandler(0, (pl, slot, itemstack, action) -> {
                if (action.isShiftClicked()) {
                    SlimefunGuide.openMainMenuAsync(p, true, book, 1);
                } else {
                    Object last = SlimefunGuide.getLastEntry(profile, true);
                    SlimefunGuide.handleHistory(pl, last, book, false);
                }
                return false;
            });
        } else {
            menu.addItem(0, (ItemStack)new CustomItem(new ItemStack(Material.ENCHANTED_BOOK), "&7\u21e6 Back", new String[]{"", "&rLeft Click: &7Go back to Main Menu"}));
            menu.addMenuClickHandler(0, (pl, slot, itemstack, action) -> {
                SlimefunGuide.openMainMenuAsync(pl, true, book, 1);
                return false;
            });
        }
        menu.addItem(3, SlimefunGuide.getDisplayItem(p, sfItem != null, recipe[0]));
        menu.addMenuClickHandler(3, (pl, slot, itemstack, action) -> {
            SlimefunGuide.displayItem(pl, itemstack, true, book, 0);
            return false;
        });
        menu.addItem(4, SlimefunGuide.getDisplayItem(p, sfItem != null, recipe[1]));
        menu.addMenuClickHandler(4, (pl, slot, itemstack, action) -> {
            SlimefunGuide.displayItem(pl, itemstack, true, book, 0);
            return false;
        });
        menu.addItem(5, SlimefunGuide.getDisplayItem(p, sfItem != null, recipe[2]));
        menu.addMenuClickHandler(5, (pl, slot, itemstack, action) -> {
            SlimefunGuide.displayItem(pl, itemstack, true, book, 0);
            return false;
        });
        if (sfItem != null) {
            if (sfItem.hasWiki()) {
                try {
                    menu.addItem(8, (ItemStack)new CustomItem(Material.KNOWLEDGE_BOOK, "&rView this Item on our Wiki &7(Slimefun Wiki)", new String[]{"", "&7\u21e8 Click to open"}));
                    menu.addMenuClickHandler(8, (pl, slot, itemstack, action) -> {
                        pl.closeInventory();
                        pl.sendMessage("");
                        pl.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&7&o" + sfItem.getWiki())));
                        pl.sendMessage("");
                        return false;
                    });
                }
                catch (Exception x) {
                    Slimefun.getLogger().log(Level.SEVERE, "An Error occured while adding a Wiki Page for Slimefun " + Slimefun.getVersion(), x);
                }
            }
            if (Slimefun.getItemConfig().contains(sfItem.getID() + ".youtube")) {
                try {
                    menu.addItem(7, (ItemStack)new CustomItem(CustomSkull.getItem((String)"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYjQzNTNmZDBmODYzMTQzNTM4NzY1ODYwNzViOWJkZjBjNDg0YWFiMDMzMWI4NzJkZjExYmQ1NjRmY2IwMjllZCJ9fX0="), "&rDemonstration Video &7(Youtube)", new String[]{"", "&7\u21e8 Click to watch"}));
                    menu.addMenuClickHandler(7, (pl, slot, itemstack, action) -> {
                        pl.closeInventory();
                        pl.sendMessage("");
                        pl.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&7&o" + Slimefun.getItemConfig().getString(sfItem.getID() + ".youtube"))));
                        pl.sendMessage("");
                        return false;
                    });
                }
                catch (Exception x) {
                    Slimefun.getLogger().log(Level.SEVERE, "An Error occured while adding a Youtube Video for Slimefun " + Slimefun.getVersion(), x);
                }
            }
        }
        menu.addItem(10, recipeType);
        menu.addMenuClickHandler(10, (pl, slot, itemstack, action) -> false);
        menu.addItem(12, SlimefunGuide.getDisplayItem(p, sfItem != null, recipe[3]));
        menu.addMenuClickHandler(12, (pl, slot, itemstack, action) -> {
            SlimefunGuide.displayItem(pl, itemstack, true, book, 0);
            return false;
        });
        menu.addItem(13, SlimefunGuide.getDisplayItem(p, sfItem != null, recipe[4]));
        menu.addMenuClickHandler(13, (pl, slot, itemstack, action) -> {
            SlimefunGuide.displayItem(pl, itemstack, true, book, 0);
            return false;
        });
        menu.addItem(14, SlimefunGuide.getDisplayItem(p, sfItem != null, recipe[5]));
        menu.addMenuClickHandler(14, (pl, slot, itemstack, action) -> {
            SlimefunGuide.displayItem(pl, itemstack, true, book, 0);
            return false;
        });
        menu.addItem(16, recipeOutput);
        menu.addMenuClickHandler(16, (pl, slot, itemstack, action) -> false);
        menu.addItem(21, SlimefunGuide.getDisplayItem(p, sfItem != null, recipe[6]));
        menu.addMenuClickHandler(21, (pl, slot, itemstack, action) -> {
            SlimefunGuide.displayItem(pl, itemstack, true, book, 0);
            return false;
        });
        menu.addItem(22, SlimefunGuide.getDisplayItem(p, sfItem != null, recipe[7]));
        menu.addMenuClickHandler(22, (pl, slot, itemstack, action) -> {
            SlimefunGuide.displayItem(pl, itemstack, true, book, 0);
            return false;
        });
        menu.addItem(23, SlimefunGuide.getDisplayItem(p, sfItem != null, recipe[8]));
        menu.addMenuClickHandler(23, (pl, slot, itemstack, action) -> {
            SlimefunGuide.displayItem(pl, itemstack, true, book, 0);
            return false;
        });
        if (sfItem instanceof RecipeDisplayItem) {
            SlimefunGuide.displayRecipes(menu, (RecipeDisplayItem)((Object)sfItem), 0);
        }
        menu.open(new Player[]{p});
    }

    private static ItemStack getDisplayItem(Player p, boolean isSlimefunRecipe, ItemStack item) {
        if (isSlimefunRecipe) {
            SlimefunItem slimefunItem = SlimefunItem.getByItem(item);
            if (slimefunItem == null) {
                return item;
            }
            String lore = Slimefun.hasPermission(p, slimefunItem, false) ? "&rNeeds to be unlocked elsewhere" : "&rNo Permission";
            return Slimefun.hasUnlocked(p, slimefunItem, false) ? item : new CustomItem(Material.BARRIER, ItemUtils.getItemName(item), new String[]{"&4&lLOCKED", "", lore});
        }
        return item;
    }

    private static void handleHistory(Player pl, Object last, boolean book, boolean cheat) {
        if (last instanceof Category) {
            SlimefunGuide.openCategory(pl, (Category)last, !cheat, 1, book);
        } else if (last instanceof SlimefunItem) {
            SlimefunGuide.displayItem(pl, ((SlimefunItem)last).getItem(), false, book, 0);
        } else if (last instanceof GuideHandler) {
            ((GuideHandler)last).run(pl, true, book);
        } else if (last instanceof String) {
            SlimefunGuide.openSearch(pl, (String)last, cheat, false);
        } else {
            SlimefunGuide.displayItem(pl, (ItemStack)last, false, book, 0);
        }
    }

    private static void displayRecipes(ChestMenu menu, RecipeDisplayItem sfItem, int page) {
        List<ItemStack> recipes = sfItem.getDisplayRecipes();
        if (!recipes.isEmpty()) {
            menu.addItem(53, null);
            if (page == 0) {
                for (int i = 27; i < 36; ++i) {
                    menu.replaceExistingItem(i, (ItemStack)new CustomItem(Material.GRAY_STAINED_GLASS_PANE, sfItem.getRecipeSectionLabel(), new String[0]));
                    menu.addMenuClickHandler(i, (pl, slot, itemstack, action) -> false);
                }
            } else {
                menu.replaceExistingItem(28, (ItemStack)new CustomItem(Material.LIME_STAINED_GLASS_PANE, "&a\u21e6 Previous Page", new String[0]));
                menu.addMenuClickHandler(28, (pl, slot, itemstack, action) -> {
                    SlimefunGuide.displayRecipes(menu, sfItem, page - 1);
                    pl.playSound(pl.getLocation(), Sound.ITEM_BOOK_PAGE_TURN, 1.0f, 1.0f);
                    return false;
                });
            }
            if (recipes.size() > 18 * (page + 1)) {
                menu.replaceExistingItem(34, (ItemStack)new CustomItem(Material.LIME_STAINED_GLASS_PANE, "&aNext Page \u21e8", new String[0]));
                menu.addMenuClickHandler(34, (pl, slot, itemstack, action) -> {
                    SlimefunGuide.displayRecipes(menu, sfItem, page + 1);
                    pl.playSound(pl.getLocation(), Sound.ITEM_BOOK_PAGE_TURN, 1.0f, 1.0f);
                    return false;
                });
            } else {
                menu.replaceExistingItem(34, (ItemStack)new CustomItem(Material.GRAY_STAINED_GLASS_PANE, sfItem.getRecipeSectionLabel(), new String[0]));
                menu.addMenuClickHandler(34, (pl, slot, itemstack, action) -> false);
            }
            int inputs = 36;
            int outputs = 45;
            for (int i = 0; i < 18; ++i) {
                int slot2;
                int n = slot2 = i % 2 == 0 ? inputs++ : outputs++;
                if (i + page * 18 < recipes.size()) {
                    if (page == 0) {
                        menu.replaceExistingItem(slot2, recipes.get(i + page * 18));
                        menu.addMenuClickHandler(slot2, (pl, s, itemstack, action) -> {
                            SlimefunGuide.displayItem(pl, itemstack, true, false, 0);
                            return false;
                        });
                        continue;
                    }
                    menu.replaceExistingItem(slot2, recipes.get(i + page * 18));
                    continue;
                }
                menu.replaceExistingItem(slot2, null);
                menu.addMenuClickHandler(slot2, (pl, s, itemstack, action) -> false);
            }
        }
    }
}

