/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.cscorelib2.database;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashSet;
import me.mrCookieSlime.Slimefun.cscorelib2.database.Database;
import me.mrCookieSlime.Slimefun.cscorelib2.database.SQLDatabase;
import org.bukkit.plugin.Plugin;

public abstract class LocalSQLDatabase<T extends LocalSQLDatabase<T>>
extends SQLDatabase<T> {
    protected String name;

    public LocalSQLDatabase(Plugin plugin, String name, Database.DatabaseLoader<T> callback) {
        super(plugin);
        this.name = name;
        this.callback = callback;
        this.queries = new HashSet();
        this.getConnection();
    }

    public abstract String getDriver();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Connection getConnection() {
        try {
            if (this.connection != null && this.connection.isValid(1)) {
                return this.connection;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        try {
            System.out.println("[Slimefun - Database] Loading SQL Driver...");
            Class.forName(this.getDriver());
        }
        catch (Exception x) {
            System.err.println("ERROR: Failed to load SQL Driver: " + this.getDriver());
            x.printStackTrace();
            this.callback.onLoad(this, null);
            return null;
        }
        System.out.println("[Slimefun - Database] Attempting to connect to local Database \"" + this.name + "\"");
        try (Connection connection2 = DriverManager.getConnection(this.getIP());){
            System.out.println("> Connection Result: SUCCESSFUL");
            this.callback.onLoad(this, connection2);
            this.connection = connection2;
            Connection connection = connection2;
            return connection;
        }
        catch (Exception x) {
            System.err.println("> Connection Result: FAILED");
            System.err.println(" ");
            System.err.println("ERROR: Could not connect to local Database \"" + this.name + "\"");
            x.printStackTrace();
            this.callback.onLoad(this, null);
            return null;
        }
    }
}

