/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.cscorelib2.config;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import lombok.NonNull;
import me.mrCookieSlime.Slimefun.cscorelib2.config.Config;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class Localization {
    private static final UnaryOperator<String> unicodes = str -> {
        if (str == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        char[] chars = str.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '[' && i + 1 < chars.length && chars[i + 1] == 'u') {
                i += 2;
                String unicode = "";
                for (int j = 0; j < 6 && i < chars.length; ++i, ++j) {
                    if (chars[i] == ']') {
                        unicode = String.valueOf((char)Integer.parseInt(unicode, 16));
                        break;
                    }
                    unicode = unicode + chars[i];
                }
                builder.append(unicode);
                continue;
            }
            builder.append(chars[i]);
        }
        return builder.toString();
    };
    private File file;
    private Config config;
    private boolean allowUnicodes = true;

    public Localization(@NonNull Plugin plugin) {
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        this.file = new File("plugins/" + plugin.getDescription().getName().replace(" ", "_"), "messages.yml");
        this.config = new Config(this.file);
    }

    public Localization(@NonNull Plugin plugin, @NonNull String name) {
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.file = new File("plugins/" + plugin.getDescription().getName().replace(" ", "_"), name);
        this.config = new Config(this.file);
    }

    public Localization(@NonNull Plugin plugin, @NonNull String name, boolean allowUnicodes) {
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.file = new File("plugins/" + plugin.getDescription().getName().replace(" ", "_") + "/" + name);
        this.config = new Config(this.file);
        this.allowUnicodes = allowUnicodes;
    }

    public void setDefaultMessages(String key, String ... messages) {
        this.setDefaultMessages(key, Arrays.asList(messages));
    }

    public List<String> setDefaultMessages(String key, List<String> messages) {
        if (!this.config.contains(key)) {
            this.config.setValue(key, messages);
        }
        return this.getMessages(key);
    }

    public String setDefaultMessage(String key, String message) {
        String msg = this.getMessage(message);
        if (msg == null) {
            this.config.setValue(key, message);
            return this.allowUnicodes ? (String)unicodes.apply(message) : message;
        }
        return msg;
    }

    public void setPrefix(String prefix) {
        this.setDefaultMessage("prefix", prefix);
    }

    public List<String> getMessages(String key) {
        if (!this.allowUnicodes) {
            return this.config.getStringList(key);
        }
        return this.config.getStringList(key).stream().map(unicodes).collect(Collectors.toList());
    }

    public String[] getMessagesArray(String key) {
        if (!this.allowUnicodes) {
            List<String> list = this.config.getStringList(key);
            return list.toArray(new String[list.size()]);
        }
        return (String[])this.config.getStringList(key).stream().map(unicodes).toArray(String[]::new);
    }

    public String getMessage(String key) {
        return this.allowUnicodes ? (String)unicodes.apply(this.config.getString(key)) : this.config.getString(key);
    }

    public void sendMessage(CommandSender sender, String key, boolean addPrefix) {
        String prefix = addPrefix && this.config.contains("prefix") ? this.getMessage("prefix") : "";
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(prefix + this.getMessage(key))));
    }

    public void sendMessage(CommandSender sender, String key, boolean addPrefix, UnaryOperator<String> function) {
        String prefix = addPrefix && this.config.contains("prefix") ? this.getMessage("prefix") : "";
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(prefix + (String)function.apply(this.getMessage(key)))));
    }

    public void sendMessages(CommandSender sender, String key, boolean addPrefix, UnaryOperator<String> function) {
        String prefix = addPrefix && this.config.contains("prefix") ? this.getMessage("prefix") : "";
        for (String translation : this.getMessages(key)) {
            translation = (String)function.apply(translation);
            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(prefix + translation)));
        }
    }

    public void sendMessage(CommandSender sender, String key) {
        String prefix = this.config.contains("prefix") ? this.getMessage("prefix") : "";
        String message = ChatColor.translateAlternateColorCodes((char)'&', (String)(prefix + this.getMessage(key)));
        if (sender instanceof Player) {
            sender.sendMessage(message);
        } else {
            sender.sendMessage(ChatColor.stripColor((String)message));
        }
    }

    public void sendMessages(CommandSender sender, String key) {
        String prefix = this.config.contains("prefix") ? this.getMessage("prefix") : "";
        for (String translation : this.getMessages(key)) {
            String message = ChatColor.translateAlternateColorCodes((char)'&', (String)(prefix + translation));
            if (sender instanceof Player) {
                sender.sendMessage(message);
                continue;
            }
            sender.sendMessage(ChatColor.stripColor((String)message));
        }
    }

    public void broadcastMessage(String key, boolean addPrefix, UnaryOperator<String> function) {
        String prefix = addPrefix && this.config.contains("prefix") ? this.getMessage("prefix") : "";
        Bukkit.broadcastMessage((String)ChatColor.translateAlternateColorCodes((char)'&', (String)(prefix + (String)function.apply(this.getMessage(key)))));
    }

    public void broadcastMessages(String key, boolean addPrefix, UnaryOperator<String> function) {
        String prefix = addPrefix && this.config.contains("prefix") ? this.getMessage("prefix") : "";
        for (String translation : this.getMessages(key)) {
            translation = (String)function.apply(translation);
            Bukkit.broadcastMessage((String)ChatColor.translateAlternateColorCodes((char)'&', (String)(prefix + translation)));
        }
    }

    public void broadcastMessage(String key) {
        String prefix = this.config.contains("prefix") ? this.getMessage("prefix") : "";
        Bukkit.broadcastMessage((String)ChatColor.translateAlternateColorCodes((char)'&', (String)(prefix + this.getMessage(key))));
    }

    public void broadcastMessages(String key) {
        String prefix = this.config.contains("prefix") ? this.getMessage("prefix") : "";
        for (String translation : this.getMessages(key)) {
            Bukkit.broadcastMessage((String)ChatColor.translateAlternateColorCodes((char)'&', (String)(prefix + translation)));
        }
    }

    public void reload() {
        this.config.reload();
    }

    public void save() {
        this.config.save();
    }

    public Config getConfig() {
        return this.config;
    }
}

