/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ClickAction;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.InvUtils;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.Item.CustomItem;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Lists.SlimefunItems;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineFuel;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.interfaces.RecipeDisplayItem;
import me.mrCookieSlime.Slimefun.Setup.SlimefunManager;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.api.energy.ChargableBlock;
import me.mrCookieSlime.Slimefun.api.energy.EnergyTicker;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import me.mrCookieSlime.Slimefun.cscorelib2.math.DoubleHandler;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.ProtectableAction;
import me.mrCookieSlime.Slimefun.utils.MachineHelper;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public abstract class AGenerator
extends SlimefunItem
implements RecipeDisplayItem {
    public static Map<Location, MachineFuel> processing = new HashMap<Location, MachineFuel>();
    public static Map<Location, Integer> progress = new HashMap<Location, Integer>();
    private final Set<MachineFuel> recipes = new HashSet<MachineFuel>();
    private static final int[] border = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 13, 31, 36, 37, 38, 39, 40, 41, 42, 43, 44};
    private static final int[] border_in = new int[]{9, 10, 11, 12, 18, 21, 27, 28, 29, 30};
    private static final int[] border_out = new int[]{14, 15, 16, 17, 23, 26, 32, 33, 34, 35};

    public AGenerator(Category category, ItemStack item, String id, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, id, recipeType, recipe);
        new BlockMenuPreset(id, this.getInventoryTitle()){

            @Override
            public void init() {
                AGenerator.this.constructMenu(this);
            }

            @Override
            public boolean canOpen(Block b, Player p) {
                return p.hasPermission("slimefun.inventory.bypass") || SlimefunPlugin.getProtectionManager().hasPermission((OfflinePlayer)p, b.getLocation(), ProtectableAction.ACCESS_INVENTORIES);
            }

            @Override
            public int[] getSlotsAccessedByItemTransport(ItemTransportFlow flow) {
                if (flow == ItemTransportFlow.INSERT) {
                    return AGenerator.this.getInputSlots();
                }
                return AGenerator.this.getOutputSlots();
            }
        };
        AGenerator.registerBlockHandler(id, (p, b, tool, reason) -> {
            BlockMenu inv = BlockStorage.getInventory(b);
            if (inv != null) {
                for (int slot : this.getInputSlots()) {
                    if (inv.getItemInSlot(slot) == null) continue;
                    b.getWorld().dropItemNaturally(b.getLocation(), inv.getItemInSlot(slot));
                    inv.replaceExistingItem(slot, null);
                }
                for (int slot : this.getOutputSlots()) {
                    if (inv.getItemInSlot(slot) == null) continue;
                    b.getWorld().dropItemNaturally(b.getLocation(), inv.getItemInSlot(slot));
                    inv.replaceExistingItem(slot, null);
                }
            }
            progress.remove(b.getLocation());
            processing.remove(b.getLocation());
            return true;
        });
        this.registerDefaultRecipes();
    }

    public AGenerator(Category category, ItemStack item, String id, RecipeType recipeType, ItemStack[] recipe, ItemStack recipeOutput) {
        this(category, item, id, recipeType, recipe);
        this.recipeOutput = recipeOutput;
    }

    public AGenerator(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        this(category, (ItemStack)item, item.getItemID(), recipeType, recipe);
    }

    private void constructMenu(BlockMenuPreset preset) {
        for (int i : border) {
            preset.addItem(i, (ItemStack)new CustomItem(new ItemStack(Material.GRAY_STAINED_GLASS_PANE), " "), (p, slot, item, action) -> false);
        }
        for (int i : border_in) {
            preset.addItem(i, (ItemStack)new CustomItem(new ItemStack(Material.CYAN_STAINED_GLASS_PANE), " "), (p, slot, item, action) -> false);
        }
        for (int i : border_out) {
            preset.addItem(i, (ItemStack)new CustomItem(new ItemStack(Material.ORANGE_STAINED_GLASS_PANE), " "), (p, slot, item, action) -> false);
        }
        for (int i : this.getOutputSlots()) {
            preset.addMenuClickHandler(i, (ChestMenu.MenuClickHandler)new ChestMenu.AdvancedMenuClickHandler(){

                public boolean onClick(Player p, int slot, ItemStack cursor, ClickAction action) {
                    return false;
                }

                public boolean onClick(InventoryClickEvent e, Player p, int slot, ItemStack cursor, ClickAction action) {
                    return cursor == null || cursor.getType() == null || cursor.getType() == Material.AIR;
                }
            });
        }
        preset.addItem(22, (ItemStack)new CustomItem(new ItemStack(Material.BLACK_STAINED_GLASS_PANE), " "), (p, slot, item, action) -> false);
    }

    public abstract String getInventoryTitle();

    public abstract ItemStack getProgressBar();

    public abstract void registerDefaultRecipes();

    public abstract int getEnergyProduction();

    public int[] getInputSlots() {
        return new int[]{19, 20};
    }

    public int[] getOutputSlots() {
        return new int[]{24, 25};
    }

    public MachineFuel getProcessing(Location l) {
        return processing.get(l);
    }

    public boolean isProcessing(Location l) {
        return progress.containsKey(l);
    }

    public void registerFuel(MachineFuel fuel) {
        this.recipes.add(fuel);
    }

    @Override
    public void preRegister() {
        this.addItemHandler(new EnergyTicker(){

            @Override
            public double generateEnergy(Location l, SlimefunItem sf, Config data) {
                BlockMenu inv = BlockStorage.getInventory(l);
                if (AGenerator.this.isProcessing(l)) {
                    int timeleft = progress.get(l);
                    if (timeleft > 0) {
                        MachineHelper.updateProgressbar(inv, 22, timeleft, processing.get(l).getTicks(), AGenerator.this.getProgressBar());
                        if (ChargableBlock.isChargable(l)) {
                            if (ChargableBlock.getMaxCharge(l) - ChargableBlock.getCharge(l) >= AGenerator.this.getEnergyProduction()) {
                                ChargableBlock.addCharge(l, AGenerator.this.getEnergyProduction());
                                progress.put(l, timeleft - 1);
                                return ChargableBlock.getCharge(l);
                            }
                            return 0.0;
                        }
                        progress.put(l, timeleft - 1);
                        return AGenerator.this.getEnergyProduction();
                    }
                    ItemStack fuel = processing.get(l).getInput();
                    if (SlimefunManager.isItemSimiliar(fuel, new ItemStack(Material.LAVA_BUCKET), true) || SlimefunManager.isItemSimiliar(fuel, SlimefunItems.BUCKET_OF_FUEL, true) || SlimefunManager.isItemSimiliar(fuel, SlimefunItems.BUCKET_OF_OIL, true)) {
                        inv.pushItem(new ItemStack(Material.BUCKET), AGenerator.this.getOutputSlots());
                    }
                    inv.replaceExistingItem(22, (ItemStack)new CustomItem(new ItemStack(Material.BLACK_STAINED_GLASS_PANE), " "));
                    progress.remove(l);
                    processing.remove(l);
                    return 0.0;
                }
                HashMap found = new HashMap();
                MachineFuel fuel = AGenerator.this.findRecipe(inv, found);
                if (fuel != null) {
                    for (Map.Entry entry : found.entrySet()) {
                        inv.replaceExistingItem((Integer)entry.getKey(), InvUtils.decreaseItem((ItemStack)inv.getItemInSlot((Integer)entry.getKey()), (int)((Integer)entry.getValue())));
                    }
                    processing.put(l, fuel);
                    progress.put(l, fuel.getTicks());
                }
                return 0.0;
            }

            @Override
            public boolean explode(Location l) {
                return false;
            }
        });
    }

    private MachineFuel findRecipe(BlockMenu menu, Map<Integer, Integer> found) {
        for (MachineFuel recipe : this.recipes) {
            for (int slot : this.getInputSlots()) {
                if (!SlimefunManager.isItemSimiliar(menu.getItemInSlot(slot), recipe.getInput(), true)) continue;
                found.put(slot, recipe.getInput().getAmount());
                return recipe;
            }
        }
        return null;
    }

    public Set<MachineFuel> getFuelTypes() {
        return this.recipes;
    }

    @Override
    public String getRecipeSectionLabel() {
        return "&7\u21e9 Available Types of Fuel \u21e9";
    }

    @Override
    public List<ItemStack> getDisplayRecipes() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (MachineFuel fuel : this.recipes) {
            ItemStack item = fuel.getInput().clone();
            ItemMeta im = item.getItemMeta();
            ArrayList<String> lore = new ArrayList<String>();
            lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)("&8\u21e8 &7Lasts " + AGenerator.getTimeLeft(fuel.getTicks() / 2))));
            lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)("&8\u21e8 &e\u26a1 &7" + this.getEnergyProduction() * 2)) + " J/s");
            lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)("&8\u21e8 &e\u26a1 &7" + DoubleHandler.getFancyDouble((double)fuel.getTicks() * (double)this.getEnergyProduction()) + " J in total")));
            im.setLore(lore);
            item.setItemMeta(im);
            list.add(item);
        }
        if (list.size() % 2 != 0) {
            list.add(null);
        }
        return list;
    }

    private static String getTimeLeft(int seconds) {
        String timeleft = "";
        int minutes = (int)((long)seconds / 60L);
        if (minutes > 0) {
            timeleft = timeleft + minutes + "m ";
        }
        return "&7" + timeleft + (seconds -= minutes * 60) + "s";
    }
}

