/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.api.energy;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import me.mrCookieSlime.CSCoreLibPlugin.general.Math.DoubleHandler;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.SlimefunStartup;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.TickerTask;
import me.mrCookieSlime.Slimefun.api.energy.ChargableBlock;
import me.mrCookieSlime.Slimefun.api.energy.EnergyFlowListener;
import me.mrCookieSlime.Slimefun.holograms.EnergyHologram;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.plugin.Plugin;

public class EnergyNet {
    private static final int RANGE = 6;
    public static Set<String> machines_input = new HashSet<String>();
    public static Set<String> machines_storage = new HashSet<String>();
    public static Set<String> machines_output = new HashSet<String>();
    public static Map<String, EnergyFlowListener> listeners = new HashMap<String, EnergyFlowListener>();

    public static NetworkComponent getComponent(Block b) {
        return EnergyNet.getComponent(b.getLocation());
    }

    public static NetworkComponent getComponent(String id) {
        if (machines_input.contains(id)) {
            return NetworkComponent.SOURCE;
        }
        if (machines_storage.contains(id)) {
            return NetworkComponent.DISTRIBUTOR;
        }
        if (machines_output.contains(id)) {
            return NetworkComponent.CONSUMER;
        }
        return NetworkComponent.NONE;
    }

    public static NetworkComponent getComponent(Location l) {
        if (!BlockStorage.hasBlockInfo(l)) {
            return NetworkComponent.NONE;
        }
        String id = BlockStorage.checkID(l);
        if (machines_input.contains(id)) {
            return NetworkComponent.SOURCE;
        }
        if (machines_storage.contains(id)) {
            return NetworkComponent.DISTRIBUTOR;
        }
        if (machines_output.contains(id)) {
            return NetworkComponent.CONSUMER;
        }
        return NetworkComponent.NONE;
    }

    public static void registerComponent(String id, NetworkComponent component) {
        switch (component) {
            case CONSUMER: {
                machines_output.add(id);
                break;
            }
            case DISTRIBUTOR: {
                machines_storage.add(id);
                break;
            }
            case SOURCE: {
                machines_input.add(id);
                break;
            }
        }
    }

    public static void tick(Block b) {
        HashSet<Location> input = new HashSet<Location>();
        HashSet<Location> storage = new HashSet<Location>();
        HashSet<Location> output = new HashSet<Location>();
        double supply = 0.0;
        double demand = 0.0;
        if (EnergyNet.scan(b.getLocation(), Axis.UNKNOWN, new HashSet<Location>(), input, storage, output, supply, demand).isEmpty()) {
            EnergyHologram.update(b, "&4No Energy Network found");
        } else {
            int capacity;
            for (final Location source : input) {
                long timestamp = System.currentTimeMillis();
                SlimefunItem item = BlockStorage.check(source);
                double energy = item.getEnergyTicker().generateEnergy(source, item, BlockStorage.getBlockInfo(source));
                if (item.getEnergyTicker().explode(source)) {
                    BlockStorage.clearBlockInfo(source);
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)SlimefunStartup.instance, new Runnable(){

                        @Override
                        public void run() {
                            source.getBlock().setType(Material.LAVA);
                            source.getWorld().createExplosion(source, 0.0f, false);
                        }
                    });
                } else {
                    supply += energy;
                }
                TickerTask.block_timings.put(source, System.currentTimeMillis() - timestamp);
            }
            for (Location battery : storage) {
                supply += (double)ChargableBlock.getCharge(battery);
            }
            int available = (int)DoubleHandler.fixDouble((double)supply);
            for (Location destination : output) {
                capacity = ChargableBlock.getMaxCharge(destination);
                int charge = ChargableBlock.getCharge(destination);
                if (charge >= capacity) continue;
                int rest = capacity - charge;
                demand += (double)rest;
                if (available <= 0) continue;
                if (available > rest) {
                    ChargableBlock.setUnsafeCharge(destination, capacity, false);
                    available -= rest;
                    continue;
                }
                ChargableBlock.setUnsafeCharge(destination, charge + available, false);
                available = 0;
            }
            for (Location battery : storage) {
                if (available > 0) {
                    capacity = ChargableBlock.getMaxCharge(battery);
                    if (available > capacity) {
                        ChargableBlock.setUnsafeCharge(battery, capacity, true);
                        available -= capacity;
                        continue;
                    }
                    ChargableBlock.setUnsafeCharge(battery, available, true);
                    available = 0;
                    continue;
                }
                ChargableBlock.setUnsafeCharge(battery, 0, true);
            }
            for (Location source : input) {
                if (!ChargableBlock.isChargable(source)) continue;
                if (available > 0) {
                    capacity = ChargableBlock.getMaxCharge(source);
                    if (available > capacity) {
                        ChargableBlock.setUnsafeCharge(source, capacity, false);
                        available -= capacity;
                        continue;
                    }
                    ChargableBlock.setUnsafeCharge(source, available, false);
                    available = 0;
                    continue;
                }
                ChargableBlock.setUnsafeCharge(source, 0, false);
            }
            EnergyHologram.update(b, supply, demand);
        }
    }

    public static Set<Location> scan(Location source, Axis exclude, Set<Location> sources, Set<Location> input, Set<Location> storage, Set<Location> output, double supply, double demand) {
        Location l;
        int i;
        sources.add(source);
        HashSet<Location> blocks = new HashSet<Location>();
        blocks.add(source);
        if (!exclude.equals((Object)Axis.X_POSITIVE)) {
            for (i = 0; i <= 6; ++i) {
                l = new Location(source.getWorld(), source.getX() + (double)i + 1.0, source.getY(), source.getZ());
                if (EnergyNet.continueScan(l, Axis.X_NEGATIVE, blocks, sources, input, storage, output, supply, demand)) continue;
                return new HashSet<Location>();
            }
        }
        if (!exclude.equals((Object)Axis.X_NEGATIVE)) {
            for (i = 0; i <= 6; ++i) {
                l = new Location(source.getWorld(), source.getX() - (double)i - 1.0, source.getY(), source.getZ());
                if (EnergyNet.continueScan(l, Axis.X_POSITIVE, blocks, sources, input, storage, output, supply, demand)) continue;
                return new HashSet<Location>();
            }
        }
        if (!exclude.equals((Object)Axis.Y_POSITIVE)) {
            for (i = 0; i <= 6; ++i) {
                l = new Location(source.getWorld(), source.getX(), source.getY() + (double)i + 1.0, source.getZ());
                if (EnergyNet.continueScan(l, Axis.Y_NEGATIVE, blocks, sources, input, storage, output, supply, demand)) continue;
                return new HashSet<Location>();
            }
        }
        if (!exclude.equals((Object)Axis.Y_NEGATIVE)) {
            for (i = 0; i <= 6; ++i) {
                l = new Location(source.getWorld(), source.getX(), source.getY() - (double)i - 1.0, source.getZ());
                if (EnergyNet.continueScan(l, Axis.Y_POSITIVE, blocks, sources, input, storage, output, supply, demand)) continue;
                return new HashSet<Location>();
            }
        }
        if (!exclude.equals((Object)Axis.Z_POSITIVE)) {
            for (i = 0; i <= 6; ++i) {
                l = new Location(source.getWorld(), source.getX(), source.getY(), source.getZ() + (double)i + 1.0);
                if (EnergyNet.continueScan(l, Axis.Z_NEGATIVE, blocks, sources, input, storage, output, supply, demand)) continue;
                return new HashSet<Location>();
            }
        }
        if (!exclude.equals((Object)Axis.Z_NEGATIVE)) {
            for (i = 0; i <= 6; ++i) {
                l = new Location(source.getWorld(), source.getX(), source.getY(), source.getZ() - (double)i - 1.0);
                if (EnergyNet.continueScan(l, Axis.Z_POSITIVE, blocks, sources, input, storage, output, supply, demand)) continue;
                return new HashSet<Location>();
            }
        }
        return blocks;
    }

    private static boolean continueScan(Location l, Axis axis, Set<Location> blocks, Set<Location> sources, Set<Location> input, Set<Location> storage, Set<Location> output, double supply, double demand) {
        if (!sources.contains(l)) {
            if (BlockStorage.check(l, "ENERGY_REGULATOR")) {
                return false;
            }
            switch (EnergyNet.getComponent(l)) {
                case CONSUMER: {
                    blocks.add(l);
                    output.add(l);
                    break;
                }
                case DISTRIBUTOR: {
                    Set<Location> nextBlocks;
                    blocks.add(l);
                    if (ChargableBlock.isCapacitor(l)) {
                        storage.add(l);
                    }
                    if ((nextBlocks = EnergyNet.scan(l, axis, sources, input, storage, output, supply, demand)).isEmpty()) {
                        return false;
                    }
                    for (Location sink : nextBlocks) {
                        blocks.add(sink);
                    }
                    break;
                }
                case SOURCE: {
                    blocks.add(l);
                    input.add(l);
                    break;
                }
            }
        }
        return true;
    }

    public static enum NetworkComponent {
        SOURCE,
        DISTRIBUTOR,
        CONSUMER,
        NONE;

    }

    public static enum Axis {
        X_POSITIVE,
        X_NEGATIVE,
        Y_POSITIVE,
        Y_NEGATIVE,
        Z_POSITIVE,
        Z_NEGATIVE,
        UNKNOWN;

    }
}

