/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.listeners;

import java.util.List;
import me.mrCookieSlime.Slimefun.Lists.SlimefunItems;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.Juice;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunBackpack;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Setup.SlimefunManager;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.PlayerProfile;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.api.inventory.BackpackInventory;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class BackpackListener
implements Listener {
    public BackpackListener(SlimefunPlugin plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onClose(InventoryCloseEvent e) {
        if (SlimefunPlugin.getUtilities().enchanting.containsKey(e.getPlayer().getUniqueId())) {
            SlimefunPlugin.getUtilities().enchanting.remove(e.getPlayer().getUniqueId());
        }
        if (SlimefunPlugin.getUtilities().backpack.containsKey(e.getPlayer().getUniqueId())) {
            ((Player)e.getPlayer()).playSound(e.getPlayer().getLocation(), Sound.ENTITY_HORSE_ARMOR, 1.0f, 1.0f);
            PlayerProfile.getBackpack(SlimefunPlugin.getUtilities().backpack.get(e.getPlayer().getUniqueId())).markDirty();
            SlimefunPlugin.getUtilities().backpack.remove(e.getPlayer().getUniqueId());
        }
    }

    @EventHandler
    public void onItemDrop(PlayerDropItemEvent e) {
        ItemStack item;
        SlimefunItem sfItem;
        if (SlimefunPlugin.getUtilities().backpack.containsKey(e.getPlayer().getUniqueId()) && (sfItem = SlimefunItem.getByItem(item = e.getItemDrop().getItemStack())) instanceof SlimefunBackpack) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onClick(InventoryClickEvent e) {
        ItemStack item = SlimefunPlugin.getUtilities().backpack.get(e.getWhoClicked().getUniqueId());
        if (item != null) {
            if (e.getClick() == ClickType.NUMBER_KEY) {
                ItemStack hotbarItem = e.getWhoClicked().getInventory().getItem(e.getHotbarButton());
                SlimefunItem sfItem = SlimefunItem.getByItem(hotbarItem);
                if (hotbarItem != null && hotbarItem.getType().toString().contains("SHULKER_BOX") || sfItem instanceof SlimefunBackpack) {
                    e.setCancelled(true);
                }
            } else if (e.getCurrentItem() != null && e.getCurrentItem().getType() != Material.AIR) {
                SlimefunItem sfItem = SlimefunItem.getByItem(e.getCurrentItem());
                if (SlimefunManager.isItemSimiliar(item, SlimefunItems.COOLER, false) && !(sfItem instanceof Juice) || e.getCurrentItem().getType().toString().contains("SHULKER_BOX") || sfItem instanceof SlimefunBackpack) {
                    e.setCancelled(true);
                }
            }
        }
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent e) {
        if (e.getAction() == Action.RIGHT_CLICK_AIR || e.getAction() == Action.RIGHT_CLICK_BLOCK) {
            Player p = e.getPlayer();
            ItemStack item = e.getItem();
            SlimefunItem sfItem = SlimefunItem.getByItem(item);
            if (sfItem instanceof SlimefunBackpack) {
                this.openBackpack(item, sfItem, ((SlimefunBackpack)sfItem).getSize(), e, p);
            }
        }
    }

    private void openBackpack(ItemStack item, SlimefunItem sfItem, int size, PlayerInteractEvent e, Player p) {
        e.setCancelled(true);
        if (item.getAmount() == 1) {
            if (Slimefun.hasUnlocked(p, sfItem, true) && !PlayerProfile.get((OfflinePlayer)p, profile -> this.openBackpack(item, (PlayerProfile)profile, size))) {
                Slimefun.getLocal().sendMessage((CommandSender)p, "messages.opening-backpack");
            }
        } else {
            SlimefunPlugin.getLocal().sendMessage((CommandSender)p, "backpack.no-stack", true);
        }
    }

    private void openBackpack(ItemStack item, PlayerProfile profile, int size) {
        Player p = profile.getPlayer();
        for (int line = 0; line < item.getItemMeta().getLore().size(); ++line) {
            if (!((String)item.getItemMeta().getLore().get(line)).equals(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7ID: <ID>"))) continue;
            BackpackInventory backpack = profile.createBackpack(size);
            BackpackListener.setBackpackId(p, item, line, backpack.getID());
            break;
        }
        if (!SlimefunPlugin.getUtilities().backpack.containsValue(item)) {
            p.playSound(p.getLocation(), Sound.ENTITY_HORSE_ARMOR, 1.0f, 1.0f);
            SlimefunPlugin.getUtilities().backpack.put(p.getUniqueId(), item);
            Slimefun.runSync(() -> PlayerProfile.getBackpack(item).open(p));
        } else {
            SlimefunPlugin.getLocal().sendMessage((CommandSender)p, "backpack.already-open", true);
        }
    }

    public static void setBackpackId(Player p, ItemStack item, int line, int id) {
        ItemMeta im = item.getItemMeta();
        List lore = im.getLore();
        lore.set(line, ((String)lore.get(line)).replace("<ID>", p.getUniqueId() + "#" + id));
        im.setLore(lore);
        item.setItemMeta(im);
    }
}

