/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.cscorelib2.database;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.function.Consumer;
import me.mrCookieSlime.Slimefun.cscorelib2.database.Database;
import org.bukkit.scheduler.BukkitTask;

public class DatabaseQuery {
    protected Database database;
    protected String query;
    protected boolean finished;
    protected BukkitTask task;

    public DatabaseQuery(Database database, String query) {
        this.database = database;
        this.query = query;
    }

    public void execute() {
        this.task = this.database.getPlugin().getServer().getScheduler().runTaskAsynchronously(this.database.getPlugin(), () -> {
            try {
                this.waitForConnection();
                if (this.task.isCancelled()) {
                    return;
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                Thread.currentThread().interrupt();
            }
            this.database.update(this.query);
            this.finished = true;
        });
    }

    public void execute(Consumer<ResultSet> func) {
        this.task = this.database.getPlugin().getServer().getScheduler().runTaskAsynchronously(this.database.getPlugin(), () -> {
            try {
                this.waitForConnection();
                if (this.task.isCancelled()) {
                    return;
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                Thread.currentThread().interrupt();
            }
            try {
                ResultSet set = this.database.query(this.query);
                func.accept(set);
                set.close();
                this.finished = true;
            }
            catch (SQLException e) {
                System.out.println(this.query);
                e.printStackTrace();
            }
        });
    }

    public void forEach(Runnable callback, Consumer<ResultSet> func) {
        this.task = this.database.getPlugin().getServer().getScheduler().runTaskAsynchronously(this.database.getPlugin(), () -> {
            try {
                this.waitForConnection();
                if (this.task.isCancelled()) {
                    return;
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                Thread.currentThread().interrupt();
            }
            callback.run();
            try {
                ResultSet set = this.database.query(this.query);
                while (set.next()) {
                    func.accept(set);
                }
                set.close();
                this.finished = true;
            }
            catch (SQLException e) {
                System.out.println(this.query);
                e.printStackTrace();
            }
        });
    }

    protected void waitForConnection() throws InterruptedException {
        while (!this.database.isConnected()) {
            Thread.sleep(50L);
        }
    }

    public boolean hasFinished() {
        return this.finished;
    }

    public static class ImportantDatabaseQuery
    extends DatabaseQuery {
        public ImportantDatabaseQuery(Database database, String query) {
            super(database, query);
        }

        @Override
        protected void waitForConnection() throws InterruptedException {
            while (this.database.getConnection() == null) {
                Thread.sleep(50L);
            }
        }
    }
}

