/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.Objects.tasks;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import me.mrCookieSlime.Slimefun.Lists.SlimefunItems;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunArmorPiece;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Setup.SlimefunManager;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.HashedArmorpiece;
import me.mrCookieSlime.Slimefun.api.PlayerProfile;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.api.energy.ItemEnergy;
import me.mrCookieSlime.Slimefun.utils.Utilities;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class ArmorTask
implements Runnable {
    private final Utilities utilities = SlimefunPlugin.getUtilities();
    private final Set<PotionEffect> radiationEffects;

    public ArmorTask() {
        HashSet<PotionEffect> effects = new HashSet<PotionEffect>();
        effects.add(new PotionEffect(PotionEffectType.WITHER, 400, 2));
        effects.add(new PotionEffect(PotionEffectType.BLINDNESS, 400, 3));
        effects.add(new PotionEffect(PotionEffectType.CONFUSION, 400, 3));
        effects.add(new PotionEffect(PotionEffectType.WEAKNESS, 400, 2));
        effects.add(new PotionEffect(PotionEffectType.SLOW, 400, 1));
        effects.add(new PotionEffect(PotionEffectType.SLOW_DIGGING, 400, 1));
        this.radiationEffects = Collections.unmodifiableSet(effects);
    }

    @Override
    public void run() {
        block0: for (Player p : Bukkit.getOnlinePlayers()) {
            if (!p.isValid() || p.isDead()) continue;
            ItemStack[] armor = p.getInventory().getArmorContents();
            HashedArmorpiece[] cachedArmor = PlayerProfile.get((OfflinePlayer)p).getArmor();
            for (int slot = 0; slot < 4; ++slot) {
                HashedArmorpiece armorpiece = cachedArmor[slot];
                ItemStack item = armor[slot];
                if (armorpiece.hasDiverged(item)) {
                    SlimefunItem sfItem = SlimefunItem.getByItem(item);
                    if (!(sfItem instanceof SlimefunArmorPiece) || !Slimefun.hasUnlocked(p, sfItem, true)) {
                        sfItem = null;
                    }
                    armorpiece.update(item, sfItem);
                }
                if (item == null || !armorpiece.getItem().isPresent()) continue;
                Bukkit.getScheduler().runTask((Plugin)SlimefunPlugin.instance, () -> {
                    for (PotionEffect effect : armorpiece.getItem().get().getEffects()) {
                        p.removePotionEffect(effect.getType());
                        p.addPotionEffect(effect);
                    }
                });
            }
            if (SlimefunManager.isItemSimiliar(p.getInventory().getHelmet(), SlimefunItems.SOLAR_HELMET, true) && Slimefun.hasUnlocked(p, SlimefunItem.getByID("SOLAR_HELMET"), true) && (p.getWorld().getTime() < 12300L || p.getWorld().getTime() > 23850L) && p.getEyeLocation().getBlock().getLightFromSky() == 15) {
                ItemEnergy.chargeInventory(p, ((Double)Slimefun.getItemValue("SOLAR_HELMET", "charge-amount")).floatValue());
            }
            for (ItemStack radioactive : this.utilities.radioactiveItems) {
                if (!SlimefunManager.containsSimilarItem((Inventory)p.getInventory(), radioactive, true)) continue;
                if (SlimefunManager.isItemSimiliar(SlimefunItems.SCUBA_HELMET, p.getInventory().getHelmet(), true) && SlimefunManager.isItemSimiliar(SlimefunItems.HAZMATSUIT_CHESTPLATE, p.getInventory().getChestplate(), true) && SlimefunManager.isItemSimiliar(SlimefunItems.HAZMATSUIT_LEGGINGS, p.getInventory().getLeggings(), true) && SlimefunManager.isItemSimiliar(SlimefunItems.RUBBER_BOOTS, p.getInventory().getBoots(), true)) continue block0;
                if (!Slimefun.isEnabled(p, radioactive, false)) continue;
                SlimefunPlugin.getLocal().sendMessage((CommandSender)p, "messages.radiation");
                Bukkit.getScheduler().runTask((Plugin)SlimefunPlugin.instance, () -> {
                    p.addPotionEffects(this.radiationEffects);
                    p.setFireTicks(400);
                });
                continue block0;
            }
        }
    }
}

