/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.cscorelib2.database;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashSet;
import me.mrCookieSlime.Slimefun.cscorelib2.config.Config;
import me.mrCookieSlime.Slimefun.cscorelib2.database.Database;
import me.mrCookieSlime.Slimefun.cscorelib2.database.SQLDatabase;
import org.bukkit.plugin.Plugin;

public abstract class AuthenticatedSQLDatabase<T extends AuthenticatedSQLDatabase<T>>
extends SQLDatabase<T> {
    protected String host;
    protected String user;
    protected String password;
    protected String database;
    protected int port;

    public AuthenticatedSQLDatabase(Plugin plugin, Database.DatabaseLoader<T> callback) {
        super(plugin);
        this.callback = callback;
        this.queries = new HashSet();
        Config cfg = new Config(plugin, this.getType() + ".yml");
        cfg.setDefaultValue("host", "localhost");
        cfg.setDefaultValue("port", this.getDefaultPort());
        cfg.setDefaultValue("username", "root");
        cfg.setDefaultValue("password", "password");
        cfg.setDefaultValue("database", "database");
        cfg.setDefaultValue("table-prefix", "");
        cfg.save();
        this.host = cfg.getString("host");
        this.port = cfg.getInt("port");
        this.user = cfg.getString("username");
        this.password = cfg.getString("password");
        this.database = cfg.getString("database");
        this.tablePrefix = cfg.getString("table-prefix");
        this.getConnection();
    }

    public abstract String getDriver();

    public abstract int getDefaultPort();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Connection getConnection() {
        try {
            if (this.connection != null && this.connection.isValid(1)) {
                return this.connection;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        try {
            System.out.println("[Slimefun5] Loading SQL Driver...");
            Class.forName(this.getDriver());
        }
        catch (Exception x) {
            System.err.println("ERROR: Failed to load SQL Driver: " + this.getDriver());
            x.printStackTrace();
            this.callback.onLoad(this, null);
            return null;
        }
        System.out.println("[Slimefun5] Attempting to connect to Database \"" + this.database + "\"");
        try (Connection connection2 = DriverManager.getConnection(this.getIP(), this.user, this.password);){
            System.out.println("> Connection Result: SUCCESSFUL");
            this.callback.onLoad(this, connection2);
            this.connection = connection2;
            Connection connection = connection2;
            return connection;
        }
        catch (Exception x) {
            System.err.println("> Connection Result: FAILED");
            System.err.println(" ");
            System.err.println("ERROR: Double-check the Host and Credentials you specified in the \"" + this.getType() + ".yml\" under /plugins/" + this.plugin.getName() + "/" + this.getType() + ".yml");
            x.printStackTrace();
            this.callback.onLoad(this, null);
            return null;
        }
    }
}

