/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.Objects;

import java.util.Arrays;
import java.util.List;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.api.PlayerProfile;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class LockedCategory
extends Category {
    private List<Category> parents;

    public LockedCategory(ItemStack item, Category ... parents) {
        super(item);
        this.parents = Arrays.asList(parents);
    }

    public LockedCategory(ItemStack item, int tier, Category ... parents) {
        super(item, tier);
        this.parents = Arrays.asList(parents);
    }

    public List<Category> getParents() {
        return this.parents;
    }

    public void addParent(Category category) {
        if (category == this) {
            throw new IllegalArgumentException("Category '" + this.getItem().getItemMeta().getDisplayName() + "' cannot be a parent of itself.");
        }
        this.parents.add(category);
    }

    public void removeParent(Category category) {
        this.parents.remove(category);
    }

    public boolean hasUnlocked(Player p) {
        PlayerProfile profile = PlayerProfile.get((OfflinePlayer)p);
        for (Category category : this.parents) {
            for (SlimefunItem item : category.getItems()) {
                if (!Slimefun.isEnabled(p, item, false) || !Slimefun.hasPermission(p, item, false) || item.getResearch() == null || profile.hasUnlocked(item.getResearch())) continue;
                return false;
            }
        }
        return true;
    }
}

