/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.holograms;

import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.Item.CustomItem;
import me.mrCookieSlime.CSCoreLibPlugin.general.World.ArmorStandFactory;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.ChatInput;
import me.mrCookieSlime.Slimefun.cscorelib2.math.DoubleHandler;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public final class HologramProjectorHologram {
    private HologramProjectorHologram() {
    }

    public static ArmorStand getArmorStand(Block projector, boolean createIfNoneExists) {
        String nametag = BlockStorage.getLocationInfo(projector.getLocation(), "text");
        double offset = Double.parseDouble(BlockStorage.getLocationInfo(projector.getLocation(), "offset"));
        Location l = new Location(projector.getWorld(), (double)projector.getX() + 0.5, (double)projector.getY() + offset, (double)projector.getZ() + 0.5);
        for (Entity n : l.getChunk().getEntities()) {
            if (!(n instanceof ArmorStand) || n.getCustomName() == null || !n.getCustomName().equals(nametag) || !(l.distanceSquared(n.getLocation()) < 0.4)) continue;
            return (ArmorStand)n;
        }
        if (!createIfNoneExists) {
            return null;
        }
        ArmorStand hologram = ArmorStandFactory.createHidden((Location)l);
        hologram.setCustomName(nametag);
        return hologram;
    }

    public static void remove(Block b) {
        ArmorStand hologram = HologramProjectorHologram.getArmorStand(b, false);
        if (hologram != null) {
            hologram.remove();
        }
    }

    public static void openEditor(Player p, Block projector) {
        ChestMenu menu = new ChestMenu("Hologram Settings");
        menu.addItem(0, (ItemStack)new CustomItem(new ItemStack(Material.NAME_TAG), "&7Text &e(Click to edit)", new String[]{"", "&r" + ChatColor.translateAlternateColorCodes((char)'&', (String)BlockStorage.getLocationInfo(projector.getLocation(), "text"))}));
        menu.addMenuClickHandler(0, (pl, slot, item, action) -> {
            pl.closeInventory();
            SlimefunPlugin.getLocal().sendMessage((CommandSender)pl, "machines.HOLOGRAM_PROJECTOR.enter-text", true);
            ChatInput.waitForPlayer((Plugin)SlimefunPlugin.instance, pl, message -> {
                ArmorStand hologram = HologramProjectorHologram.getArmorStand(projector, true);
                hologram.setCustomName(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
                BlockStorage.addBlockInfo(projector, "text", hologram.getCustomName());
                HologramProjectorHologram.openEditor(pl, projector);
            });
            return false;
        });
        menu.addItem(1, (ItemStack)new CustomItem(new ItemStack(Material.CLOCK), "&7Offset: &e" + DoubleHandler.fixDouble(Double.valueOf(BlockStorage.getLocationInfo(projector.getLocation(), "offset")) + 1.0), new String[]{"", "&rLeft Click: &7+0.1", "&rRight Click: &7-0.1"}));
        menu.addMenuClickHandler(1, (pl, slot, item, action) -> {
            double offset = DoubleHandler.fixDouble(Double.valueOf(BlockStorage.getLocationInfo(projector.getLocation(), "offset")) + (double)(action.isRightClicked() ? -0.1f : 0.1f));
            ArmorStand hologram = HologramProjectorHologram.getArmorStand(projector, true);
            Location l = new Location(projector.getWorld(), (double)projector.getX() + 0.5, (double)projector.getY() + offset, (double)projector.getZ() + 0.5);
            hologram.teleport(l);
            BlockStorage.addBlockInfo(projector, "offset", String.valueOf(offset));
            HologramProjectorHologram.openEditor(pl, projector);
            return false;
        });
        menu.open(new Player[]{p});
    }
}

