/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.GPS.GPSNetwork;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.Research;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.ItemState;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.VanillaItem;
import me.mrCookieSlime.Slimefun.Setup.SlimefunLocalization;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.GuideHandler;
import me.mrCookieSlime.Slimefun.api.PlayerProfile;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public final class Slimefun {
    private Slimefun() {
    }

    public static void registerGuideHandler(GuideHandler handler) {
        List handlers = SlimefunPlugin.getUtilities().guideHandlers.getOrDefault(handler.getTier(), new ArrayList());
        handlers.add(handler);
        SlimefunPlugin.getUtilities().guideHandlers.put(handler.getTier(), handlers);
    }

    public static GPSNetwork getGPSNetwork() {
        return SlimefunPlugin.instance.getGPS();
    }

    public static Logger getLogger() {
        return SlimefunPlugin.instance.getLogger();
    }

    public static Object getItemValue(String id, String key) {
        return Slimefun.getItemConfig().getValue(id + '.' + key);
    }

    public static void setItemVariable(String id, String key, Object value) {
        Slimefun.getItemConfig().setDefaultValue(id + '.' + key, value);
    }

    public static Config getItemConfig() {
        return SlimefunPlugin.getItemCfg();
    }

    public static void registerResearch(Research research, ItemStack ... items) {
        for (ItemStack item : items) {
            research.addItems(SlimefunItem.getByItem(item));
        }
        research.register();
    }

    public static boolean hasUnlocked(Player p, ItemStack item, boolean message) {
        SlimefunItem sfItem = SlimefunItem.getByItem(item);
        ItemState state = SlimefunItem.getState(item);
        if (sfItem == null) {
            if (state != ItemState.ENABLED) {
                if (message && state != ItemState.VANILLA) {
                    SlimefunPlugin.getLocal().sendMessage((CommandSender)p, "messages.disabled-item", true);
                }
                return false;
            }
            return true;
        }
        if (Slimefun.isEnabled(p, item, message) && Slimefun.hasPermission(p, sfItem, message)) {
            if (sfItem.getResearch() == null) {
                return true;
            }
            if (PlayerProfile.get((OfflinePlayer)p).hasUnlocked(sfItem.getResearch())) {
                return true;
            }
            if (message && !(sfItem instanceof VanillaItem)) {
                SlimefunPlugin.getLocal().sendMessage((CommandSender)p, "messages.not-researched", true);
            }
            return false;
        }
        return false;
    }

    public static boolean hasUnlocked(Player p, SlimefunItem sfItem, boolean message) {
        if (Slimefun.isEnabled(p, sfItem, message) && Slimefun.hasPermission(p, sfItem, message)) {
            if (sfItem.getResearch() == null) {
                return true;
            }
            if (PlayerProfile.get((OfflinePlayer)p).hasUnlocked(sfItem.getResearch())) {
                return true;
            }
            if (message && !(sfItem instanceof VanillaItem)) {
                SlimefunPlugin.getLocal().sendMessage((CommandSender)p, "messages.not-researched", true);
            }
            return false;
        }
        return false;
    }

    public static boolean hasPermission(Player p, SlimefunItem item, boolean message) {
        if (item == null) {
            return true;
        }
        if (item.getPermission().equalsIgnoreCase("")) {
            return true;
        }
        if (p.hasPermission(item.getPermission())) {
            return true;
        }
        if (message) {
            SlimefunPlugin.getLocal().sendMessage((CommandSender)p, "messages.no-permission", true);
        }
        return false;
    }

    public static boolean isEnabled(Player p, ItemStack item, boolean message) {
        SlimefunItem sfItem = SlimefunItem.getByItem(item);
        if (sfItem == null) {
            return !SlimefunItem.isDisabled(item);
        }
        return Slimefun.isEnabled(p, sfItem, message);
    }

    public static boolean isEnabled(Player p, SlimefunItem sfItem, boolean message) {
        String world = p.getWorld().getName();
        if (SlimefunPlugin.getWhitelist().contains(world + ".enabled")) {
            if (SlimefunPlugin.getWhitelist().getBoolean(world + ".enabled")) {
                if (!SlimefunPlugin.getWhitelist().contains(world + ".enabled-items." + sfItem.getID())) {
                    SlimefunPlugin.getWhitelist().setDefaultValue(world + ".enabled-items." + sfItem.getID(), (Object)true);
                }
                if (SlimefunPlugin.getWhitelist().getBoolean(world + ".enabled-items." + sfItem.getID())) {
                    return true;
                }
                if (message) {
                    SlimefunPlugin.getLocal().sendMessage((CommandSender)p, "messages.disabled-in-world", true);
                }
                return false;
            }
            if (message) {
                SlimefunPlugin.getLocal().sendMessage((CommandSender)p, "messages.disabled-in-world", true);
            }
            return false;
        }
        return true;
    }

    public static List<String> listIDs() {
        ArrayList<String> ids = new ArrayList<String>();
        for (SlimefunItem item : SlimefunItem.list()) {
            ids.add(item.getID());
        }
        return ids;
    }

    public static List<ItemStack> listCategories() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (Category c : Category.list()) {
            items.add(c.getItem());
        }
        return items;
    }

    @Deprecated
    public static void addDescription(String id, String ... description) {
        Slimefun.getItemConfig().setDefaultValue(id + ".description", Arrays.asList(description));
    }

    public static void addHint(String id, String ... hint) {
        Slimefun.getItemConfig().setDefaultValue(id + ".hint", Arrays.asList(hint));
    }

    public static void addYoutubeVideo(String id, String link) {
        Slimefun.getItemConfig().setDefaultValue(id + ".youtube", (Object)link);
    }

    public static void addWikiPage(String id, String link) {
        Slimefun.getItemConfig().setDefaultValue(id + ".wiki", (Object)link);
    }

    public static void addOfficialWikiPage(String id, String page) {
        Slimefun.addWikiPage(id, "https://github.com/TheBusyBiscuit/Slimefun4/wiki/" + page);
    }

    public static List<GuideHandler> getGuideHandlers(int tier) {
        return SlimefunPlugin.getUtilities().guideHandlers.getOrDefault(tier, new ArrayList());
    }

    public static String getVersion() {
        return SlimefunPlugin.instance.getDescription().getVersion();
    }

    public static SlimefunLocalization getLocal() {
        return SlimefunPlugin.getLocal();
    }
}

