/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.cscorelib2.inventory;

import java.util.stream.IntStream;
import lombok.NonNull;
import me.mrCookieSlime.Slimefun.cscorelib2.inventory.ItemUtils;
import me.mrCookieSlime.Slimefun.cscorelib2.inventory.MenuClickHandler;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public final class InvUtils {
    public static final MenuClickHandler EMPTY_CLICK = (p, slot, item, cursor, action) -> false;

    private InvUtils() {
    }

    public static boolean hasEmptySlot(@NonNull Inventory inv) {
        if (inv == null) {
            throw new NullPointerException("inv is marked non-null but is null");
        }
        return inv.firstEmpty() != 1;
    }

    public static boolean fits(@NonNull Inventory inv, @NonNull ItemStack item, int ... slots) {
        if (inv == null) {
            throw new NullPointerException("inv is marked non-null but is null");
        }
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        if (slots.length == 0) {
            slots = IntStream.range(0, inv.getSize()).toArray();
        }
        for (int slot : slots) {
            ItemStack stack = inv.getItem(slot);
            if (stack == null || stack.getType() == Material.AIR) {
                return true;
            }
            if (stack.getAmount() + item.getAmount() > stack.getMaxStackSize() || !ItemUtils.canStack(stack, item)) continue;
            return true;
        }
        return false;
    }
}

