/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.cscorelib2.protection;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import lombok.NonNull;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.ProtectableAction;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.ProtectionModule;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.modules.ASkyBlockProtectionModule;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.modules.BentoBoxProtectionModule;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.modules.BlockLockerProtectionModule;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.modules.FactionsProtectionModule;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.modules.FactionsUUIDProtectionModule;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.modules.GriefPreventionProtectionModule;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.modules.LWCProtectionModule;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.modules.LocketteProtectionModule;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.modules.PlotSquaredProtectionModule;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.modules.PreciousStonesProtectionModule;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.modules.RedProtectProtectionModule;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.modules.TownyProtectionModule;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.modules.WorldGuardProtectionModule;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.block.Block;

public final class ProtectionManager {
    private final Set<ProtectionModule> cscorelibProtectionModules = new HashSet<ProtectionModule>();
    private final Logger logger;

    public ProtectionManager(Server server) {
        this.logger = this.getLogger(server);
        this.logger.log(Level.INFO, "Loading Protection Modules...");
        this.logger.log(Level.INFO, "This may happen more than once.");
        if (server.getPluginManager().isPluginEnabled("WorldGuard") && server.getPluginManager().isPluginEnabled("WorldEdit")) {
            this.registerModule(new WorldGuardProtectionModule());
        }
        if (server.getPluginManager().isPluginEnabled("Factions")) {
            if (server.getPluginManager().getPlugin("Factions").getDescription().getDepend().contains("MassiveCore")) {
                this.registerModule(new FactionsProtectionModule());
            } else {
                this.registerModule(new FactionsUUIDProtectionModule());
            }
        }
        if (server.getPluginManager().isPluginEnabled("Towny")) {
            this.registerModule(new TownyProtectionModule());
        }
        if (server.getPluginManager().isPluginEnabled("GriefPrevention")) {
            this.registerModule(new GriefPreventionProtectionModule());
        }
        if (server.getPluginManager().isPluginEnabled("ASkyBlock")) {
            this.registerModule(new ASkyBlockProtectionModule());
        }
        if (server.getPluginManager().isPluginEnabled("LWC")) {
            this.registerModule(new LWCProtectionModule());
        }
        if (server.getPluginManager().isPluginEnabled("PreciousStones")) {
            this.registerModule(new PreciousStonesProtectionModule());
        }
        if (server.getPluginManager().isPluginEnabled("Lockette")) {
            this.registerModule(new LocketteProtectionModule());
        }
        if (server.getPluginManager().isPluginEnabled("PlotSquared")) {
            this.registerModule(new PlotSquaredProtectionModule());
        }
        if (server.getPluginManager().isPluginEnabled("RedProtect")) {
            this.registerModule(new RedProtectProtectionModule());
        }
        if (server.getPluginManager().isPluginEnabled("BentoBox")) {
            this.registerModule(new BentoBoxProtectionModule());
        }
        if (server.getPluginManager().isPluginEnabled("BlockLocker")) {
            this.registerModule(new BlockLockerProtectionModule());
        }
        if (server.getPluginManager().isPluginEnabled("ProtectionStones")) {
            this.loadModuleMSG("ProtectionStones");
        }
        if (server.getPluginManager().isPluginEnabled("uSkyblock")) {
            this.loadModuleMSG("uSkyblock");
        }
    }

    private Logger getLogger(Server server) {
        Logger customLogger = new Logger("CS-CoreLib2", null){

            @Override
            public void log(@NonNull LogRecord logRecord) {
                if (logRecord == null) {
                    throw new NullPointerException("logRecord is marked non-null but is null");
                }
                logRecord.setMessage("[CS-CoreLib2 - Protection]" + logRecord.getMessage());
            }
        };
        customLogger.setParent(server.getLogger());
        customLogger.setLevel(Level.ALL);
        return customLogger;
    }

    public void registerModule(String name, ProtectionModule module) {
        this.cscorelibProtectionModules.add(module);
        this.loadModuleMSG(name);
    }

    public void registerModule(ProtectionModule module) {
        try {
            module.load();
            this.registerModule(module.getName(), module);
        }
        catch (Exception x) {
            this.logger.log(Level.SEVERE, "An Error occured while registering the Protection Module: \"" + module.getName() + "\"", x);
        }
    }

    private void loadModuleMSG(String module) {
        this.logger.log(Level.INFO, "Loaded Protection Module \"{0}\"", module);
    }

    public boolean hasPermission(@NonNull OfflinePlayer p, @NonNull Block b, @NonNull ProtectableAction action) {
        if (p == null) {
            throw new NullPointerException("p is marked non-null but is null");
        }
        if (b == null) {
            throw new NullPointerException("b is marked non-null but is null");
        }
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        return this.hasPermission(p, b.getLocation(), action);
    }

    public boolean hasPermission(@NonNull OfflinePlayer p, @NonNull Location l, @NonNull ProtectableAction action) {
        if (p == null) {
            throw new NullPointerException("p is marked non-null but is null");
        }
        if (l == null) {
            throw new NullPointerException("l is marked non-null but is null");
        }
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        for (ProtectionModule module : this.cscorelibProtectionModules) {
            try {
                if (module.hasPermission(p, l, action)) continue;
                return false;
            }
            catch (Exception x) {
                this.logger.log(Level.SEVERE, "An Error occured while querying the Protection Module: \"" + module.getName() + "\"", x);
                return false;
            }
        }
        return true;
    }
}

