/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.api.item_transport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.Item.CustomItem;
import me.mrCookieSlime.Slimefun.Setup.SlimefunManager;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.DirtyChestMenu;
import me.mrCookieSlime.Slimefun.api.inventory.UniversalBlockMenu;
import me.mrCookieSlime.Slimefun.api.item_transport.CargoManager;
import me.mrCookieSlime.Slimefun.api.item_transport.ChestTerminalSorter;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemRequest;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemSlot;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import me.mrCookieSlime.Slimefun.api.item_transport.StoredItem;
import me.mrCookieSlime.Slimefun.api.network.Network;
import me.mrCookieSlime.Slimefun.api.network.NetworkComponent;
import me.mrCookieSlime.Slimefun.cscorelib2.math.DoubleHandler;
import me.mrCookieSlime.Slimefun.holograms.SimpleHologram;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.Directional;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class CargoNet
extends Network {
    public static boolean extraChannels = false;
    private static final int RANGE = 5;
    private static final int[] slots = new int[]{19, 20, 21, 28, 29, 30, 37, 38, 39};
    public static final int[] terminal_slots = new int[]{0, 1, 2, 3, 4, 5, 6, 9, 10, 11, 12, 13, 14, 15, 18, 19, 20, 21, 22, 23, 24, 27, 28, 29, 30, 31, 32, 33, 36, 37, 38, 39, 40, 41, 42};
    public static final int TERMINAL_OUT_SLOT = 17;
    private static final ChestTerminalSorter sorter = new ChestTerminalSorter();
    private static final ItemStack terminal_noitem_item = new CustomItem(new ItemStack(Material.BARRIER), "&4No Item cached");
    private static final ChestMenu.MenuClickHandler terminal_noitem_handler = (p, slot, item, action) -> false;
    private Set<Location> inputNodes = new HashSet<Location>();
    private Set<Location> outputNodes = new HashSet<Location>();
    private Set<Location> advancedOutputNodes = new HashSet<Location>();
    private final Set<Location> terminals = new HashSet<Location>();
    private final Set<Location> imports = new HashSet<Location>();
    private final Set<Location> exports = new HashSet<Location>();

    public static CargoNet getNetworkFromLocation(Location l) {
        return CargoNet.getNetworkFromLocation(l, CargoNet.class);
    }

    public static CargoNet getNetworkFromLocationOrCreate(Location l) {
        CargoNet cargoNetwork = CargoNet.getNetworkFromLocation(l);
        if (cargoNetwork == null) {
            cargoNetwork = new CargoNet(l);
            CargoNet.registerNetwork(cargoNetwork);
        }
        return cargoNetwork;
    }

    @Deprecated
    public static boolean isConnected(Block b) {
        return CargoNet.getNetworkFromLocation(b.getLocation()) != null;
    }

    protected CargoNet(Location l) {
        super(l);
    }

    @Override
    public int getRange() {
        return 5;
    }

    @Override
    public NetworkComponent classifyLocation(Location l) {
        String id = BlockStorage.checkID(l);
        if (id == null) {
            return null;
        }
        switch (id) {
            case "CARGO_MANAGER": {
                return NetworkComponent.REGULATOR;
            }
            case "CARGO_NODE": {
                return NetworkComponent.CONNECTOR;
            }
            case "CARGO_NODE_INPUT": 
            case "CARGO_NODE_OUTPUT": 
            case "CARGO_NODE_OUTPUT_ADVANCED": 
            case "CT_IMPORT_BUS": 
            case "CT_EXPORT_BUS": 
            case "CHEST_TERMINAL": {
                return NetworkComponent.TERMINUS;
            }
        }
        return null;
    }

    @Override
    public void locationClassificationChange(Location l, NetworkComponent from, NetworkComponent to) {
        if (from == NetworkComponent.TERMINUS) {
            this.inputNodes.remove(l);
            this.outputNodes.remove(l);
            this.advancedOutputNodes.remove(l);
            this.terminals.remove(l);
            this.imports.remove(l);
            this.exports.remove(l);
        }
        if (to == NetworkComponent.TERMINUS) {
            switch (BlockStorage.checkID(l)) {
                case "CARGO_NODE_INPUT": {
                    this.inputNodes.add(l);
                    break;
                }
                case "CARGO_NODE_OUTPUT": {
                    this.outputNodes.add(l);
                    break;
                }
                case "CARGO_NODE_OUTPUT_ADVANCED": {
                    this.advancedOutputNodes.add(l);
                    break;
                }
                case "CHEST_TERMINAL": {
                    this.terminals.add(l);
                    break;
                }
                case "CT_IMPORT_BUS": {
                    this.imports.add(l);
                    break;
                }
                case "CT_EXPORT_BUS": {
                    this.exports.add(l);
                    break;
                }
            }
        }
    }

    public void tick(Block b) {
        if (!this.regulator.equals((Object)b.getLocation())) {
            SimpleHologram.update(b, "&4Multiple Cargo Regulators connected");
            return;
        }
        super.tick();
        if (this.connectorNodes.isEmpty() && this.terminusNodes.isEmpty()) {
            SimpleHologram.update(b, "&7Status: &4&lOFFLINE");
        } else {
            Object frequency;
            SimpleHologram.update(b, "&7Status: &a&lONLINE");
            HashMap output = new HashMap();
            for (Location outputNode : this.outputNodes) {
                frequency = CargoNet.getFrequency(outputNode);
                if (!output.containsKey(frequency)) {
                    output.put((Integer)frequency, new ArrayList());
                }
                ((List)output.get(frequency)).add(outputNode);
            }
            for (Location outputNode : this.advancedOutputNodes) {
                frequency = CargoNet.getFrequency(outputNode);
                if (!output.containsKey(frequency)) {
                    output.put((Integer)frequency, new ArrayList());
                }
                ((List)output.get(frequency)).add(outputNode);
            }
            HashSet<Location> providers = new HashSet<Location>();
            HashSet destinations = output.containsKey(16) ? new HashSet((Collection)output.get(16)) : new HashSet();
            for (Location inputNode : this.inputNodes) {
                int frequency2 = CargoNet.getFrequency(inputNode);
                if (frequency2 != 16) continue;
                providers.add(inputNode);
            }
            CargoNet self = this;
            BlockStorage storage = BlockStorage.getStorage(b.getWorld());
            SlimefunPlugin.instance.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)SlimefunPlugin.instance, () -> {
                Block target;
                Block target2;
                if (BlockStorage.getLocationInfo(b.getLocation(), "visualizer") == null) {
                    self.display();
                }
                if (extraChannels) {
                    BlockMenu menu;
                    for (Location bus : this.imports) {
                        menu = BlockStorage.getInventory(bus);
                        if (menu.getItemInSlot(17) == null) {
                            Block target22 = CargoNet.getAttachedBlock(bus.getBlock());
                            ItemSlot stack = CargoManager.withdraw(bus.getBlock(), storage, target22, -1);
                            if (stack != null) {
                                menu.replaceExistingItem(17, stack.getItem());
                            }
                        }
                        if (menu.getItemInSlot(17) == null) continue;
                        SlimefunPlugin.getUtilities().itemRequests.add(new ItemRequest(bus, 17, menu.getItemInSlot(17), ItemTransportFlow.INSERT));
                    }
                    for (Location bus : this.exports) {
                        menu = BlockStorage.getInventory(bus);
                        if (menu.getItemInSlot(17) != null) {
                            target2 = CargoNet.getAttachedBlock(bus.getBlock());
                            menu.replaceExistingItem(17, CargoManager.insert(bus.getBlock(), storage, target2, menu.getItemInSlot(17), -1));
                        }
                        if (menu.getItemInSlot(17) != null) continue;
                        ArrayList<CustomItem> items = new ArrayList<CustomItem>();
                        for (int slot : slots) {
                            ItemStack template = menu.getItemInSlot(slot);
                            if (template == null) continue;
                            items.add(new CustomItem(template, 1));
                        }
                        if (items.isEmpty()) continue;
                        int index = Integer.parseInt(BlockStorage.getLocationInfo(bus, "index"));
                        if (++index > items.size() - 1) {
                            index = 0;
                        }
                        BlockStorage.addBlockInfo(bus, "index", String.valueOf(index));
                        SlimefunPlugin.getUtilities().itemRequests.add(new ItemRequest(bus, 17, (ItemStack)items.get(index), ItemTransportFlow.WITHDRAW));
                    }
                    for (Location terminal : this.terminals) {
                        menu = BlockStorage.getInventory(terminal);
                        ItemStack sendingItem = menu.getItemInSlot(17);
                        if (sendingItem == null) continue;
                        SlimefunPlugin.getUtilities().itemRequests.add(new ItemRequest(terminal, 17, sendingItem, ItemTransportFlow.INSERT));
                    }
                    Iterator<Object> iterator = SlimefunPlugin.getUtilities().itemRequests.iterator();
                    while (iterator.hasNext()) {
                        ItemRequest request = (ItemRequest)iterator.next();
                        if (!this.terminals.contains(request.getTerminal()) && !this.imports.contains(request.getTerminal()) && !this.exports.contains(request.getTerminal())) continue;
                        menu = BlockStorage.getInventory(request.getTerminal());
                        switch (request.getDirection()) {
                            case INSERT: {
                                ItemStack requestedItem = request.getItem();
                                for (Location l : destinations) {
                                    Block target3 = CargoNet.getAttachedBlock(l.getBlock());
                                    requestedItem = CargoManager.insert(l.getBlock(), storage, target3, requestedItem, -1);
                                    if (requestedItem != null) continue;
                                    menu.replaceExistingItem(request.getSlot(), null);
                                    break;
                                }
                                if (requestedItem != null) {
                                    menu.replaceExistingItem(request.getSlot(), requestedItem);
                                }
                                iterator.remove();
                                break;
                            }
                            case WITHDRAW: {
                                int slot = request.getSlot();
                                ItemStack prevStack = menu.getItemInSlot(slot);
                                if (!(prevStack == null || prevStack.getAmount() + request.getItem().getAmount() <= prevStack.getMaxStackSize() && SlimefunManager.isItemSimiliar(prevStack, (ItemStack)new CustomItem(request.getItem(), 1), true))) {
                                    iterator.remove();
                                    break;
                                }
                                Object stack = null;
                                ItemStack requested = request.getItem();
                                for (Location l : providers) {
                                    target = CargoNet.getAttachedBlock(l.getBlock());
                                    ItemStack is2 = CargoManager.withdraw(l.getBlock(), storage, target, requested);
                                    if (is2 == null) continue;
                                    stack = stack == null ? is2 : new CustomItem(stack, stack.getAmount() + is2.getAmount());
                                    if (is2.getAmount() == requested.getAmount()) break;
                                    requested = new CustomItem(requested, requested.getAmount() - is2.getAmount());
                                }
                                if (stack != null) {
                                    ItemStack prev = menu.getItemInSlot(slot);
                                    if (prev == null) {
                                        menu.replaceExistingItem(slot, (ItemStack)stack);
                                    } else {
                                        menu.replaceExistingItem(slot, (ItemStack)new CustomItem(stack, stack.getAmount() + prev.getAmount()));
                                    }
                                }
                                iterator.remove();
                                break;
                            }
                        }
                    }
                }
                for (Location input : this.inputNodes) {
                    DirtyChestMenu menu;
                    ItemSlot slot;
                    Integer frequency = CargoNet.getFrequency(input);
                    if (frequency < 0 || frequency > 15) continue;
                    Block inputTarget = CargoNet.getAttachedBlock(input.getBlock());
                    ItemStack stack = null;
                    int previousSlot = -1;
                    boolean roundrobin = BlockStorage.getLocationInfo(input, "round-robin").equals("true");
                    if (inputTarget != null && (slot = CargoManager.withdraw(input.getBlock(), storage, inputTarget, Integer.parseInt(BlockStorage.getLocationInfo(input, "index")))) != null) {
                        stack = slot.getItem();
                        previousSlot = slot.getSlot();
                    }
                    if (stack != null && output.containsKey(frequency)) {
                        Location out;
                        ArrayList<Location> outputlist = new ArrayList<Location>((Collection)output.get(frequency));
                        if (roundrobin) {
                            int cIndex;
                            if (!SlimefunPlugin.getUtilities().roundRobin.containsKey(input)) {
                                SlimefunPlugin.getUtilities().roundRobin.put(input, 0);
                            }
                            if ((cIndex = SlimefunPlugin.getUtilities().roundRobin.get(input).intValue()) < outputlist.size()) {
                                for (int i = 0; i < cIndex; ++i) {
                                    Location temp = (Location)outputlist.get(0);
                                    outputlist.remove(temp);
                                    outputlist.add(temp);
                                }
                                ++cIndex;
                            } else {
                                cIndex = 1;
                            }
                            SlimefunPlugin.getUtilities().roundRobin.put(input, cIndex);
                        }
                        Iterator cIndex = outputlist.iterator();
                        while (cIndex.hasNext() && ((target = CargoNet.getAttachedBlock((out = (Location)cIndex.next()).getBlock())) == null || (stack = CargoManager.insert(out.getBlock(), storage, target, stack, -1)) != null)) {
                        }
                    }
                    if (stack == null || previousSlot <= -1) continue;
                    if (storage.hasUniversalInventory(inputTarget)) {
                        menu = storage.getUniversalInventory(inputTarget);
                        ((UniversalBlockMenu)menu).replaceExistingItem(previousSlot, stack);
                        continue;
                    }
                    if (storage.hasInventory(inputTarget.getLocation())) {
                        menu = BlockStorage.getInventory(inputTarget.getLocation());
                        ((BlockMenu)menu).replaceExistingItem(previousSlot, stack);
                        continue;
                    }
                    if (!(inputTarget.getState() instanceof InventoryHolder)) continue;
                    Inventory inv = ((InventoryHolder)inputTarget.getState()).getInventory();
                    inv.setItem(previousSlot, stack);
                }
                if (extraChannels) {
                    ArrayList<StoredItem> items = new ArrayList<StoredItem>();
                    for (Location l : providers) {
                        int inv;
                        DirtyChestMenu menu;
                        target2 = CargoNet.getAttachedBlock(l.getBlock());
                        if (storage.hasUniversalInventory(target2)) {
                            menu = storage.getUniversalInventory(target2);
                            int[] previousSlot = ((UniversalBlockMenu)menu).getPreset().getSlotsAccessedByItemTransport((UniversalBlockMenu)menu, ItemTransportFlow.WITHDRAW, null);
                            int roundrobin = previousSlot.length;
                            for (inv = 0; inv < roundrobin; ++inv) {
                                int slot = previousSlot[inv];
                                ItemStack is3 = menu.getItemInSlot(slot);
                                if (is3 == null || !CargoManager.matchesFilter(l.getBlock(), is3, -1)) continue;
                                boolean add = true;
                                for (StoredItem storedItem : items) {
                                    if (!SlimefunManager.isItemSimiliar(is3, storedItem.getItem(), true)) continue;
                                    add = false;
                                    storedItem.add(is3.getAmount());
                                }
                                if (!add) continue;
                                items.add(new StoredItem((ItemStack)new CustomItem(is3, 1), is3.getAmount()));
                            }
                            continue;
                        }
                        if (storage.hasInventory(target2.getLocation())) {
                            menu = BlockStorage.getInventory(target2.getLocation());
                            if (BlockStorage.checkID(target2.getLocation()).startsWith("BARREL_") && BlockStorage.getLocationInfo(target2.getLocation(), "storedItems") != null) {
                                int stored = Integer.parseInt(BlockStorage.getLocationInfo(target2.getLocation(), "storedItems"));
                                int[] roundrobin = ((BlockMenu)menu).getPreset().getSlotsAccessedByItemTransport((BlockMenu)menu, ItemTransportFlow.WITHDRAW, null);
                                inv = roundrobin.length;
                                for (int slot = 0; slot < inv; ++slot) {
                                    int slot2 = roundrobin[slot];
                                    ItemStack is4 = menu.getItemInSlot(slot2);
                                    if (is4 == null || !CargoManager.matchesFilter(l.getBlock(), is4, -1)) continue;
                                    boolean add = true;
                                    for (StoredItem item2 : items) {
                                        if (!SlimefunManager.isItemSimiliar(is4, item2.getItem(), true)) continue;
                                        add = false;
                                        item2.add(is4.getAmount() + stored);
                                    }
                                    if (!add) continue;
                                    items.add(new StoredItem((ItemStack)new CustomItem(is4, 1), is4.getAmount() + stored));
                                }
                                continue;
                            }
                            int[] stored = ((BlockMenu)menu).getPreset().getSlotsAccessedByItemTransport((BlockMenu)menu, ItemTransportFlow.WITHDRAW, null);
                            int roundrobin = stored.length;
                            for (inv = 0; inv < roundrobin; ++inv) {
                                int slot = stored[inv];
                                ItemStack is5 = menu.getItemInSlot(slot);
                                if (is5 == null || !CargoManager.matchesFilter(l.getBlock(), is5, -1)) continue;
                                boolean add = true;
                                for (StoredItem storedItem : items) {
                                    if (!SlimefunManager.isItemSimiliar(is5, storedItem.getItem(), true)) continue;
                                    add = false;
                                    storedItem.add(is5.getAmount());
                                }
                                if (!add) continue;
                                items.add(new StoredItem((ItemStack)new CustomItem(is5, 1), is5.getAmount()));
                            }
                            continue;
                        }
                        if (!(target2.getState() instanceof InventoryHolder)) continue;
                        Inventory inv2 = ((InventoryHolder)target2.getState()).getInventory();
                        ItemStack[] stored = inv2.getContents();
                        int roundrobin = stored.length;
                        for (inv = 0; inv < roundrobin; ++inv) {
                            ItemStack is6 = stored[inv];
                            if (is6 == null || !CargoManager.matchesFilter(l.getBlock(), is6, -1)) continue;
                            boolean add = true;
                            for (StoredItem item : items) {
                                if (!SlimefunManager.isItemSimiliar(is6, item.getItem(), true)) continue;
                                add = false;
                                item.add(is6.getAmount());
                            }
                            if (!add) continue;
                            items.add(new StoredItem((ItemStack)new CustomItem(is6, 1), is6.getAmount()));
                        }
                    }
                    Collections.sort(items, sorter);
                    for (Location l : this.terminals) {
                        BlockMenu menu = BlockStorage.getInventory(l);
                        int page = Integer.parseInt(BlockStorage.getLocationInfo(l, "page"));
                        if (!items.isEmpty() && items.size() < (page - 1) * terminal_slots.length + 1) {
                            page = 1;
                            BlockStorage.addBlockInfo(l, "page", String.valueOf(1));
                        }
                        for (int i = 0; i < terminal_slots.length; ++i) {
                            int slot = terminal_slots[i];
                            if (items.size() > i + terminal_slots.length * (page - 1)) {
                                StoredItem item = (StoredItem)items.get(i + terminal_slots.length * (page - 1));
                                ItemStack stack = item.getItem().clone();
                                ItemMeta im = stack.getItemMeta();
                                ArrayList<String> lore = new ArrayList<String>();
                                lore.add("");
                                lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)("&7Stored Items: &r" + DoubleHandler.getFancyDouble(item.getAmount()))));
                                if (stack.getMaxStackSize() > 1) {
                                    lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)("&7<Left Click: Request 1 | Right Click: Request " + (item.getAmount() > stack.getMaxStackSize() ? stack.getMaxStackSize() : item.getAmount()) + ">")));
                                } else {
                                    lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7<Left Click: Request 1>"));
                                }
                                lore.add("");
                                if (im.hasLore()) {
                                    for (String string : im.getLore()) {
                                        lore.add(string);
                                    }
                                }
                                im.setLore(lore);
                                stack.setItemMeta(im);
                                menu.replaceExistingItem(slot, stack);
                                menu.addMenuClickHandler(slot, (p, sl, is, action) -> {
                                    SlimefunPlugin.getUtilities().itemRequests.add(new ItemRequest(l, 44, (ItemStack)new CustomItem(item.getItem(), action.isRightClicked() ? (item.getAmount() > item.getItem().getMaxStackSize() ? item.getItem().getMaxStackSize() : item.getAmount()) : 1), ItemTransportFlow.WITHDRAW));
                                    return false;
                                });
                                continue;
                            }
                            menu.replaceExistingItem(slot, terminal_noitem_item);
                            menu.addMenuClickHandler(slot, terminal_noitem_handler);
                        }
                    }
                }
            });
        }
    }

    private static Block getAttachedBlock(Block block) {
        if (block.getBlockData() instanceof Directional) {
            return block.getRelative(((Directional)block.getBlockData()).getFacing().getOppositeFace());
        }
        return null;
    }

    private static int getFrequency(Location l) {
        int freq = 0;
        try {
            String str = BlockStorage.getLocationInfo(l).getString("frequency");
            if (str != null) {
                freq = Integer.parseInt(str);
            }
        }
        catch (Exception x) {
            Slimefun.getLogger().log(Level.SEVERE, "An Error occured while parsing a Cargo Node Frequency", x);
        }
        return freq;
    }
}

