/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.api;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.CSCoreLibPlugin.general.Math.DoubleHandler;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.SlimefunStartup;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.inventory.UniversalBlockMenu;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.ItemStack;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class BlockStorage {
    private static final String path_blocks = "data-storage/Slimefun/stored-blocks/";
    private static final String path_chunks = "data-storage/Slimefun/stored-chunks/";
    public static Map<String, BlockStorage> worlds = new HashMap<String, BlockStorage>();
    public static Map<String, Set<Block>> ticking_chunks = new HashMap<String, Set<Block>>();
    public static Set<String> loaded_tickers = new HashSet<String>();
    private World world;
    private Map<Location, String> storage = new HashMap<Location, String>();
    private static Map<String, String> map_chunks = new HashMap<String, String>();
    private Map<Location, BlockMenu> inventories = new HashMap<Location, BlockMenu>();
    public static Map<String, UniversalBlockMenu> universal_inventories = new HashMap<String, UniversalBlockMenu>();
    private Map<String, Config> cache_blocks = new HashMap<String, Config>();
    public static int info_delay;
    private static int chunk_changes;
    private int changes = 0;

    public static BlockStorage getStorage(World world) {
        return worlds.get(world.getName());
    }

    public static BlockStorage getForcedStorage(World world) {
        return BlockStorage.isWorldRegistered(world.getName()) ? worlds.get(world.getName()) : new BlockStorage(world);
    }

    private static String serializeLocation(Location l) {
        return l.getWorld().getName() + ";" + l.getBlockX() + ";" + l.getBlockY() + ";" + l.getBlockZ();
    }

    private static String serializeChunk(Chunk chunk) {
        return chunk.getWorld().getName() + ";Chunk;" + chunk.getX() + ";" + chunk.getZ();
    }

    private static Location deserializeLocation(String l) {
        try {
            World w = Bukkit.getWorld((String)l.split(";")[0]);
            if (w != null) {
                return new Location(w, (double)Integer.parseInt(l.split(";")[1]), (double)Integer.parseInt(l.split(";")[2]), (double)Integer.parseInt(l.split(";")[3]));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockStorage(World w) {
        if (worlds.containsKey(w.getName())) {
            return;
        }
        this.world = w;
        System.out.println("[Slimefun] Loading Blocks for World \"" + w.getName() + "\"");
        System.out.println("[Slimefun] This may take a long time...");
        File f = new File(path_blocks + w.getName());
        if (f.exists()) {
            long total = f.listFiles().length;
            long start = System.currentTimeMillis();
            long done = 0L;
            long timestamp = System.currentTimeMillis();
            long totalBlocks = 0L;
            try {
                for (File file : f.listFiles()) {
                    if (!file.getName().endsWith(".sfb")) continue;
                    if (timestamp + (long)info_delay < System.currentTimeMillis()) {
                        System.out.println("[Slimefun] Loading Blocks... " + Math.round((float)done * 100.0f / (float)total * 100.0f / 100.0f) + "% done (\"" + w.getName() + "\")");
                        timestamp = System.currentTimeMillis();
                    }
                    YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)file);
                    for (String key : cfg.getKeys(false)) {
                        try {
                            ++totalBlocks;
                            this.storage.put(BlockStorage.deserializeLocation(key), cfg.getString(key));
                            if (!SlimefunItem.isTicking(file.getName().replace(".sfb", ""))) continue;
                            HashSet<Block> blocks = ticking_chunks.containsKey(BlockStorage.deserializeLocation(key).getChunk().toString()) ? ticking_chunks.get(BlockStorage.deserializeLocation(key).getChunk().toString()) : new HashSet<Block>();
                            blocks.add(BlockStorage.deserializeLocation(key).getBlock());
                            ticking_chunks.put(BlockStorage.deserializeLocation(key).getChunk().toString(), blocks);
                            if (loaded_tickers.contains(BlockStorage.deserializeLocation(key).getChunk().toString())) continue;
                            loaded_tickers.add(BlockStorage.deserializeLocation(key).getChunk().toString());
                        }
                        catch (Exception x) {
                            System.err.println("[Slimefun] Failed to load " + file.getName() + "(ERR: " + key + ")");
                            x.printStackTrace();
                        }
                    }
                    ++done;
                }
            }
            finally {
                long time = System.currentTimeMillis() - start;
                System.out.println("[Slimefun] Loading Blocks... 100% (FINISHED - " + time + "ms)");
                System.out.println("[Slimefun] Loaded a total of " + totalBlocks + " Blocks for World \"" + this.world.getName() + "\"");
                if (totalBlocks > 0L) {
                    System.out.println("[Slimefun] Avg: " + DoubleHandler.fixDouble((double)((double)time / (double)totalBlocks), (int)3) + "ms/Block");
                }
            }
        } else {
            f.mkdirs();
        }
        File chunks = new File("data-storage/Slimefun/stored-chunks/chunks.sfc");
        if (chunks.exists()) {
            YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)chunks);
            for (String key : cfg.getKeys(false)) {
                try {
                    if (!this.world.getName().equals(key.split(";")[0])) continue;
                    map_chunks.put(key, cfg.getString(key));
                }
                catch (Exception x) {
                    System.err.println("[Slimefun] Failed to load " + chunks.getName() + " for World \"" + this.world.getName() + "\" (ERR: " + key + ")");
                    x.printStackTrace();
                }
            }
        }
        worlds.put(this.world.getName(), this);
        for (File file : new File("data-storage/Slimefun/stored-inventories").listFiles()) {
            if (!file.getName().startsWith(w.getName()) || !file.getName().endsWith(".sfi")) continue;
            Location l = BlockStorage.deserializeLocation(file.getName().replace(".sfi", ""));
            Config cfg = new Config(file);
            try {
                BlockMenuPreset preset;
                if (cfg.getString("preset") != null) {
                    preset = BlockMenuPreset.getPreset(cfg.getString("preset"));
                    this.inventories.put(l, new BlockMenu(preset, l, cfg));
                    continue;
                }
                preset = BlockMenuPreset.getPreset(BlockStorage.checkID(l));
                this.inventories.put(l, new BlockMenu(preset, l, cfg));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (File file : new File("data-storage/Slimefun/universal-inventories").listFiles()) {
            if (!file.getName().endsWith(".sfi")) continue;
            Config cfg = new Config(file);
            BlockMenuPreset preset = BlockMenuPreset.getPreset(cfg.getString("preset"));
            universal_inventories.put(preset.getID(), new UniversalBlockMenu(preset, cfg));
        }
    }

    public void computeChanges() {
        this.changes = this.cache_blocks.size() + chunk_changes;
        HashMap<Location, BlockMenu> inventories2 = new HashMap<Location, BlockMenu>(this.inventories);
        for (Map.Entry entry : inventories2.entrySet()) {
            this.changes += ((BlockMenu)((Object)entry.getValue())).changes;
        }
        HashMap<String, UniversalBlockMenu> universal_inventories2 = new HashMap<String, UniversalBlockMenu>(universal_inventories);
        for (Map.Entry entry : universal_inventories2.entrySet()) {
            this.changes += ((UniversalBlockMenu)((Object)entry.getValue())).changes;
        }
    }

    public int getChanges() {
        return this.changes;
    }

    public void save(boolean remove) {
        this.save(true, remove);
    }

    public void save(boolean computeChanges, boolean remove) {
        if (computeChanges) {
            this.computeChanges();
        }
        if (this.changes == 0) {
            return;
        }
        System.out.println("[Slimefun] Saving Blocks for World \"" + this.world.getName() + "\" (" + this.changes + " Changes queued)");
        HashMap<String, Config> cache = new HashMap<String, Config>(this.cache_blocks);
        for (Map.Entry entry : cache.entrySet()) {
            this.cache_blocks.remove(entry.getKey());
            Config config = (Config)entry.getValue();
            if (config.getKeys().isEmpty()) {
                config.getFile().delete();
                continue;
            }
            config.save();
        }
        HashMap<Location, BlockMenu> inventories2 = new HashMap<Location, BlockMenu>(this.inventories);
        for (Map.Entry entry : inventories2.entrySet()) {
            ((BlockMenu)((Object)entry.getValue())).save((Location)entry.getKey());
        }
        HashMap<String, UniversalBlockMenu> hashMap = new HashMap<String, UniversalBlockMenu>(universal_inventories);
        for (Map.Entry entry : hashMap.entrySet()) {
            ((UniversalBlockMenu)((Object)entry.getValue())).save();
        }
        if (chunk_changes > 0) {
            File file = new File("data-storage/Slimefun/stored-chunks/chunks.sfc");
            Config config = new Config("data-storage/Slimefun/temp.yml");
            for (Map.Entry<String, String> entry : map_chunks.entrySet()) {
                config.setValue(entry.getKey(), (Object)entry.getValue());
            }
            config.save(file);
            if (remove) {
                worlds.remove(this.world.getName());
            }
        }
        this.changes = 0;
        chunk_changes = 0;
    }

    public static void store(Block block, ItemStack item) {
        SlimefunItem sfitem = SlimefunItem.getByItem(item);
        if (sfitem != null) {
            BlockStorage.addBlockInfo(block, "id", sfitem.getID(), true);
        }
    }

    public static void store(Block block, String item) {
        BlockStorage.addBlockInfo(block, "id", item, true);
    }

    public static ItemStack retrieve(Block block) {
        if (!BlockStorage.hasBlockInfo(block)) {
            return null;
        }
        SlimefunItem item = SlimefunItem.getByID(BlockStorage.getBlockInfo(block, "id"));
        BlockStorage.clearBlockInfo(block);
        if (item == null) {
            return null;
        }
        return item.getItem();
    }

    public static Config getBlockInfo(Block block) {
        return BlockStorage.getBlockInfo(block.getLocation());
    }

    public static Config getBlockInfo(Location l) {
        try {
            BlockStorage storage = BlockStorage.getStorage(l.getWorld());
            Config cfg = new Config("data-storage/Slimefun/temp.yml");
            if (!storage.storage.containsKey(l)) {
                return cfg;
            }
            for (Map.Entry<String, String> entry : BlockStorage.parseJSON(BlockStorage.getJSONData(l)).entrySet()) {
                cfg.setValue(entry.getKey(), (Object)entry.getValue());
            }
            return cfg;
        }
        catch (Exception x) {
            System.err.println(x.getClass().getName());
            System.err.println("[Slimefun] Failed to parse BlockInfo for Block @ " + l.getBlockX() + ", " + l.getBlockY() + ", " + l.getBlockZ());
            try {
                System.err.println(BlockStorage.getJSONData(l));
            }
            catch (Exception x2) {
                System.err.println("No Metadata found!");
            }
            System.err.println("[Slimefun] ");
            System.err.println("[Slimefun] IGNORE THIS ERROR UNLESS IT IS SPAMMING");
            System.err.println("[Slimefun] ");
            x.printStackTrace();
            return new Config("data-storage/Slimefun/temp.yml");
        }
    }

    private static Map<String, String> parseJSON(String json) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (json != null && json.length() > 2) {
            try {
                JSONParser parser = new JSONParser();
                JSONObject obj = (JSONObject)parser.parse(json);
                for (Object entry : obj.keySet()) {
                    String key = entry.toString();
                    String value = obj.get(entry).toString();
                    map.put(key, value);
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return map;
    }

    private static String getJSONData(Location l) {
        BlockStorage storage = BlockStorage.getStorage(l.getWorld());
        return storage.storage.get(l);
    }

    private static String getJSONData(Chunk chunk) {
        return map_chunks.get(BlockStorage.serializeChunk(chunk));
    }

    public static String getBlockInfo(Block block, String key) {
        return BlockStorage.getBlockInfo(block.getLocation(), key);
    }

    public static String getBlockInfo(Location l, String key) {
        return BlockStorage.parseJSON(BlockStorage.getJSONData(l)).get(key);
    }

    public static void addBlockInfo(Location l, String key, String value) {
        BlockStorage.addBlockInfo(l, key, value, false);
    }

    public static void addBlockInfo(Block block, String key, String value) {
        BlockStorage.addBlockInfo(block.getLocation(), key, value);
    }

    public static void addBlockInfo(Block block, String key, String value, boolean updateTicker) {
        BlockStorage.addBlockInfo(block.getLocation(), key, value, updateTicker);
    }

    public static void addBlockInfo(Location l, String key, String value, boolean updateTicker) {
        Config cfg = new Config("data-storage/Slimefun/temp.yml");
        if (BlockStorage.hasBlockInfo(l)) {
            cfg = BlockStorage.getBlockInfo(l);
        }
        cfg.setValue(key, (Object)value);
        BlockStorage.setBlockInfo(l, cfg, updateTicker);
    }

    public static boolean hasBlockInfo(Block block) {
        return BlockStorage.hasBlockInfo(block.getLocation());
    }

    public static boolean hasBlockInfo(Location l) {
        BlockStorage storage = BlockStorage.getStorage(l.getWorld());
        return storage != null && storage.storage.containsKey(l) && BlockStorage.getBlockInfo(l, "id") != null;
    }

    public static void setBlockInfo(Block block, Config cfg, boolean updateTicker) {
        BlockStorage.setBlockInfo(block.getLocation(), cfg, updateTicker);
    }

    public static void setBlockInfo(Location l, Config cfg, boolean updateTicker) {
        BlockStorage._integrated_removeBlockInfo(l, false);
        JSONObject json = new JSONObject();
        for (String key : cfg.getKeys()) {
            json.put((Object)key, (Object)cfg.getString(key));
        }
        BlockStorage.setBlockInfo(l, json.toJSONString(), updateTicker);
    }

    public static void setBlockInfo(Block b, String json, boolean updateTicker) {
        BlockStorage.setBlockInfo(b.getLocation(), json, updateTicker);
    }

    public static void setBlockInfo(Location l, String json, boolean updateTicker) {
        BlockStorage storage = BlockStorage.getStorage(l.getWorld());
        storage.storage.put(l, json);
        Map<String, String> parsed = BlockStorage.parseJSON(json);
        if (BlockMenuPreset.isInventory(parsed.get("id"))) {
            if (BlockMenuPreset.isUniversalInventory(parsed.get("id"))) {
                if (!universal_inventories.containsKey(parsed.get("id"))) {
                    storage.loadUniversalInventory(BlockMenuPreset.getPreset(parsed.get("id")));
                }
            } else if (!storage.hasInventory(l)) {
                File file = new File("data-storage/Slimefun/stored-inventories/" + BlockStorage.serializeLocation(l) + ".sfi");
                if (file.exists()) {
                    storage.inventories.put(l, new BlockMenu(BlockMenuPreset.getPreset(parsed.get("id")), l, new Config(file)));
                } else {
                    storage.loadInventory(l, BlockMenuPreset.getPreset(parsed.get("id")));
                }
            }
        }
        BlockStorage.refreshCache(BlockStorage.getStorage(l.getWorld()), l, parsed.get("id"), json, updateTicker);
    }

    public static void clearBlockInfo(Block block) {
        BlockStorage.clearBlockInfo(block.getLocation());
    }

    public static void clearBlockInfo(Location l) {
        BlockStorage.clearBlockInfo(l, true);
    }

    public static void clearBlockInfo(Block b, boolean destroy) {
        BlockStorage.clearBlockInfo(b.getLocation(), destroy);
    }

    public static void clearBlockInfo(Location l, boolean destroy) {
        SlimefunStartup.ticker.delete.put(l, destroy);
    }

    public static void _integrated_removeBlockInfo(Location l, boolean destroy) {
        BlockStorage storage = BlockStorage.getStorage(l.getWorld());
        if (BlockStorage.hasBlockInfo(l)) {
            BlockStorage.refreshCache(storage, l, BlockStorage.getBlockInfo(l).getString("id"), null, destroy);
            storage.storage.remove(l);
        }
        if (destroy) {
            if (storage.hasInventory(l)) {
                storage.clearInventory(l);
            }
            if (storage.hasUniversalInventory(l)) {
                storage.getUniversalInventory(l).close();
                storage.getUniversalInventory(l).save();
            }
            if (ticking_chunks.containsKey(l.getChunk().toString())) {
                Set<Block> blocks = ticking_chunks.get(l.getChunk().toString());
                blocks.remove(l.getBlock());
                if (blocks.isEmpty()) {
                    ticking_chunks.remove(l.getChunk().toString());
                    loaded_tickers.remove(l.getChunk().toString());
                } else {
                    ticking_chunks.put(l.getChunk().toString(), blocks);
                }
            }
        }
    }

    public static void moveBlockInfo(Block block, Block newBlock) {
        SlimefunStartup.ticker.move.put(block, newBlock);
    }

    public static void _integrated_moveBlockInfo(Block block, Block newBlock) {
        if (!BlockStorage.hasBlockInfo(block)) {
            return;
        }
        BlockStorage storage = BlockStorage.getStorage(block.getWorld());
        BlockStorage.setBlockInfo(newBlock, BlockStorage.getBlockInfo(block), true);
        if (storage.inventories.containsKey(block.getLocation())) {
            BlockMenu menu = storage.inventories.get(block.getLocation());
            storage.inventories.put(newBlock.getLocation(), menu);
            storage.clearInventory(block.getLocation());
            menu.move(newBlock);
        }
        BlockStorage.refreshCache(storage, block, BlockStorage.getBlockInfo(block).getString("id"), null, true);
        storage.storage.remove(block.getLocation());
        try {
            if (ticking_chunks.containsKey(block.getChunk().toString())) {
                Set<Block> blocks = ticking_chunks.get(block.getChunk().toString());
                blocks.remove(block);
                if (blocks.isEmpty()) {
                    ticking_chunks.remove(block.getChunk().toString());
                    loaded_tickers.remove(block.getChunk().toString());
                } else {
                    ticking_chunks.put(block.getChunk().toString(), blocks);
                }
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private static void refreshCache(BlockStorage storage, Block b, String key, String value, boolean updateTicker) {
        BlockStorage.refreshCache(storage, b.getLocation(), key, value, updateTicker);
    }

    private static void refreshCache(BlockStorage storage, Location l, String key, String value, boolean updateTicker) {
        SlimefunItem item;
        Config cfg = storage.cache_blocks.containsKey(key) ? storage.cache_blocks.get(key) : new Config(path_blocks + l.getWorld().getName() + "/" + key + ".sfb");
        cfg.setValue(BlockStorage.serializeLocation(l), (Object)value);
        storage.cache_blocks.put(key, cfg);
        if (updateTicker && (item = SlimefunItem.getByID(key)) != null && item.isTicking()) {
            Chunk chunk = l.getChunk();
            if (value != null) {
                HashSet<Block> blocks = ticking_chunks.containsKey(chunk.toString()) ? ticking_chunks.get(chunk.toString()) : new HashSet<Block>();
                blocks.add(l.getBlock());
                ticking_chunks.put(chunk.toString(), blocks);
                if (!loaded_tickers.contains(chunk.toString())) {
                    loaded_tickers.add(chunk.toString());
                }
            }
        }
    }

    public static SlimefunItem check(Block block) {
        return BlockStorage.check(block.getLocation());
    }

    public static SlimefunItem check(Location l) {
        if (!BlockStorage.hasBlockInfo(l)) {
            return null;
        }
        return SlimefunItem.getByID(BlockStorage.getBlockInfo(l, "id"));
    }

    public static String checkID(Block block) {
        return BlockStorage.checkID(block.getLocation());
    }

    public static boolean check(Block block, String slimefunItem) {
        return BlockStorage.check(block.getLocation(), slimefunItem);
    }

    public static String checkID(Location l) {
        if (!BlockStorage.hasBlockInfo(l)) {
            return null;
        }
        return BlockStorage.getBlockInfo(l, "id");
    }

    public static boolean check(Location l, String slimefunItem) {
        if (!BlockStorage.hasBlockInfo(l)) {
            return false;
        }
        try {
            String id = BlockStorage.getBlockInfo(l, "id");
            return id != null && id.equalsIgnoreCase(slimefunItem);
        }
        catch (NullPointerException x) {
            return false;
        }
    }

    public static boolean isWorldRegistered(String name) {
        return worlds.containsKey(name);
    }

    public static Set<String> getTickingChunks() {
        return new HashSet<String>(loaded_tickers);
    }

    public static Set<Block> getTickingBlocks(Chunk chunk) {
        return BlockStorage.getTickingBlocks(chunk.toString());
    }

    public static Set<Block> getTickingBlocks(String chunk) {
        return new HashSet<Block>((Collection)ticking_chunks.get(chunk));
    }

    public BlockMenu loadInventory(Location l, BlockMenuPreset preset) {
        BlockMenu menu = new BlockMenu(preset, l);
        this.inventories.put(l, menu);
        return menu;
    }

    public void loadUniversalInventory(BlockMenuPreset preset) {
        universal_inventories.put(preset.getID(), new UniversalBlockMenu(preset));
    }

    public void clearInventory(Location l) {
        BlockMenu menu = BlockStorage.getInventory(l);
        for (HumanEntity human : new ArrayList(menu.toInventory().getViewers())) {
            human.closeInventory();
        }
        this.inventories.get(l).delete(l);
        this.inventories.remove(l);
    }

    public boolean hasInventory(Location l) {
        return this.inventories.containsKey(l);
    }

    public boolean hasUniversalInventory(String id) {
        return universal_inventories.containsKey(id);
    }

    public UniversalBlockMenu getUniversalInventory(Block block) {
        return this.getUniversalInventory(block.getLocation());
    }

    public UniversalBlockMenu getUniversalInventory(Location l) {
        String id = BlockStorage.checkID(l);
        return id == null ? null : this.getUniversalInventory(id);
    }

    public UniversalBlockMenu getUniversalInventory(String id) {
        return universal_inventories.get(id);
    }

    public static BlockMenu getInventory(Block b) {
        return BlockStorage.getInventory(b.getLocation());
    }

    public static BlockMenu getInventory(Location l) {
        BlockStorage storage = BlockStorage.getStorage(l.getWorld());
        if (storage == null) {
            return null;
        }
        if (!storage.hasInventory(l)) {
            return storage.loadInventory(l, BlockMenuPreset.getPreset(BlockStorage.checkID(l)));
        }
        return storage.inventories.get(l);
    }

    public static JSONParser getParser() {
        return new JSONParser();
    }

    public static Config getChunkInfo(Chunk chunk) {
        try {
            Config cfg = new Config("data-storage/Slimefun/temp.yml");
            if (!map_chunks.containsKey(BlockStorage.serializeChunk(chunk))) {
                return cfg;
            }
            for (Map.Entry<String, String> entry : BlockStorage.parseJSON(BlockStorage.getJSONData(chunk)).entrySet()) {
                cfg.setValue(entry.getKey(), (Object)entry.getValue());
            }
            return cfg;
        }
        catch (Exception x) {
            System.err.println(x.getClass().getName());
            System.err.println("[Slimefun] Failed to parse ChunkInfo for Chunk @ " + chunk.getX() + ", " + chunk.getZ());
            try {
                System.err.println(BlockStorage.getJSONData(chunk));
            }
            catch (Exception x2) {
                System.err.println("No Metadata found!");
            }
            x.printStackTrace();
            return new Config("data-storage/Slimefun/temp.yml");
        }
    }

    public static boolean hasChunkInfo(Chunk chunk) {
        return map_chunks.containsKey(BlockStorage.serializeChunk(chunk));
    }

    public static void setChunkInfo(Chunk chunk, String key, String value) {
        Config cfg = new Config("data-storage/Slimefun/temp.yml");
        if (BlockStorage.hasChunkInfo(chunk)) {
            cfg = BlockStorage.getChunkInfo(chunk);
        }
        cfg.setValue(key, (Object)value);
        JSONObject json = new JSONObject();
        for (String path : cfg.getKeys()) {
            json.put((Object)path, (Object)cfg.getString(path));
        }
        map_chunks.put(BlockStorage.serializeChunk(chunk), json.toJSONString());
        ++chunk_changes;
    }

    public static String getChunkInfo(Chunk chunk, String key) {
        return BlockStorage.getChunkInfo(chunk).getString(key);
    }

    public static boolean hasChunkInfo(Chunk chunk, String key) {
        return BlockStorage.getChunkInfo(chunk, key) != null;
    }

    public static void clearChunkInfo(Chunk chunk) {
        map_chunks.remove(BlockStorage.serializeChunk(chunk));
    }

    public static String getBlockInfoAsJson(Block block) {
        return BlockStorage.getBlockInfoAsJson(block.getLocation());
    }

    public static String getBlockInfoAsJson(Location l) {
        return BlockStorage.getJSONData(l);
    }

    public boolean hasUniversalInventory(Block block) {
        return this.hasUniversalInventory(block.getLocation());
    }

    public boolean hasUniversalInventory(Location l) {
        String id = BlockStorage.checkID(l);
        return id == null ? false : this.hasUniversalInventory(id);
    }

    static {
        chunk_changes = 0;
    }
}

