/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.cscorelib2.updater;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import lombok.NonNull;
import me.mrCookieSlime.Slimefun.cscorelib2.updater.UpdateCheck;
import me.mrCookieSlime.Slimefun.cscorelib2.updater.Updater;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class GitHubBuildsUpdater
implements Updater {
    private static final String api_url = "https://thebusybiscuit.github.io/builds/";
    private Plugin plugin;
    private URL versionsURL;
    private URL downloadURL;
    private Thread thread;
    private File file;
    private String prefix;
    private String repository;
    private String localVersion;
    private String remoteVersion;
    protected int timeout = 5000;
    protected UpdateCheck predicate;

    public GitHubBuildsUpdater(@NonNull Plugin plugin, @NonNull File file, @NonNull String repo) {
        this(plugin, file, repo, "DEV - ");
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (repo == null) {
            throw new NullPointerException("repo is marked non-null but is null");
        }
    }

    public GitHubBuildsUpdater(@NonNull Plugin plugin, @NonNull File file, @NonNull String repo, @NonNull String prefix) {
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (repo == null) {
            throw new NullPointerException("repo is marked non-null but is null");
        }
        if (prefix == null) {
            throw new NullPointerException("prefix is marked non-null but is null");
        }
        this.plugin = plugin;
        this.file = file;
        this.repository = repo;
        this.prefix = prefix;
        this.localVersion = this.extractBuild(plugin.getDescription().getVersion());
        this.predicate = (local, remote) -> Integer.parseInt(remote) > Integer.parseInt(local);
        this.prepareUpdateFolder();
    }

    private String extractBuild(String version) {
        if (version.startsWith(this.prefix)) {
            return version.substring(this.prefix.length()).split(" ")[0];
        }
        throw new IllegalArgumentException("Not a valid Development-Build Version: " + version);
    }

    @Override
    public void start() {
        try {
            this.versionsURL = new URL(api_url + this.getRepository() + "/builds.json");
            this.plugin.getServer().getScheduler().runTask(this.plugin, () -> {
                this.thread = new Thread(new UpdaterTask());
                this.thread.start();
            });
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public String getRepository() {
        return this.repository;
    }

    @Override
    public String getLocalVersion() {
        return this.localVersion;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setPredicate(UpdateCheck predicate) {
        this.predicate = predicate;
    }

    public class UpdaterTask
    implements Runnable {
        @Override
        public void run() {
            if (this.connect()) {
                try {
                    this.check();
                }
                catch (NumberFormatException x) {
                    GitHubBuildsUpdater.this.plugin.getLogger().log(Level.SEVERE, "Could not auto-update " + GitHubBuildsUpdater.this.plugin.getName());
                    GitHubBuildsUpdater.this.plugin.getLogger().log(Level.SEVERE, "Unrecognized Version: \"" + GitHubBuildsUpdater.this.localVersion + "\"");
                }
            }
        }

        private boolean connect() {
            try {
                URLConnection connection = GitHubBuildsUpdater.this.versionsURL.openConnection();
                connection.setConnectTimeout(GitHubBuildsUpdater.this.timeout);
                connection.addRequestProperty("User-Agent", "Auto Updater (by TheBusyBiscuit)");
                connection.setDoOutput(true);
                BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                JsonObject obj = (JsonObject)new JsonParser().parse(reader.readLine());
                if (obj == null) {
                    System.err.println("[CS-CoreLib - Updater] Could not connect to github.io for Plugin \"" + GitHubBuildsUpdater.this.plugin.getName() + "\", is it down?");
                    try {
                        GitHubBuildsUpdater.this.thread.join();
                    }
                    catch (InterruptedException x) {
                        GitHubBuildsUpdater.this.plugin.getLogger().log(Level.SEVERE, "The Auto-Updater Thread was interrupted", x);
                        Thread.currentThread().interrupt();
                    }
                    return false;
                }
                GitHubBuildsUpdater.this.remoteVersion = String.valueOf(obj.get("last_successful").getAsInt());
                GitHubBuildsUpdater.this.downloadURL = new URL(GitHubBuildsUpdater.api_url + GitHubBuildsUpdater.this.getRepository() + "/" + GitHubBuildsUpdater.this.getRepository().split("/")[1] + "-" + GitHubBuildsUpdater.this.remoteVersion + ".jar");
                return true;
            }
            catch (IOException e) {
                GitHubBuildsUpdater.this.plugin.getLogger().log(Level.WARNING, "Could not connect to github.io for Plugin \"" + GitHubBuildsUpdater.this.plugin.getName() + "\", is it down? (" + e.getMessage() + ")");
                try {
                    GitHubBuildsUpdater.this.thread.join();
                }
                catch (InterruptedException x) {
                    GitHubBuildsUpdater.this.plugin.getLogger().log(Level.SEVERE, "The Auto-Updater Thread was interrupted", x);
                    Thread.currentThread().interrupt();
                }
                return false;
            }
        }

        private void check() {
            if (GitHubBuildsUpdater.this.predicate.hasUpdate(GitHubBuildsUpdater.this.localVersion, GitHubBuildsUpdater.this.remoteVersion)) {
                this.install();
            } else {
                GitHubBuildsUpdater.this.plugin.getLogger().log(Level.INFO, GitHubBuildsUpdater.this.plugin.getName() + " is up to date!");
                try {
                    GitHubBuildsUpdater.this.thread.join();
                }
                catch (InterruptedException x) {
                    GitHubBuildsUpdater.this.plugin.getLogger().log(Level.SEVERE, "The Auto-Updater Thread was interrupted", x);
                    Thread.currentThread().interrupt();
                }
            }
        }

        private void install() {
            GitHubBuildsUpdater.this.plugin.getLogger().log(Level.INFO, GitHubBuildsUpdater.this.plugin.getName() + " is outdated!");
            GitHubBuildsUpdater.this.plugin.getLogger().log(Level.INFO, "Downloading " + GitHubBuildsUpdater.this.plugin.getName() + " v" + GitHubBuildsUpdater.this.remoteVersion);
            GitHubBuildsUpdater.this.plugin.getServer().getScheduler().runTask(GitHubBuildsUpdater.this.plugin, () -> {
                BufferedInputStream input = null;
                FileOutputStream output = null;
                try {
                    int read;
                    input = new BufferedInputStream(GitHubBuildsUpdater.this.downloadURL.openStream());
                    output = new FileOutputStream(new File("plugins/" + Bukkit.getUpdateFolder(), GitHubBuildsUpdater.this.file.getName()));
                    byte[] data = new byte[1024];
                    while ((read = input.read(data, 0, 1024)) != -1) {
                        output.write(data, 0, read);
                    }
                }
                catch (Exception x) {
                    GitHubBuildsUpdater.this.plugin.getLogger().log(Level.SEVERE, "Could not auto-update " + GitHubBuildsUpdater.this.plugin.getName(), x);
                }
                finally {
                    try {
                        if (input != null) {
                            input.close();
                        }
                        if (output != null) {
                            output.close();
                        }
                        GitHubBuildsUpdater.this.plugin.getLogger().log(Level.INFO, " ");
                        GitHubBuildsUpdater.this.plugin.getLogger().log(Level.INFO, "#################### - UPDATE - ####################");
                        GitHubBuildsUpdater.this.plugin.getLogger().log(Level.INFO, GitHubBuildsUpdater.this.plugin.getName() + " was successfully updated (" + GitHubBuildsUpdater.this.localVersion + " -> " + GitHubBuildsUpdater.this.remoteVersion + ")");
                        GitHubBuildsUpdater.this.plugin.getLogger().log(Level.INFO, "Please restart your Server in order to use the new Version");
                        GitHubBuildsUpdater.this.plugin.getLogger().log(Level.INFO, " ");
                    }
                    catch (IOException e) {
                        GitHubBuildsUpdater.this.plugin.getLogger().log(Level.SEVERE, "An Error occured while auto-updating \"" + GitHubBuildsUpdater.this.plugin.getName() + "\"", e);
                    }
                    try {
                        GitHubBuildsUpdater.this.thread.join();
                    }
                    catch (InterruptedException x) {
                        GitHubBuildsUpdater.this.plugin.getLogger().log(Level.SEVERE, "The Auto-Updater Thread was interrupted", x);
                        Thread.currentThread().interrupt();
                    }
                }
            });
        }
    }
}

